/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/bpsmalloc.cpp,v 1.3 2005/02/18 13:20:23 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

#ifdef __cplusplus
extern "C" {
#endif

char **bps_malloc2D(int n, int m, size_t sz)
{
  char **data;
  int    j, k;

  if ( n <= 0 || m <= 0 ) return NULL;

  if ((data = (char**)emalloc(sizeof(char*)*(n+1))) == NULL) return NULL;
  
  data[n] = NULL;

  for (j = 0; j < n; j++)
    if ((data[j] = (char*)emalloc(m*sz)) == NULL ) {
      for (k = 0; k <= j && data[k] != NULL; k++ ) efree(data[k]);
      efree(data);
      data = NULL;
      break;
		} else {
			memset(data[j], 0, m*sz);
		}
    
  return data;
}

void bps_free2D(char **data)
{
  int j;
  if ( data == NULL ) return;
  for (j = 0; data[j] != NULL; j++ )
    efree(data[j]);

  efree(data);
}

#ifdef __cplusplus
}
#endif
