/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/bpsave.cpp,v 1.4 2005/02/22 04:32:19 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version                         *
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jul.3  1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename bpsave.c                       *
*           BPS BPSAVE command                  *
*                                               *
************************************************/
#ifdef __cplusplus
extern "C" {
#endif

static void check_exten(char *str)
{
  for (; *str != 0; str++) {
    if (*str == '.')
      return;
  }
  strcat(str, ".prm");
}


/***********************************************
        save parameters
***********************************************/
DLLEXPORT int mod_bps_bpsave()
{
  char   filename[FILE_LENGTH];
  int    lay_no;
  FILE  *fp;

  rebps();

  /* FOR NETWORK STRUCTURE */
  strcpy(filename, GetString(0));
  check_exten(filename);
  if ((fp = fopen(filename, "w")) == NULL)
    return 203; /* Parameter File Open Error */

  fprintf(fp, "%d\t\t%s\n", bps_cont.bps_sp.NumOfLayer, ": number of layer");

  fprintf(fp, "%d", bps_cont.bps_sp.NumOfCell[0]);
  for (lay_no = 1; lay_no < bps_cont.bps_sp.NumOfLayer; lay_no++)
    fprintf(fp, ",%d", bps_cont.bps_sp.NumOfCell[lay_no]);

  fprintf(fp, "\t\t%s\n", ": number of each layer's cell");
  fprintf(fp, "%s", bps_cont.bps_sp.FuncBias[0]);
  for (lay_no = 1; lay_no < bps_cont.bps_sp.NumOfLayer; lay_no++)
    fprintf(fp, ",%s", bps_cont.bps_sp.FuncBias[lay_no]);

  fprintf(fp, "\t%s\n", ": status of char.func and bias");

  /* FOR LEARNING */
  fprintf(fp, "%c\t\t%s\n", bps_cont.bps_sp.InitAlgo,
          ": init algorithm");
  fprintf(fp, "%s\t%s\n",   bps_cont.bps_sp.InitWgtFile,
          ": init data file name made by init command");
  fprintf(fp, "%d\t\t%s\n", bps_cont.bps_sp.Seed,
          ": seed");
  fprintf(fp, "%g\t\t%s\n", bps_cont.bps_sp.MaxInitWgt,
          ": maximum of init data");
  fprintf(fp, "%g\t\t%s\n", bps_cont.bps_sp.MinInitWgt,
          ": minimum of init data");
  fprintf(fp, "%s\t%s\n",   bps_cont.bps_sp.LrnInitWgtFile,
          ": init weight file for learn command");
  fprintf(fp, "%s\t%s\n",   bps_cont.bps_sp.WgtHistoryFile,
          ": weight history file name");
  fprintf(fp, "%d\t\t%s\n", bps_cont.bps_sp.WgtStorInterval,
          ": weight store interval");
  fprintf(fp, "%c\t\t%s\n", bps_cont.bps_sp.WgtStorMode,
          ": weight history store mode");
  fprintf(fp, "%s\t%s\n",   bps_cont.bps_sp.ErrHistoryFile,
          ": error history file name");
  fprintf(fp, "%d\t\t%s\n", bps_cont.bps_sp.ErrStorInterval,
          ": error store interval");
  fprintf(fp, "%c\t\t%s\n", bps_cont.bps_sp.ErrStorDirection,
          ": store direction for error");
  fprintf(fp, "%c\t\t%s\n", bps_cont.bps_sp.ErrStorMode,
          ": store mode for error");
  fprintf(fp, "%s\t%s\n",   bps_cont.bps_sp.InputFile,
          ": input data file name for learning");
  fprintf(fp, "%s\t%s\n",   bps_cont.bps_sp.TeachFile,
          ": teach data file name for learning");
  fprintf(fp, "%d\t\t%s\n", bps_cont.bps_sp.LrnFirstPtrn,
          ": first pattern No. for learning");
  fprintf(fp, "%d\t\t%s\n", bps_cont.bps_sp.LrnLastPtrn,
          ": last pattern No.");
  fprintf(fp, "%c\t\t%s\n", bps_cont.bps_sp.LearnMode,
          ": learning mode");
  fprintf(fp, "%c\t\t%s\n", bps_cont.bps_sp.LearnAlgo,
          ": learning algorithm");
  fprintf(fp, "%g\t%s\n",   bps_cont.bps_sp.LearnRate,
          ": learning rate");
  fprintf(fp, "%g\t%s\n",   bps_cont.bps_sp.Momentum,
          ": momentum");
  fprintf(fp, "%g\t%s\n",   bps_cont.bps_sp.IncreaseFact,
          ": increasing factor for learn. rate");
  fprintf(fp, "%g\t%s\n",   bps_cont.bps_sp.ReductFact,
          ": reduction factor for learn. rate");
  fprintf(fp, "%g\t%s\n",   bps_cont.bps_sp.VoglThresh,
          ": threshold for Vogl method");
  fprintf(fp, "%g\t%s\n",   bps_cont.bps_sp.Theta,
          ": factor for Ochiai's method");
  fprintf(fp, "%g\t%s\n",   bps_cont.bps_sp.MinError,
          ": min. error for end");
  fprintf(fp, "%d\t\t%s\n", bps_cont.bps_sp.MaxLearnCount,
          ": max. learn count for end");
  fprintf(fp, "%d\t\t%s\n", bps_cont.bps_sp.DisplayInterval,
          ": display interval (console)");
  fprintf(fp, "%s\t%s\n",   bps_cont.bps_sp.Comment,
          ": comment");

  /* FOR TEST */
  fprintf(fp, "%s\t%s\n",   bps_cont.bps_sp.TestWgtFile,
          ": weight file name for test");
  fprintf(fp, "%d\t\t%s\n", bps_cont.bps_sp.WgtHistoryNo,
          ": weight history number");
  fprintf(fp, "%s\t%s\n",   bps_cont.bps_sp.TestFile,
          ": test data file name");
  fprintf(fp, "%d\t\t%s\n", bps_cont.bps_sp.TestFirstPtrn,
          ": first pattern No. for test");
  fprintf(fp, "%d\t\t%s\n", bps_cont.bps_sp.TestLastPtrn,
          ": last pattern No. for test");
  fprintf(fp, "%d\t\t%s\n", bps_cont.bps_sp.InputLayer,
          ": input layer No.");
  fprintf(fp, "%d\t\t%s\n", bps_cont.bps_sp.OutputLayer,
          ": output layer No.");
  fprintf(fp, "%s\t%s\n",   bps_cont.bps_sp.ActFile,
          ": result file name");

 /* modified by higashi */
 /* Structure Learning Params */
  fprintf(fp, "%d\t%s\n",   bps_cont.bps_sp.StrLrnMode,
          ": structure learning mode . structure learning");
  fprintf(fp, "%g\t%s\n",   bps_cont.bps_sp.Ramuda,
          ": param of structure learning . Structure learning");
 /* end of modified */
  fclose(fp);
  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif
