/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/bpload.cpp,v 1.4 2005/02/22 07:38:30 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/************************************************
*                                               *
*       Back Propergation Simurator             *
*             subroutine packege                *
*               Version                         *
*         coded         in May.9  1990          *
*         coded by      M.Kai                   *
*         last modified in Jul.3  1990          *
*         modified by   K.Kuroda                *
*                                               *
*************************************************
*                                               *
*       filename bpload.c                       *
*           BPS BPLOAD command                  *
*                                               *
************************************************/

#define MAX 100

#ifdef __cplusplus
extern "C" {
#endif

static void check_exten(char *str);

static void check_exten(char *str)
{
  for (; *str != 0; str++) {
    if (*str == '.')
      return;
  }
  strcat(str, ".prm");
}


/***********************************************
  load parameters
  ************************************************/
DLLEXPORT int mod_bps_bpload(){
  register int  i;
  char          filename[FILE_LENGTH], rem[MAX], func_bias[BPS_MAX_LAYER][5];
  char          init_algo, stor_mode, stor_dir, learn_mode, *str;
  int           lay_no;
  FILE         *fp;

  rebps();

  str = GetString(0);
  strcpy(filename, str);
  check_exten(filename);
  if(str == NULL)
		return 2; /* illegal parameter */
  if ((fp = fopen(filename, "r")) == NULL)
    return 203; /* Parameter File Open Error */

  /* FOR NETWORK STRUCTURE */
  fscanf(fp, "%d", &bps_cont.bps_sp.NumOfLayer);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_cont.bps_sp.NumOfCell[0]);
  for (lay_no = 1; lay_no < bps_cont.bps_sp.NumOfLayer; lay_no++)
    fscanf(fp, ",%d", &bps_cont.bps_sp.NumOfCell[lay_no]);
  fgets(rem, MAX, fp);

  fscanf(fp, "%2s", func_bias[0]);
  for (lay_no = 1; lay_no < bps_cont.bps_sp.NumOfLayer; lay_no++)
    fscanf(fp, ",%2s", func_bias[lay_no]);
  for (lay_no = 0; lay_no < bps_cont.bps_sp.NumOfLayer; lay_no++) {
    for (i = 0; i < 2; i++)
      func_bias[lay_no][i] = toupper(func_bias[lay_no][i]);
    if ((strcmp("LN", func_bias[lay_no]) && strcmp("LA", func_bias[lay_no]) &&
         strcmp("SN", func_bias[lay_no]) && strcmp("SA", func_bias[lay_no]))
        != 0)
      return 208; /* Unknown Function Or Bias */
    strcpy(bps_cont.bps_sp.FuncBias[lay_no], func_bias[lay_no]);
  }
  fgets(rem, MAX, fp);


  /* FOR INITIALIZE */
  fscanf(fp, "%c", &init_algo);
  init_algo = toupper(init_algo);
  if ((init_algo != BPS_INITALGO_JIA) && (init_algo != BPS_INITALGO_RANDUM))
    return 210; /* Unknown Algorithm */
  bps_cont.bps_sp.InitAlgo = init_algo;
  fgets(rem, MAX, fp);
  fscanf(fp, "%s", bps_cont.bps_sp.InitWgtFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_cont.bps_sp.Seed);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_cont.bps_sp.MaxInitWgt);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_cont.bps_sp.MinInitWgt);
  fgets(rem, MAX, fp);


  /* FOR LEARNING */
  fscanf(fp, "%s", bps_cont.bps_sp.LrnInitWgtFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%s", bps_cont.bps_sp.WgtHistoryFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_cont.bps_sp.WgtStorInterval);
  fgets(rem, MAX, fp);
  fscanf(fp, "%c", &stor_mode);
  stor_mode = toupper(stor_mode);
  if ((stor_mode != BPS_STOREMODE_APPEND) && 
      (stor_mode != BPS_STOREMODE_OVERWRITE))
		return 202; /* Unknown Store Mode */
  bps_cont.bps_sp.WgtStorMode = stor_mode;
  fgets(rem, MAX, fp);

  fscanf(fp, "%s", bps_cont.bps_sp.ErrHistoryFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_cont.bps_sp.ErrStorInterval);
  fgets(rem, MAX, fp);
  fscanf(fp, "%c", &stor_dir);
  stor_dir = toupper(stor_dir);
  if ((stor_dir != BPS_STOREDIR_RECORD) &&
      (stor_dir != BPS_STOREDIR_DATAPOINT))
    return 201; /* Unknown Store Direction */
  bps_cont.bps_sp.ErrStorDirection = stor_dir;
  fgets(rem, MAX, fp);
  fscanf(fp, "%c", &stor_mode);
  stor_mode = toupper(stor_mode);
  if ((stor_mode != BPS_STOREMODE_APPEND) && 
      (stor_mode != BPS_STOREMODE_OVERWRITE))
    return 202; /* Unknown Store Mode */
  bps_cont.bps_sp.ErrStorMode = stor_mode;
  fgets(rem, MAX, fp);

  fscanf(fp, "%s", bps_cont.bps_sp.InputFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%s", bps_cont.bps_sp.TeachFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_cont.bps_sp.LrnFirstPtrn);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_cont.bps_sp.LrnLastPtrn);
  fgets(rem, MAX, fp);

  fscanf(fp, "%c", &learn_mode);
  learn_mode = toupper(learn_mode);
  if ((learn_mode != BPS_LEARNMODE_SET) &&
      (learn_mode != BPS_LEARNMODE_PATTERN))
    return 202; /* Unknown Store Mode */
  bps_cont.bps_sp.LearnMode = learn_mode;
  fgets(rem, MAX, fp);
  fscanf(fp, "%c", &bps_cont.bps_sp.LearnAlgo);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_cont.bps_sp.LearnRate);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_cont.bps_sp.Momentum);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_cont.bps_sp.IncreaseFact);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_cont.bps_sp.ReductFact);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_cont.bps_sp.VoglThresh);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_cont.bps_sp.Theta);
  fgets(rem, MAX, fp);

  fscanf(fp, "%lf", &bps_cont.bps_sp.MinError);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_cont.bps_sp.MaxLearnCount);
  fgets(rem, MAX, fp);

  fscanf(fp, "%d", &bps_cont.bps_sp.DisplayInterval);
  fgets(rem, MAX, fp);
  fscanf(fp, "%s", bps_cont.bps_sp.Comment);
  fgets(rem, MAX, fp);

  /* FOR TEST */
  fscanf(fp, "%s", bps_cont.bps_sp.TestWgtFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_cont.bps_sp.WgtHistoryNo);
  fgets(rem, MAX, fp);
  fscanf(fp, "%s", bps_cont.bps_sp.TestFile);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_cont.bps_sp.TestFirstPtrn);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_cont.bps_sp.TestLastPtrn);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_cont.bps_sp.InputLayer);
  fgets(rem, MAX, fp);
  fscanf(fp, "%d", &bps_cont.bps_sp.OutputLayer);
  fgets(rem, MAX, fp);
  fscanf(fp, "%s", bps_cont.bps_sp.ActFile);
  fgets(rem, MAX, fp);

/*            modified by higashi       */
  fscanf(fp, "%d", &bps_cont.bps_sp.StrLrnMode);
  fgets(rem, MAX, fp);
  fscanf(fp, "%lf", &bps_cont.bps_sp.Ramuda);
  fgets(rem, MAX, fp);
/*----------- end of modified   --------*/
  fclose(fp);

  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif
