/*
 * Copyright (c) 2003-2005 RIKEN Japan, All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $SATELLITE: satellite4/modules/bps/command/actload.cpp,v 1.8 2005/02/22 07:38:24 ninja Exp $ */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "libbps.h"

/************************************************
*						*
*	Back Propergation Simulator(BPS)	*
*	      subroutine package		*
*	  coded 	in Sep.7 1990		*
*	  coded by	K.Kuroda		*
*						*
*************************************************
*						*
*	filename actload.c			*
*	   BPS ACTLOAD command			*
*						*
************************************************/

#ifdef __cplusplus
extern "C" {
#endif


/************************************************
	load data from result file
************************************************/
DLLEXPORT int mod_bps_actload()
{
  int           idx[MAX_INDEX];
  int           i, j;

  int           unit_num_int, patt_num_int;
  char          patt_num_char, unit_num_char;
	char         *str1, *str2;

  Header        header;
  float        *dum;
  Buffer       *Data;
  unsigned int  bufsiz;

  rebps();

  /* Get Arguments from SATELLITE Language */
  patt_num_int  = (int) GetScalar(0);
  unit_num_int  = (int) GetScalar(1);

	str1 = GetString(0);
  if(str1 == NULL)
		return 2; /* illegal parameter */
  patt_num_char = *str1;
	str2 = GetString(1);
  if(str2 == NULL)
		return 2; /* illegal parameter */
  unit_num_char = *str2;

  strcpy(bps_cont.bps_sp.FileName, GetString(2));

  switch (patt_num_char) {
  case 'X':
	case 'x': 
    if ((unit_num_char == 'y') || (unit_num_char == 'Y')) {
      if (LoadHeader(bps_cont.bps_sp.FileName, &header) == -1)
				return 11; /* Illigal File No. */
      idx[0] = header.index[1]; /*  data point    */
      idx[1] = header.index[0]; /*  time(record)  */
      bufsiz = IndexSize(2, idx);
      Data = AllocBuffer(bufsiz);

      message_2d_before(idx);
      for (i = 0; i < idx[0]; i++) {
				for (j = 0; j < idx[1]; j++) {
					dum = (float*)LoadData(bps_cont.bps_sp.FileName, j, &header);
					if (dum==(float*)NULL){
						return 13; /*  Data File Read Error */
					}
					*(Data+i*idx[1]+j) = (double)dum[i];
					FreeData(dum);
				}
				message_2d_after(i, "ACTIVATION");
			}
			printf("\n");
      ReturnSnapshot(Data, 2, idx);
      efree(Data);
    } else {
      if (LoadHeader(bps_cont.bps_sp.FileName, &header) == -1)
				return 11; /* Illegal File No. */
      if (unit_num_int < 1)
				return 130; /* Illigal Unit No. */
      if (unit_num_int > header.index[1])
				return 130; /* Illigal Unit No. */
      Data = AllocBuffer(header.index[0]);

      for (i = 0; i < header.index[0]; i++) {
				dum = (float*)LoadData(bps_cont.bps_sp.FileName, i, &header);
				if(dum==(float*)NULL){
					efree(Data);
					return 13; /* Data File Read Error */
				}
				Data[i] = (double)dum[unit_num_int - 1];
				FreeData(dum);
      }
      message_1d_after("ACTIVATION");
      ReturnSnapshot(Data, 1, header.index);
      efree(Data);
    }
    break;

  case 'y':
  case 'Y':
    if ((unit_num_char != 'x') && (unit_num_char != 'X'))
      return 130; /* Illigal Unit No. */
		if (LoadHeader(bps_cont.bps_sp.FileName, &header) == -1)
			return 11; /* Illigal File No. */
	
    idx[0] = header.index[0];
    idx[1] = header.index[1];
    message_2d_before(idx);

    bufsiz = IndexSize(2, idx);
    Data = AllocBuffer(bufsiz);

    for (i = 0; i < idx[0]; i++){
      dum = (float*)LoadData(bps_cont.bps_sp.FileName, i, &header);
      if(dum==(float*)NULL)
				return 13; /* Data File Read Error */
      for(j=0; j < idx[1]; j++){
	      *(Data+i*idx[1]+j) = (double)dum[j];
      }
      message_2d_after(i, "ACTIVATION");
      FreeData(dum);
    }
    ReturnSnapshot(Data, 2, idx);
    efree(Data);
    printf("\n");
    break;

  default:
    if (LoadHeader(bps_cont.bps_sp.FileName, &header) == -1)
			return 11; /* Illigal File No. */
    if ((patt_num_int < 1) && (patt_num_int > header.index[0]))
      return 132; /* Illigal Pattern No. */

    if ((unit_num_char == 'x') || (unit_num_char == 'X')) {
      idx[0] = header.index[1];
      Data = AllocBuffer((unsigned int)header.index[1]);
      dum = (float*)LoadData(bps_cont.bps_sp.FileName, patt_num_int - 1, &header);
      if(dum==(float*)NULL)
				return 13; /* Data File Read Error */
      for(i=0; i<header.index[1]; i++){
        Data[i] = (double)dum[i];
      }
      ReturnSnapshot(Data, 1, idx);
      message_1d_after("ACTIVATION");
      efree(Data);
      FreeData(dum);
    }

    else {
      if (unit_num_int < 1)
        return 130; /* Illigal Unit No. */
      if (unit_num_int > header.index[1])
        return 130; /* Illigal Unit No. */

      idx[0] = 1;
      Data = AllocBuffer((unsigned)1);
      dum = (float*)LoadData(bps_cont.bps_sp.FileName, patt_num_int - 1, &header);
      if(dum==(float*)NULL)
				return 13; /* Data File Read Error */
      Data[0] = dum[unit_num_int - 1];
      message_1d_after("ACTIVATION");
      ReturnSnapshot(Data, 1, idx);
      efree(Data);
      FreeData(dum);
    }
  }

  wrbps();
  return 0;
}

#ifdef __cplusplus
}
#endif