# Configure paths for pthread
# Yoshihiro OKUMURA

dnl AM_PATH_PTHREAD()
dnl test for pthread, and define PTHREAD_CFLAGS and PTHREAD_LIBS
dnl
AC_DEFUN(AM_PATH_PTHREAD,
[dnl
# define pthread_test() program
  m4_define([pthread_test],[
  #include <pthread.h>
  static int n;
  void *func(void *data){ n=1234; return (void*)&n; }
  int main(){
    pthread_t t;
    void *ret;
    pthread_create(&t, NULL, func, 0);
    pthread_join(t,&ret);
    exit(n!=1234 || ret!=(void*)&n);
  }])

  PTHREAD_LIBS=""
  PTHREAD_CFLAGS=""
# checking header
  have_pthreads=no
  AC_CHECK_HEADER(pthread.h, have_pthreads=yes)
  if test "x$have_pthreads" = xno; then
    AC_MSG_ERROR(*** Unable to locate working posix thread library ***)
  fi
# checking -pthread or -pthreads trick
  pthread_trick=""
  for flag in pthread pthreads; do
    ac_save_cflags="$CFLAGS"
    CFLAGS="$CFLAGS -$flag"
    AC_TRY_RUN(pthread_test(),
               pthread_flag_works=yes,
               pthread_flag_works=no,
               [AC_LINK_IFELSE(pthread_test(),
                               pthread_flag_works=yes,
                               pthread_flag_works=no)])
    CFLAGS="$ac_save_cflags"
    if test $pthread_flag_works = yes; then
       pthread_trick=-$flag
    fi
  done
# checking libs
  ac_save_libs="$LIBS"
  LIBS="$pthread_trick $LIBS"
  PTHREAD_LIBS=error
  AC_CHECK_LIB(pthread, pthread_attr_init, PTHREAD_LIBS="-lpthread")
  if test "x$PTHREAD_LIBS" = xerror; then
    AC_CHECK_LIB(pthreads, pthread_attr_init, PTHREAD_LIBS="-lpthreads")
  fi
  if test "x$PTHREAD_LIBS" = xerror; then
    AC_CHECK_LIB(thread, pthread_attr_init, PTHREAD_LIBS="-lthread")
  fi
  if test "x$PTHREAD_LIBS" = xerror; then
    AC_CHECK_LIB(c_r, pthread_attr_init, PTHREAD_LIBS="-lc_r")
  fi
  if test "x$PTHREAD_LIBS" = xerror; then
    AC_CHECK_FUNC(pthread_attr_init, PTHREAD_LIBS="")
  fi
  if test "x$PTHREAD_LIBS" = xerror; then
    AC_MSG_ERROR(*** Unable to locate working posix thread library ***)
  fi
  LIBS="$ac_save_libs"
# checking cflags
  PTHREAD_CFLAGS="-D_REENTRANT"
  case "$target" in
    *-*-bsdi*)
      PTHREAD_CFLAGS="$PTHREAD_CFLAGS -D_THREAD_SAFE"
      ;;
    *-*-darwin*)
      PTHREAD_CFLAGS="-D_THREAD_SAFE"
# causes Carbon.p complaints?
#     PTHREAD_CFLAGS="-D_REENTRANT -D_THREAD_SAFE"
      ;;
    *-*-freebsd*)
      PTHREAD_CFLAGS="$PTHREAD_CFLAGS -D_THREAD_SAFE"
      ;;
    *-*-netbsd*)
      PTHREAD_CFLAGS="$PTHREAD_CFLAGS -I/usr/pkg/include"
      PTHREAD_LIBS="-L/usr/pkg/lib -lpthread -lsem"
      ;;
    *-*-openbsd*)
      PTHREAD_LIBS="-pthread"
      ;;
    *-*-solaris*)
      if test x"$PTHREAD_LIBS" = x"-lpthread"; then
        ac_save_libs="$LIBS"
        LIBS="$pthread_trick $LIBS $PTHREAD_LIBS"
        AC_CHECK_LIB(posix4, pthread_attr_init, PTHREAD_LIBS="$PTHREAD_LIBS -lposix4")
        LIBS="$ac_save_libs"
      fi
      PTHREAD_CFLAGS="$PTHREAD_CFLAGS -D_THREAD_SAFE"
      ;;
    *-*-sysv5*)
      PTHREAD_CFLAGS="$PTHREAD_CFLAGS -Kthread"
      ;;
    *-*-irix*)
      PTHREAD_CFLAGS="-D_SGI_MP_SOURCE"
      ;;
    *-*-aix*)
      PTHREAD_CFLAGS="$PTHREAD_CFLAGS -mthreads"
      ;;
    *-*-hpux11*)
      PTHREAD_LIBS="-L/usr/lib -lpthread"
      ;;
    *-*-qnx*)
      PTHREAD_CFLAGS=""
      PTHREAD_LIBS=""
      ;;
    *)
      ;;
  esac
  PTHREAD_LIBS="$pthread_trick $PTHREAD_LIBS"
  # Save the original compiler flags and libraries
  ac_save_cflags="$CFLAGS"; ac_save_libs="$LIBS"
  # Add the pthread compiler flags and libraries
  CFLAGS="$CFLAGS $PTHREAD_CFLAGS";
  LIBS="$LIBS $PTHREAD_LIBS"
  # Check to see if we have pthread support on this system
  AC_MSG_CHECKING(for pthreads)
  AC_TRY_RUN(pthread_test(),working_pthreads=yes,working_pthreads=no)
  AC_MSG_RESULT($working_pthreads)
  # Restore the compiler flags and libraries
  CFLAGS="$ac_save_cflags"; LIBS="$ac_save_libs"
  if test x"$working_pthreads" = x"no" ; then
    AC_MSG_ERROR(*** Unable to locate working posix thread library ***)
  fi
  AC_SUBST(PTHREAD_CFLAGS)
  AC_SUBST(PTHREAD_LIBS)
])
