/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: pipe.h,v 1.1.1.1 2004/03/31 08:15:07 orrisroot Exp $ */
#ifndef __PIPESTREAM_H__
#define __PIPESTREAM_H__

#ifndef RETSIGTYPE
#define RETSIGTYPE void
#endif

typedef RETSIGTYPE (*SIGNALTYPE)(int);

class PipeStream {
private:
  bool in_pipe,open_pipe;
  tty_console *console;
  sl4_fd_t ttyout, ttyerr;
  sl4_fd_t out[2];
  int  pid;
  void internal_ls(const char *args);
  void internal_cd(const char *args);
  void internal_pwd(const char *args);
public:
  PipeStream(tty_console *con);
  ~PipeStream();
  void set_in_pipe(bool s){ in_pipe=s; }
  bool get_in_pipe(void){ return in_pipe; }
  void set_open_pipe(bool s){ open_pipe=s; }
  bool get_open_pipe(void){ return open_pipe; }
  bool makepipe(const char *bin);
  void closepipe(std::string& str);
  std::string external_cmd(const char *cmd,bool usepipe);
  bool        internal_cmd(const char *cmd);
};
#endif // __PIPESTREAM_H__
