/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: acc.cpp,v 1.2 2004/08/26 13:34:09 orrisroot Exp $ */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "SL_header.h"

#include <libsatellite.h>

#define  __IMPORTSYMBOL__
#include "SL_exception.h"
#include "history.h"
#include "module.h"
#include "tty_console.h"
#include "SL_Index.h"
#include "Base_Buffer.h"
#include "Series_Buffer.h"
#include "Snapshot_Buffer.h"
#include "String_Buffer.h"
#include "Scalar_Buffer.h"
#include "SL_Tool.h"
#include "SL_Object.h"
#include "SymbolList.h"
#include "SystemCommon.h"
#undef   __IMPORTSYMBOL__

#include "acc.h"

#ifdef __cplusplus
extern "C" {
#endif

/* accumulator */
static hash_table_t *accumulator = NULL;

static void _acc_del_func(void *data, void *arg){
  SL_Object *obj = (SL_Object*)data;
  if(obj->empty()){
    delete_SL_Object(obj);
  }
}

int acc_table_init(){
  accumulator = hash_table_ptr_new();
  if(accumulator == NULL)
    return -1;
  return 0;
}

void acc_table_clean(){
  hash_table_delete(accumulator, _acc_del_func, NULL);
}

void acc_gc(){
  hash_table_erase(accumulator, _acc_del_func, NULL);
}

int acc_add(SL_Object *obj){
  if(obj == NULL) return 0;
  if(hash_table_insert(accumulator, obj, obj) != 0)
    return -1;
  return 0;
}

int acc_del(SL_Object *obj){
  if(hash_table_remove(accumulator, obj) != 0)
    return -1;
  return 0;
}

#ifdef __cplusplus
}
#endif
