/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: Program.h,v 1.2 2004/08/26 13:34:09 orrisroot Exp $ */
#ifndef __PROGRAM_H__
#define __PROGRAM_H__

#ifndef __STACKMACHINE_H__
class StackMachine;
typedef void (StackMachine::*STACKFUNC)();
#endif

#define PROG_TYPE_PROG  1
#define PROG_TYPE_SYM   2
#define PROG_TYPE_PPTR  3
#define PROG_TYPE_FUNC  4
#define PROG_TYPE_DATA  5
#define PROG_TYPE_OBJ   6

class Program {
private:
  int type;
  union {
    STACKFUNC  prog;
    symbol_t  *sym;
    Program   *pptr;
    int        data;
    SL_Object *obj;
  } dat;
  Program *next,*prev;
public:
  Program() : next(0), prev(0) { dat.prog=0; }
  ~Program();
  STACKFUNC GetProgram(){return dat.prog;}
  symbol_t *GetSymbol(){return dat.sym;}
  Program *GetProgPtr(){return dat.pptr;}
  int GetData(){return dat.data;}
  SL_Object *GetObj(){return dat.obj;}
  Program *GetNext(){return next;}
  Program *GetPrev(){return prev;}
  Program *operator+(int p);
  Program *operator-(int p);
  void SetProgram(STACKFUNC p){ dat.prog=p; type=PROG_TYPE_PROG;}
  void SetSymbol(symbol_t *p){  dat.sym=p; type=PROG_TYPE_SYM;}
  void SetProgPtr(Program *p){  dat.pptr=p; type=PROG_TYPE_PPTR;}
  void SetData(int p){          dat.data=p; type=PROG_TYPE_DATA;}
  void SetObj(SL_Object *p){    dat.obj =p; type=PROG_TYPE_OBJ;}
  void SetNext(Program *n){next=n;}
  void SetPrev(Program *p){prev=p;}
};

class Program_List {
private:
  Program *top,*pc;
public:
  Program_List(): top(0), pc(0) {}
  ~Program_List(){ Program_Init(); }
  void Program_Init();
  Program *Program_Add(STACKFUNC add);
  Program *Symbol_Add(symbol_t *add);
  Program *Data_Add(int add);
  Program *Obj_Add(SL_Object *add);
  Program *Get_PC(){return pc;}
  Program *Get_Top(){return top;}
  void     Set_PC(Program *set){pc=set;}
  void     Init_PC(){pc=top;}
  Program *Inc_PC(){if(pc!=0)pc=pc->GetNext();return pc;}
  Program *Dec_PC(){if(pc!=0)pc=pc->GetPrev();return pc;}
  bool Program_Set(int p,STACKFUNC func);
};

class SubProgram {
private:
  Program_List sub;
  int narg;
  symbol_t      **arg_symbols;
  symbol_t       *my_sym;
  std::stack<SL_Object**> symtab_objs_stack;
  std::stack<symbol_t**>  symtab_syms_stack;
public:
  symbol_table_t *lo_symtab;
  SubProgram(symbol_t *sym);
  ~SubProgram();
  symbol_t *my_symbol(){ return my_sym; }
  Program_List *GetProgList(){return &sub;}
  int pickup_args(symbol_t *sym);
  int  GetNarg(){return narg;}
  symbol_t **GetArgSymbols(){return arg_symbols;}
  int push_syms();
  int pop_syms();
};

#endif
