/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: LexicalAnalizer.h,v 1.1.1.1 2004/03/31 08:15:07 orrisroot Exp $ */
#ifndef __LEXICALANALIZER_H__
#define __LEXICALANALIZER_H__

class StackMachine;
class LexicalAnalizer {
private:
  friend class sl_shell;
  StackMachine *stackmachine;
  tty_console  *console;
  int c,in_comment;
  bool top;
  char stream[1024];
  char *streamptr;
  bool  contflag;

  bool  keep_alive, rc_finished, setup_finished, clean_finished,clean_need;
  std::string rc_file,setup_file,clean_file;
  std::list<std::string> infiles;

  char *getnum(unsigned char *st);
  unsigned char *exponent(unsigned char *st);
  char *gettoken(char *oneline, char *token, int siz, int mode);
  int   number();
  int   token();
  bool  is_external_cmd(const char *sbuf, char *full, size_t len);
  bool  is_internal_cmd(const char *sbuf);
  int   quoted_string(int quote);
  char *getline(char *str,int sepa);
  int   follow(int expect, int ifyes, int ifno);
  int   backslash(int c);

  // inline macros
  int stream_getc(){
    int ret;
    ret = *(unsigned char*)streamptr;
    streamptr++;
    return ret;
  } // GETC()
  void  stream_ungetc(){--streamptr;}       // UNGETC()
  int stream_lookup(){ return *(unsigned char*)streamptr; } // LOOKUP()
  void  space_skip();                       // SPACE_SKIP()
                                            
  // parts of getstream()
  int   break_comment(int echo);
  void  comment_proc();
  int   c_like_comment();
  char *nextarg(char *sbuf, const char *separator);
  void  prepro(char *oneline, size_t bsize);
  void  alias_proc(char *oneline, size_t bsize);
public:
  std::stack<Inline*> inline_stack;
  CommandAlias alias;
  LexicalAnalizer(StackMachine *s,tty_console *con);
  ~LexicalAnalizer();
  bool InitStream(const char *st);
  int yylex();
  int getstream(int pn);
  void flush_stream();
  bool moreinput(int yyparse_flag);
};
#endif
