/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: CommandAlias.cpp,v 1.1.1.1 2004/03/31 08:15:07 orrisroot Exp $ */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include "SL_header.h"

#include <libsatellite.h>

#define  __IMPORTSYMBOL__
#include "SL_exception.h"
#include "history.h"
#include "module.h"
#include "tty_console.h"
#undef   __IMPORTSYMBOL__
#define  __EXPORTSYMBOL__
#include "CommandAlias.h"

using namespace std;

CommandAlias::~CommandAlias(){
  for(it=alias.begin();it!=alias.end();it++){
    delete (*it);
  }
}

void CommandAlias::trim(string &str){
  size_t len;
  /* trim left space */
  while(!str.empty()){
    if(str[0]==' '|| str[0]=='\n' || str[0]=='\t' || str[0]=='\r'){
      str.erase(0,1);
    }else{
      break;
    }
  }
  /* trim tail space */
  len = str.length() - 1;
  while(!str.empty()){
    if(str[len]==' '|| str[len]=='\n' || str[len]=='\t' || str[len]=='\r'){
      str.erase(len,1);
      len--;
    }else{
      break;
    }
  }
}

void CommandAlias::Print(tty_console *con){
  for(it=alias.begin();it!=alias.end();it++)
    con->tty_printf("       %s       %s\n", (*it)->nick.c_str(), (*it)->real.c_str());
}

void CommandAlias::Install(const char *n,const char *r){
  const char *prev;
  Alias *tmp;
  if(n==0) return;
  try{ tmp = new Alias; }catch(bad_alloc){return;}
  tmp->nick=n;
  trim(tmp->nick);
  if(r){
   tmp->real=r;
   trim(tmp->real);
  }
  if(tmp->real.empty()){
    Delete(tmp->nick.c_str());
    delete tmp;
  }else{
    prev = LookUp(tmp->nick.c_str());
    if(prev) Delete(tmp->nick.c_str());
    alias.push_back(tmp);
  }
}

void CommandAlias::Delete(const char *n){
  string tmp;
  if(n==0)return;
  if(alias.empty())return;
  tmp = n;
  for(it=alias.begin();it!=alias.end();it++){
    if(!strcmp((*it)->nick.c_str(),tmp.c_str())){
      delete (*it);
      alias.erase(it);
      break;
    }
  }
  return;
}

const char *CommandAlias::LookUp(const char *n){
  size_t nlen,len;
  if(n==0||*n=='\0')return 0;
  if(alias.empty())return 0;
  nlen=strlen(n);
  for(it=alias.begin();it!=alias.end();it++){
    len=(*it)->nick.length();
    if( (nlen==len) && (!strcmp((*it)->nick.c_str(),n))){
      if((*it)->real.empty())return 0;
      return (*it)->real.c_str() ;
    }
  }
  return 0;
}
