/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: module.h,v 1.2 2004/04/09 01:56:11 orrisroot Exp $ */
#ifndef __SL_MODULE__
#define __SL_MODULE__
#include "declspec.h"

typedef int (*module_function_t)(void);
typedef int (*module_function_main_t)(int);

#define SL4_MODULE_ATTACH 0
#define SL4_MODULE_DETACH 1

typedef struct _module_t {
  char *module_name;
  hash_table_t *messages;
  hash_table_t *errors;
  hash_table_t *commands;
  int   is_loaded;
  void *library;
  module_function_main_t main_function;
  module_function_t      init_function;
  module_function_t      clean_function;
  char *dll_file;
  char *ini_file;
  char *err_mesg;
} module_t;

typedef struct _module_message_t {
  int   number;
  char *message;
} module_message_t;

typedef struct _module_command_t {
  char  *command_name;
  char  *function_name;
  int    argc;
  char **argv;
  int   *message_number;
  module_function_t    function;
  char               **messages;
  module_t *module;
} module_command_t;

DECLSPEC module_t *module_new(const char *name);
DECLSPEC void      module_delete(module_t *mod);
DECLSPEC int       module_load(module_t *mod);
DECLSPEC int       module_unload(module_t *mod);

DECLSPEC int       module_set_dll(module_t *mod, const char *file);
DECLSPEC int       module_set_ini(module_t *mod, const char *file);

/* module callback event number */
#define MODULE_EVENT_NEW    0
#define MODULE_EVENT_LOAD   1
#define MODULE_EVENT_UNLOAD 2
#define MODULE_EVENT_DELETE 3

typedef void (*module_event_callback_t)(int event, module_t *mod);

DECLSPEC void module_set_callback(module_event_callback_t cb);

#endif // __SL_MODULE__
