/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: mathfunc.h,v 1.1.1.1 2004/03/31 08:15:07 orrisroot Exp $ */
#ifndef __MATHFUNCTIONS_H__
#define __MATHFUNCTIONS_H__

#ifdef __cplusplus
extern "C" {
#endif

/* basic operators */
double math_add(double a, double b);
double math_sub(double a, double b);
double math_mul(double a, double b);
double math_div(double a, double b);
double math_mod(double a, double b);
double math_gt(double a, double b);
double math_lt(double a, double b);
double math_ge(double a, double b);
double math_le(double a, double b);
double math_eq(double a, double b);
double math_ne(double a, double b);
double math_and(double a, double b);
double math_or(double a, double b);
double math_not(double a, double dmy);
double math_negate(double a,double dmy);
/* mathematical functions */
double math_int(double a, double dmy);
double math_floor(double a, double dmy);
double math_ceil(double a, double dmy);
double math_round(double a, double dmy);
double math_abs(double a, double dmy);
double math_sign(double a, double dmy);
double math_pow(double a, double b);
double math_exp(double a, double dmy);
double math_log(double a, double dmy);
double math_log2(double a, double dmy);
double math_log10(double a, double dmy);
double math_sqrt(double a, double dmy);
double math_sin(double a, double dmy);
double math_cos(double a, double dmy);
double math_tan(double a, double dmy);
double math_asin(double a, double dmy);
double math_acos(double a, double dmy);
double math_atan(double a, double dmy);
double math_atan2(double a, double b);

#ifdef __cplusplus
}
#endif

#endif /* __MATHFUNCTIONS_H__ */
