/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: index.c,v 1.2 2004/07/29 18:07:53 orrisroot Exp $ */
#define  LIBSATELLITE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>

#include "libsatellite.h"

DLLEXPORT int RegularIndex(int *idx2, int *idx, int n){
  register int	i;
  if(idx2 == NULL) return 0;
  for(i = 0; i < n; i++) {
    if(0 > idx2[i] || idx2[i] >= idx[i] )
      return 0;
  }
  return 1;
}

DLLEXPORT int CopyIndex(int *to, int *from, int n){
  register int    i;
  for(i = 0; i < n; i++) to[i] = from[i];
  return n;
}

DLLEXPORT int EqualIndex(int *to, int *from, int n){
  register int    i;
  for(i = 0; i < n; i++) {
    if(to[i] != from[i])
      return 0;			/* FALSE */
  }
  return 1;			/* TRUE */
}

DLLEXPORT int IndexSize(int dim, int *idx){
  register int	i, siz = 1;
  if(dim == 0 || idx == 0) return 0;
  for(i = 0; i < dim; i++) siz *= idx[i];
  return siz;
}

DLLEXPORT int *SubIndex(int *idx){
  return idx + 1;
}


DLLEXPORT int _Index(int *idx2, int dim, int *idx){
  register int	i, fac = 1, n = 0;
  if(dim == 0) return 0;
  for(i = dim - 1; i >= 0; i--) {
    n += fac * idx2[i];
    fac *= idx[i];
  }
  return n;
}

DLLEXPORT int *rIndex(int n, int *idx2, int dim, int *idx){
  /* n    : data point        */
  /* idx2 : index of data     */
  /* dim  : dimension of data */
  /* idx  : range of index    */
  register int	i, siz;
  siz = (dim == 1) ? 1 : IndexSize(dim - 1, SubIndex(idx));
  for(i = 0; i < dim; i++) {
    idx2[i] = n / siz;
    n %= siz;
    if(siz != 1) siz /= idx[i+1];
  }
  return idx2;
}

DLLEXPORT void MaxIndex(int *a, int *b, int *idx, int dim){
  register int i;
  for(i = 0; i < dim; i++) 
    idx[i] = Max(a[i], b[i]);
}

DLLEXPORT void MinIndex(int *a, int *b, int *idx, int dim){
  register int i;
  for(i = 0; i < dim; i++) 
    idx[i] = Min(a[i], b[i]);
}
