/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SystemCommon.h,v 1.3 2004/12/17 12:39:50 orrisroot Exp $ */
#ifndef  __SYSTEMCOMMON_H__
#define  __SYSTEMCOMMON_H__
#include "declspec.h"

#define  SUCCESS   0
#define  OUT_MEM   1
#define  OPEN_ER   2
#define  READ_DT   3
#define  WRITE_DT  4
#define  READ_HD   5
#define  WRITE_HD  6
#define  OUT_INDEX 7
#define  ILL_INDEX 8
#define  ILL_DIM   9
#define  DIM_MIS   10
#define  NO_READY  11
#define  BSIZ_MIS  12
#define  UNLINK    13
typedef double Buffer;

typedef struct {
  void   *ptr;
  size_t  size;
} __SystemCommonMemoryStruct;

class DECLSPEC SystemCommon {
private:
  int narg;
  int ErrorNO;
  SL_Object **argv;
  symbol_t  **argv_sym;
  SL_Object *ret;
  SL_Object *GetBufferFromID(int);
  std::list<__SystemCommonMemoryStruct> mem_struct;
  std::list<__SystemCommonMemoryStruct>::iterator mem_it;
  bool compat2x;
public:
  tty_console *console;
  symbol_table_t *gl_symtab;
  symbol_table_t *lo_symtab;
  symbol_table_t *cur_symtab;
  SystemCommon(tty_console *con);
  ~SystemCommon();
  void ComCallInit(int oargc,SL_Object **oargv, symbol_t **oargv_sym);
  symbol_t *get_symbol(int n);
  SL_Object *ComCallQuit();
  char   *SCsl4_getstr(char *buf, int siz);
  int     SCGetArgNum(){return narg;}
  char   *SCGetArgType(int n);
  int     SCGetBufferID(int n);
  double  SCGetScalar(int n);
  std::string *SCGetStringMem(int n, int *dim, int *index);
  double *SCGetSeriesMem(int n, int *dim, int *index);
  char   *SCGetString(int n);
  double *SCGetSeries(int n, int *dim, int *index);
  double *SCGetSnapshot(int n, int *dim, int *index){
    return SCGetSeries(n,dim,index);
  }
  void SCReturnSeries(double *buf,int dim,int *index);
  void SCReturnSnapshot(double *buf,int dim,int *index);
  void SCReturnScalar(double sc);
  void SCReturnString(char *str);
  Buffer *SCAllocBuffer(unsigned  buf_size);
  Buffer *SCCAllocBuffer(unsigned buf_size);
  int SCFreeBuffer(Buffer *area);
  //  int SCDestroyBuffer(int n);
  int SCInitBuffer(int n, int dim, int *index);
  Buffer *SCReadBuffer(int n, int *dim, int *index);
  Buffer *SCGetBuffer(int n, int *dim, int *index){
    return SCReadBuffer(n,dim,index);
  }
  int SCWriteBuffer(int n,int dim,int *index,Buffer *area);
  int SCPutBuffer(int n, int dim, int *index,Buffer *area){
    return SCWriteBuffer(n,dim,index,area);
  }
  int SCGetHeader(int n, int *index){
    int dim;
    SL_Object *obj;
    obj=GetBufferFromID(n);
    if(obj!=NULL && obj->GetBufferPointer()==NULL)return -1;
    obj->GetBufferPointer()->GetIndexInfo(&dim,index);
    return dim;
  }
  int SCPutHeader(int n,int dim,int *index){
    ErrorNO=SUCCESS;
    SL_Object *obj;
    obj=GetBufferFromID(n);
    if(obj!=NULL && obj->GetBufferPointer()==NULL)return -1;
    obj->GetBufferPointer()->SetIndexInfo(dim,index);
    return ErrorNO;
  }
  int SCAppendBuffer(int n,int sub_dim,int *sub_index,Buffer *area);
  Buffer *SCReadSubBuffer(int n,int time,int *sub_dim,int *sub_index);
  int SCWriteSubBuffer(int n,int t,int sub_dim,int *sub_index,Buffer *area);
  Buffer *SCReadTimeSeries(int n,int sub_dim,int *sub_index,int *length);
  int SCWriteTimeSeries(int n,int sub_dim,int *sub_index,Buffer *area,int len);
  int SCGetBufferInfo(int n,int *index){return SCGetHeader(n,index);}

  // memory allocation functions
  void *SCmalloc(size_t size);
  void *SCcalloc(size_t num, size_t size);
  void  SCfree(void *ptr);
  void *SCrealloc(void *ptr, size_t size);

  // console access functions
  int SCprintf(const char *fmt,...);
  int SCfprintf(int fp, const char *fmt, ...);
  int SCfprintf(FILE *fp, const char *fmt, ...);
};

#ifdef __SYSTEMCOMMON_MAIN__
DECLSPEC SystemCommon *syscom;
#else
extern DECLSPEC SystemCommon *syscom;
#endif

#endif
