/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SymbolList.h,v 1.4 2004/09/24 15:59:07 orrisroot Exp $ */
#ifndef __SYMBOLLIST_H__
#define __SYMBOLLIST_H__
#include "declspec.h"

/* symbol type definition */
#define SYMBOL_TYPE_UNDEF   0
#define SYMBOL_TYPE_VAR     1
#define SYMBOL_TYPE_CONST   2
#define SYMBOL_TYPE_PROC    3
#define SYMBOL_TYPE_FUNC    4
#define SYMBOL_TYPE_MODULE  5
#define SYMBOL_TYPE_CLASS   6
#define SYMBOL_TYPE_BLTIN   7
#define SYMBOL_TYPE_OPCODE  8
#define SYMBOL_TYPE_SATCOM  9

/* symbol callback event number */
#define SYMBOL_EVENT_UPDATE   0
#define SYMBOL_EVENT_DELETE   1

/* symbol list callback event number */
#define SYMLIST_EVENT_ADD        0
#define SYMLIST_EVENT_DELETE     1

typedef struct _symbol_t {
  char *name;
  int   type;
  SL_Object *object;
  int   ref_cnt;
  struct _symbol_t **ref;
  struct _symbol_t  *dep;
  sl4_list_t *cblist;
} symbol_t ;

typedef void (*symbol_callback_t)(int event, symbol_t *sym, void *data);
typedef void (*symlist_event_callback_t)(int event, symbol_t *sym);

typedef struct _symbol_table_t {
  hash_table_t *table;
} symbol_table_t;


DECLSPEC symbol_t       *symbol_new(const char *name, SL_Object *obj, 
                                    int type);
DECLSPEC int             symbol_get_type(symbol_t *sym);
DECLSPEC SL_Object      *symbol_get_object(symbol_t *sym);
DECLSPEC SL_Object      *symbol_get_single_object(symbol_t *sym);
DECLSPEC int             symbol_set_object(symbol_t *sym, SL_Object *obj, 
                                           int type);
DECLSPEC int             symbol_set_depend(symbol_t *sym, symbol_t *dep);
DECLSPEC int             symbol_undef(symbol_t *sym);
DECLSPEC void            symbol_delete(symbol_t *sym);

DECLSPEC symbol_table_t *symbol_table_new();
DECLSPEC void            symbol_table_delete(symbol_table_t *symtab);
DECLSPEC symbol_t       *symbol_table_lookup(symbol_table_t *symtab,
                                             const char *name);
DECLSPEC int             symbol_table_install(symbol_table_t *symtab,
                                              symbol_t *sym);
DECLSPEC void            symbol_table_set_undef(symbol_table_t *symtab);
DECLSPEC int             symbol_table_undef(symbol_table_t *symtab,
                                            const char *name);
DECLSPEC int             symbol_table_undefall(symbol_table_t *symtab);
DECLSPEC int             symbol_table_move(symbol_table_t *dstst,
                                           symbol_table_t *srcst,
                                           symbol_t *sym);
DECLSPEC void            symbol_table_listup(symbol_table_t *symtab,
                                             tty_console *con, int is_global);

/* symbol event callback */
DECLSPEC void symbol_do_event(symbol_t *sym, int event);
DECLSPEC int  symbol_add_callback(symbol_t *sym, symbol_callback_t cb, 
                                  void *data);
DECLSPEC int  symbol_remove_callback(symbol_t *sym, symbol_callback_t cb, 
                                     void *data);

/* symbol list evnet call back */
DECLSPEC void   symlist_set_var_callback(symlist_event_callback_t cb);
DECLSPEC void   symlist_set_module_callback(symlist_event_callback_t cb);
#endif
