/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: Series_Buffer.h,v 1.1.1.1 2004/03/31 08:15:07 orrisroot Exp $ */
#ifndef __SERIES_BUFFER_H__
#define __SERIES_BUFFER_H__
#include "declspec.h"

class DECLSPEC Series_Buffer : public Base_Buffer {
public:
  Series_Buffer();
  ~Series_Buffer();
  Base_Buffer *duplicate();
  bool  CopyBuffer(Base_Buffer *from);
  bool  InitBuffer();
  bool  FreeBuffer();
  bool  AllocBuffer(unsigned size);
  bool  ClAllocBuffer(unsigned size);
  bool  ReAllocBuffer(unsigned size);
  bool  SetData(Index point, double val);
  double GetData(Index point);
  int    AppendBuffer(Series_Buffer *sub);
  Series_Buffer *GetSubBuffer(int time);
  Series_Buffer *GetTimeSeries(Index point);
  int PutSubBuffer(int time, Series_Buffer *sub);
  int PutTimeSeries(Index point, Series_Buffer *buf);
};

#endif
