/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SL_Object.h,v 1.2 2004/04/07 14:17:39 orrisroot Exp $ */
#ifndef __SL_OBJECT_H__
#define __SL_OBJECT_H__
#include "declspec.h"

#define MATH_ADD         0
#define MATH_SUB         1
#define MATH_MUL         2
#define MATH_DIV         3
#define MATH_MOD         4
#define MATH_GT          5
#define MATH_LT          6
#define MATH_GE          7
#define MATH_LE          8
#define MATH_EQ          9
#define MATH_NE         10
#define MATH_AND        11
#define MATH_OR         12
#define MATH_NOT        13
#define MATH_NEGATE     14
#define MATH_INT        15
#define MATH_FLOOR      16
#define MATH_CEIL       17
#define MATH_ROUND      18
#define MATH_ABS        19
#define MATH_SIGN       20
#define MATH_POW        21
#define MATH_EXP        22
#define MATH_LOG        23
#define MATH_LOG2       24
#define MATH_LOG10      25
#define MATH_SQRT       26
#define MATH_SIN        27
#define MATH_COS        28
#define MATH_TAN        29
#define MATH_ASIN       30
#define MATH_ACOS       31
#define MATH_ATAN       32
#define MATH_ATAN2      33
#define MATH_SIZE       34

namespace SL_OBJ {
  enum TYPE { UNDEF_O,    SERIES_O,
	      SNAPSHOT_O, STRING_O,
	      SCALAR_O,   BUILTIN_O,
	      CONSTANT_O, MODULE_NAME_O,
              SATCOM_O };
}

class DECLSPEC SL_Object {
private:
  SL_OBJ::TYPE objtype;
  int link;
  Base_Buffer *buffer;
  void print_number(char *fmt,char *def, double d);
  void index_header(int i,char *fmt, int win_c);
  int  formatting(char *fmt, size_t index_width, int win_c);
  SL_Object *scalar_op(int dptr_n, SL_Object *obj);
  SL_Object *series_op(int dptr_n, SL_Object *obj);
  SL_Object *snapshot_op(int dptr_n, SL_Object *obj);
  SL_Object *string_op(int dptr_n, SL_Object *obj);
public:
  SL_Object(SL_OBJ::TYPE type, Base_Buffer *src);
  ~SL_Object();
  int  IsTrue();
  void obj_ref(){ link++; }
  void obj_unref();
  bool empty();
  SL_OBJ::TYPE TypeofOBJ(){return objtype;}
  void SetType(SL_OBJ::TYPE type){objtype=type;}
  SL_Object *obj_dup();
  Base_Buffer *GetBufferPointer(){return buffer;}
  bool Init(SL_OBJ::TYPE type, Index idx);
  SL_Object *Array(Index point);
  void ArrayAsgn(Index point, SL_Object *from);
  SL_Object *Snap(int time);
  void SnapAsgn(int time, SL_Object *from);
  SL_Object *Opecode(int dptr_n, SL_Object *obj);
  void Read();
  void Print(char *fmt, int win_c);
  char *TypeName();
};

DECLSPEC SL_Object *new_SL_Object(SL_OBJ::TYPE type, Base_Buffer *src);
DECLSPEC void       delete_SL_Object(SL_Object *obj);
#endif
