/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SL_Index.h,v 1.1.1.1 2004/03/31 08:15:07 orrisroot Exp $ */
#ifndef __INDEX_H__
#define __INDEX_H__
#include "declspec.h"

class DECLSPEC Index {
protected:
  int  dim;
  int  index[MAX_INDEX];
public:
  Index();
  bool  SetIndexInfo(int d,int *in);
  bool  GetIndexInfo(int *d,int *in);
  void  CopyIndex(Index from);
  void  SetIndex(int num, int val){index[num]=val;}
  int   GetIndex(int num){return index[num];}
  void  SetDim(int val){dim=val;}
  int   GetDim(){return dim;}
  bool  RegularIndex(Index idx);
  bool  EqualIndex(Index idx);
  int   IndexSize();
  Index SubIndex();
  int   SubIndexSize(){
    int i;
    if(index[0]==0)return 0;
    i=IndexSize();
    return i/index[0];
  }
  int   DataPoint(Index point);
  Index rIndex(int n);
};
#endif
