/* 
 * Copyright (c) 2003 RIKEN (The Institute of Physical and Chemical Research)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY RIKEN AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL RIKEN OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

/* $Id: SL_Index.cpp,v 1.2 2004/07/29 18:07:53 orrisroot Exp $ */
#define  LIBSATELLITE_EXPORTS

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "SL_header.h"

#define  __EXPORTSYMBOL__
#include "SL_Index.h"
#undef   __EXPORTSYMBOL__

Index::Index() : dim(0) {
  int i;
  for(i=0; i<MAX_INDEX; i++)
    index[i]=0;
}

bool Index::SetIndexInfo(int d,int *in){
  int i;
  if(in==0){return false;}
  dim=d;
  for(i=0;i<d;i++){
    index[i]=in[i];
  }
  return true;
}

bool Index::GetIndexInfo(int *d,int *in){
  int i;
  if(d==0 || in==0){return false;}
  *d=dim;
  for(i=0;i<dim;i++){
    in[i]=index[i];
  }
  return true;
}

void Index::CopyIndex(Index from){
  int i;
  for( i=0 ; i<MAX_INDEX; i++ )
    index[i]=from.GetIndex(i);
  dim=from.GetDim();
}

// compare idx
bool Index::RegularIndex(Index idx){
  int i;
  for(i=0;i<dim;i++)
    if(index[i]<=idx.GetIndex(i))
      return false;
  return true;
}

bool Index::EqualIndex(Index idx){
  int i;
  for(i=0;i<dim;i++)
    if(index[i]!=idx.GetIndex(i))
      return false;
  return true;
}

// get index size
int Index::IndexSize(){
  int i, size=1;
  if(dim==0 && index[0]==0)
    return size/*return 0*/;	// modify by dsptec 2002.8.26
  for(i=0 ; i<dim ; i++)
    size*=index[i];
  return size;
}

// get sub index
Index Index::SubIndex(){
  int i;
  Index idx;
  for(i=0; i<dim-1; i++)
    idx.SetIndex(i,index[i+1]);
  idx.SetDim( dim==0 ? 0 : dim-1);
  return idx;
}

// calcurate offset
int Index::DataPoint(Index point){
  int i, fac=1, n=0;
  if(dim==0 || index[0]==0) return 0;
  for( i=dim-1; i>=0; i-- ){
    n += fac * point.index[i];
    fac *= index[i];
  }
  return n;
}

// get regular index
Index Index::rIndex(int n){
  int	i, size;
  Index ret;
  size= (dim==1) ? 1 : SubIndex().IndexSize();
  for( i=0 ; i<dim ; i++ ){
    ret.SetIndex(i,n/size);
    n %= size;
    if(size != 1) size /= index[i+1];
  }
  ret.SetDim(dim);
  return ret;
}
