@echo off
setlocal

set DOCUMENT=usersman-ja
set DOCUMENTXML=%DOCUMENT%.xml
set DOCUMENTPDF=%DOCUMENT%.pdf

rem XSL Formmatter

set SCRIPTPATH=%~p0
cd %SCRIPTPATH%\..\..
set TOOLSDIR=%cd%\tools
set PATH=%TOOLSDIR%\win32;%PATH%
cd %SCRIPTPATH%\..
set SGML_CATALOG_FILES=..\docbook\xml\4.2\catalog.xml
set HTMLDIR=%DOCUMENT%
set PDFDIR=pdf-ja

if exist %DOCUMENTXML% goto lintcheck
  echo Error: %DOCUMENTXML% not found.
  pause
  exit /b 1

:lintcheck
call ../tools/docbook-lint.bat %DOCUMENTXML%
if errorlevel 0 goto deldir
  echo Error: some error occured in docbook lint check.
  pause
  exit /b 1

:deldir
if exist %HTMLDIR% goto createpdfdir
  echo Error: %HTMLDIR% directory not found.
  pause
  exit /b 1

:createpdfdir
if exist pdf-ja rmdir /s /q %PDFDIR%
mkdir %PDFDIR%
mkdir %PDFDIR%\images
copy  /y %HTMLDIR%\images\*eq*.gif %PDFDIR%\images

:convert
XSLCmd.exe -d %DOCUMENTXML% -s xsl\fo\axf-ja.xsl -o %DOCUMENTPDF%

endlocal
