#!/bin/sh

DOCUMENT=usersman-ja

DIRNAME=`dirname $0`
cd $DIRNAME/../
BASEDIR=`pwd`
HTMLDIR=$BASEDIR/$DOCUMENT
LINT=$BASEDIR/../tools/docbook-lint.sh
TEXBASE=tex-math-equations
TEXFILE=$TEXBASE.tex
DVIFILE=$TEXBASE.dvi
LOGFILE=$TEXBASE.log
DOCUMENTXML=$DOCUMENT.xml
DOCUMENTPDF=$DOCUMENT.pdf

SGML_CATALOG_FILES=$BASEDIR/../docbook/xml/4.2/catalog.xml
export SGML_CATALOG_FILES
DVI2BITMAP_PK_PATH=`kpsewhich pk cmr10.110pk | sed 's+/[^/]*$+/%f.%dpk+'`
export DVI2BITMAP_PK_PATH

# xmllint
$LINT $DOCUMENTXML
if [ $? -ne 0 ]; then
  echo "Error: some error occured in docbook lint check."
  exit 1;
fi

if [ -d $HTMLDIR ]; then
  rm -rf $HTMLDIR
fi

mkdir $HTMLDIR
mkdir $HTMLDIR/images
cp xsl/html/etc/*.css $HTMLDIR
cp xsl/html/etc/*.gif $HTMLDIR/images
cp ja/images/*.gif    $HTMLDIR/images

xsltproc --catalogs -o $HTMLDIR/index.html xsl/html/ja.xsl $DOCUMENTXML

if [ -f $HTMLDIR/tex-math-equations.tex ]; then
  cd $HTMLDIR
  latex $TEXFILE
  if [ -f $DVIFILE ]; then
    dvi2bitmap --font-mode=lasf --output-type=gif --magnification=4 --scale=5 --process=blur,transparent --resolution=144 $DVIFILE
  fi
  rm -f *.dvi *.log *.tex *.aux
fi
