@echo off
setlocal

set DOCUMENT=usersman-ja
set DOCUMENTXML=%DOCUMENT%.xml
set DOCUMENTPDF=%DOCUMENT%.pdf

set SCRIPTPATH=%~p0
cd %SCRIPTPATH%\..\..
set TOOLSDIR=%cd%\tools
set PATH=%TOOLSDIR%\win32;%PATH%
cd %SCRIPTPATH%\..
set SGML_CATALOG_FILES=..\docbook\xml\4.2\catalog.xml
set HTMLDIR=%DOCUMENT%

if exist %DOCUMENTXML% goto lintcheck
  echo Error: %DOCUMENTXML% not found.
  pause
  exit /b 1

:lintcheck
call ../tools/docbook-lint.bat %DOCUMENTXML%
if errorlevel 0 goto deldir
  echo Error: some error occured in docbook lint check.
  pause
  exit /b 1

:deldir

if exist %HTMLDIR% rmdir /s /q %HTMLDIR%
mkdir %HTMLDIR%
mkdir %HTMLDIR%\images
copy /y xsl\html\etc\style.css %HTMLDIR%
copy /y xsl\html\etc\*.gif     %HTMLDIR%\images
copy /y ja\images\*.gif        %HTMLDIR%\images

xsltproc.exe --catalogs -o %HTMLDIR%/index.html xsl/html/ja.xsl %DOCUMENTXML%

cd %HTMLDIR%

latex tex-math-equations.tex
if not exist tex-math-equations.dvi goto deltexfile
dvi2bitmap --font-mode=lasf --output-type=gif --magnification=4 --scale=5 --process=transparent,blur --resolution=144 tex-math-equations.dvi

:deltexfile
del /f tex-math-equations.*

endlocal
