npp("pendulum")
nlink();

ntime(10.0,0.01,0.01,0.01);
time=(0~(10.0/0.01))*0.01;

series theta;

nout(theta,"PENDULUM",0,1);
theta0=PI/180*10.0;
npara("PENDULUM","theta0",theta0);
ncal();

phi=PI/180*90;
m=1.0;
l=1.0;
gra=9.8;

true_theta=theta0*sin(sqrt(gra/1)*time+phi);
theta=theta/(PI/180.0);
true_theta=true_theta/(PI/180.0);

wopen(1,"A4",0,1);
origin(25,25);
color("white","white");
line(0, 0, 100, 100, "BF");
color("black","black")
origin(40,40);
size(80,80);
title(1,"time[s]","angle[deg]");
scale("N","F","N","F",0,10,-30,30);
axis(1,1,"XY","XY",5,0,3,2,15,0);
frame();
graph(theta,time,0,1,10,0,2);
graph(true_theta,time,0,0,0,0,0);
