#!/bin/sh

DOCUMENT=reference-ja

DOCUMENTXML=$DOCUMENT.xml
DOCUMENTPDF=$DOCUMENT.pdf

DIRNAME=`dirname $0`
cd $DIRNAME/../
BASEDIR=`pwd`
HTMLDIR=$BASEDIR/$DOCUMENT
LINT=$BASEDIR/../tools/docbook-lint.sh
TEXBASE=tex-math-equations
TEXFILE=$TEXBASE.tex
DVIFILE=$TEXBASE.dvi
LOGFILE=$TEXBASE.log

SGML_CATALOG_FILES=$BASEDIR/../docbook/xml/4.2/catalog.xml
export SGML_CATALOG_FILES
#DVI2BITMAP_PK_PATH=`kpsewhich pk cmr10.110pk | sed 's+/[^/]*$+/%f.%dpk+'`
DVI2BITMAP_PK_PATH=`kpsewhich pk cmr10.110pk | sed 's+/[^/]*$++'`
export DVI2BITMAP_PK_PATH

# xmllint
$LINT $DOCUMENTXML
if [ $? -ne 0 ]; then
  echo "Error: some error occured in docbook lint check."
  exit 1;
fi

if [ -d $HTMLDIR ]; then
  rm -rf $HTMLDIR
fi

mkdir $HTMLDIR
mkdir $HTMLDIR/images
cp xsl/html/etc/*.css $HTMLDIR
cp xsl/html/etc/*.gif $HTMLDIR/images
for i in bps builtin constant control dcm declaration gpm ispp math ncs npe operator statistics system utility; do
  if [ -d ja/$i/images ]; then
     cp ja/$i/images/*.gif $HTMLDIR/images
  fi
done

xsltproc --catalogs -o $HTMLDIR/index.html xsl/html/ja.xsl $DOCUMENTXML

if [ -f $HTMLDIR/$TEXFILE ]; then
  cd $HTMLDIR
  latex $TEXFILE
  if [ -f $DVIFILE ]; then
    dvi2bitmap --font-mode=lasf --output-type=gif --magnification=4 --scale=5 --process=blur,transparent --resolution=144 $DVIFILE
  fi
  rm -f *.dvi *.log *.tex *.aux
fi
