#!/bin/sh

AUTOCONF=autoconf
AUTOMAKE=automake
ACLOCAL=aclocal
AUTOHEADER=autoheader
LIBTOOLIZE=libtoolize

# host os check 
if [ ! -f /etc/fedora-release ]; then
   echo "running host is not Fedora Core";
   exit 1;
fi
if [ x"`cat /etc/fedora-release`" != x"Fedora Core release 1 (Yarrow)" ]; then
   echo "running host is not Frdora Core release 1"; 
   exit 1;
fi

set -x
$ACLOCAL -I macros -I config
$AUTOHEADER -I macros -I config
$LIBTOOLIZE --automake --force --copy
#$ACLOCAL -I macros -I config
$AUTOMAKE --foreign --add-missing --copy
$AUTOCONF

if [ -f config.h.in ]; then
  touch config.h.in
fi

if [ -f stamp-h.in ]; then
  touch stamp-h.in
fi

tmp=`find . -name 'autom4te.cache'`
if [ x"$tmp" != x"" ]; then
  rm -rf $tmp;
fi
tmp=`find . -name 'configure.lineno'`
if [ x"$tmp" != x"" ]; then
  rm -f $tmp;
fi
tmp=`find . -name '*~'`
if [ x"$tmp" != x"" ]; then
  rm -f $tmp;
fi

# (cd modules/gpm && sh ./bootstrap.sh)
