
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGITwoAxesHolder;


/**
 * An observer of the property dialog for two-dimensional scalar type data.
 * 
 */
public interface SGISXYDataDialogObserver
	extends SGIDataPropertyDialogObserver, SGITwoAxesHolder
{

	/**
	 * Returns the index of clicked objects.
	 * @return
	 */
	public int getSelectedTabIndex();


	// Line
	public boolean isLineVisible();
	public float getLineWidth( final String unit );
	public int getLineType();
	public Color getLineColor();
	public boolean setLineVisible( final boolean b );
	public boolean setLineWidth( final float width, final String unit );
	public boolean setLineType( final int type );
	public boolean setLineColor( final Color cl );


	// Symbol
	public boolean isSymbolVisible();
	public int getSymbolType();
	public float getSymbolSize( final String unit );
	public float getSymbolLineWidth( final String unit );
	public Color getSymbolInnerColor();
	public Color getSymbolLineColor();
	public boolean setSymbolVisible( final boolean b );
	public boolean setSymbolType( final int type );
	public boolean setSymbolSize( final float size, final String unit );
	public boolean setSymbolLineWidth( final float width, final String unit );
	public boolean setSymbolInnerColor( final Color cl );
	public boolean setSymbolLineColor( final Color cl );


	// Bar
	public boolean isBarVisible();
	public double getBarBaselineValue();
	public double getBarWidthValue();
	public float getBarEdgeLineWidth( final String unit );
	public Color getBarInnerColor();
	public Color getBarEdgeLineColor();
	public boolean setBarVisible( final boolean b );
	public boolean setBarBaselineValue( final double value );
	public boolean setBarWidthValue( final double width );
	public boolean setBarEdgeLineWidth( final float width, final String unit );
	public boolean setBarInnerColor( final Color cl );
	public boolean setBarEdgeLineColor( final Color cl );
	public boolean hasValidBaselineValue( final int config, final Number value );


	// Error Bar
	public boolean isErrorBarHolding();
	public boolean isErrorBarVisible();
	public int getErrorBarHeadType();
	public float getErrorBarHeadSize( final String unit );
	public Color getErrorBarColor();
	public float getErrorBarLineWidth( final String unit );
	public int getErrorBarStyle();
	public boolean setErrorBarVisible( final boolean b );
	public boolean setErrorBarHeadType( final int type );
	public boolean setErrorBarHeadSize( final float size, final String unit );
	public boolean setErrorBarColor( final Color cl );
	public boolean setErrorBarLineWidth( final float width, final String unit  );
	public boolean setErrorBarStyle( final int style );


	// Tick Label
	public boolean isTickLabelHolding();
	public boolean isTickLabelVisible();
	public String getTickLabelFontName();
	public int getTickLabelFontStyle();
	public float getTickLabelFontSize( final String unit );
	public Color getTickLabelColor();
	public boolean isTickLabelHorizontal();
	public boolean setTickLabelVisible( final boolean b );
	public boolean setTickLabelFontName( final String name );
	public boolean setTickLabelFontStyle( final int style );
	public boolean setTickLabelFontSize( final float size, final String unit  );
	public boolean setTickLabelColor( final Color cl );
	public boolean setTickLabelHorizontal( final boolean b );


}

