
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGITwoAxesHolder;

/**
 * An observer of the property dialog for rectangular shapes.
 *
 */
public interface SGIRectangularShapeDialogObserver
	extends SGIPropertyDialogObserver, SGITwoAxesHolder
{


	/**
	 * 
	 * @return
	 */
	public double getLeftXValue();
	

	/**
	 * 
	 * @return
	 */
	public double getRightXValue();

	
	/**
	 * 
	 * @return
	 */
	public double getTopYValue();

	
	/**
	 * 
	 * @return
	 */
	public double getBottomYValue();


	/**
	 * 
	 * @return
	 */
	public float getLineWidth( final String unit );


	/**
	 * 
	 * @return
	 */
	public int getLineType();


	/**
	 * 
	 * @return
	 */
	public Color getLineColor();



	/**
	 * 
	 * @return
	 */
	public Color getInnerColor();


	/**
	 * 
	 * @return
	 */
	public boolean isTransparent();



	/**
	 * 
	 * @param value
	 */
	public void setLeftXValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public void setRightXValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public void setTopYValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public void setBottomYValue( final double value );


	/**
	 * 
	 */
	public boolean setLineWidth( final float lineWidth, final String unit );


	/**
	 * 
	 * @param type
	 * @return
	 */
	public boolean setLineType( final int type );

	/**
	 * 
	 * @param cl
	 */
	public boolean setLineColor( final Color cl );


	/**
	 * 
	 * @param cl
	 */
	public boolean setInnerColor( final Color cl );


	/**
	 * 
	 * @param b
	 * @return
	 */
	public boolean setTransparent( final boolean b );



	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidLeftXValue( final int config, final Number value );


	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidTopYValue( final int config, final Number value );


	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidRightXValue( final int config, final Number value );


	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidBottomYValue( final int config, final Number value );


}

