
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.util.ArrayList;
import java.util.List;

import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;

/**
 * A base dialog class to set the properties of data objects.
 *
 */
public abstract class SGDataDialog extends SGPropertyDialog
{

	/** Creates new form SGPropertyDialogSXYData */
	public SGDataDialog( java.awt.Frame parent, boolean modal )
	{
		super(parent, modal);
	}



	/**
	 * 
	 * @param list
	 * @return
	 */
	protected String getDataNameFromObservers()
	{
		List oList = this.mPropertyDialogObserverList;
		final int len = oList.size();
		if( len==0 )
		{
			return null;
		}

		ArrayList nList = new ArrayList( len );
		for( int ii=0; ii<len; ii++ )
		{
			SGIDataPropertyDialogObserver l
				= (SGIDataPropertyDialogObserver)oList.get(ii);
			nList.add( l.getName() );
		}

		String name0 = (String)nList.get(0);
		String name = name0;
		if( len>1 )
		{
			for( int ii=1; ii<len; ii++ )
			{
				String name1 = (String)nList.get(ii);
				if( name0.equals( name1 ) == false )
				{
					name = null;
					break;
				}
			}
		}

		return name;
	}


	/**
	 * 
	 * @param list
	 * @return
	 */
	protected Boolean getLegendVisibleFromObservers()
	{
		List oList = this.mPropertyDialogObserverList;
		final int len = oList.size();
		if( len==0 )
		{
			return null;
		}

		ArrayList lList = new ArrayList( len );
		for( int ii=0; ii<len; ii++ )
		{
			SGIDataPropertyDialogObserver l
				= (SGIDataPropertyDialogObserver)oList.get(ii);
			lList.add( new Boolean( l.getLegendVisibleFlag() ) );
		}

		Boolean b0 = (Boolean)lList.get(0);
		Boolean b = b0;
		if( len>1 )
		{
			for( int ii=1; ii<len; ii++ )
			{
				Boolean b1 = (Boolean)lList.get(ii);
				if( b0.equals( b1 ) == false )
				{
					b = null;
					break;
				}
			}
		}

		return b;
	}


}

