
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGIFigureDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGITwoAxesHolder;

/**
 * An observer of the dialog for XY-type figures.
 */
public interface SGIXYFigureDialogObserver
	extends SGIFigureDialogObserver, SGITwoAxesHolder
{

	public boolean setGridVisible( final boolean b );
	public boolean setAutoCalculateRange( final boolean b );
	public boolean setGridStepValueX( final double value );
	public boolean setGridStepValueY( final double value );
	public boolean setGridBaselineValueX( final double value );
	public boolean setGridBaselineValueY( final double value );
	public boolean setGridLineWidth( final float width, final String unit );
	public boolean setGridLineType( final int type );
	public boolean setGridLineColor( final Color cl );

	public boolean isGridVisible();
	public boolean isAutoCalculateRange();
	public double getGridStepValueX();
	public double getGridStepValueY();
	public double getGridBaselineValueX();
	public double getGridBaselineValueY();
	public float getGridLineWidth( final String unit );
	public int getGridLineType();
	public Color getGridLineColor();

	public boolean hasValidStepXValue( final Number step );
	public boolean hasValidStepYValue( final Number step );

}

