
package jp.riken.brain.ni.samuraigraph.base;

import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

/**
 * The progress bar.
 */
public class SGProgressBar extends JProgressBar
{

	/**
	 * Minimum value of the progress bar.
	 */
	public static final int PROGRESS_VALUE_MIN = 0;


	/**
	 * Maximum value of the progress bar.
	 */
	public static final int PROGRESS_VALUE_MAX = 100;


	/**
	 * 
	 */
	public SGProgressBar()
	{
		super();
		this.setBorder( new EmptyBorder(0,0,0,0) );
	}


	/**
	 * Set progress value.
	 * @param ratio - progress ratio
	 */
	public void setProgressValue( final float ratio )
	{
		final int min = PROGRESS_VALUE_MIN;
		final int max = PROGRESS_VALUE_MAX;
		final int value = (int)( min + ratio*max );
		final int current = this.getValue();
		int cnt= current;
		if( current == value )
		{
			return;
		}
		else if( current < value )
		{
			while( true )
			{
				this.setValue(cnt);
				cnt++;
				if( cnt>value )
				{
					break;
				}
			}
		}
		else
		{
			while( true )
			{
				this.setValue(cnt);
				cnt--;
				if( cnt<value )
				{
					break;
				}
			}
		}
	}


	/**
	 * 
	 *
	 */
	public void initProgressValue()
	{
		this.setValue( PROGRESS_VALUE_MIN );
	}

}

