
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.colorchooser.DefaultColorSelectionModel;


/**
 * A dialog with color chooser.
 */
public class SGColorDialog extends JDialog
{

	/** Creates new form SGColorDialog */
	public SGColorDialog( final JDialog parent, final String title, final boolean modal )
	{
		super(parent, title, modal);
		initComponents();
		this.initProperty();
	}
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        mColorChooserPanel = new javax.swing.JPanel();
        mColorChooser = new javax.swing.JColorChooser();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mColorChooserPanel.add(mColorChooser);

        getContentPane().add(mColorChooserPanel, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JColorChooser mColorChooser;
    private javax.swing.JPanel mColorChooserPanel;
    // ϐ錾̏I//GEN-END:variables


	// initialize this object
	private void initProperty()
	{
		// hide the preview panel
		mColorChooser.setPreviewPanel( new JPanel() );

		// set original color selection model
		mColorChooser.setSelectionModel( new OriginalColorSelectionModel() );

		// set unresizable
		this.setResizable(false);
	}


	/**
	 * 
	 */
	public JColorChooser getColorChooser()
	{
		return this.mColorChooser;
	}


	// The original color chooser
	private static class OriginalColorSelectionModel
		extends DefaultColorSelectionModel
	{

		private Color selectedColor;

		public OriginalColorSelectionModel()
		{
			super();
			this.selectedColor = Color.white;
		}

		public Color getSelectedColor()
		{
			return this.selectedColor;
		}

		// Overrode so as to throw ChangeEvent object
		// even when the input color is equal to the selected color
		public void setSelectedColor( final Color color )
		{
			if( color!=null )
			{
				this.selectedColor = color;
				this.fireStateChanged();
			}
		}
	}

    
}
