#!/bin/sh
PACKAGE=samurai-graph
APPNAME="Samurai Graph"

BASEDIR=`dirname $0`
cd "$BASEDIR"
TOPDIR=../..
DISTDIR=$TOPDIR/dist
SRCDIR=$TOPDIR/src
RESOURCEDIR=$SRCDIR/resources
DOCDIR=$TOPDIR/../doc
USERSMANDIR=$DOCDIR/usersman-ja
HTMLDIR=$USERSMANDIR/html
PROPERTYFILE=$SRCDIR/resources/samurai-graph.properties
PROPERTY_STRING_VERSION="samurai-graph.version"

# get version string
VERSION=`grep "$PROPERTY_STRING_VERSION" $PROPERTYFILE | sed -e "s+^$PROPERTY_STRING_VERSION=++g" -e "s+.$++g"`
MAJOR_VERSION=`echo $VERSION | \
     sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
MINOR_VERSION=`echo $VERSION | \
     sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
MICRO_VERSION=`echo $VERSION | \
     sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

DIRIMG="$PACKAGE-bin-$VERSION"
DIRIMG_LIB="$DIRIMG/lib"
DIRIMG_LIBVG="$DIRIMG_LIB/vectorgraphics"
DIRIMG_DOC="$DIRIMG/doc"
DIRIMG_DOCVG="$DIRIMG_DOC/vectorgraphics"
DIRIMG_EXAMPLES="$DIRIMG/examples"
IMGFILE="$DIRIMG.zip"

VECTORVERSION=`echo u$VERSION | sed -e 's+\.++g'`
VECTORDIRIMG="$PACKAGE-$VECTORVERSION"
VECTORDIRIMG_LIB="$VECTORDIRIMG/lib"
VECTORDIRIMG_LIBVG="$VECTORDIRIMG_LIB/vectorgraphics"
VECTORDIRIMG_DOC="$VECTORDIRIMG/doc"
VECTORDIRIMG_DOCVG="$VECTORDIRIMG_DOC/vectorgraphics"
VECTORDIRIMG_EXAMPLES="$VECTORDIRIMG/examples"
VECTORIMGDIST_USERSMAN="$VECTORDIRIMG/usersmanual"
VECTORIMGDIST_USERSMANJA="$VECTORIMGDIST_USERSMAN/ja"
VECTORIMGDIST_USERSMANJAIMG="$VECTORIMGDIST_USERSMANJA/images"
VECTORIMGDIST_USERSMANIMG="$VECTORIMGDIST_USERSMAN/images"

VECTORIMGFILE="$VECTORDIRIMG.tar.gz"

# check dist directory
check_dist_directory () {
  if [ ! -d $DISTDIR ]; then
    echo "Error: $DISTDIR not found"
    exit 65;
  fi
  if [ ! -f $DISTDIR/samurai-graph.jar ]; then
    echo "Error: $DISTDIR/samurai-graph.jar not found"
    exit 65;
  fi
}

# check manual directory
check_html_directory () {
  if [ ! -d $HTMLDIR ]; then
    echo "Error: $HTMLDIR not found"
    exit 65;
  fi
  if [ ! -f $HTMLDIR/index.html ]; then
    echo "Error: $HTMLDIR/index.html not found"
    exit 65;
  fi
}

# delte directory image
delete_dirimage () {
  echo -n "[Samurai Graph] delete distribution directory and file...  "
  rm -rf "$DIRIMG"
  rm -f  "$IMGFILE"
  echo 'done'
}

# build directory image
build_dirimage () {
  echo -n "[Samurai Graph] build distribution directory and file...  "
  mkdir "$DIRIMG"
  mkdir "$DIRIMG_LIB"
  mkdir "$DIRIMG_LIBVG"
  mkdir "$DIRIMG_DOC"
  mkdir "$DIRIMG_DOCVG"
  mkdir "$DIRIMG_EXAMPLES"
  cp "$DISTDIR/samurai-graph.jar"  "$DIRIMG"
  cp "$DISTDIR/LICENSE.txt"        "$DIRIMG"
  cp "$DISTDIR/COPYING.txt"        "$DIRIMG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-base.jar"            "$DIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphics2d.jar"      "$DIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio.jar"      "$DIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-cgm.jar"  "$DIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-emf.jar"  "$DIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-gif.jar"  "$DIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-java.jar" "$DIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-pdf.jar"  "$DIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-ppm.jar"  "$DIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-ps.jar"   "$DIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-svg.jar"  "$DIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-swf.jar"  "$DIRIMG_LIBVG"
  cp "$DISTDIR/doc/vectorgraphics/LGPL.txt"                    "$DIRIMG_DOCVG"
  cp "$DISTDIR/doc/vectorgraphics/LICENSE.txt"                 "$DIRIMG_DOCVG"
  cp "$DISTDIR/doc/vectorgraphics/ReleaseNotes-1.2.2.html"     "$DIRIMG_DOCVG"
  cp "$DISTDIR/doc/vectorgraphics/SAMURAIGRAPH-ChangeLog.txt"  "$DIRIMG_DOCVG"
  cp "$TOPDIR/examples/data/"*.txt  "$DIRIMG_EXAMPLES"
  cp "$TOPDIR/examples/data/"*.sgp  "$DIRIMG_EXAMPLES"
  zip -9 -r "$IMGFILE" "$DIRIMG"
  echo 'done'
}

# delete disk image file for vectordesign
delete_vector_dirimage () {
  echo -n "[Samurai Graph] delete distribution directory and file for vectordesign...  "
  rm -rf "$VECTORDIRIMG"
  rm -f  "$VECTORIMGFILE"
  echo 'done'
}

# build disk image file for vectordesign
build_vector_dirimage () {
  echo -n "[Samurai Graph] build distribution directory and file for vectordesign...  "
  mkdir "$VECTORDIRIMG"
  mkdir "$VECTORDIRIMG_LIB"
  mkdir "$VECTORDIRIMG_LIBVG"
  mkdir "$VECTORDIRIMG_DOC"
  mkdir "$VECTORDIRIMG_DOCVG"
  mkdir "$VECTORDIRIMG_EXAMPLES"
  mkdir "$VECTORIMGDIST_USERSMAN"
  mkdir "$VECTORIMGDIST_USERSMANJA"
  mkdir "$VECTORIMGDIST_USERSMANJAIMG"
  mkdir "$VECTORIMGDIST_USERSMANJAIMG/etc"

  cp "$DISTDIR/samurai-graph.jar"  "$VECTORDIRIMG"
  cp "$DISTDIR/LICENSE.txt"        "$VECTORDIRIMG"
  cp "$DISTDIR/COPYING.txt"        "$VECTORDIRIMG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-base.jar"            "$VECTORDIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphics2d.jar"      "$VECTORDIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio.jar"      "$VECTORDIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-cgm.jar"  "$VECTORDIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-emf.jar"  "$VECTORDIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-gif.jar"  "$VECTORDIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-java.jar" "$VECTORDIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-pdf.jar"  "$VECTORDIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-ppm.jar"  "$VECTORDIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-ps.jar"   "$VECTORDIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-svg.jar"  "$VECTORDIRIMG_LIBVG"
  cp "$DISTDIR/lib/vectorgraphics/freehep-graphicsio-swf.jar"  "$VECTORDIRIMG_LIBVG"
  cp "$DISTDIR/doc/vectorgraphics/LGPL.txt"                    "$VECTORDIRIMG_DOCVG"
  cp "$DISTDIR/doc/vectorgraphics/LICENSE.txt"                 "$VECTORDIRIMG_DOCVG"
  cp "$DISTDIR/doc/vectorgraphics/ReleaseNotes-1.2.2.html"     "$VECTORDIRIMG_DOCVG"
  cp "$DISTDIR/doc/vectorgraphics/SAMURAIGRAPH-ChangeLog.txt"  "$VECTORDIRIMG_DOCVG"
  cp "$TOPDIR/examples/data/"*.txt  "$VECTORDIRIMG_EXAMPLES"
  cp "$TOPDIR/examples/data/"*.sgp  "$VECTORDIRIMG_EXAMPLES"
  cp "$HTMLDIR"/*.html "$VECTORIMGDIST_USERSMANJA"
  cp "$HTMLDIR/images"/*.gif "$VECTORIMGDIST_USERSMANJAIMG"
  cp "$HTMLDIR/images/etc"/*.gif "$VECTORIMGDIST_USERSMANJAIMG/etc"
  sed -e "s+@SAMURAIGRAPH_VERSION@+$VERSION+g" \
      -e "s+@SAMURAIGRAPH_VECTORIMGFILE@+$VECTORDIRIMG+g" \
      "resources/vector/README.txt.in"  > "$VECTORDIRIMG/README.txt"
  tar zcf "$VECTORIMGFILE" "$VECTORDIRIMG"
  echo 'done'
}

case "$1" in
build)
  check_dist_directory
  check_html_directory
  delete_dirimage
  delete_vector_dirimage
  build_dirimage
  build_vector_dirimage
  ;;
clean)
  delete_dirimage
  delete_vector_dirimage
  ;;
*)
  echo "Usage: ${0##*/}: { build | clean }" 2>&1
  exit 65
  ;;
esac

exit 0
