/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGClientPanel;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGIPaintable;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIShapeElement;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGIVisible;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SGFigure
implements ActionListener,
SGIConstants,
SGIUndoable,
SGIMovable,
SGISelectable,
SGIPaintable,
SGIFigureDialogObserver,
SGINode,
SGIRootObjectConstants,
SGIVisible,
SGIDisposable,
SGIFigureConstants {
    private int mID;
    protected SGDrawingWindow mWnd = null;
    protected List mDataList = new ArrayList();
    protected float mGraphRectX = 0.0f;
    protected float mGraphRectY = 0.0f;
    protected float mGraphRectWidth = 0.0f;
    protected float mGraphRectHeight = 0.0f;
    protected float mMagnification = 1.0f;
    protected JPopupMenu mPopupMenu = new JPopupMenu();
    protected SGPropertyDialog mDialog = null;
    private SGIFigureElement mPressedElement = null;
    private Point mPressedPoint = new Point();
    private final Rectangle2D mTempFigureRect = new Rectangle2D.Float();
    private Color mBackgroundColor;
    private final Rectangle2D mDraggingRect = new Rectangle2D.Float();
    private static boolean mSnapToGridFlag = true;
    private final Rectangle2D mRubberBandRect = new Rectangle2D.Float();
    static boolean mRubberBandFlag = true;
    static boolean mRubberBandVisibleFlag = false;
    private int mMouseLocation = 0;
    protected static final float MIN_WIDTH = 50.0f;
    protected static final float MAX_WIDTH = 50.0f;
    private static boolean mBoundingBoxVisibleFlag = false;
    protected SGProperties mTemporaryProperties = null;
    private boolean mTransparentFlag = false;
    public static final String MENUCMD_SHOW_BOUNDING_BOX = "Show Bounding Box";
    private boolean mVisibleFlag = true;
    private JComponent mComponent = null;
    private final Map mFigureElementMap = new TreeMap();
    private boolean mSelectionSymbolsVisibleFlag = true;
    private boolean mSelectedFlag = false;
    public static final int DRAW_BACK_MARGIN = 2;
    protected boolean mChangedFlag = false;
    public static final String MENUCMD_RUBBER_BANDING = "Rubber Banding";
    public static final String MENUCMD_SAVE_PROPERTY = "Save Property";
    public static final String MENUCMD_PROPERTY = "Property";
    public static final String MENUCMD_GRID_VISIBLE = "Grid Visible";
    public static final String MENUCMD_GRID_PROPERTY = "Grid Property";
    private SGUndoManager mUndoManager = new SGUndoManager(this);
    public static final int MARGIN_TOP = 5;
    public static final int MARGIN_BOTTOM = 5;
    public static final int MARGIN_LEFT = 5;
    public static final int MARGIN_RIGHT = 5;
    public static final String TAG_NAME_FIGURE = "Figure";
    public static final String KEY_FIGURE_TYPE = "Type";
    public static final String KEY_FIGURE_X_IN_CLIENT = "X";
    public static final String KEY_FIGURE_Y_IN_CLIENT = "Y";
    public static final String KEY_FIGURE_WIDTH = "Width";
    public static final String KEY_FIGURE_HEIGHT = "Height";
    public static final String KEY_SPACE_AXIS_LINE_AND_NUMBER = "SpaceAxisLineAndNumber";
    public static final String KEY_SPACE_NUMBER_AND_TITLE = "SpaceNumberAndTitle";
    public static final String KEY_FIGURE_BACKGROUND_COLOR = "BackgroundColor";
    public static final String KEY_FIGURE_BACKGROUND_TRANSPARENT = "BackgroundTransparent";
    private final float DUPLICATION_OFFSET = 20.0f;
    private int mMode = 1;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement;

    public SGFigure(SGDrawingWindow sGDrawingWindow) {
        this.mWnd = sGDrawingWindow;
        this.mComponent = sGDrawingWindow.getFigurePanel();
        this.create();
    }

    public String toString() {
        return new String("SGFigure:" + this.getID());
    }

    private boolean create() {
        this.createDialog();
        this.createPopupMenu();
        this.setBackgroundColor(SGIFigureConstants.DEFAULT_FIGURE_BACKGROUND_COLOR);
        this.setVisible(true);
        return true;
    }

    public boolean isVisible() {
        return this.mVisibleFlag;
    }

    public void setVisible(boolean bl) {
        this.mVisibleFlag = bl;
    }

    public JComponent getComponent() {
        return this.mComponent;
    }

    public void repaint() {
        this.mComponent.repaint();
    }

    public int getWidth() {
        return this.mComponent.getWidth();
    }

    public int getHeight() {
        return this.mComponent.getHeight();
    }

    public int getID() {
        return this.mID;
    }

    public boolean setID(int n) {
        this.mID = n;
        return true;
    }

    public boolean setBackgroundColor(Color color) {
        this.mBackgroundColor = color;
        return true;
    }

    public boolean setBackgroundColor(String string) {
        Color color = SGUtilityText.getColor(string);
        if (color == null) {
            return false;
        }
        return this.setBackgroundColor(color);
    }

    public boolean setBackgroundColor(String string, String string2, String string3) {
        Color color = SGUtilityText.getColor(string, string2, string3);
        if (color == null) {
            return false;
        }
        return this.setBackgroundColor(color);
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public boolean isTransparent() {
        return this.mTransparentFlag;
    }

    public SGDrawingWindow getWindow() {
        return this.mWnd;
    }

    public float getSpaceAxisLineAndNumber() {
        return this.getAxisElement().getSpaceAxisLineAndNumber();
    }

    public float getSpaceAxisLineAndNumber(String string) {
        float f = this.getSpaceAxisLineAndNumber();
        return (float)SGUtilityText.convertFromPoint(f, string);
    }

    public float getSpaceNumberAndTitle() {
        return this.getAxisElement().getSpaceNumberAndTitle();
    }

    public float getSpaceNumberAndTitle(String string) {
        float f = this.getSpaceNumberAndTitle();
        return (float)SGUtilityText.convertFromPoint(f, string);
    }

    public boolean setSpaceAxisLineAndNumber(float f) {
        SGIAxisElement sGIAxisElement = this.getAxisElement();
        float f2 = sGIAxisElement.getSpaceAxisLineAndNumber();
        if (f != f2) {
            sGIAxisElement.setSpaceAxisLineAndNumber(f);
            sGIAxisElement.setChanged(true);
            this.updateGraphRect();
        }
        return true;
    }

    public boolean setSpaceAxisLineAndNumber(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < 0.0) {
            return false;
        }
        if (d > 5.0) {
            return false;
        }
        return this.setSpaceAxisLineAndNumber((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setSpaceNumberAndTitle(float f) {
        SGIAxisElement sGIAxisElement = this.getAxisElement();
        float f2 = sGIAxisElement.getSpaceNumberAndTitle();
        if (f != f2) {
            sGIAxisElement.setSpaceNumberAndTitle(f);
            sGIAxisElement.setChanged(true);
            this.updateGraphRect();
        }
        return true;
    }

    public boolean setSpaceNumberAndTitle(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < 0.0) {
            return false;
        }
        if (d > 5.0) {
            return false;
        }
        return this.setSpaceNumberAndTitle((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setLegendVisible(boolean bl) {
        SGILegendElement sGILegendElement = this.getLegendElement();
        boolean bl2 = sGILegendElement.isLegendVisible();
        if (bl2 != bl) {
            sGILegendElement.setLegendVisible(bl);
            sGILegendElement.setChanged(true);
        }
        return true;
    }

    public boolean setTransparent(boolean bl) {
        this.mTransparentFlag = bl;
        return true;
    }

    public SGIFigureElement[] getIFigureElementArray() {
        ArrayList arrayList = new ArrayList(this.mFigureElementMap.values());
        SGIFigureElement[] sGIFigureElementArray = arrayList.toArray(new SGIFigureElement[0]);
        return sGIFigureElementArray;
    }

    public ArrayList getChildNodes() {
        return new ArrayList(this.mFigureElementMap.values());
    }

    public String getClassDescription() {
        return "Figure: " + this.getID();
    }

    public String getInstanceDescription() {
        float f = (float)SGUtilityNumber.roundOffNumber(this.mGraphRectX * 0.035277776f, -2);
        float f2 = (float)SGUtilityNumber.roundOffNumber(this.mGraphRectY * 0.035277776f, -2);
        String string = this.getClassDescription();
        string = string + " ( X=" + f + "cm, Y=" + f2 + "cm )";
        return string;
    }

    public SGIFigureElement getIFigureElement(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("");
        }
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (!clazz.isAssignableFrom(sGIFigureElementArray[i].getClass())) continue;
            return sGIFigureElementArray[i];
        }
        return null;
    }

    public SGIAxisElement getAxisElement() {
        return (SGIAxisElement)this.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement = SGFigure.class$("jp.riken.brain.ni.samuraigraph.base.SGIAxisElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIAxisElement);
    }

    public SGIGraphElement getGraphElement() {
        return (SGIGraphElement)this.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement = SGFigure.class$("jp.riken.brain.ni.samuraigraph.base.SGIGraphElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement);
    }

    public SGILegendElement getLegendElement() {
        return (SGILegendElement)this.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement = SGFigure.class$("jp.riken.brain.ni.samuraigraph.base.SGILegendElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGILegendElement);
    }

    public void setIFigureElement(int n, SGIFigureElement sGIFigureElement) {
        if (sGIFigureElement == null) {
            throw new IllegalArgumentException("");
        }
        Class<?> clazz = sGIFigureElement.getClass();
        Iterator iterator = this.mFigureElementMap.values().iterator();
        while (iterator.hasNext()) {
            SGIFigureElement sGIFigureElement2 = (SGIFigureElement)iterator.next();
            if (!sGIFigureElement2.getClass().equals(clazz)) continue;
            throw new IllegalArgumentException("");
        }
        this.mFigureElementMap.put(new Integer(n), sGIFigureElement);
    }

    void clearFocusedObjectsOtherThan(SGIFigureElement sGIFigureElement) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].getClass().equals(sGIFigureElement.getClass())) continue;
            sGIFigureElementArray[i].clearFocusedObjects();
        }
        this.setSelected(false);
    }

    public boolean isGraphRectContains(Point2D point2D) {
        Rectangle2D rectangle2D = this.getGraphRect();
        return rectangle2D.contains(point2D);
    }

    public boolean isGraphRectContains(int n, int n2) {
        Rectangle2D rectangle2D = this.getGraphRect();
        return rectangle2D.contains(n, n2);
    }

    public Rectangle2D getGraphRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getGraphRectX(), this.getGraphRectY(), this.getGraphRectWidth(), this.getGraphRectHeight());
        return float_;
    }

    public Rectangle2D getGraphRectInClientRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.mGraphRectX, this.mGraphRectY, this.mGraphRectWidth, this.mGraphRectHeight);
        return float_;
    }

    public float getGraphRectX() {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        return (float)rectangle2D.getX() + this.mMagnification * this.mGraphRectX;
    }

    public float getGraphRectY() {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        return (float)rectangle2D.getY() + this.mMagnification * this.mGraphRectY;
    }

    public float getGraphRectWidth() {
        return this.mMagnification * this.mGraphRectWidth;
    }

    public float getGraphRectHeight() {
        return this.mMagnification * this.mGraphRectHeight;
    }

    public float getFigureX() {
        return this.mGraphRectX;
    }

    public float getFigureX(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFigureX(), string);
    }

    public float getFigureY() {
        return this.mGraphRectY;
    }

    public float getFigureY(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFigureY(), string);
    }

    public float getFigureWidth() {
        return this.mGraphRectWidth;
    }

    public float getFigureWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFigureWidth(), string);
    }

    public float getFigureHeight() {
        return this.mGraphRectHeight;
    }

    public float getFigureHeight(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFigureHeight(), string);
    }

    public boolean setFigureX(float f) {
        if (this.equalLength(this.mGraphRectX, f)) {
            return true;
        }
        this.mGraphRectX = f;
        this.updateGraphRect();
        return true;
    }

    public boolean setFigureX(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < -50.0) {
            return false;
        }
        if (d > 150.0) {
            return false;
        }
        return this.setFigureX((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setFigureY(float f) {
        if (this.equalLength(this.mGraphRectY, f)) {
            return true;
        }
        this.mGraphRectY = f;
        this.updateGraphRect();
        return true;
    }

    public boolean setFigureY(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < -50.0) {
            return false;
        }
        if (d > 150.0) {
            return false;
        }
        return this.setFigureY((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setFigureWidth(float f) {
        if (this.equalLength(this.mGraphRectWidth, f)) {
            return true;
        }
        this.mGraphRectWidth = f;
        this.updateGraphRect();
        return true;
    }

    public boolean setFigureWidth(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < 1.0) {
            return false;
        }
        if (d > 50.0) {
            return false;
        }
        return this.setFigureWidth((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setFigureHeight(float f) {
        if (this.equalLength(this.mGraphRectHeight, f)) {
            return true;
        }
        this.mGraphRectHeight = f;
        this.updateGraphRect();
        return true;
    }

    public boolean setFigureHeight(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < 1.0) {
            return false;
        }
        if (d > 50.0) {
            return false;
        }
        return this.setFigureHeight((float)SGUtilityText.convertToPoint(f, string));
    }

    private boolean equalLength(float f, float f2) {
        float f3;
        float f4 = Math.abs(f - f2) * 0.035277776f;
        return f4 < (f3 = (float)SGUtilityNumber.getPowersOfTen(-1));
    }

    public boolean setGraphRectLocation(float f, float f2) {
        this.setGraphRectLocationAttributes(f, f2);
        this.updateGraphRect();
        return true;
    }

    private boolean setGraphRectLocationAttributes(float f, float f2) {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        this.mGraphRectX = (f - (float)rectangle2D.getX()) / this.mMagnification;
        this.mGraphRectY = (f2 - (float)rectangle2D.getY()) / this.mMagnification;
        return true;
    }

    protected boolean setGraphRectLocationRoundingOut(float f, float f2) {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        float f3 = (f - (float)rectangle2D.getX()) * 0.035277776f / this.mMagnification;
        float f4 = (f2 - (float)rectangle2D.getY()) * 0.035277776f / this.mMagnification;
        float f5 = (float)SGUtilityNumber.roundOutNumber(f3, -2);
        float f6 = (float)SGUtilityNumber.roundOutNumber(f4, -2);
        float f7 = f5 / 0.035277776f;
        float f8 = f6 / 0.035277776f;
        this.mGraphRectX = f7;
        this.mGraphRectY = f8;
        this.updateGraphRect();
        return true;
    }

    private Rectangle2D getRectangleRoundingOut(Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        return this.getRectangleRoundingOut(f, f2, f3, f4);
    }

    private Rectangle2D getRectangleRoundingOut(float f, float f2, float f3, float f4) {
        Rectangle2D rectangle2D = this.mWnd.getPaperRect();
        float f5 = (f - (float)rectangle2D.getX()) * 0.035277776f / this.mMagnification;
        float f6 = (f2 - (float)rectangle2D.getY()) * 0.035277776f / this.mMagnification;
        float f7 = (float)SGUtilityNumber.roundOutNumber(f5, -2);
        float f8 = (float)SGUtilityNumber.roundOutNumber(f6, -2);
        float f9 = f7 / 0.035277776f;
        float f10 = f8 / 0.035277776f;
        float f11 = f3 * 0.035277776f / this.mMagnification;
        float f12 = f4 * 0.035277776f / this.mMagnification;
        float f13 = (float)SGUtilityNumber.roundOutNumber(f11, -2);
        float f14 = (float)SGUtilityNumber.roundOutNumber(f12, -2);
        float f15 = f13 / 0.035277776f;
        float f16 = f14 / 0.035277776f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f9, f10, f15, f16);
        return float_;
    }

    public boolean setGraphRectSize(float f, float f2) {
        this.setGraphRectSizeAttributes(f, f2);
        this.updateGraphRect();
        return true;
    }

    private boolean setGraphRectSizeAttributes(float f, float f2) {
        this.mGraphRectWidth = f / this.mMagnification;
        this.mGraphRectHeight = f2 / this.mMagnification;
        return true;
    }

    protected boolean setGraphRectSizeRoundingOut(float f, float f2) {
        float f3 = f * 0.035277776f / this.mMagnification;
        float f4 = f2 * 0.035277776f / this.mMagnification;
        float f5 = (float)SGUtilityNumber.roundOutNumber(f3, -2);
        float f6 = (float)SGUtilityNumber.roundOutNumber(f4, -2);
        float f7 = f5 / 0.035277776f;
        float f8 = f6 / 0.035277776f;
        this.mGraphRectWidth = f7;
        this.mGraphRectHeight = f8;
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        this.setGraphRectLocationAttributes(f, f2);
        this.setGraphRectSizeAttributes(f3, f4);
        this.updateGraphRect();
        return true;
    }

    public boolean isLegendVisible() {
        return this.getLegendElement().isLegendVisible();
    }

    public boolean addData(SGData sGData) {
        return this.addData(sGData, "data");
    }

    public boolean addData(SGData sGData, String string, SGIFigureElement[] sGIFigureElementArray) {
        this.addToList(sGData);
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].addData(sGData, string);
        }
        this.repaint();
        return true;
    }

    public boolean addData(SGData sGData, String string) {
        return this.addData(sGData, string, this.getIFigureElementArray());
    }

    public boolean addData(SGData sGData, String string, Map map) {
        SGIFigureElement[] sGIFigureElementArray;
        this.addToList(sGData);
        List list = this.getVisibleDataList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            sGIFigureElementArray = (SGIFigureElement[])list.get(i);
            String string2 = this.getDataName((SGData)sGIFigureElementArray);
            arrayList.add(string2);
        }
        String string3 = SGUtilityText.getSerialName(arrayList, string);
        sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            Object v = map.get(new Integer(i));
            SGProperties sGProperties = (SGProperties)v;
            if (sGIFigureElementArray[i].addData(sGData, string3, sGProperties)) continue;
            return false;
        }
        this.broadcast(this.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement = SGFigure.class$("jp.riken.brain.ni.samuraigraph.base.SGIGraphElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIGraphElement), "");
        return true;
    }

    private void addToList(SGData sGData) {
        this.mDataList.add(sGData);
    }

    protected boolean setViewBounds() {
        Rectangle2D rectangle2D = this.mWnd.getViewportBounds();
        this.setViewBounds(rectangle2D);
        return true;
    }

    protected boolean setViewBounds(Rectangle2D rectangle2D) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setViewBounds(rectangle2D);
        }
        return true;
    }

    public boolean resize(float f, float f2) {
        this.mGraphRectX *= f;
        this.mGraphRectY *= f2;
        this.mGraphRectWidth *= f;
        this.mGraphRectHeight *= f2;
        this.updateGraphRect();
        this.setViewBounds();
        return true;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean zoom(float f) {
        this.mMagnification = f;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].zoom(f);
        }
        this.updateGraphRect();
        return true;
    }

    protected void setSelectionSymbolsVisible(boolean bl) {
        this.mSelectionSymbolsVisibleFlag = bl;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setSymbolsVisibleAroundFocusedObjects(bl);
        }
    }

    protected boolean isSelectionSymbolsVisible() {
        return this.mSelectionSymbolsVisibleFlag;
    }

    protected boolean setDirectlyBefore() {
        return this.prepare();
    }

    protected boolean setDirectlyAfter() {
        if (!this.commit()) {
            return false;
        }
        this.notifyToRoot();
        this.repaint();
        return true;
    }

    public boolean setFigureXDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setFigureX(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setFigureYDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setFigureY(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setFigureLocationDirectly(float f, String string, float f2, String string2) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setFigureX(f, string)) {
            return false;
        }
        if (!this.setFigureY(f2, string2)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setFigureWidthDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setFigureWidth(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setFigureHeightDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setFigureHeight(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setFigureSizeDirectly(float f, String string, float f2, String string2) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setFigureWidth(f, string)) {
            return false;
        }
        if (!this.setFigureHeight(f2, string2)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setSpaceAxisLineAndNumberDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setSpaceAxisLineAndNumber(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setSpaceNumberAndTitleDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setSpaceNumberAndTitle(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setBackgroundColorDirectly(Color color) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setBackgroundColor(color)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setTransparentDirectly(boolean bl) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.setTransparent(bl)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    protected boolean onMouseMoved(MouseEvent mouseEvent) {
        SGITimingLineElement sGITimingLineElement;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (!this.mWnd.isInsertFlagSelected()) {
            Cursor cursor = this.setMouseCursor(n, n2);
            if (!Cursor.getDefaultCursor().equals(cursor)) {
                return true;
            }
        } else if (this.mWnd.getTimingLineInsertionFlag() && (sGITimingLineElement = (SGITimingLineElement)this.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement = SGFigure.class$("jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement)) != null) {
            sGITimingLineElement.guideToAdd(n, n2);
        }
        return false;
    }

    public boolean addString(int n, int n2, String string) {
        SGIStringElement sGIStringElement = (SGIStringElement)this.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement = SGFigure.class$("jp.riken.brain.ni.samuraigraph.base.SGIStringElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement);
        if (sGIStringElement != null) {
            return sGIStringElement.addString(n, n2, string);
        }
        return false;
    }

    public boolean addString(int n, int n2) {
        SGIStringElement sGIStringElement = (SGIStringElement)this.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement = SGFigure.class$("jp.riken.brain.ni.samuraigraph.base.SGIStringElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIStringElement);
        if (sGIStringElement != null) {
            return sGIStringElement.addString(n, n2);
        }
        return false;
    }

    public boolean addAxisBreakSymbol(int n, int n2) {
        SGIAxisBreakElement sGIAxisBreakElement = (SGIAxisBreakElement)this.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement = SGFigure.class$("jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIAxisBreakElement);
        if (sGIAxisBreakElement != null) {
            return sGIAxisBreakElement.addAxisBreakSymbol(n, n2);
        }
        return false;
    }

    public boolean addTimingLine(int n, int n2) {
        SGITimingLineElement sGITimingLineElement = (SGITimingLineElement)this.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement = SGFigure.class$("jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGITimingLineElement);
        if (sGITimingLineElement != null) {
            return sGITimingLineElement.addTimingLine(n, n2);
        }
        return false;
    }

    public boolean addSignificantDifferenceSymbol(int n, int n2) {
        SGISignificantDifferenceElement sGISignificantDifferenceElement = (SGISignificantDifferenceElement)this.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement = SGFigure.class$("jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGISignificantDifferenceElement);
        if (sGISignificantDifferenceElement != null) {
            return sGISignificantDifferenceElement.addSignificantDifferenceSymbol(n, n2);
        }
        return false;
    }

    public boolean addShape(int n, int n2, int n3) {
        SGIShapeElement sGIShapeElement = (SGIShapeElement)this.getIFigureElement(class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement == null ? (class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement = SGFigure.class$("jp.riken.brain.ni.samuraigraph.base.SGIShapeElement")) : class$jp$riken$brain$ni$samuraigraph$base$SGIShapeElement);
        if (sGIShapeElement != null) {
            return sGIShapeElement.addShape(n, n2, n3);
        }
        return false;
    }

    protected boolean onMouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getClickCount();
        int n2 = mouseEvent.getModifiers();
        SGIFigureElement sGIFigureElement = this.onFigureElementClicked(mouseEvent);
        if (sGIFigureElement != null) {
            this.mWnd.setFocusedFigure(this, false);
            this.afterClicked(mouseEvent);
            return true;
        }
        if (this.isGraphRectContains(mouseEvent.getPoint())) {
            this.updateFocusedFigureList(mouseEvent);
            this.afterClicked(mouseEvent);
            if (SwingUtilities.isRightMouseButton(mouseEvent) & n == 1) {
                this.updatePopupMenu();
                this.mPopupMenu.show(this.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
            if (SwingUtilities.isLeftMouseButton(mouseEvent) & n == 2) {
                this.mWnd.showPropertyDialogForSelectedFigures();
            }
            return true;
        }
        return false;
    }

    public boolean isSelected() {
        return this.mSelectedFlag;
    }

    public void setSelected(boolean bl) {
        this.mSelectedFlag = bl;
    }

    public boolean hideSelectedObjects() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].hideSelectedObjects()) continue;
            return false;
        }
        return true;
    }

    protected void setSymbolsVisibleAroundAllObjects(boolean bl) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setSymbolsVisibleAroundAllObjects(bl);
        }
    }

    protected boolean updatePopupMenu() {
        Component[] componentArray = this.mPopupMenu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JCheckBoxMenuItem)) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)componentArray[i];
            String string = jCheckBoxMenuItem.getActionCommand();
            if (string.equals(MENUCMD_RUBBER_BANDING)) {
                jCheckBoxMenuItem.setSelected(mRubberBandFlag);
                continue;
            }
            if (string.equals(MENUCMD_SHOW_BOUNDING_BOX)) {
                jCheckBoxMenuItem.setSelected(mBoundingBoxVisibleFlag);
                continue;
            }
            if (!string.equals("Snap to Grid")) continue;
            jCheckBoxMenuItem.setSelected(SGFigure.isSnappingToGrid());
        }
        return true;
    }

    private boolean afterClicked(MouseEvent mouseEvent) {
        this.repaint();
        return true;
    }

    private SGIFigureElement onFigureElementClicked(MouseEvent mouseEvent) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = sGIFigureElementArray.length - 1; i >= 0; --i) {
            if (!sGIFigureElementArray[i].onMouseClicked(mouseEvent)) continue;
            return sGIFigureElementArray[i];
        }
        return null;
    }

    protected boolean onMousePressed(MouseEvent mouseEvent) {
        if (this.isSelected() && this.pressWithMouseLocation(mouseEvent)) {
            return true;
        }
        if (this.pressFigureElement(mouseEvent)) {
            return true;
        }
        if (this.isGraphRectContains(mouseEvent.getPoint())) {
            return this.pressed(mouseEvent);
        }
        return false;
    }

    private boolean pressFigureElement(MouseEvent mouseEvent) {
        SGIFigureElement sGIFigureElement = this.onFigureElementPressed(mouseEvent);
        if (sGIFigureElement != null) {
            this.afterPressed(mouseEvent);
            return true;
        }
        return false;
    }

    private boolean pressWithMouseLocation(MouseEvent mouseEvent) {
        if (this.mMouseLocation != 0) {
            return this.pressed(mouseEvent);
        }
        return false;
    }

    private boolean pressed(MouseEvent mouseEvent) {
        this.clearFocusedObjects();
        this.afterPressed(mouseEvent);
        return true;
    }

    private boolean afterPressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            mRubberBandVisibleFlag = true;
            if (this.mPressedElement == null && this.mWnd.getCursor().equals(Cursor.getDefaultCursor())) {
                this.changeCursor();
                if (this.mMouseLocation == 0) {
                    this.mWnd.setCursor(new Cursor(13));
                }
            }
        }
        this.mPressedPoint.setLocation(mouseEvent.getPoint());
        this.recordFigureRect();
        return true;
    }

    protected boolean updateFocusedFigureList(MouseEvent mouseEvent) {
        SGDrawingWindow sGDrawingWindow = this.getWindow();
        ArrayList arrayList = sGDrawingWindow.getFocusedObjectsList();
        int n = mouseEvent.getModifiers();
        if ((n & 2) == 0 & (n & 1) == 0) {
            if (!arrayList.contains(this)) {
                sGDrawingWindow.clearAllFocusedObjectsInFigures();
                sGDrawingWindow.setFocusedFigure(this, true);
            }
        } else if (arrayList.contains(this)) {
            int n2 = this.mMouseLocation;
            if (n2 != 5 & n2 != 6 & n2 != 8 & n2 != 7 && this.mPressedElement == null) {
                sGDrawingWindow.setFocusedFigure(this, !this.isSelected());
            }
        } else {
            sGDrawingWindow.setFocusedFigure(this, !this.isSelected());
        }
        return true;
    }

    boolean recordFigureRect() {
        this.mTempFigureRect.setRect(this.getGraphRectInClientRect());
        return true;
    }

    private SGIFigureElement onFigureElementPressed(MouseEvent mouseEvent) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = sGIFigureElementArray.length - 1; i >= 0; --i) {
            if (!sGIFigureElementArray[i].setTemporaryPropertiesOfFocusedObjects()) {
                return null;
            }
            if (!sGIFigureElementArray[i].onMousePressed(mouseEvent)) continue;
            this.mPressedElement = sGIFigureElementArray[i];
            return sGIFigureElementArray[i];
        }
        return null;
    }

    protected boolean onMouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.mPressedElement != null) {
            ArrayList arrayList = this.mPressedElement.getFocusedObjectsList();
            if (!this.mPressedElement.onMouseDragged(mouseEvent)) {
                return false;
            }
            if (arrayList.size() != 0) {
                this.mWnd.moveFocusedObjects(n, n2);
            }
            this.setCursorToWindow(this.mPressedElement);
            return true;
        }
        if (!this.isSelected()) {
            return false;
        }
        int n3 = this.mMouseLocation;
        if (n3 == 0) {
            this.mWnd.moveFocusedObjects(n, n2);
            return true;
        }
        this.recordFigureRect();
        Point point = new Point(this.mPressedPoint);
        Rectangle2D rectangle2D = this.getDraggingRect();
        SGUtility.resizeRectangle(rectangle2D, point, mouseEvent, n3);
        if (rectangle2D.getWidth() < 50.0 | rectangle2D.getHeight() < 50.0) {
            return true;
        }
        this.mPressedPoint.setLocation(point);
        this.setDraggingRect(rectangle2D);
        this.snapToLines(n3);
        if (!mRubberBandFlag) {
            this.setGraphRectOnDragging();
        }
        return false;
    }

    public void translate(float f, float f2) {
        Rectangle2D rectangle2D = this.getDraggingRect();
        this.setDraggingRect((float)rectangle2D.getX() + f, (float)rectangle2D.getY() + f2, (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        this.snapToLines(0);
        if (!mRubberBandFlag) {
            this.mPressedPoint.setLocation((float)this.mPressedPoint.x + f, (float)this.mPressedPoint.y + f2);
            this.setGraphRectOnDragging();
        }
    }

    public void translateSelectedObjects(int n, int n2) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].equals(this.mPressedElement)) continue;
            sGIFigureElementArray[i].translateFocusedObjects(n, n2);
        }
    }

    Rectangle2D getRubberBandRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(this.mRubberBandRect);
        return float_;
    }

    Rectangle2D getDraggingRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(this.mDraggingRect);
        return float_;
    }

    void setRubberBandRect(float f, float f2, float f3, float f4) {
        this.mRubberBandRect.setRect(f, f2, f3, f4);
    }

    void setDraggingRect(float f, float f2, float f3, float f4) {
        this.mDraggingRect.setRect(f, f2, f3, f4);
    }

    void setDraggingRect(Rectangle2D rectangle2D) {
        this.mDraggingRect.setRect(rectangle2D);
    }

    protected boolean setGraphRectOnDragging() {
        Rectangle2D rectangle2D = this.getRubberBandRect();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        Rectangle rectangle = this.getGraphRect().getBounds();
        if (rectangle.equals(rectangle2D.getBounds())) {
            return true;
        }
        this.setGraphRectLocationAttributes(f, f2);
        this.setGraphRectSizeAttributes(f3, f4);
        this.updateGraphRect();
        return true;
    }

    private float roundOffInFigureLengthOrder(float f) {
        float f2 = f * 0.035277776f;
        float f3 = (float)SGUtilityNumber.roundOffNumber(f2, -2);
        float f4 = f3 / 0.035277776f;
        return f4;
    }

    void snapToLines(int n) {
        if (SGFigure.isSnappingToGrid()) {
            this.snapToGrid(n);
        } else {
            this.snapToUnitCell(n);
        }
    }

    private void snapToUnitCell(int n) {
        float f = (float)SGUtilityNumber.getPowersOfTen(-1);
        float f2 = this.mMagnification * f / 0.035277776f;
        this.snap(f2, n);
    }

    private void snapToGrid(int n) {
        float f = this.mMagnification * this.mWnd.getGridLineInterval();
        this.snap(f, n);
    }

    private void snap(float f, int n) {
        float f2;
        float f3;
        float f4;
        int n2;
        float f5;
        int n3;
        float f6;
        float f7;
        float f8 = this.mWnd.getPaperX();
        float f9 = this.mWnd.getPaperY();
        Rectangle2D rectangle2D = this.getDraggingRect();
        float f10 = (float)rectangle2D.getMinX();
        float f11 = (float)rectangle2D.getMaxX();
        float f12 = (float)rectangle2D.getMinY();
        float f13 = (float)rectangle2D.getMaxY();
        float f14 = f10;
        float f15 = f13;
        float f16 = f14 - f8;
        float f17 = f15 - f9;
        int n4 = (int)(f16 / f);
        int n5 = (int)(f17 / f);
        float f18 = f * (float)n4;
        float f19 = f * (float)n5;
        int n6 = n4;
        int n7 = n5;
        if (f16 - f18 > f / 2.0f) {
            ++n6;
        }
        if (f17 - f19 > f / 2.0f) {
            ++n7;
        }
        float f20 = f8 + (float)n6 * f;
        float f21 = f9 + (float)n7 * f;
        if (n == 3 | n == 7 | n == 5) {
            f7 = f20;
            f6 = f11 - f7;
        } else if (n == 4 | n == 8 | n == 6) {
            f7 = f10;
            n3 = (int)((f11 - f8) / f);
            f5 = f * (float)n3;
            n2 = n3;
            if (f11 - f8 - f5 > f / 2.0f) {
                ++n2;
            }
            f4 = f8 + (float)n2 * f;
            f6 = f4 - f10;
        } else if (n == 0) {
            f7 = f20;
            f6 = (float)rectangle2D.getWidth();
        } else {
            f7 = f10;
            f6 = (float)rectangle2D.getWidth();
        }
        if (n == 2 | n == 7 | n == 8) {
            f3 = f12;
            f2 = f21 - f12;
        } else if (n == 1 | n == 6 | n == 5) {
            n3 = (int)((f12 - f9) / f);
            f5 = f * (float)n3;
            n2 = n3;
            if (f12 - f9 - f5 > f / 2.0f) {
                ++n2;
            }
            f4 = f9 + (float)n2 * f;
            f2 = f13 - f4;
            f3 = f4;
        } else if (n == 0) {
            f2 = (float)rectangle2D.getHeight();
            f3 = f21 - f2;
        } else {
            f3 = f12;
            f2 = (float)rectangle2D.getHeight();
        }
        this.setRubberBandRect(f7, f3, f6, f2);
    }

    protected boolean onMouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (!this.mWnd.isInsertFlagSelected()) {
            this.setMouseCursor(n, n2);
        }
        if (mRubberBandFlag & this.mPressedElement == null) {
            this.setGraphRectOnDragging();
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            mRubberBandVisibleFlag = false;
        }
        if (this.mPressedElement != null) {
            this.mPressedElement.onMouseReleased(mouseEvent);
        }
        this.mPressedElement = null;
        return true;
    }

    protected boolean isFigureMoved() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.mTempFigureRect.getBounds();
        boolean bl = !rectangle2.equals(rectangle = this.getGraphRectInClientRect().getBounds());
        return bl;
    }

    boolean drawbackFigure() {
        Rectangle2D rectangle2D = this.mWnd.getClientRect();
        Rectangle2D rectangle2D2 = this.getBoundingBox();
        Rectangle2D rectangle2D3 = this.mWnd.getPaperRect();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(rectangle2D2);
        if (rectangle2D2.getX() < rectangle2D.getX()) {
            ((Rectangle2D)float_).setRect(2.0, ((RectangularShape)float_).getY() + 2.0, ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (rectangle2D2.getY() < rectangle2D.getY()) {
            ((Rectangle2D)float_).setRect(((RectangularShape)float_).getX() + 2.0, 2.0, ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (rectangle2D2.getX() + rectangle2D2.getWidth() > rectangle2D3.getX() + rectangle2D3.getWidth()) {
            ((Rectangle2D)float_).setRect(rectangle2D3.getX() + rectangle2D3.getWidth() - rectangle2D2.getWidth() - 2.0, ((RectangularShape)float_).getY() + 2.0, ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (rectangle2D2.getY() + rectangle2D2.getHeight() > rectangle2D3.getY() + rectangle2D3.getHeight()) {
            ((Rectangle2D)float_).setRect(((RectangularShape)float_).getX() + 2.0, rectangle2D3.getY() + rectangle2D3.getHeight() - rectangle2D2.getHeight() - 2.0, ((RectangularShape)float_).getWidth(), ((RectangularShape)float_).getHeight());
        }
        if (!this.setBoundingBox(float_)) {
            return false;
        }
        this.snapToLines(0);
        this.setGraphRectOnDragging();
        return true;
    }

    public boolean clearFocusedObjects() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].clearFocusedObjects()) continue;
            return false;
        }
        return true;
    }

    public boolean setMementoBackward() {
        if (!this.mUndoManager.setMementoBackward()) {
            return false;
        }
        this.updateGraphRect();
        return true;
    }

    public boolean setMementoForward() {
        if (!this.mUndoManager.setMementoForward()) {
            return false;
        }
        this.updateGraphRect();
        return true;
    }

    void updateGraphRect() {
        float f = this.getGraphRectX();
        float f2 = this.getGraphRectY();
        float f3 = this.getGraphRectWidth();
        float f4 = this.getGraphRectHeight();
        this.setRubberBandRect(f, f2, f3, f4);
        this.setDraggingRect(f, f2, f3, f4);
        this.updateImage();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        if (sGIFigureElementArray != null) {
            for (int i = 0; i < sGIFigureElementArray.length; ++i) {
                sGIFigureElementArray[i].setGraphRect(f, f2, f3, f4);
            }
        }
        this.repaint();
    }

    public void notifyToRoot() {
        this.mWnd.notifyToRoot();
    }

    public boolean isChanged() {
        return this.mChangedFlag;
    }

    public boolean isChangedRoot() {
        if (this.isChanged()) {
            return true;
        }
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (!sGIFigureElementArray[i].isChangedRoot()) continue;
            return true;
        }
        return false;
    }

    public void setChanged(boolean bl) {
        this.mChangedFlag = bl;
    }

    private Cursor setMouseCursor(int n, int n2) {
        this.setMouseLocation(n, n2);
        if (this.mMouseLocation == 0) {
            if (!this.onDrawingElement(n, n2)) {
                return this.setMouseCursor();
            }
        } else {
            return this.setMouseCursor();
        }
        return null;
    }

    private Cursor setMouseCursor() {
        if (!this.isSelected()) {
            Cursor cursor = Cursor.getDefaultCursor();
            this.setMouseCursor(cursor);
            return cursor;
        }
        return this.changeCursor();
    }

    private void setMouseLocation(int n, int n2) {
        float f = 1.5f * SGClientPanel.getAnchorSize();
        Rectangle2D rectangle2D = this.getRubberBandRect();
        this.mMouseLocation = SGUtility.getMouseLocation(rectangle2D, n, n2, f);
    }

    private Cursor changeCursor() {
        Cursor cursor = null;
        switch (this.mMouseLocation) {
            case 3: {
                cursor = new Cursor(10);
                break;
            }
            case 4: {
                cursor = new Cursor(11);
                break;
            }
            case 1: {
                cursor = new Cursor(8);
                break;
            }
            case 2: {
                cursor = new Cursor(9);
                break;
            }
            case 5: {
                cursor = new Cursor(6);
                break;
            }
            case 8: {
                cursor = new Cursor(5);
                break;
            }
            case 6: {
                cursor = new Cursor(7);
                break;
            }
            case 7: {
                cursor = new Cursor(4);
                break;
            }
            default: {
                cursor = Cursor.getDefaultCursor();
            }
        }
        this.setMouseCursor(cursor);
        return cursor;
    }

    private void setMouseCursor(Cursor cursor) {
        this.mWnd.setCursor(cursor);
    }

    private boolean onDrawingElement(int n, int n2) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = sGIFigureElementArray.length - 1; i >= 0; --i) {
            if (!sGIFigureElementArray[i].onDrawingElement(n, n2)) continue;
            this.setCursorToWindow(sGIFigureElementArray[i]);
            return true;
        }
        this.mWnd.setCursor(Cursor.getDefaultCursor());
        return false;
    }

    protected boolean setCursorToWindow(SGIFigureElement sGIFigureElement) {
        Cursor cursor = sGIFigureElement.getFigureElementCursor();
        if (cursor != null) {
            this.mWnd.setCursor(cursor);
        }
        return true;
    }

    private boolean createPopupMenu() {
        JPopupMenu jPopupMenu = this.mPopupMenu;
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel("  -- Figure --"));
        jPopupMenu.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = SGUtility.addCheckBoxItem(jPopupMenu, this, MENUCMD_RUBBER_BANDING);
        jCheckBoxMenuItem.setSelected(mRubberBandFlag);
        jCheckBoxMenuItem = SGUtility.addCheckBoxItem(jPopupMenu, this, "Snap to Grid");
        jCheckBoxMenuItem.setSelected(mSnapToGridFlag);
        jCheckBoxMenuItem = SGUtility.addCheckBoxItem(jPopupMenu, this, MENUCMD_SHOW_BOUNDING_BOX);
        jCheckBoxMenuItem.setSelected(mBoundingBoxVisibleFlag);
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, MENUCMD_SAVE_PROPERTY);
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Move to Front");
        SGUtility.addItem(jPopupMenu, this, "Move to Back");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Cut");
        SGUtility.addItem(jPopupMenu, this, "Copy");
        SGUtility.addItem(jPopupMenu, this, "Paste");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Delete");
        SGUtility.addItem(jPopupMenu, this, "Duplicate");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, MENUCMD_PROPERTY);
        return true;
    }

    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    protected abstract boolean createDialog();

    public SGProperties getProperties() {
        FigureProperties figureProperties = new FigureProperties();
        this.getProperties(figureProperties);
        return figureProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof FigureProperties)) {
            return false;
        }
        FigureProperties figureProperties = (FigureProperties)sGProperties;
        figureProperties.setX(this.mGraphRectX);
        figureProperties.setY(this.mGraphRectY);
        figureProperties.setWidth(this.mGraphRectWidth);
        figureProperties.setHeight(this.mGraphRectHeight);
        figureProperties.setSpaceLineAndNumber(this.getAxisElement().getSpaceAxisLineAndNumber());
        figureProperties.setSpaceNumberAndTitle(this.getAxisElement().getSpaceNumberAndTitle());
        figureProperties.setBackgroundColor(this.mBackgroundColor);
        figureProperties.setTransparent(this.mTransparentFlag);
        figureProperties.setLegendVisible(this.getLegendElement().isLegendVisible());
        return true;
    }

    public SGPropertyDialog getPropertyDialog() {
        return this.mDialog;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (string.equals(MENUCMD_SHOW_BOUNDING_BOX)) {
            mBoundingBoxVisibleFlag = !mBoundingBoxVisibleFlag;
            this.updatePopupMenu();
            this.updateImage();
            this.repaint();
            return;
        }
        if (string.equals(MENUCMD_RUBBER_BANDING)) {
            mRubberBandFlag = !mRubberBandFlag;
            this.updatePopupMenu();
            this.updateImage();
            this.repaint();
            return;
        }
        if (string.equals("Snap to Grid")) {
            SGFigure.setSnappingToGrid(!SGFigure.isSnappingToGrid());
            this.updatePopupMenu();
            this.mWnd.updateSnapToGridItems();
            return;
        }
        if (string.equals(MENUCMD_SAVE_PROPERTY)) {
            this.mWnd.createPropertyFileFromFocusedFigures();
        } else if (string.equals(MENUCMD_PROPERTY)) {
            this.mWnd.showPropertyDialogForSelectedFigures();
        } else if (string.equals("Move to Front")) {
            this.mWnd.moveFocusedObjectsToFront();
        } else if (string.equals("Move to Back")) {
            this.mWnd.moveFocusedObjectsToBack();
        } else if (string.equals("Cut")) {
            this.mWnd.doCut();
        } else if (string.equals("Copy")) {
            this.mWnd.doCopy();
        } else if (string.equals("Paste")) {
            this.mWnd.doPaste();
        } else if (string.equals("Delete")) {
            this.mWnd.doDelete();
        } else if (string.equals("Duplicate")) {
            this.mWnd.doDuplicate();
        }
        if (object instanceof SGIFigureElement) {
            SGIFigureElement sGIFigureElement = (SGIFigureElement)actionEvent.getSource();
            if (string.equals("Notify the change")) {
                this.broadcast(sGIFigureElement, string);
            } else if (string.equals("Notify the change on undo")) {
                this.broadcast(sGIFigureElement, string);
            } else if (string.equals("Set properties of selected objects")) {
                this.mWnd.showPropertyDialogForSelectedObjects(this, sGIFigureElement);
            } else if (string.equals("Clear focused objects")) {
                this.mWnd.clearAllFocusedObjectsInFigures();
            } else if (string.equals("Notify the change to root")) {
                this.notifyToRoot();
            } else if (string.equals("Notify the change of cursor")) {
                this.setCursorToWindow(sGIFigureElement);
            } else if (string.equals("Merge Data")) {
                this.mergeData(sGIFigureElement);
            }
        }
    }

    private boolean mergeData(SGIFigureElement sGIFigureElement) {
        SGData sGData;
        int n;
        List list = sGIFigureElement.getDataList();
        ArrayList<SGData> arrayList = new ArrayList<SGData>();
        List list2 = this.mDataList;
        for (n = 0; n < list2.size(); ++n) {
            sGData = (SGData)list2.get(n);
            if (list.contains(sGData)) continue;
            arrayList.add(sGData);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGData = (SGData)arrayList.get(n);
            this.removeData(sGData);
        }
        return true;
    }

    public boolean initPropertiesHistory() {
        return this.mUndoManager.initPropertiesHistory();
    }

    public boolean undo() {
        return this.mUndoManager.undo();
    }

    public boolean redo() {
        return this.mUndoManager.redo();
    }

    public boolean commit() {
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.mChangedFlag = true;
        }
        this.mTemporaryProperties = null;
        this.updateGraphRect();
        return true;
    }

    public boolean preview() {
        this.updateGraphRect();
        return true;
    }

    public boolean cancel() {
        this.setProperties(this.mTemporaryProperties);
        this.updateGraphRect();
        this.mTemporaryProperties = null;
        return true;
    }

    public SGProperties getMemento() {
        return this.getProperties();
    }

    public boolean setMemento(SGProperties sGProperties) {
        return this.setProperties(sGProperties);
    }

    public boolean updateHistory() {
        ArrayList<SGIFigureElement> arrayList = new ArrayList<SGIFigureElement>();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            SGIFigureElement sGIFigureElement = sGIFigureElementArray[i];
            arrayList.add(sGIFigureElement);
            if (!sGIFigureElement.equals(this.getLegendElement())) continue;
        }
        this.mUndoManager.updateHistory(arrayList);
        return true;
    }

    public void initUndoBuffer() {
        this.mUndoManager.initUndoBuffer();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].initUndoBuffer();
        }
    }

    public boolean isUndoable() {
        return this.mUndoManager.isUndoable();
    }

    public boolean isRedoable() {
        return this.mUndoManager.isRedoable();
    }

    public boolean initGraphAreaLocation() {
        SGTuple2f sGTuple2f = new SGTuple2f();
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (!this.calcMargin(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        float f3 = sGTuple2f2.x;
        float f4 = sGTuple2f2.y;
        this.mGraphRectX = f3;
        this.mGraphRectY = f;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setGraphRectLocation(this.mGraphRectX, this.mGraphRectY);
            sGIFigureElementArray[i].setGraphRectSize(this.mGraphRectWidth, this.mGraphRectHeight);
        }
        return true;
    }

    public boolean calcMargin(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[sGIFigureElementArray.length];
        SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[sGIFigureElementArray.length];
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
            sGTuple2fArray2[i] = new SGTuple2f();
            boolean bl = sGIFigureElementArray[i].getMarginAroundGraphRect(sGTuple2fArray[i], sGTuple2fArray2[i]);
            if (bl) continue;
            return false;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            float f5 = sGTuple2fArray[i].x;
            float f6 = sGTuple2fArray[i].y;
            float f7 = sGTuple2fArray2[i].x;
            float f8 = sGTuple2fArray2[i].y;
            if (f5 > f) {
                f = f5;
            }
            if (f6 > f2) {
                f2 = f6;
            }
            if (f7 > f3) {
                f3 = f7;
            }
            if (!(f8 > f4)) continue;
            f4 = f8;
        }
        float f9 = this.mMagnification;
        sGTuple2f.x = f + f9 * 5.0f;
        sGTuple2f.y = f2 + f9 * 5.0f;
        sGTuple2f2.x = f3 + f9 * 5.0f;
        sGTuple2f2.y = f4 + f9 * 5.0f;
        return true;
    }

    public Rectangle2D getBoundingBox() {
        Rectangle2D rectangle2D = this.getGraphRect();
        SGTuple2f sGTuple2f = new SGTuple2f();
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (!this.calcMargin(sGTuple2f, sGTuple2f2)) {
            return null;
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float((float)rectangle2D.getX() - sGTuple2f2.x, (float)rectangle2D.getY() - sGTuple2f.x, (float)rectangle2D.getWidth() + sGTuple2f2.x + sGTuple2f2.y, (float)rectangle2D.getHeight() + sGTuple2f.x + sGTuple2f.y);
        return float_;
    }

    public boolean setBoundingBox(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return false;
        }
        SGTuple2f sGTuple2f = new SGTuple2f();
        SGTuple2f sGTuple2f2 = new SGTuple2f();
        if (!this.calcMargin(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        float f = (float)rectangle2D.getX() + sGTuple2f2.x;
        float f2 = (float)rectangle2D.getY() + sGTuple2f.x;
        float f3 = (float)rectangle2D.getWidth() - (sGTuple2f2.x + sGTuple2f2.y);
        float f4 = (float)rectangle2D.getHeight() - (sGTuple2f.x + sGTuple2f.y);
        this.setGraphRect(f, f2, f3, f4);
        return true;
    }

    public boolean setCenter(float f, float f2) {
        float f3;
        float f4;
        Rectangle2D rectangle2D = this.getBoundingBox();
        float f5 = (float)rectangle2D.getWidth();
        float f6 = f - f5 / 2.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f6, f4 = f2 - (f3 = (float)rectangle2D.getHeight()) / 2.0f, f5, f3);
        return this.setBoundingBox(float_);
    }

    public boolean setGraphRectLocationByLeftBottom(float f, float f2) {
        Rectangle2D rectangle2D = this.getGraphRect();
        this.setGraphRectLocation(f, f2 - (float)rectangle2D.getHeight());
        return true;
    }

    private boolean broadcast(SGIFigureElement sGIFigureElement, String string) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].synchronize(sGIFigureElement, string);
        }
        return true;
    }

    public boolean removeData(SGData sGData) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        List list = this.mDataList;
        for (int i = list.size() - 1; i >= 0; --i) {
            SGData sGData2 = (SGData)list.get(i);
            if (!sGData2.equals(sGData)) continue;
            sGData.dispose();
            list.remove(i);
            for (int j = 0; j < sGIFigureElementArray.length; ++j) {
                sGIFigureElementArray[j].removeData(sGData);
            }
            return true;
        }
        return false;
    }

    public List getDataList() {
        return new ArrayList(this.mDataList);
    }

    public List getVisibleDataList() {
        return this.getGraphElement().getVisibleDataList();
    }

    public void paint(Graphics graphics, boolean bl) {
        this.paintGraphics((Graphics2D)graphics, bl);
    }

    protected void updateImage() {
    }

    private void paintGraphics(Graphics2D graphics2D, boolean bl) {
        SGIFigureElement[] sGIFigureElementArray;
        if (!this.mTransparentFlag) {
            sGIFigureElementArray = this.getGraphRect();
            graphics2D.setPaint(this.mBackgroundColor);
            graphics2D.fill((Shape)sGIFigureElementArray);
        }
        if (mBoundingBoxVisibleFlag & this.mSelectionSymbolsVisibleFlag && (sGIFigureElementArray = this.getBoundingBox()) != null) {
            graphics2D.setPaint(Color.BLUE);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw((Shape)sGIFigureElementArray);
        }
        sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].paint(graphics2D, bl);
        }
    }

    public Element createElement(Document document) {
        Element element = document.createElement(TAG_NAME_FIGURE);
        if (!this.writeProperty(element)) {
            return null;
        }
        if (!this.createElementLower(document, element)) {
            return null;
        }
        return element;
    }

    public Element createElementForFocusedInBoundingBox(Document document) {
        Element element = document.createElement(TAG_NAME_FIGURE);
        if (!this.writePropertyOnFocusedInBoundingBox(element)) {
            return null;
        }
        if (!this.createElementLower(document, element)) {
            return null;
        }
        return element;
    }

    public Element createElementForFocusedForDuplication(Document document) {
        Element element = document.createElement(TAG_NAME_FIGURE);
        if (!this.writePropertyForDuplication(element)) {
            return null;
        }
        if (!this.createElementLower(document, element)) {
            return null;
        }
        return element;
    }

    private boolean createElementLower(Document document, Element element) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            Element element2 = sGIFigureElementArray[i].createElement(document);
            if (sGIFigureElementArray[i] instanceof SGIGraphElement) continue;
            if (element2 == null) {
                return false;
            }
            element.appendChild(element2);
        }
        ArrayList arrayList = new ArrayList();
        if (!this.getGraphElement().createElementOfData(document, arrayList)) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Element element3 = (Element)arrayList.get(i);
            element.appendChild(element3);
        }
        return true;
    }

    public boolean writeProperty(Element element) {
        float f = this.mGraphRectX;
        float f2 = this.mGraphRectY;
        return this.writeProperty_(element, f, f2);
    }

    public boolean writePropertyOnFocusedInBoundingBox(Element element) {
        SGDrawingWindow sGDrawingWindow = this.getWindow();
        Rectangle2D rectangle2D = sGDrawingWindow.getBoundingBoxOfFigures(sGDrawingWindow.getFocusedObjectsList());
        float f = this.mGraphRectX - (float)rectangle2D.getX() / this.mMagnification;
        float f2 = this.mGraphRectY - (float)rectangle2D.getY() / this.mMagnification;
        return this.writeProperty_(element, f, f2);
    }

    public boolean writePropertyForDuplication(Element element) {
        float f = 20.0f * this.mMagnification;
        float f2 = this.mGraphRectX + f;
        float f3 = this.mGraphRectY + f;
        return this.writeProperty_(element, f2, f3);
    }

    public abstract String getClassType();

    private boolean writeProperty_(Element element, float f, float f2) {
        element.setAttribute(KEY_FIGURE_TYPE, this.getClassType());
        float f3 = (float)SGUtilityNumber.roundOffNumber(f * 0.035277776f, -2);
        float f4 = (float)SGUtilityNumber.roundOffNumber(f2 * 0.035277776f, -2);
        element.setAttribute(KEY_FIGURE_X_IN_CLIENT, Float.toString(f3) + "cm");
        element.setAttribute(KEY_FIGURE_Y_IN_CLIENT, Float.toString(f4) + "cm");
        float f5 = (float)SGUtilityNumber.roundOffNumber(this.mGraphRectWidth * 0.035277776f, -2);
        float f6 = (float)SGUtilityNumber.roundOffNumber(this.mGraphRectHeight * 0.035277776f, -2);
        element.setAttribute(KEY_FIGURE_WIDTH, Float.toString(f5) + "cm");
        element.setAttribute(KEY_FIGURE_HEIGHT, Float.toString(f6) + "cm");
        element.setAttribute(KEY_SPACE_AXIS_LINE_AND_NUMBER, Float.toString(this.getSpaceAxisLineAndNumber() * 0.035277776f) + "cm");
        element.setAttribute(KEY_SPACE_NUMBER_AND_TITLE, Float.toString(this.getSpaceNumberAndTitle() * 0.035277776f) + "cm");
        element.setAttribute(KEY_FIGURE_BACKGROUND_COLOR, SGUtilityText.getColorString(this.mBackgroundColor));
        element.setAttribute(KEY_FIGURE_BACKGROUND_TRANSPARENT, Boolean.toString(this.mTransparentFlag));
        return true;
    }

    public boolean readProperty(Element element) {
        float f;
        StringBuffer stringBuffer;
        String string = null;
        Number number = null;
        Boolean bl = null;
        Color color = null;
        string = element.getAttribute(KEY_FIGURE_X_IN_CLIENT);
        if (string.length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setFigureX(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute(KEY_FIGURE_Y_IN_CLIENT)).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setFigureY(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute(KEY_FIGURE_WIDTH)).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setFigureWidth(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute(KEY_FIGURE_HEIGHT)).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.setFigureHeight(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute(KEY_FIGURE_BACKGROUND_COLOR)).length() != 0) {
            color = SGUtilityText.getColorFromString(string);
            if (color == null) {
                return false;
            }
            if (!this.setBackgroundColor(color)) {
                return false;
            }
        }
        if ((string = element.getAttribute(KEY_FIGURE_BACKGROUND_TRANSPARENT)).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl2 = bl;
            if (!this.setTransparent(bl2)) {
                return false;
            }
        }
        return true;
    }

    public boolean createDataObjectFromPropertyFile(Element element, SGData sGData) {
        this.mDataList.add(sGData);
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].createDataObject(element, sGData)) continue;
            return false;
        }
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof FigureProperties)) {
            return false;
        }
        FigureProperties figureProperties = (FigureProperties)sGProperties;
        this.mGraphRectX = figureProperties.mX;
        this.mGraphRectY = figureProperties.mY;
        this.mGraphRectWidth = figureProperties.mWidth;
        this.mGraphRectHeight = figureProperties.mHeight;
        this.setBackgroundColor(figureProperties.mBackgroundColor);
        this.setTransparent(figureProperties.mTransparentFlag);
        this.setSpaceAxisLineAndNumber(figureProperties.mSpaceLineAndNumber);
        this.setSpaceNumberAndTitle(figureProperties.mSpaceNumberAndTitle);
        this.setLegendVisible(figureProperties.mLegendVisibleFlag);
        return true;
    }

    protected boolean duplicateFocusedObjects() {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].duplicateFocusedObjects()) continue;
            return false;
        }
        return true;
    }

    protected ArrayList createCopiedObjects() {
        ArrayList arrayList = new ArrayList();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            arrayList.addAll(sGIFigureElementArray[i].getCopiedObjectsList());
        }
        return arrayList;
    }

    protected ArrayList cutFocusedObjects() {
        ArrayList arrayList = new ArrayList();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            arrayList.addAll(sGIFigureElementArray[i].cutFocusedObjects());
        }
        return arrayList;
    }

    boolean createCopiedDataObjects(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        ArrayList arrayList4 = this.getGraphElement().getFocusedDataList();
        for (int i = 0; i < arrayList4.size(); ++i) {
            SGData sGData = (SGData)arrayList4.get(i);
            arrayList.add(sGData);
            String string = this.getDataName(sGData);
            arrayList2.add(string);
            Map map = this.getDataPropertiesMap(sGData);
            arrayList3.add(map);
        }
        return true;
    }

    boolean cutFocusedDataObjects(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        ArrayList arrayList4 = this.getGraphElement().cutFocusedData();
        for (int i = 0; i < arrayList4.size(); ++i) {
            SGData sGData = (SGData)arrayList4.get(i);
            arrayList.add(sGData);
            String string = this.getDataName(sGData);
            arrayList2.add(string);
            Map map = this.getDataPropertiesMap(sGData);
            arrayList3.add(map);
        }
        return true;
    }

    public String getDataName(SGData sGData) {
        return this.getGraphElement().getDataName(sGData);
    }

    public boolean setDataName(String string, SGData sGData) {
        return this.getGraphElement().setDataName(string, sGData);
    }

    public Map getDataPropertiesMap(SGData sGData) {
        TreeMap<Integer, SGProperties> treeMap = new TreeMap<Integer, SGProperties>();
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            SGProperties sGProperties = sGIFigureElementArray[i].getDataProperties(sGData);
            treeMap.put(new Integer(i), sGProperties);
        }
        return treeMap;
    }

    public boolean paste(ArrayList arrayList) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].paste(arrayList)) continue;
            return false;
        }
        return true;
    }

    public boolean moveFocusedObjects(boolean bl) {
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            if (sGIFigureElementArray[i].moveFocusedObjects(bl)) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        this.mComponent = null;
        this.mWnd = null;
        this.mDataList.clear();
        Map map = this.mFigureElementMap;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            SGIFigureElement sGIFigureElement = (SGIFigureElement)v;
            sGIFigureElement.dispose();
        }
        map.clear();
    }

    public void setMode(int n) {
        this.mMode = n;
        SGIFigureElement[] sGIFigureElementArray = this.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setMode(n);
        }
    }

    public int getMode() {
        return this.mMode;
    }

    public static boolean isSnappingToGrid() {
        return mSnapToGridFlag;
    }

    public static void setSnappingToGrid(boolean bl) {
        mSnapToGridFlag = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class FigureProperties
    extends SGProperties {
        private float mX;
        private float mY;
        private float mWidth;
        private float mHeight;
        private float mSpaceLineAndNumber;
        private float mSpaceNumberAndTitle;
        private Color mBackgroundColor;
        private boolean mTransparentFlag;
        private boolean mLegendVisibleFlag;

        public void dispose() {
            this.mBackgroundColor = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FigureProperties)) {
                return false;
            }
            FigureProperties figureProperties = (FigureProperties)object;
            if (figureProperties.mX != this.mX) {
                return false;
            }
            if (figureProperties.mY != this.mY) {
                return false;
            }
            if (figureProperties.mWidth != this.mWidth) {
                return false;
            }
            if (figureProperties.mHeight != this.mHeight) {
                return false;
            }
            if (figureProperties.mSpaceLineAndNumber != this.mSpaceLineAndNumber) {
                return false;
            }
            if (figureProperties.mSpaceNumberAndTitle != this.mSpaceNumberAndTitle) {
                return false;
            }
            if (!figureProperties.mBackgroundColor.equals(this.mBackgroundColor)) {
                return false;
            }
            if (figureProperties.mTransparentFlag != this.mTransparentFlag) {
                return false;
            }
            return figureProperties.mLegendVisibleFlag == this.mLegendVisibleFlag;
        }

        public void setX(float f) {
            this.mX = f;
        }

        public void setY(float f) {
            this.mY = f;
        }

        public void setWidth(float f) {
            this.mWidth = f;
        }

        public void setHeight(float f) {
            this.mHeight = f;
        }

        public void setSpaceLineAndNumber(float f) {
            this.mSpaceLineAndNumber = f;
        }

        public void setSpaceNumberAndTitle(float f) {
            this.mSpaceNumberAndTitle = f;
        }

        public void setBackgroundColor(Color color) {
            this.mBackgroundColor = color;
        }

        public void setTransparent(boolean bl) {
            this.mTransparentFlag = bl;
        }

        public void setLegendVisible(boolean bl) {
            this.mLegendVisibleFlag = bl;
        }

        public float getX() {
            return this.mX;
        }

        public float getY() {
            return this.mY;
        }

        public float getWidth() {
            return this.mWidth;
        }

        public float getHeight() {
            return this.mHeight;
        }

        public float getSpaceLineAndNumber() {
            return this.mSpaceLineAndNumber;
        }

        public float getSpaceNumberAndTitle() {
            return this.mSpaceNumberAndTitle;
        }

        public Color getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public boolean isTransparent() {
            return this.mTransparentFlag;
        }

        public boolean isLegendVisible() {
            return this.mLegendVisibleFlag;
        }
    }
}

