/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SGElementGroup
implements SGIElementGroupConstants {
    protected SGDrawingElement[] mDrawingElementArray = null;
    protected SGElementGroupSet mGroupSet = null;
    protected float mMagnification = 1.0f;
    protected ArrayList mColorList = new ArrayList();
    protected boolean mVisibleFlag = true;

    protected abstract boolean initDrawingElement(int var1);

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        return true;
    }

    protected boolean setDialogProperty() {
        return true;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setMagnification(float f) {
        if ((double)f < 0.0) {
            throw new IllegalArgumentException("ratio < 0.0");
        }
        this.mMagnification = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                this.mDrawingElementArray[i].setMagnification(f);
            }
        }
        return true;
    }

    public boolean addColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color==null");
        }
        this.mColorList.add(color);
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                this.mDrawingElementArray[i].addColor(color);
            }
        }
        return true;
    }

    public boolean setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color==null");
        }
        this.mColorList.clear();
        this.mColorList.add(color);
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                this.mDrawingElementArray[i].setColor(color);
            }
        }
        return true;
    }

    public boolean setColorList(ArrayList arrayList) {
        if (arrayList == null) {
            throw new IllegalArgumentException("colorList==null");
        }
        if (arrayList.size() == 0) {
            throw new IllegalArgumentException("colorList.size()==0");
        }
        this.mColorList = new ArrayList(arrayList);
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                this.mDrawingElementArray[i].setColor(arrayList);
            }
        }
        return true;
    }

    public Color getColor(int n) {
        if (this.mColorList == null) {
            return null;
        }
        if (n >= this.mColorList.size()) {
            new ArrayIndexOutOfBoundsException("index >= mColorList.size()");
        }
        return (Color)this.mColorList.get(n);
    }

    public ArrayList getColorList() {
        return this.mColorList;
    }

    public boolean zoom(float f) {
        this.mMagnification = f;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                this.mDrawingElementArray[i].zoom(f);
            }
        }
        return true;
    }

    public void setVisible(boolean bl) {
        this.mVisibleFlag = bl;
    }

    public boolean isVisible() {
        return this.mVisibleFlag;
    }

    public boolean contains(int n, int n2) {
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                if (!this.mDrawingElementArray[i].isVisible() || !this.mDrawingElementArray[i].contains(n, n2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean paintElement(Graphics2D graphics2D) {
        return this.paintElement(graphics2D, null);
    }

    public abstract boolean paintElement(Graphics2D var1, Rectangle2D var2);

    public abstract SGDrawingElement getDrawingElement();

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        this.setVisible(sGDrawingElement.isVisible());
        this.setColorList(sGDrawingElement.getColorList());
        return true;
    }

    public abstract String getTagName();

    public Element createElement(Document document) {
        Element element = document.createElement(this.getTagName());
        if (!this.writeProperty(element)) {
            return null;
        }
        return element;
    }

    public abstract boolean writeProperty(Element var1);

    public boolean readProperty(Element element) {
        SGProperties sGProperties = this.readProperties(element);
        return this.setProperties(sGProperties);
    }

    public abstract SGProperties readProperties(Element var1);

    public boolean setPropertyWithDialog() {
        return this.setProperties(this.getPropertiesFromDialog());
    }

    public SGProperties getProperties() {
        ElementGroupProperties elementGroupProperties = new ElementGroupProperties();
        this.getProperties(elementGroupProperties);
        return elementGroupProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ElementGroupProperties)) {
            return false;
        }
        ElementGroupProperties elementGroupProperties = (ElementGroupProperties)sGProperties;
        elementGroupProperties.setVisible(this.isVisible());
        elementGroupProperties.setColorList(new ArrayList(this.mColorList));
        return true;
    }

    protected ElementGroupProperties getPropertiesFromDialog() {
        return null;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ElementGroupProperties)) {
            return false;
        }
        ElementGroupProperties elementGroupProperties = (ElementGroupProperties)sGProperties;
        Boolean bl = elementGroupProperties.isVisible();
        if (bl == null) {
            return false;
        }
        ArrayList arrayList = elementGroupProperties.getColorList();
        if (arrayList == null) {
            return false;
        }
        this.setVisible(bl);
        this.setColorList(arrayList);
        return true;
    }

    public static class ElementGroupProperties
    extends SGProperties {
        private boolean mVisible;
        private ArrayList mColorList = new ArrayList();

        public boolean equals(Object object) {
            if (!(object instanceof ElementGroupProperties)) {
                return false;
            }
            ElementGroupProperties elementGroupProperties = (ElementGroupProperties)object;
            if (this.mVisible != elementGroupProperties.mVisible) {
                return false;
            }
            return this.mColorList.equals(elementGroupProperties.mColorList);
        }

        public Boolean isVisible() {
            return this.mVisible;
        }

        public ArrayList getColorList() {
            return new ArrayList(this.mColorList);
        }

        public void setVisible(boolean bl) {
            this.mVisible = bl;
        }

        public void setColorList(ArrayList arrayList) {
            if (arrayList == null) {
                throw new IllegalArgumentException("list==null");
            }
            this.mColorList = new ArrayList(arrayList);
        }
    }
}

