/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.print.attribute.standard.MediaSize;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIImageExportManager;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGIPaintable;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObject;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGIWindowDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGMenuBar;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGRootManager;
import jp.riken.brain.ni.samuraigraph.base.SGToolBar;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGWindowDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SGDrawingWindow
extends JFrame
implements ComponentListener,
PropertyChangeListener,
MouseInputListener,
MouseWheelListener,
MenuListener,
ActionListener,
AdjustmentListener,
SGIUndoable,
SGIWindowDialogObserver,
SGIRootObject,
SGINode {
    private int mID;
    private final SGRootManager mManager;
    private final JLayeredPane mLayeredPane = new JLayeredPane();
    private BackgroundPanel mBackgroundPanel;
    private ForegroundPanel mForegroundPanel;
    private RulerPanel mRulerPanel;
    private JScrollBar mHScrollBar = null;
    private JScrollBar mVScrollBar = null;
    private JPopupMenu mPopupMenu = new JPopupMenu();
    private SGWindowDialog mDialog = null;
    private SGIImageExportManager mImageExportManager;
    private final SGTuple2f mTemporaryViewportSize = new SGTuple2f();
    private float mMagnification = 1.0f;
    private SGToolBar mToolBar;
    private boolean mLockFigureFlag = false;
    private SGProperties mTemporaryProperties = null;
    private final SGTuple2f mPaperOrigin = new SGTuple2f();
    private final SGTuple2f mPaperSize = new SGTuple2f();
    private Rectangle2D mClientRect = null;
    public static final String TITLE = "Samurai Graph";
    private ArrayList mCopiedFiguresList = new ArrayList();
    private ArrayList mCopiedObjectsList = new ArrayList();
    private ArrayList mCopiedDataObjectsList = new ArrayList();
    private ArrayList mCopiedDataNameList = new ArrayList();
    private ArrayList mCopiedDataPropertiesMapList = new ArrayList();
    private static final String[] IMAGE_FILENAMES_ARRAY = new String[]{"Samurai.gif"};
    protected boolean mRulerVisibleFlag = true;
    public static final float PAPER_MARGIN = 56.692917f;
    private static final String DIALOG_TITLE_ADDITION_ERROR = "Failed to add a symbol.";
    private static final String ERRMSG_CLICK_GRAPH_RECTANGLE = "Click within the recatngle of figure.";
    private boolean mViewportPressedFlag = false;
    protected final Point mTempMouseLocation = new Point();
    public static final String WINDOW_TITLE_PREFIX = "Samurai Graph - Window : ";
    private ArrayList mActionListenerList = new ArrayList();
    private boolean mPaperPortraitFlag = true;
    private ArrayList mPasteTargetList = new ArrayList();
    private boolean mAutoZoomFlag = false;
    private final Rectangle2D mTempPaperRect = new Rectangle2D.Float();
    private static final float BOUNDING_BOX_MARGIN;
    private boolean mChangedFlag = false;
    private Rectangle2D mTempRect = new Rectangle2D.Double();
    private int mCurrentStateCounter = 0;
    private int mWindowStateCounter = 0;
    private ArrayList mWindowPropertyHistoryList = new ArrayList();
    private ArrayList mUndoableObjectHistoryList = new ArrayList();
    private SGMenuBar mMenuBar = new SGMenuBar();
    private int mPropertyFileCreationModeOfFigures;

    public SGDrawingWindow() {
        this.mManager = new SGRootManager(this);
        this.setTitle(TITLE);
        this.create();
        this.setDefaultCloseOperation(2);
    }

    public String toString() {
        return new String("SGDrawingWindow:" + this.getID());
    }

    private Map loadImages() {
        String[] stringArray = IMAGE_FILENAMES_ARRAY;
        int n = stringArray.length;
        ImageIcon[] imageIconArray = new ImageIcon[n];
        for (int i = 0; i < n; ++i) {
            imageIconArray[i] = this.createIcon(stringArray[i]);
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        HashMap<String, ImageIcon> hashMap = new HashMap<String, ImageIcon>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(stringArray[i], imageIconArray[i]);
            mediaTracker.addImage(imageIconArray[i].getImage(), i);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return hashMap;
    }

    private boolean create() {
        Map map = this.loadImages();
        SwingUtilities.updateComponentTreeUI(this);
        ImageIcon imageIcon = (ImageIcon)map.get("Samurai.gif");
        this.setIconImage(imageIcon.getImage());
        this.createPopupMenu();
        this.createPropertyDialog();
        this.createMenuBar();
        this.createToolBar();
        this.getContentPane().add((Component)this.mLayeredPane, "Center");
        this.createBackgroundPanel();
        this.createForegroundPanel();
        this.createRulerPanel();
        this.createScrollBars();
        this.pack();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.updateItemsByFigureNumbers();
        this.updateGridItems();
        this.updatePaperItems();
        this.updateUndoItems();
        this.updateFocusedObjectItem();
        this.updateZoomItems();
        return true;
    }

    public void updateItemsByFigureNumbers() {
        boolean bl = this.getVisibleFigureListFromMap().size() != 0;
        SGToolBar sGToolBar = this.mToolBar;
        sGToolBar.setButtonEnabled("Export as Image", bl);
        sGToolBar.setButtonEnabled("Save Property", bl);
        sGToolBar.setButtonEnabled("Print", bl);
        sGToolBar.setButtonEnabled("Bounding Box", bl);
        sGToolBar.setInsertToggleButtonsEnabled(bl);
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemEnabled("File", "Export as Image", bl);
        sGMenuBar.setMenuItemEnabled("File", "Save Property", bl);
        sGMenuBar.setMenuItemEnabled("File", "Print", bl);
        sGMenuBar.setMenuItemEnabled("Layout", "Bounding Box", bl);
        sGMenuBar.setMenuItemEnabled("Layout", "Snap to Grid", bl);
        sGMenuBar.setMenuItemEnabled("Arrange", "Auto Arrangement", bl);
        sGMenuBar.setInsertToggleButtonsEnabled(bl);
    }

    public boolean init() {
        float f = 566.92914f;
        float f2 = f / SGIConstants.GOLDEN_RATIO;
        this.setViewportSize(f, f2);
        this.mToolBar.setPreferredSize(new Dimension((int)f, this.mToolBar.getHeight()));
        this.mTemporaryViewportSize.setValues(f, f2);
        this.setComponentBounds();
        this.mClientRect = new Rectangle2D.Float();
        this.setPaperOrigin(0.0f, 0.0f);
        float f3 = SGDefaultValues.PAPER_WIDTH;
        float f4 = SGDefaultValues.PAPER_HEIGHT;
        this.setPaperSizeRoundingOff(f3, f4);
        this.updateClientRect();
        return true;
    }

    private void repaintAll() {
        this.getContentPane().repaint();
    }

    private boolean createScrollBars() {
        ForegroundPanel foregroundPanel = this.mForegroundPanel;
        JScrollBar jScrollBar = new JScrollBar(1, 0, 100, 0, 100);
        JScrollBar jScrollBar2 = new JScrollBar(0, 0, 100, 0, 100);
        jScrollBar.setVisible(false);
        jScrollBar2.setVisible(false);
        foregroundPanel.setLayout(new BorderLayout());
        foregroundPanel.add((Component)jScrollBar, "East");
        foregroundPanel.add((Component)jScrollBar2, "South");
        int n = jScrollBar2.getMinimum();
        int n2 = jScrollBar2.getMaximum();
        int n3 = jScrollBar2.getVisibleAmount();
        jScrollBar2.setValue((n2 - n3 - n) / 2);
        n = jScrollBar.getMinimum();
        n2 = jScrollBar.getMaximum();
        n3 = jScrollBar.getVisibleAmount();
        jScrollBar.setValue((n2 - n3 - n) / 2);
        jScrollBar2.addAdjustmentListener(this);
        jScrollBar.addAdjustmentListener(this);
        this.mHScrollBar = jScrollBar2;
        this.mVScrollBar = jScrollBar;
        return true;
    }

    private ImageIcon createIcon(String string) {
        URL uRL = this.getClass().getResource("/resources/" + string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon;
    }

    private boolean createToolBar() {
        SGToolBar sGToolBar;
        this.mToolBar = sGToolBar = new SGToolBar();
        sGToolBar.setRoot(this);
        sGToolBar.addActionListener(this);
        sGToolBar.addPropertyChangeListener(this);
        this.addComponentListener(sGToolBar);
        sGToolBar.addComponentListener(this);
        this.addComponentListener(this);
        this.setToolBar();
        return true;
    }

    private boolean setToolBar() {
        this.getContentPane().remove(this.mToolBar);
        int n = this.mToolBar.getOrientation();
        if (n == 0) {
            this.getContentPane().add((Component)this.mToolBar, "North");
        } else if (n == 1) {
            this.getContentPane().add((Component)this.mToolBar, "West");
        }
        this.validate();
        return true;
    }

    private int getToolBarHeight() {
        int n = 0;
        if (this.mToolBar.isVisible()) {
            n = this.mToolBar.getHeight();
        }
        return n;
    }

    private int getToolBarWidth() {
        int n = 0;
        if (this.mToolBar.isVisible()) {
            n = this.mToolBar.getWidth();
        }
        return n;
    }

    public String[] getToolBarPattern() {
        String[] stringArray = this.mToolBar.getToolBarPattern();
        return stringArray;
    }

    public void setToolBarPattern(String[] stringArray) {
        this.mToolBar.setToolBarPattern(stringArray);
        this.updateToolBarVisibleMenuItems();
        this.updateToolBarVisibleItems();
    }

    private boolean createBackgroundPanel() {
        BackgroundPanel backgroundPanel = new BackgroundPanel(this);
        this.mLayeredPane.add(backgroundPanel);
        this.mLayeredPane.setLayer(backgroundPanel, 20);
        this.mBackgroundPanel = backgroundPanel;
        return true;
    }

    private boolean createForegroundPanel() {
        ForegroundPanel foregroundPanel = new ForegroundPanel(this);
        this.mLayeredPane.add((Component)foregroundPanel, "Center");
        this.mLayeredPane.setLayer(foregroundPanel, 40);
        this.mForegroundPanel = foregroundPanel;
        return true;
    }

    private boolean createRulerPanel() {
        RulerPanel rulerPanel = new RulerPanel(this);
        this.mLayeredPane.add(rulerPanel);
        this.mLayeredPane.setLayer(rulerPanel, 50);
        this.mRulerPanel = rulerPanel;
        return true;
    }

    public int getRulerWidth() {
        int n = 0;
        if (this.mRulerVisibleFlag) {
            n = 20;
        }
        return n;
    }

    private boolean createPopupMenu() {
        JPopupMenu jPopupMenu = this.mPopupMenu;
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel("  -- Window --"));
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Paste");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Property");
        return true;
    }

    private boolean createPropertyDialog() {
        this.mDialog = new SGWindowDialog((Frame)this, true);
        return true;
    }

    public int getID() {
        return this.mID;
    }

    public boolean setID(int n) {
        this.mID = n;
        return true;
    }

    public boolean isGridLineVisible() {
        return this.mBackgroundPanel.isGridVisible();
    }

    public float getGridLineWidth() {
        return this.mBackgroundPanel.getGridLineWidth();
    }

    public float getGridLineInterval() {
        return this.mBackgroundPanel.getGridInterval();
    }

    public Color getGridLineColor() {
        return this.mBackgroundPanel.getGridLineColor();
    }

    public boolean setGridLineWidth(float f) {
        this.mBackgroundPanel.setGridLineWidth(f);
        return true;
    }

    public boolean setGridLineColor(Color color) {
        this.mBackgroundPanel.setGridLineColor(color);
        return true;
    }

    public boolean setPaperColor(Color color) {
        this.mBackgroundPanel.setPaperColor(color);
        return true;
    }

    public boolean setGridLineVisible(boolean bl) {
        this.mBackgroundPanel.setGridVisible(bl);
        return true;
    }

    public boolean setGridLineInterval(float f) {
        this.mBackgroundPanel.setGridInterval(f);
        return true;
    }

    public Color getPaperColor() {
        return this.mBackgroundPanel.getPaperColor();
    }

    static float getAnchorSize() {
        return 6.0f;
    }

    public int getCurrentFigureId() {
        return this.getFigureMap().size() + 1;
    }

    public int getTopWidth() {
        Insets insets = this.getInsets();
        int n = insets.top;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n2 = jMenuBar.getHeight();
        int n3 = 0;
        if (this.mToolBar.getOrientation() == 0) {
            n3 = this.getToolBarHeight();
        }
        int n4 = n + n2 + n3;
        return n4;
    }

    public int getBottomWidth() {
        Insets insets = this.getInsets();
        int n = insets.bottom;
        return n;
    }

    public int getLeftWidth() {
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = 0;
        if (this.mToolBar.getOrientation() == 1) {
            n2 = this.getToolBarWidth();
        }
        return n + n2;
    }

    public int getRightWidth() {
        Insets insets = this.getInsets();
        int n = insets.right;
        return n;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public float getMagnificationPercent() {
        return this.mMagnification * 100.0f;
    }

    public void setImageFileCreator(SGIImageExportManager sGIImageExportManager) {
        this.mImageExportManager = sGIImageExportManager;
    }

    public boolean addFigure(int n, SGFigure sGFigure) {
        this.addFigure_(n, sGFigure);
        return true;
    }

    public boolean addFigure(int n, SGFigure sGFigure, Point point) {
        this.addFigure_(n, sGFigure);
        Point2D point2D = this.getLocationOnFigure(point);
        sGFigure.setGraphRectLocation((float)point2D.getX(), (float)point2D.getY());
        sGFigure.snapToLines(0);
        sGFigure.setGraphRectOnDragging();
        return true;
    }

    private boolean addFigure_(int n, SGFigure sGFigure) {
        sGFigure.setID(n);
        this.mManager.putFigure(n, sGFigure);
        this.mLayeredPane.setLayer(sGFigure, 30);
        this.mLayeredPane.add(sGFigure);
        SGTuple2f sGTuple2f = this.getViewportSize();
        int n2 = this.getRulerWidth();
        sGFigure.setLocation(n2, n2);
        sGFigure.setSize((int)sGTuple2f.x, (int)sGTuple2f.y);
        SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setISize(new SGTuple2f(sGTuple2f.x, sGTuple2f.y));
        }
        sGFigure.setViewBounds();
        this.zoom(this.mMagnification);
        this.updateItemsByFigureNumbers();
        return true;
    }

    public SGFigure[] getFigureArrayFromMap() {
        TreeMap treeMap = this.getFigureMap();
        SGFigure[] sGFigureArray = new SGFigure[treeMap.size()];
        Iterator iterator = treeMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            sGFigureArray[n] = (SGFigure)iterator.next();
            ++n;
        }
        return sGFigureArray;
    }

    public ArrayList getFigureListFromLayer() {
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>(Arrays.asList(this.getFigureArrayFromLayer()));
        return arrayList;
    }

    public ArrayList getFigureListFromMap() {
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>(Arrays.asList(this.getFigureArrayFromMap()));
        return arrayList;
    }

    public SGFigure[] getFigureArrayFromLayer() {
        Component[] componentArray = this.mLayeredPane.getComponentsInLayer(30);
        SGFigure[] sGFigureArray = new SGFigure[componentArray.length];
        for (int i = 0; i < sGFigureArray.length; ++i) {
            sGFigureArray[i] = (SGFigure)componentArray[i];
        }
        return sGFigureArray;
    }

    public ArrayList getVisibleFigureListFromMap() {
        SGFigure[] sGFigureArray = this.getFigureArrayFromMap();
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (!sGFigureArray[i].isVisible()) continue;
            arrayList.add(sGFigureArray[i]);
        }
        return arrayList;
    }

    public ArrayList getVisibleFigureListFromLayer() {
        SGFigure[] sGFigureArray = this.getFigureArrayFromLayer();
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (!sGFigureArray[i].isVisible()) continue;
            arrayList.add(sGFigureArray[i]);
        }
        return arrayList;
    }

    public ArrayList getChildNodes() {
        return this.getVisibleFigureListFromMap();
    }

    public boolean drawBackAllVisibleFigures() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (this.drawBackFigure(sGFigure)) continue;
            return false;
        }
        return true;
    }

    public boolean drawBackFigure(SGFigure sGFigure) {
        return sGFigure.drawbackFigure();
    }

    public void moveToBack(SGFigure sGFigure) {
        this.move(sGFigure, false);
    }

    public void moveToFront(SGFigure sGFigure) {
        this.move(sGFigure, true);
    }

    private void move(SGFigure sGFigure, boolean bl) {
        JLayeredPane jLayeredPane = this.mLayeredPane;
        if (bl) {
            jLayeredPane.moveToFront(sGFigure);
        } else {
            jLayeredPane.moveToBack(sGFigure);
        }
    }

    public SGFigure getFigure(int n) {
        return this.mManager.getFigure(n);
    }

    public TreeMap getFigureMap() {
        return (TreeMap)this.mManager.getFigureMap().clone();
    }

    protected boolean hideFigure(SGFigure sGFigure) {
        sGFigure.setVisible(false);
        sGFigure.setChanged(true);
        return true;
    }

    public boolean clearFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList.get(i);
            sGISelectable.setSelected(false);
        }
        return true;
    }

    public ArrayList getFocusedObjectsList() {
        ArrayList arrayList = new ArrayList();
        this.getFocusedObjectsList(arrayList);
        return arrayList;
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList2.get(i);
            if (!sGISelectable.isSelected()) continue;
            arrayList.add(sGISelectable);
        }
        return true;
    }

    public ArrayList getCopiedFiguresList() {
        return new ArrayList(this.mCopiedFiguresList);
    }

    public boolean hideSelectedObjects() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.isSelected()) {
                this.hideFigure(sGFigure);
                continue;
            }
            if (sGFigure.hideSelectedObjects()) continue;
            return false;
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
            this.clearFocusedObjects();
            this.updateItemsByFigureNumbers();
        }
        return true;
    }

    protected void setSelectionSymbolsVisible(boolean bl) {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.setSelectionSymbolsVisible(bl);
        }
    }

    public boolean removeFigure(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (this.removeFigure(sGFigure)) continue;
            return false;
        }
        return true;
    }

    protected boolean removeFigure(SGFigure sGFigure) {
        if (sGFigure == null) {
            return false;
        }
        this.mManager.removeFigure(sGFigure);
        this.mLayeredPane.remove(sGFigure);
        return true;
    }

    protected boolean setFigureVisible(SGFigure sGFigure, boolean bl) {
        if (sGFigure == null) {
            return false;
        }
        sGFigure.setVisible(bl);
        this.setFocusedFigure(sGFigure, false);
        return true;
    }

    public boolean clearAllFocusedObjectsInFigures() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.clearFocusedObjects()) continue;
            return false;
        }
        return this.clearFocusedFigures();
    }

    public boolean clearFocusedFigures() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            this.setFocusedFigure(sGFigure, false);
        }
        return true;
    }

    public boolean setFocusedFigure(SGFigure sGFigure, boolean bl) {
        sGFigure.setSelected(bl);
        sGFigure.setSymbolsVisibleAroundAllObjects(bl);
        return true;
    }

    public Point2D getLocationOnFigure(int n, int n2) {
        int n3 = this.getRulerWidth();
        float f = n - this.getLeftWidth() - n3;
        float f2 = n2 - this.getTopWidth() - n3;
        return new Point2D.Float(f, f2);
    }

    public Point2D getLocationOnFigure(Point point) {
        return this.getLocationOnFigure(point.x, point.y);
    }

    protected boolean setScrollValue(JScrollBar jScrollBar, double d) {
        int n = jScrollBar.getMinimum();
        int n2 = jScrollBar.getMaximum();
        int n3 = jScrollBar.getVisibleAmount();
        int n4 = n2 - n - n3;
        double d2 = d * (double)n4;
        jScrollBar.setValue((int)d2);
        return true;
    }

    protected float getScrollValue(JScrollBar jScrollBar) {
        int n;
        int n2 = jScrollBar.getMinimum();
        int n3 = jScrollBar.getMaximum();
        if (n3 - n2 - (n = jScrollBar.getVisibleAmount()) == 0) {
            return 0.0f;
        }
        float f = (float)jScrollBar.getValue() / (float)(n3 - n2 - n);
        return f;
    }

    protected float getHScrollValue() {
        return this.getScrollValue(this.mHScrollBar);
    }

    protected float getVScrollValue() {
        return this.getScrollValue(this.mVScrollBar);
    }

    private boolean setScrollBarValue() {
        if (this.mHScrollBar.isVisible()) {
            this.setScrollBarValue(true);
        }
        if (this.mVScrollBar.isVisible()) {
            this.setScrollBarValue(false);
        }
        return true;
    }

    private boolean setScrollBarValue(boolean bl) {
        Rectangle2D rectangle2D = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getViewportBounds();
        JScrollBar jScrollBar = null;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (bl) {
            jScrollBar = this.mHScrollBar;
            f = (float)rectangle2D.getWidth();
            f2 = (float)rectangle2D.getX();
            f3 = (float)rectangle2D2.getWidth();
        } else {
            jScrollBar = this.mVScrollBar;
            f = (float)rectangle2D.getHeight();
            f2 = (float)rectangle2D.getY();
            f3 = (float)rectangle2D2.getHeight();
        }
        int n = jScrollBar.getMinimum();
        int n2 = jScrollBar.getMaximum();
        int n3 = (int)(f3 / f * (float)(n2 - n));
        jScrollBar.setVisibleAmount(n3);
        float f4 = -f2 / (f - f3);
        int n4 = n + (int)(f4 * (float)(n2 - n3 - n));
        jScrollBar.setValue(n4);
        jScrollBar.setBlockIncrement(n3);
        return true;
    }

    public SGTuple2f getViewportSize() {
        SGTuple2f sGTuple2f = this.getPaneSize();
        int n = this.getRulerWidth();
        sGTuple2f.x -= (float)n;
        sGTuple2f.y -= (float)n;
        return sGTuple2f;
    }

    public SGTuple2f getPaneOrigin() {
        Rectangle2D rectangle2D = this.getPaneBounds();
        SGTuple2f sGTuple2f = new SGTuple2f((float)rectangle2D.getX(), (float)rectangle2D.getY());
        return sGTuple2f;
    }

    public SGTuple2f getPaneSize() {
        Rectangle2D rectangle2D = this.getPaneBounds();
        SGTuple2f sGTuple2f = new SGTuple2f((float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        return sGTuple2f;
    }

    public Rectangle2D getPaneBounds() {
        Insets insets = this.getInsets();
        int n = insets.top;
        int n2 = insets.bottom;
        int n3 = insets.left;
        int n4 = insets.right;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n5 = jMenuBar.getHeight();
        int n6 = this.getToolBarHeight();
        float f = this.getWidth() - (n3 + n4);
        float f2 = this.getHeight() - (n + n2 + n5 + n6);
        float f3 = n3;
        float f4 = n + n5 + n6;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f3, f4, f, f2);
        return float_;
    }

    public boolean setPaperOrigin(float f, float f2) {
        Rectangle2D rectangle2D = this.getClientRect();
        float f3 = this.mMagnification;
        float f4 = (f - (float)rectangle2D.getX()) / f3;
        float f5 = (f2 - (float)rectangle2D.getY()) / f3;
        this.mPaperOrigin.setValues(f4, f5);
        return true;
    }

    public boolean setPaperWidth(float f) {
        return this.setPaperSize(f, this.getPaperHeight());
    }

    public boolean setPaperHeight(float f) {
        return this.setPaperSize(this.getPaperWidth(), f);
    }

    public boolean setPaperSize(float f, float f2) {
        return this.setPaperSizeRoundingOff(f, f2);
    }

    public float getPaperX() {
        Rectangle2D rectangle2D = this.getClientRect();
        return (float)rectangle2D.getX() + this.mMagnification * this.mPaperOrigin.x;
    }

    public float getPaperY() {
        Rectangle2D rectangle2D = this.getClientRect();
        return (float)rectangle2D.getY() + this.mMagnification * this.mPaperOrigin.y;
    }

    public float getPaperWidth() {
        return this.mPaperSize.x;
    }

    public float getPaperHeight() {
        return this.mPaperSize.y;
    }

    public Rectangle2D getPaperRect() {
        float f = this.getMagnification();
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getPaperX(), this.getPaperY(), f * this.getPaperWidth(), f * this.getPaperHeight());
        return float_;
    }

    public Rectangle2D getBoundingBox() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float f = this.mMagnification * 56.692917f;
        Rectangle2D rectangle2D = this.getPaperRect();
        ((Rectangle2D)float_).setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + (double)f, rectangle2D.getHeight() + (double)f);
        return float_;
    }

    public boolean setViewportSize(float f, float f2) {
        this.mTemporaryViewportSize.setValues(f, f2);
        Insets insets = this.getInsets();
        int n = insets.top;
        int n2 = insets.bottom;
        int n3 = insets.left;
        int n4 = insets.right;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n5 = jMenuBar.getHeight();
        int n6 = this.getToolBarHeight();
        int n7 = this.getRulerWidth();
        float f3 = f + (float)n3 + (float)n4 + (float)n7;
        float f4 = f2 + (float)n + (float)n2 + (float)n5 + (float)n6 + (float)n7;
        this.setSize((int)f3, (int)f4);
        return true;
    }

    protected boolean setComponentBounds() {
        Rectangle2D rectangle2D = this.getPaneBounds();
        int n = (int)rectangle2D.getWidth();
        int n2 = (int)rectangle2D.getHeight();
        int n3 = this.getRulerWidth();
        this.mLayeredPane.setSize(n, n2);
        this.mRulerPanel.setBounds(0, 0, n, n2);
        this.mForegroundPanel.setBounds(n3, n3, n - n3, n2 - n3);
        this.mForegroundPanel.setPreferredSize(new Dimension(n - n3, n2 - n3));
        this.mForegroundPanel.validate();
        this.mBackgroundPanel.setBounds(n3, n3, n - n3, n2 - n3);
        this.validate();
        return true;
    }

    private boolean onResized() {
        if (this.getClientRect() == null) {
            return false;
        }
        this.setComponentBounds();
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x / this.mTemporaryViewportSize.x;
        float f2 = sGTuple2f.y / this.mTemporaryViewportSize.y;
        this.updateClientRect();
        SGTuple2f sGTuple2f2 = this.getViewportSize();
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.recordFigureRect();
            sGFigure.setSize(sGTuple2f2);
            sGFigure.setViewBounds();
        }
        if (this.mLockFigureFlag) {
            Rectangle2D rectangle2D = this.getPaperRect();
            float f3 = f * (float)rectangle2D.getWidth() / this.mMagnification;
            float f4 = f2 * (float)rectangle2D.getHeight() / this.mMagnification;
            this.setPaperSizeRoundingOff(f3, f4);
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                sGFigure.recordFigureRect();
                sGFigure.resize(f, f2);
                sGFigure.setChanged(true);
            }
            this.updateClientRect();
            if (!this.mTemporaryViewportSize.equals(sGTuple2f)) {
                this.setChanged(true);
                this.notifyToRoot();
            }
        }
        this.mTemporaryViewportSize.setValues(sGTuple2f);
        this.zoomWithBoundingBox();
        return true;
    }

    private boolean setZoomValue(Number number) {
        this.mToolBar.setZoomValue(number);
        this.zoom(number.floatValue() / 100.0f);
        this.updateZoomItems();
        return true;
    }

    private boolean setDefaultZoom() {
        return this.setZoomValue(new Integer(100));
    }

    public boolean zoom(float f) {
        this.mMagnification = f;
        SGFigure[] sGFigureArray = this.getFigureArrayFromMap();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (sGFigureArray[i].zoom(this.mMagnification)) continue;
            throw new Error();
        }
        this.mRulerPanel.setMagnification(f);
        this.mBackgroundPanel.setMagnification(f);
        this.mForegroundPanel.setMagnification(f);
        this.updateClientRect();
        this.getContentPane().repaint();
        return true;
    }

    public boolean setFigureBoundingBox(int n) {
        Object object;
        if (n != 0 && n != 1 && n != 2) {
            return false;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        ArrayList arrayList2 = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = (SGFigure)arrayList2.get(i);
            arrayList.add(((SGFigure)object).getBoundingBox());
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        if (rectangle2D == null) {
            return false;
        }
        object = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getPaperRect();
        float f = (float)rectangle2D2.getWidth();
        float f2 = (float)rectangle2D2.getHeight();
        float f3 = this.mMagnification;
        if (n == 0 | n == 1) {
            f = BOUNDING_BOX_MARGIN + (float)(-((RectangularShape)object).getX() + rectangle2D.getX() + rectangle2D.getWidth()) / f3;
        }
        if (n == 0 | n == 2) {
            f2 = BOUNDING_BOX_MARGIN + (float)(-((RectangularShape)object).getY() + rectangle2D.getY() + rectangle2D.getHeight()) / f3;
        }
        this.setPaperSizeRoundingOut(f, f2);
        this.updateClientRect();
        return true;
    }

    public Rectangle2D getBoundingBoxOfFigures(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 0) {
            return new Rectangle2D.Float();
        }
        ArrayList<Rectangle2D> arrayList2 = new ArrayList<Rectangle2D>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure == null) continue;
            Rectangle2D rectangle2D = sGFigure.getBoundingBox();
            if (rectangle2D == null) {
                return null;
            }
            arrayList2.add(rectangle2D);
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList2);
        return rectangle2D;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object instanceof JScrollBar) {
            JScrollBar jScrollBar = (JScrollBar)object;
            if (jScrollBar.equals(this.mHScrollBar)) {
                this.setClientRectByValueOfScrollBar(true);
            } else if (jScrollBar.equals(this.mVScrollBar)) {
                this.setClientRectByValueOfScrollBar(false);
            }
            this.updateGraphRectOfAllFigures();
            this.getContentPane().repaint();
        }
    }

    private boolean setClientRectByValueOfScrollBar(boolean bl) {
        JScrollBar jScrollBar = null;
        jScrollBar = bl ? this.mHScrollBar : this.mVScrollBar;
        float f = this.getScrollValue(jScrollBar);
        Rectangle2D rectangle2D = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getViewportBounds();
        float f2 = (float)rectangle2D.getX();
        float f3 = (float)rectangle2D.getY();
        float f4 = (float)rectangle2D.getWidth();
        float f5 = (float)rectangle2D.getHeight();
        float f6 = (float)rectangle2D2.getWidth();
        float f7 = (float)rectangle2D2.getHeight();
        if (bl) {
            float f8 = f4 - f6;
            float f9 = -f * f8;
            this.setClientRect(f9, f3, f4, f5);
        } else {
            float f10 = f5 - f7;
            float f11 = -f * f10;
            this.setClientRect(f2, f11, f4, f5);
        }
        return true;
    }

    public Component getComponent(int n, int n2) {
        Container container = this;
        SGFigure[] sGFigureArray = this.getFigureArrayFromLayer();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            Point point;
            Rectangle2D rectangle2D;
            if (!sGFigureArray[i].isVisible() || !(rectangle2D = sGFigureArray[i].getGraphRect()).contains(point = this.getLocationInPane(n, n2))) continue;
            container = sGFigureArray[i];
            break;
        }
        return container;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        Object object2 = propertyChangeEvent.getOldValue();
        Object object3 = propertyChangeEvent.getNewValue();
        this.onResized();
        if (object.equals(this.mToolBar)) {
            this.updateToolBarVisibleMenuItems();
            this.firePropertyChange("Tool Bar", null, null);
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        this.createPropertyMenuBarItem();
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.onResized();
    }

    private int getTopShift() {
        return this.getTopWidth() + this.getRulerWidth();
    }

    private int getLeftShift() {
        return this.getLeftWidth() + this.getRulerWidth();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        SGUtility.clearGlobalFocusOwner();
        int n = this.getLeftShift();
        int n2 = this.getTopShift();
        mouseEvent.translatePoint(-n, -n2);
        if (this.clickFigures(mouseEvent)) {
            this.updateDataItem();
            this.updateFocusedObjectItem();
            return;
        }
        mouseEvent.translatePoint(n, n2);
        this.onMouseClicked(mouseEvent);
        this.updateDataItem();
        this.updateFocusedObjectItem();
    }

    protected boolean onMouseClicked(MouseEvent mouseEvent) {
        this.clearAllFocusedObjectsInFigures();
        this.setDefaultCursor();
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
            this.showPropertyDialog();
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
            this.mPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
        return true;
    }

    private boolean showPropertyDialog() {
        SGWindowDialog sGWindowDialog = this.mDialog;
        sGWindowDialog.addPropertyDialogObserver(this);
        sGWindowDialog.setLocation(this.getLocation());
        this.setDialogProperty();
        sGWindowDialog.setColorButtonBorder(true);
        this.prepare();
        sGWindowDialog.setVisible(true);
        sGWindowDialog.removePropertyDialogObserver(this);
        return true;
    }

    protected boolean clickFigures(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleFigureListFromLayer();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (!sGFigure.onMouseClicked(mouseEvent)) continue;
            return true;
        }
        return false;
    }

    protected boolean onMouseReleasedToFigure(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleFigureListFromLayer();
        if (arrayList.size() == 0) {
            return true;
        }
        boolean bl = this.mToolBar.isInsertToggleButtonSelected();
        if (bl) {
            Object var4_4 = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                sGFigure.onMouseReleased(mouseEvent);
                if (!sGFigure.onToggleSelected(mouseEvent)) continue;
                this.setDefaultCursor();
                this.setInsertToggleItemsUnselected();
                return true;
            }
            SGUtility.showErrorMessageDialog(this, ERRMSG_CLICK_GRAPH_RECTANGLE, DIALOG_TITLE_ADDITION_ERROR);
        } else {
            SGFigure sGFigure;
            int n;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure2 = (SGFigure)arrayList.get(i);
                sGFigure2.onMouseReleased(mouseEvent);
            }
            ArrayList arrayList2 = this.getFocusedObjectsList();
            for (n = 0; n < arrayList2.size(); ++n) {
                sGFigure = (SGFigure)arrayList2.get(n);
                if (!sGFigure.isFigureMoved()) continue;
                sGFigure.setChanged(true);
            }
            arrayList2 = this.getVisibleFigureListFromMap();
            for (n = 0; n < arrayList2.size(); ++n) {
                sGFigure = (SGFigure)arrayList2.get(n);
                SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
                for (int i = 0; i < sGIFigureElementArray.length; ++i) {
                    sGIFigureElementArray[i].setChangedFocusedObjects();
                }
            }
            this.updateClientRect();
            this.notifyToRoot();
        }
        return true;
    }

    protected boolean pressFigures(MouseEvent mouseEvent) {
        SGFigure[] sGFigureArray = this.getFigureArrayFromLayer();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (!sGFigureArray[i].isVisible() || !sGFigureArray[i].onMousePressed(mouseEvent)) continue;
            return true;
        }
        return false;
    }

    protected void onMouseDraggedOnFigures(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleFigureListFromLayer();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.onMouseDragged(mouseEvent)) continue;
            return;
        }
    }

    public boolean translateFocusedObjects(int n, int n2) {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.isSelected()) {
                sGFigure.translate(n, n2);
                continue;
            }
            sGFigure.translateSelectedObjects(n, n2);
        }
        return true;
    }

    protected boolean moveFocusedObjects(int n, int n2) {
        int n3 = n - this.mTempMouseLocation.x;
        int n4 = n2 - this.mTempMouseLocation.y;
        this.translateFocusedObjects(n3, n4);
        this.mTempMouseLocation.setLocation(this.mTempMouseLocation.x + n3, this.mTempMouseLocation.y + n4);
        return true;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.getViewportBoundsInComponent().contains(mouseEvent.getPoint())) {
            return;
        }
        this.mViewportPressedFlag = true;
        int n = this.getLeftWidth();
        int n2 = this.getTopWidth();
        mouseEvent.translatePoint(-n, -n2);
        if (this.mRulerPanel.pressed(mouseEvent)) {
            return;
        }
        mouseEvent.translatePoint(n, n2);
        n = this.getLeftShift();
        n2 = this.getTopShift();
        mouseEvent.translatePoint(-n, -n2);
        this.mTempMouseLocation.setLocation(mouseEvent.getPoint());
        if (this.pressFigures(mouseEvent)) {
            return;
        }
        mouseEvent.translatePoint(n, n2);
        this.onMousePressed(mouseEvent);
    }

    protected boolean onMousePressed(MouseEvent mouseEvent) {
        this.clearAllFocusedObjectsInFigures();
        return true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.mViewportPressedFlag) {
            return;
        }
        if (this.mRulerPanel.isPressed()) {
            int n = this.getLeftWidth();
            int n2 = this.getTopWidth();
            mouseEvent.translatePoint(-n, -n2);
            this.mRulerPanel.released(mouseEvent);
            mouseEvent.translatePoint(n, n2);
        } else {
            int n = this.getLeftShift();
            int n3 = this.getTopShift();
            mouseEvent.translatePoint(-n, -n3);
            this.onMouseReleasedToFigure(mouseEvent);
            mouseEvent.translatePoint(n, n3);
        }
        this.repaintAll();
        this.mViewportPressedFlag = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.mViewportPressedFlag) {
            return;
        }
        if (this.mRulerPanel.isPressed()) {
            int n = this.getLeftWidth();
            int n2 = this.getTopWidth();
            mouseEvent.translatePoint(-n, -n2);
            this.mRulerPanel.dragged(mouseEvent);
            mouseEvent.translatePoint(n, n2);
        } else {
            int n = this.getLeftShift();
            int n3 = this.getTopShift();
            mouseEvent.translatePoint(-n, -n3);
            this.onMouseDraggedOnFigures(mouseEvent);
            mouseEvent.translatePoint(n, n3);
        }
        this.onMouseMovedOrDragged(mouseEvent);
        this.repaintAll();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.getLeftShift();
        int n2 = this.getTopShift();
        mouseEvent.translatePoint(-n, -n2);
        ArrayList arrayList = this.getVisibleFigureListFromLayer();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (!sGFigure.onMouseMoved(mouseEvent)) continue;
            return;
        }
        mouseEvent.translatePoint(n, n2);
        this.onMouseMovedOrDragged(mouseEvent);
    }

    private void onMouseMovedOrDragged(MouseEvent mouseEvent) {
        Point point = this.getLocationInPane(mouseEvent.getX(), mouseEvent.getY());
        int n = point.x;
        int n2 = point.y;
        if (n < 0 || n2 < 0) {
            return;
        }
        this.setPositionLabel(n, n2);
    }

    private Point getLocationInPane(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Insets insets = this.getInsets();
        int n5 = insets.top;
        int n6 = insets.bottom;
        int n7 = insets.left;
        int n8 = insets.right;
        n3 -= n7;
        n4 -= n5;
        JMenuBar jMenuBar = this.getJMenuBar();
        double d = jMenuBar.getHeight();
        n4 = (int)((double)n4 - d);
        n4 -= this.getToolBarHeight();
        double d2 = this.getRulerWidth();
        n3 = (int)((double)n3 - d2);
        n4 = (int)((double)n4 - d2);
        return new Point(n3, n4);
    }

    protected boolean notifyPosition(Component component, int n, int n2) {
        Insets insets = this.getInsets();
        int n3 = insets.top;
        int n4 = insets.bottom;
        int n5 = insets.left;
        int n6 = insets.right;
        int n7 = n + component.getX();
        int n8 = n2 + component.getY();
        n8 += n3;
        JMenuBar jMenuBar = this.getJMenuBar();
        n8 -= jMenuBar.getHeight();
        int n9 = this.getRulerWidth();
        if ((n7 -= n9) < 0 || (n8 -= n9) < 0) {
            return true;
        }
        this.setPositionLabel(n7, n8);
        return true;
    }

    private boolean setPositionLabel(int n, int n2) {
        Rectangle2D rectangle2D = this.getClientRect();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        float f3 = 0.035277776f / this.mMagnification;
        float f4 = (-f + (float)n) * f3;
        float f5 = (-f2 + (float)n2) * f3;
        String string = "(" + decimalFormat.format(f4) + ", " + decimalFormat.format(f5) + ")";
        String string2 = WINDOW_TITLE_PREFIX + this.getID() + "  " + string;
        this.setTitle(string2);
        return true;
    }

    public void addActionListener(ActionListener actionListener) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ActionListener actionListener2 = (ActionListener)arrayList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            return;
        }
        arrayList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ActionListener actionListener2 = (ActionListener)arrayList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            this.mActionListenerList.remove(actionListener);
        }
    }

    public void notifyToListener(String string) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ActionListener actionListener = (ActionListener)arrayList.get(i);
            actionListener.actionPerformed(this.getActionEvent(string));
        }
    }

    private ActionEvent getActionEvent(String string) {
        return new ActionEvent(this, 0, string);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        JScrollBar jScrollBar = this.mVScrollBar;
        int n = mouseWheelEvent.getScrollAmount() * mouseWheelEvent.getWheelRotation();
        int n2 = jScrollBar.getValue() + n;
        jScrollBar.setValue(n2);
    }

    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    private void setInsertToggleItemsUnselected() {
        this.mToolBar.setInsertToggleItemsUnSelected();
        this.mMenuBar.setInsertToggleItemsUnSelected();
    }

    protected boolean isInsertToggleButtonSelected() {
        return this.mToolBar.isInsertToggleButtonSelected();
    }

    protected boolean isInsertLabelButtonSelected() {
        return this.mToolBar.isButtonSelected("Label");
    }

    protected boolean isInsertTimingLineButtonSelected() {
        return this.mToolBar.isButtonSelected("Timing Line");
    }

    protected boolean isInsertBreakButtonSelected() {
        return this.mToolBar.isButtonSelected("Axis Break");
    }

    protected boolean isInsertSignificantDifferenceSymbolButtonSelected() {
        return this.mToolBar.isButtonSelected("Significant Difference");
    }

    public void pasteToFigures(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4) {
        ArrayList arrayList5 = this.getFocusedObjectsList();
        if (arrayList5.size() == 0) {
            return;
        }
        for (int i = 0; i < arrayList5.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList5.get(i);
            sGFigure.paste(arrayList);
            for (int j = 0; j < arrayList3.size(); ++j) {
                SGData sGData = (SGData)arrayList2.get(j);
                String string = (String)arrayList3.get(j);
                Map map = (Map)arrayList4.get(j);
                SGData sGData2 = (SGData)sGData.copy();
                sGFigure.addData(sGData2, string, map);
            }
        }
        this.repaintAll();
        this.notifyToRoot();
    }

    public boolean closeWindow() {
        WindowEvent windowEvent = new WindowEvent(this, 201);
        WindowListener[] windowListenerArray = this.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            windowListenerArray[i].windowClosing(windowEvent);
        }
        this.dispose();
        return true;
    }

    private void updateDataItem() {
        this.updateFocusedObjectItem();
    }

    private void updateFocusedObjectItem() {
        JComponent jComponent;
        boolean bl = false;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            jComponent = (SGFigure)arrayList.get(i);
            if (((SGFigure)jComponent).isSelected()) {
                bl = true;
                break;
            }
            SGIFigureElement[] sGIFigureElementArray = ((SGFigure)jComponent).getIFigureElementArray();
            for (int j = 0; j < sGIFigureElementArray.length; ++j) {
                if (sGIFigureElementArray[j].getFocusedObjectsList().size() == 0) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemEnabled("Edit", "Cut", bl);
        sGMenuBar.setMenuItemEnabled("Edit", "Copy", bl);
        sGMenuBar.setMenuItemEnabled("Edit", "Delete", bl);
        sGMenuBar.setMenuItemEnabled("Edit", "Duplicate", bl);
        sGMenuBar.setMenuItemEnabled("Arrange", "Move to Front", bl);
        sGMenuBar.setMenuItemEnabled("Arrange", "Move to Back", bl);
        jComponent = this.mToolBar;
        ((SGToolBar)jComponent).setButtonEnabled("Cut", bl);
        ((SGToolBar)jComponent).setButtonEnabled("Copy", bl);
    }

    public void setPasteMenuEnabled(boolean bl) {
        this.mMenuBar.setMenuItemEnabled("Edit", "Paste", bl);
        this.mToolBar.setButtonEnabled("Paste", bl);
        Component[] componentArray = this.mPopupMenu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem;
            if (!(componentArray[i] instanceof JMenuItem) || !(jMenuItem = (JMenuItem)componentArray[i]).getActionCommand().equals("Paste")) continue;
            jMenuItem.setEnabled(bl);
        }
    }

    private void updateGridItems() {
        boolean bl = this.isGridLineVisible();
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            float f = this.getGridLineInterval() * 0.035277776f;
            int n = (int)Math.ceil(f / 0.5f);
            int n2 = (int)Math.floor(f / 0.5f);
            int n3 = (int)Math.rint(1.0);
            int n4 = (int)Math.rint(20.0);
            if (n3 < n2) {
                bl3 = true;
            }
            if (n < n4) {
                bl2 = true;
            }
        }
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemSelected("Layout", "Visible", bl);
        sGMenuBar.setMenuItemEnabled("Layout", "Plus", bl2);
        sGMenuBar.setMenuItemEnabled("Layout", "Minus", bl3);
    }

    public void setPaperPortrait(boolean bl) {
        this.mPaperPortraitFlag = bl;
    }

    public boolean getPaperPortrait() {
        return this.mPaperPortraitFlag;
    }

    private void updatePaperItems() {
        this.mMenuBar.setMenuItemEnabled("Layout", "Portrait", this.mPaperPortraitFlag);
    }

    private void updateZoomItems() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        int[] nArray = SGIRootObjectConstants.MAGNIFICATION_ARRAY;
        int n = nArray[0];
        int n2 = nArray[nArray.length - 1];
        int n3 = (int)this.getMagnificationPercent();
        if (this.isAutoZoom()) {
            bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = false;
        } else {
            bl4 = n3 != n;
            bl3 = n3 != n2;
            bl2 = n3 != 100;
            bl = true;
        }
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemEnabled("Layout", "Zoom In", bl4);
        sGMenuBar.setMenuItemEnabled("Layout", "Zoom Out", bl3);
        sGMenuBar.setMenuItemEnabled("Layout", "Default Zoom", bl2);
        sGMenuBar.setMenuItemEnabled("Layout", "Zoom Way Out", bl);
    }

    private void updateToolBarVisibleItems() {
        String[] stringArray = SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY;
        SGToolBar sGToolBar = this.mToolBar;
        SGMenuBar sGMenuBar = this.mMenuBar;
        for (int i = 0; i < stringArray.length; ++i) {
            sGToolBar.setToolBarVisible(stringArray[i], sGMenuBar.isToolBarMenuSelected(stringArray[i]));
        }
    }

    private void updateToolBarVisibleMenuItems() {
        String[] stringArray = SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY;
        SGToolBar sGToolBar = this.mToolBar;
        SGMenuBar sGMenuBar = this.mMenuBar;
        for (int i = 0; i < stringArray.length; ++i) {
            sGMenuBar.setToolBarMenuItemSelected(stringArray[i], sGToolBar.isToolBarVisible(stringArray[i]));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        Object object2 = actionEvent.getSource();
        if (string.equals("Exit")) {
            this.notifyToListener("exit");
        } else if (string.equals("Create New Window")) {
            this.notifyToListener("open a new window");
        } else if (string.equals("Close Window")) {
            this.closeWindow();
        } else if (string.equals("Draw Graph")) {
            this.notifyToListener("add new data");
        } else if (string.equals("Load Property")) {
            this.notifyToListener("load property");
        } else if (string.equals("Save Property")) {
            this.mPropertyFileCreationModeOfFigures = 0;
            this.notifyToListener("save property");
        } else if (string.equals("Export as Image")) {
            this.notifyToListener("export as image");
        } else if (string.equals("Print")) {
            this.notifyToListener("print");
        } else if (string.equals("Delete")) {
            this.deleteFocusedObjects();
        } else if (string.equals("Cut")) {
            this.cutFocusedObjects();
        } else if (string.equals("Copy")) {
            this.copyFocusedObjects();
        }
        if (string.equals("Paste")) {
            this.pasteCopiedObjects();
        } else if (string.equals("Duplicate")) {
            this.duplicateFocusedObjects();
        } else if (string.equals("Move to Front")) {
            this.moveFocusedObjectsToFront();
        } else if (string.equals("Move to Back")) {
            this.moveFocusedObjectsToBack();
        } else if (string.equals("Undo")) {
            this.onUndo();
        } else if (string.equals("Redo")) {
            this.onRedo();
        } else if (string.equals("A4") || string.equals("B5") || string.equals("US Letter")) {
            MediaSize mediaSize = null;
            if (string.equals("A4")) {
                mediaSize = MediaSize.ISO.A4;
            } else if (string.equals("B5")) {
                mediaSize = MediaSize.ISO.B5;
            } else if (string.equals("US Letter")) {
                mediaSize = MediaSize.NA.LETTER;
            }
            this.onPaperSizeChanged(mediaSize);
        } else if (string.equals("Portrait") || string.equals("Landscape")) {
            this.mPaperPortraitFlag = string.equals("Portrait");
            this.updatePaperItems();
        } else if (string.equals("Bounding Box")) {
            this.setBoundingBox();
        } else if (string.equals("User Customize")) {
            this.showPropertyDialog();
        } else if (string.equals("Auto Arrangement")) {
            this.onFiguresAligned();
        } else if (string.equals("Visible")) {
            this.setGridLineVisible(!this.isGridLineVisible());
            this.updateGridItems();
            this.getContentPane().repaint();
            this.setChanged(true);
            this.notifyToRoot();
        } else if (string.equals("Plus")) {
            int n;
            float f = this.getGridLineInterval() * 0.035277776f;
            float f2 = SGUtilityNumber.stepValue(true, f, 0.5f, 10.0f, 0.5f, 0.001f);
            int n2 = (int)Math.rint(f2 / 0.5f);
            if (n2 != (n = (int)Math.rint(20.0)) + 1) {
                if (f2 > 10.0f) {
                    f2 = 10.0f;
                }
                this.setGridLineInterval(f2 / 0.035277776f);
                this.updateGridItems();
                this.getContentPane().repaint();
                this.setChanged(true);
                this.notifyToRoot();
            }
        } else if (string.equals("Minus")) {
            int n;
            float f = this.getGridLineInterval() * 0.035277776f;
            float f3 = SGUtilityNumber.stepValue(false, f, 0.5f, 10.0f, 0.5f, 0.001f);
            int n3 = (int)Math.rint(f3 / 0.5f);
            if (n3 != (n = (int)Math.rint(1.0)) - 1) {
                if (f3 < 0.5f) {
                    f3 = 0.5f;
                }
                this.setGridLineInterval(f3 / 0.035277776f);
                this.updateGridItems();
                this.getContentPane().repaint();
                this.setChanged(true);
                this.notifyToRoot();
            }
        } else if (string.equals("Snap to Grid")) {
            SGFigure.setSnappingToGrid(!SGFigure.isSnappingToGrid());
        } else if (string.equals("Zoom In")) {
            int n = (int)this.getMagnificationPercent();
            object = SGIRootObjectConstants.MAGNIFICATION_ARRAY;
            for (int i = ((Object)object).length - 1; i >= 0; --i) {
                if (object[i] <= n) continue;
                this.setZoomValue(new Integer((int)object[i]));
                break;
            }
        } else if (string.equals("Zoom Out")) {
            int n = (int)this.getMagnificationPercent();
            object = SGIRootObjectConstants.MAGNIFICATION_ARRAY;
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (object[i] >= n) continue;
                this.setZoomValue(new Integer((int)object[i]));
                break;
            }
        } else if (string.equals("Default Zoom")) {
            this.setDefaultZoom();
        } else if (string.equals("Zoom Way Out")) {
            this.zoomWayOut();
        } else if (string.equals("Auto Zoom")) {
            this.setAutoZoom(!this.isAutoZoom());
        } else if (string.equals("Lock")) {
            this.mLockFigureFlag = !this.mLockFigureFlag;
            this.updateLockItems();
        } else if (string.equals("Window")) {
            this.createPropertyMenuBarItem();
        } else if (string.equals("Upgrade")) {
            this.notifyToListener("upgrade the latest version");
        } else if (string.equals("Change Log")) {
            this.notifyToListener("show the change log");
        } else if (string.equals("Proxy")) {
            this.notifyToListener("set proxy");
        } else if (string.equals("About")) {
            this.notifyToListener("show about dialog");
        }
        if (Arrays.asList(SGIRootObjectConstants.INSERT_MENUBARCMD_ARRAY).contains(string)) {
            if (object2.equals(this.mMenuBar)) {
                this.mToolBar.setInsertToggleItemsUnSelected();
                this.mToolBar.setInsertTogglebuttonSelected(string, this.mMenuBar.isInsertToggleItemSelected(string));
            } else if (object2.equals(this.mToolBar)) {
                this.mMenuBar.setInsertToggleItemsUnSelected();
                this.mMenuBar.setInsertToggleItemSelected(string, this.mToolBar.isInsertTogglebuttonSelected(string));
            }
            boolean bl = this.mToolBar.isInsertTogglebuttonSelected(string);
            if (bl) {
                object = new Cursor(1);
                this.setCursor((Cursor)object);
            } else {
                this.setDefaultCursor();
            }
        }
        if (Arrays.asList(SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY).contains(string)) {
            if (object2.equals(this.mMenuBar)) {
                this.updateToolBarVisibleItems();
            } else if (object2.equals(this.mToolBar)) {
                this.updateToolBarVisibleMenuItems();
            }
            this.firePropertyChange("Tool Bar", null, null);
        }
        if (string.equals("Property")) {
            this.showPropertyDialog();
        }
    }

    void moveFocusedObjectsToFront() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.moveFocusedObjects(true);
        }
        this.notifyToRoot();
        this.updateDataItem();
    }

    void moveFocusedObjectsToBack() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.moveFocusedObjects(false);
        }
        this.notifyToRoot();
        this.updateDataItem();
    }

    void copyFocusedObjects() {
        this.copyAllObjectsInVisibleFigures();
        this.notifyToListener("copy");
        this.updateFocusedObjectItem();
    }

    void cutFocusedObjects() {
        this.cutAllObjectsInVisibleFigures();
        this.notifyToListener("cut");
        this.notifyToRoot();
        this.updateFocusedObjectItem();
    }

    void pasteCopiedObjects() {
        this.notifyToListener("paste");
        this.notifyToRoot();
    }

    void duplicateFocusedObjects() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.duplicateFocusedObjects()) continue;
            return;
        }
        this.repaintAll();
        this.notifyToListener("duplicate");
        ArrayList arrayList2 = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList2.get(i);
            this.setFocusedFigure(sGFigure, false);
        }
        ArrayList arrayList3 = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList3.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList3.get(i);
            if (arrayList.contains(sGFigure)) continue;
            this.setFocusedFigure(sGFigure, true);
        }
        this.notifyToRoot();
    }

    void deleteFocusedObjects() {
        this.hideSelectedObjects();
        this.notifyToRoot();
        this.updateDataItem();
    }

    private void cutAllObjectsInVisibleFigures() {
        this.cutOrCopyAllObjectsInVisibleFigures(false);
    }

    private void copyAllObjectsInVisibleFigures() {
        this.cutOrCopyAllObjectsInVisibleFigures(true);
    }

    private void cutOrCopyAllObjectsInVisibleFigures(boolean bl) {
        int n;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        if (bl) {
            for (n = 0; n < arrayList.size(); ++n) {
                SGFigure sGFigure = (SGFigure)arrayList.get(n);
                arrayList2.addAll(sGFigure.createCopiedObjects());
                sGFigure.createCopiedDataObjects(arrayList3, arrayList4, arrayList5);
            }
        } else {
            for (n = 0; n < arrayList.size(); ++n) {
                SGFigure sGFigure = (SGFigure)arrayList.get(n);
                arrayList2.addAll(sGFigure.cutFocusedObjects());
                sGFigure.cutFocusedDataObjects(arrayList3, arrayList4, arrayList5);
            }
        }
        ArrayList arrayList6 = new ArrayList();
        SGUtility.copyObjects(arrayList3, arrayList6);
        this.clearCopiedObjectsList();
        this.mCopiedObjectsList.addAll(arrayList2);
        this.mCopiedDataObjectsList.addAll(arrayList6);
        this.mCopiedDataNameList.addAll(arrayList4);
        this.mCopiedDataPropertiesMapList.addAll(arrayList5);
        this.mCopiedFiguresList.addAll(this.getFocusedObjectsList());
    }

    public ArrayList getCopiedObjectsList() {
        return new ArrayList(this.mCopiedObjectsList);
    }

    public ArrayList getCopiedObjectsDataList() {
        return new ArrayList(this.mCopiedDataObjectsList);
    }

    public ArrayList getCopiedDataNameList() {
        return new ArrayList(this.mCopiedDataNameList);
    }

    public ArrayList getCopiedDataPropertiesMapList() {
        return new ArrayList(this.mCopiedDataPropertiesMapList);
    }

    private void clearCopiedObjectsList() {
        this.mCopiedObjectsList.clear();
        this.mCopiedDataObjectsList.clear();
        this.mCopiedDataNameList.clear();
        this.mCopiedDataPropertiesMapList.clear();
        this.mCopiedFiguresList.clear();
    }

    void notifyPasteToFocusedFigures() {
        this.mPasteTargetList.clear();
        this.mPasteTargetList.addAll(this.getFocusedObjectsList());
        this.notifyToListener("paste");
    }

    public void setAutoZoom(boolean bl) {
        this.mAutoZoomFlag = bl;
        this.mMenuBar.setMenuItemSelected("Layout", "Auto Zoom", bl);
        this.zoomWithBoundingBox();
    }

    public boolean isAutoZoom() {
        return this.mAutoZoomFlag;
    }

    private boolean zoomWithBoundingBox() {
        if (this.isAutoZoom()) {
            this.zoomWayOut();
        }
        this.updateZoomItems();
        return true;
    }

    private boolean zoomWayOut() {
        float f;
        Rectangle2D rectangle2D = this.getBoundingBox();
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f2 = (float)((double)sGTuple2f.x / (rectangle2D.getWidth() / (double)this.mMagnification));
        float f3 = f2 < (f = (float)((double)sGTuple2f.y / (rectangle2D.getHeight() / (double)this.mMagnification))) ? f2 : f;
        int n = (int)Math.floor(f3 * 100.0f);
        this.setZoomValue(new Integer(n));
        return true;
    }

    private void setLookAndFeel(String string) {
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            System.out.println("Error L&F Setting");
        }
    }

    private void updateLockItems() {
        boolean bl = this.mLockFigureFlag;
        this.mToolBar.setButtonSelected("Lock", bl);
        this.mMenuBar.setMenuItemSelected("Layout", "Lock", bl);
    }

    public String getClassDescription() {
        return this.getInstanceDescription();
    }

    public String getInstanceDescription() {
        return "Window: " + this.mID;
    }

    private void createPropertyMenuBarItem() {
        TreeMenuItemListener treeMenuItemListener = new TreeMenuItemListener();
        this.mMenuBar.createPropertyMenuBarItem(this, treeMenuItemListener);
    }

    private Rectangle2D getPaperRectInClientRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.mPaperOrigin.x, this.mPaperOrigin.y, this.mPaperSize.x, this.mPaperSize.y);
        return float_;
    }

    boolean recordPaperRect() {
        this.mTempPaperRect.setRect(this.getPaperRectInClientRect());
        return true;
    }

    public boolean isPaperBoundsChanged() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.mTempPaperRect.getBounds();
        return !rectangle2.equals(rectangle = this.getPaperRectInClientRect().getBounds());
    }

    private boolean onFiguresAligned() {
        SGFigure sGFigure;
        int n;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.recordFigureRect();
        }
        this.recordPaperRect();
        if (!this.alignFiguresByGraphAreaNew()) {
            return false;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            if (!sGFigure.isFigureMoved()) continue;
            sGFigure.setChanged(true);
        }
        if (this.isPaperBoundsChanged()) {
            this.setChanged(true);
        }
        this.notifyToRoot();
        return true;
    }

    private boolean onPaperSizeChanged(MediaSize mediaSize) {
        Rectangle rectangle = this.getPaperRect().getBounds();
        this.setPaperSize(mediaSize);
        Rectangle rectangle2 = this.getPaperRect().getBounds();
        if (rectangle.equals(rectangle2)) {
            return true;
        }
        this.updateClientRect();
        this.setChanged(true);
        this.notifyToRoot();
        this.zoomWithBoundingBox();
        return true;
    }

    private boolean setBoundingBox() {
        Rectangle rectangle = this.getPaperRect().getBounds();
        Rectangle2D rectangle2D = this.getClientRect();
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        if (arrayList.size() != 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                sGFigure.recordFigureRect();
            }
            this.recordPaperRect();
            Rectangle2D rectangle2D2 = this.getBoundingBoxOfFigures(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                float f = BOUNDING_BOX_MARGIN + (float)(rectangle2D.getX() + (double)sGFigure.getGraphRectX() - rectangle2D2.getX());
                float f2 = BOUNDING_BOX_MARGIN + (float)(rectangle2D.getY() + (double)sGFigure.getGraphRectY() - rectangle2D2.getY());
                sGFigure.setGraphRectLocationRoundingOut(f, f2);
                if (!sGFigure.isFigureMoved()) continue;
                sGFigure.setChanged(true);
            }
            this.setFigureBoundingBox(0);
            if (this.isPaperBoundsChanged()) {
                this.setChanged(true);
            }
            this.notifyToRoot();
        } else {
            SGUtility.showMessageDialog(this, "There is no figure.", "Failed to get the Bounding box.", 2);
        }
        return true;
    }

    public boolean setPaperSize(MediaSize mediaSize) {
        if (mediaSize == null) {
            return false;
        }
        BigDecimal bigDecimal = new BigDecimal(mediaSize.getX(1000));
        BigDecimal bigDecimal2 = new BigDecimal(mediaSize.getY(1000));
        bigDecimal = bigDecimal.movePointLeft(1);
        bigDecimal2 = bigDecimal2.movePointLeft(1);
        float f = bigDecimal.floatValue();
        float f2 = bigDecimal2.floatValue();
        if (this.mPaperPortraitFlag) {
            this.setPaperSizeRoundingOffInCMUnit(f, f2);
        } else {
            this.setPaperSizeRoundingOffInCMUnit(f2, f);
        }
        return true;
    }

    private boolean setPaperSizeRoundingOffInCMUnit(float f, float f2) {
        float f3 = (float)SGUtilityNumber.roundOffNumber(f, -2);
        float f4 = (float)SGUtilityNumber.roundOffNumber(f2, -2);
        float f5 = f3 / 0.035277776f;
        float f6 = f4 / 0.035277776f;
        this.mPaperSize.setValues(f5, f6);
        return true;
    }

    private boolean setPaperSizeRoundingOutInCMUnit(float f, float f2) {
        float f3 = (float)SGUtilityNumber.roundOutNumber(f, -2);
        float f4 = (float)SGUtilityNumber.roundOutNumber(f2, -2);
        float f5 = f3 / 0.035277776f;
        float f6 = f4 / 0.035277776f;
        this.mPaperSize.setValues(f5, f6);
        return true;
    }

    private boolean setPaperSizeRoundingOff(float f, float f2) {
        float f3 = f * 0.035277776f;
        float f4 = f2 * 0.035277776f;
        this.setPaperSizeRoundingOffInCMUnit(f3, f4);
        return true;
    }

    private boolean setPaperSizeRoundingOut(float f, float f2) {
        float f3 = f * 0.035277776f;
        float f4 = f2 * 0.035277776f;
        this.setPaperSizeRoundingOutInCMUnit(f3, f4);
        return true;
    }

    public boolean initPropertiesHistory() {
        WindowProperties windowProperties = (WindowProperties)this.getProperties();
        this.addWindowPropertiesHistory(windowProperties);
        return true;
    }

    private boolean addWindowPropertiesHistory(WindowProperties windowProperties) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.mWindowStateCounter; ++i) {
            arrayList.add(this.mWindowPropertyHistoryList.get(i));
        }
        arrayList.add(windowProperties);
        this.mWindowPropertyHistoryList = arrayList;
        return true;
    }

    public boolean commit() {
        this.updateClientRect();
        this.zoomWithBoundingBox();
        this.updateGridItems();
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.mChangedFlag = true;
        }
        this.mTemporaryProperties = null;
        this.getContentPane().repaint();
        this.notifyToRoot();
        return true;
    }

    public boolean updateHistory() {
        ArrayList<Container> arrayList = new ArrayList<Container>();
        if (this.mChangedFlag) {
            this.updateThisObjectHistory();
            arrayList.add(this);
            this.setChanged(false);
        }
        ArrayList arrayList2 = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList2.get(i);
            if (!sGFigure.isChanged()) continue;
            sGFigure.updateHistory();
            arrayList.add(sGFigure);
        }
        if (arrayList.size() != 0) {
            this.updateObjectHistory(arrayList);
        }
        return true;
    }

    public boolean updateThisObjectHistory() {
        ++this.mWindowStateCounter;
        this.addWindowPropertiesHistory((WindowProperties)this.getProperties());
        return true;
    }

    public boolean cancel() {
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.updateClientRect();
        this.getContentPane().repaint();
        return true;
    }

    public boolean preview() {
        this.updateClientRect();
        this.zoomWithBoundingBox();
        this.updateGridItems();
        this.getContentPane().repaint();
        return true;
    }

    protected boolean setDefaultCursor() {
        Cursor cursor = Cursor.getDefaultCursor();
        this.setCursor(cursor);
        return true;
    }

    private boolean setDialogProperty() {
        SGWindowDialog sGWindowDialog = this.mDialog;
        String string = "Window Properties : " + this.getID();
        sGWindowDialog.setTitle(string);
        sGWindowDialog.setDialogProperty();
        return true;
    }

    public SGPropertyDialog getPropertyDialog() {
        return this.mDialog;
    }

    private boolean updateClientRect() {
        this.updateClientRectOld();
        return true;
    }

    private boolean updateClientRectNew() {
        float f;
        float f2;
        System.out.println("-- updateClientRect --");
        Rectangle2D rectangle2D = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getPaperRect();
        Rectangle2D rectangle2D3 = this.getBoundingBox();
        Rectangle2D rectangle2D4 = this.getViewportBounds();
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        float f3 = this.getMagnification();
        float f4 = (float)rectangle2D.getX();
        float f5 = (float)rectangle2D.getY();
        float f6 = (float)rectangle2D.getWidth();
        float f7 = (float)rectangle2D.getHeight();
        float f8 = (float)rectangle2D4.getX();
        float f9 = (float)rectangle2D4.getY();
        float f10 = (float)rectangle2D4.getWidth();
        float f11 = (float)rectangle2D4.getHeight();
        float f12 = this.getPaperX();
        float f13 = this.getPaperY();
        float f14 = f3 * this.getPaperWidth();
        float f15 = f3 * this.getPaperHeight();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(rectangle2D3);
        boolean bl = (int)f8 <= (int)((RectangularShape)float_).getX();
        boolean bl2 = (int)(((RectangularShape)float_).getX() + ((RectangularShape)float_).getWidth()) <= (int)(f8 + f10);
        double d = ((RectangularShape)float_).getX();
        double d2 = ((RectangularShape)float_).getWidth();
        if (bl & bl2) {
            d = f8;
            d2 = f10;
        } else if (bl) {
            d = f8;
            if (d2 < (double)f10) {
                d2 = f10;
            }
        } else if (bl2) {
            d = (double)(f8 + f10) - d2;
            if ((double)f8 < d) {
                d = f8;
            }
            if (d2 < (double)f10) {
                d2 = f10;
            }
        }
        ((Rectangle2D)float_).setRect(d, ((RectangularShape)float_).getY(), d2, ((RectangularShape)float_).getHeight());
        bl = (double)f9 < float_.getMinY();
        bl2 = float_.getMinY() + ((RectangularShape)float_).getHeight() < (double)(f9 + f11);
        d = ((RectangularShape)float_).getY();
        d2 = ((RectangularShape)float_).getHeight();
        if (bl & bl2) {
            d = f9;
            d2 = f11;
        } else if (bl) {
            d = f9;
            if (d2 < (double)f11) {
                d2 = f11;
            }
        } else if (bl2) {
            d = (double)(f9 + f11) - d2;
            if ((double)f9 < d) {
                d = f9;
            }
            if (d2 < (double)f11) {
                d2 = f11;
            }
        }
        ((Rectangle2D)float_).setRect(((RectangularShape)float_).getX(), d, ((RectangularShape)float_).getWidth(), d2);
        this.mTempRect.setRect(float_);
        if (arrayList.size() == 0) {
            f2 = (float)((RectangularShape)float_).getX() + 0.0f;
            f = (float)((RectangularShape)float_).getY() + 0.0f;
        } else {
            SGFigure sGFigure = null;
            SGFigure sGFigure2 = null;
            float f16 = f12;
            float f17 = f13;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure3 = (SGFigure)arrayList.get(i);
                Rectangle2D rectangle2D5 = sGFigure3.getBoundingBox();
                float f18 = (float)rectangle2D5.getX();
                float f19 = (float)rectangle2D5.getY();
                if (f18 < f16) {
                    f16 = f18;
                    sGFigure = sGFigure3;
                }
                if (!(f19 < f17)) continue;
                f17 = f19;
                sGFigure2 = sGFigure3;
            }
            f2 = sGFigure != null ? f12 - f16 : f12;
            f = sGFigure2 != null ? f13 - f17 : f13;
        }
        System.out.println(f12 + "  " + f13);
        System.out.println(f2 + "  " + f);
        this.setClientRect(float_);
        this.setPaperOrigin(f2, f);
        this.updateGraphRectOfAllFigures();
        this.setEnableScrollBars();
        this.setScrollBarValue();
        System.out.println();
        return true;
    }

    private boolean updateClientRectOld() {
        double d;
        boolean bl;
        boolean bl2;
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2;
        this.fitRect(this.mClientRect, this.getBoundingBox(), true);
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), true)) {
            this.fitRect(this.mClientRect, this.getViewportBounds(), true);
        }
        if (!SGUtility.isRectContains(this.getClientRect(), this.getViewportBounds(), true)) {
            rectangle2D2 = this.getClientRect();
            rectangle2D = this.getViewportBounds();
            bl2 = SGUtility.isRectContains(rectangle2D2, rectangle2D.getX(), true);
            bl = SGUtility.isRectContains(rectangle2D2, rectangle2D.getX() + rectangle2D.getWidth(), true);
            d = 0.0;
            if (!bl2 && bl) {
                d = rectangle2D.getX() - rectangle2D2.getX();
            } else if (bl2 && !bl) {
                d = rectangle2D.getX() + rectangle2D.getWidth() - (rectangle2D2.getX() + rectangle2D2.getWidth());
            } else if (!bl2 && !bl) {
                d = rectangle2D2.getX() < rectangle2D.getX() ? rectangle2D.getX() + rectangle2D.getWidth() - (rectangle2D2.getX() + rectangle2D2.getWidth()) : rectangle2D.getX() - rectangle2D2.getX();
            }
            this.setClientRect((float)(rectangle2D2.getX() + d), (float)rectangle2D2.getY(), (float)rectangle2D2.getWidth(), (float)rectangle2D2.getHeight());
        }
        this.fitRect(this.mClientRect, this.getBoundingBox(), false);
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), false)) {
            this.fitRect(this.mClientRect, this.getViewportBounds(), false);
        }
        if (!SGUtility.isRectContains(this.getClientRect(), this.getViewportBounds(), false)) {
            rectangle2D2 = this.getClientRect();
            rectangle2D = this.getViewportBounds();
            bl2 = SGUtility.isRectContains(rectangle2D2, rectangle2D.getY(), false);
            bl = SGUtility.isRectContains(rectangle2D2, rectangle2D.getY() + rectangle2D.getHeight(), false);
            d = 0.0;
            if (!bl2 && bl) {
                d = rectangle2D.getY() - rectangle2D2.getY();
            } else if (bl2 && !bl) {
                d = rectangle2D.getY() + rectangle2D.getHeight() - (rectangle2D2.getY() + rectangle2D2.getHeight());
            } else if (!bl2 && !bl) {
                d = rectangle2D2.getY() < rectangle2D.getY() ? rectangle2D.getY() + rectangle2D.getHeight() - (rectangle2D2.getY() + rectangle2D2.getHeight()) : rectangle2D.getY() - rectangle2D2.getY();
            }
            this.setClientRect((float)rectangle2D2.getX(), (float)(rectangle2D2.getY() + d), (float)rectangle2D2.getWidth(), (float)rectangle2D2.getHeight());
        }
        this.setScrollBarValue();
        this.setEnableScrollBars();
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), true)) {
            this.fitRect(this.mClientRect, this.getViewportBounds(), true);
        }
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), false)) {
            this.fitRect(this.mClientRect, this.getViewportBounds(), false);
        }
        this.setScrollBarValue();
        return true;
    }

    private void fitRect(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        if (bl) {
            rectangle2D.setRect(rectangle2D2.getX(), rectangle2D.getY(), rectangle2D2.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D2.getY(), rectangle2D.getWidth(), rectangle2D2.getHeight());
        }
    }

    protected boolean setEnableScrollBars() {
        Rectangle rectangle = this.getViewportBounds().getBounds();
        Rectangle rectangle2 = this.getClientRect().getBounds();
        boolean bl = SGUtilityNumber.contains(rectangle.x, rectangle.x + rectangle.width, rectangle2.x, rectangle2.x + rectangle2.width);
        boolean bl2 = SGUtilityNumber.contains(rectangle.y, rectangle.y + rectangle.height, rectangle2.y, rectangle2.y + rectangle2.height);
        this.mHScrollBar.setVisible(!bl);
        this.mVScrollBar.setVisible(!bl2);
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof WindowProperties)) {
            return false;
        }
        WindowProperties windowProperties = (WindowProperties)sGProperties;
        Float f = windowProperties.getPaperWidth();
        Float f2 = windowProperties.getPaperHeight();
        if (f == null || f2 == null) {
            return false;
        }
        this.mPaperSize.setValues(f.floatValue(), f2.floatValue());
        Color color = windowProperties.getBackgroundColor();
        if (color == null) {
            return false;
        }
        this.setPaperColor(color);
        Color color2 = windowProperties.getGridColor();
        if (color2 == null) {
            return false;
        }
        this.setGridLineColor(color2);
        Boolean bl = windowProperties.getGridVisible();
        if (bl == null) {
            return false;
        }
        this.setGridLineVisible(bl);
        Float f3 = windowProperties.getGridInterval();
        if (f3 == null) {
            return false;
        }
        this.setGridLineInterval(f3.floatValue());
        Float f4 = windowProperties.getGridLineWidth();
        if (f4 == null) {
            return false;
        }
        this.setGridLineWidth(f4.floatValue());
        this.setFigureVisible(windowProperties.getVisibleFigureList());
        return true;
    }

    public SGProperties getProperties() {
        WindowProperties windowProperties = new WindowProperties();
        windowProperties.setPaperWidth(this.mPaperSize.x);
        windowProperties.setPaperHeight(this.mPaperSize.y);
        windowProperties.setBackGroundColor(this.getPaperColor());
        windowProperties.setGridColor(this.getGridLineColor());
        windowProperties.setGridVisible(this.isGridLineVisible());
        windowProperties.setGridInterval(this.getGridLineInterval());
        windowProperties.setGridLineWidth(this.getGridLineWidth());
        windowProperties.setVisibleFigureList(this.getVisibleFigureIDList());
        return windowProperties;
    }

    protected ArrayList getVisibleFigureIDList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList arrayList2 = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList2.get(i);
            int n = sGFigure.getID();
            arrayList.add(new Integer(n));
        }
        return arrayList;
    }

    protected boolean setFigureVisible(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        SGFigure[] sGFigureArray = this.getFigureArrayFromMap();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            int n = sGFigureArray[i].getID();
            if (arrayList.contains(new Integer(n))) {
                sGFigureArray[i].setVisible(true);
                continue;
            }
            sGFigureArray[i].setVisible(false);
        }
        return true;
    }

    public Rectangle2D getClientRect() {
        if (this.mClientRect == null) {
            return null;
        }
        return (Rectangle2D)this.mClientRect.clone();
    }

    public void dumpClientRect() {
        Rectangle2D rectangle2D = this.getClientRect();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        System.out.println("x=" + d * 0.035277776420116425 + "cm, y=" + d2 * 0.035277776420116425 + "cm");
        System.out.println("w=" + d3 * 0.035277776420116425 + "cm, h=" + d4 * 0.035277776420116425 + "cm");
        System.out.println();
    }

    public void dumpRect() {
        Rectangle2D rectangle2D = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getViewportBounds();
        Rectangle2D rectangle2D3 = this.getBoundingBox();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        Rectangle2D.Float float_2 = new Rectangle2D.Float();
        Rectangle2D.Float float_3 = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect((float)rectangle2D.getX() * 0.035277776f, (float)rectangle2D.getY() * 0.035277776f, (float)rectangle2D.getWidth() * 0.035277776f, (float)rectangle2D.getHeight() * 0.035277776f);
        ((Rectangle2D)float_2).setRect((float)rectangle2D2.getX() * 0.035277776f, (float)rectangle2D2.getY() * 0.035277776f, (float)rectangle2D2.getWidth() * 0.035277776f, (float)rectangle2D2.getHeight() * 0.035277776f);
        ((Rectangle2D)float_3).setRect((float)rectangle2D3.getX() * 0.035277776f, (float)rectangle2D3.getY() * 0.035277776f, (float)rectangle2D3.getWidth() * 0.035277776f, (float)rectangle2D3.getHeight() * 0.035277776f);
        System.out.println("client:" + float_);
        System.out.println("viewport:" + float_2);
        System.out.println("bounding box:" + float_3);
    }

    public boolean setClientRect(float f, float f2, float f3, float f4) {
        this.mClientRect.setRect(f, f2, f3, f4);
        return true;
    }

    public boolean setClientRect(Rectangle2D rectangle2D) {
        this.mClientRect.setRect(rectangle2D);
        return true;
    }

    public Rectangle2D getViewportBounds() {
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        return float_;
    }

    public Rectangle2D getViewportBoundsInLayeredPane() {
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        int n = this.getRulerWidth();
        Rectangle2D.Float float_ = new Rectangle2D.Float(n, n, f, f2);
        return float_;
    }

    public Rectangle2D getViewportBoundsInComponent() {
        int n = this.getTopWidth();
        int n2 = this.getLeftWidth();
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x + 20.0f;
        float f2 = sGTuple2f.y + 20.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(n2, n, f, f2);
        return float_;
    }

    protected SGFigure[][] getOrderedFigureArray() {
        int n;
        int n2;
        int n3;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        int n4 = arrayList.size();
        if (n4 == 0) {
            return new SGFigure[0][0];
        }
        int n5 = 0;
        for (n3 = 1; n3 <= 16; ++n3) {
            n2 = (n3 - 1) * (n3 - 1);
            n = n3 * n3;
            if (n2 >= n4 || n4 > n) continue;
            n5 = n3;
            break;
        }
        n3 = n5;
        n2 = n4 / n3;
        n = n4 % n3 == 0 ? n2 : n2 + 1;
        SGFigure[][] sGFigureArray = new SGFigure[n][n3];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n6 = i * n3 + j;
                if (n6 >= arrayList.size()) {
                    bl = false;
                    break;
                }
                sGFigureArray[i][j] = (SGFigure)arrayList.get(n6);
            }
            if (!bl) break;
        }
        return sGFigureArray;
    }

    private ArrayList[][] getFigureListArray() {
        int n;
        int n2;
        int n3;
        int n4;
        Rectangle2D rectangle2D;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        if (arrayList.size() == 0) {
            return null;
        }
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            rectangle2D = sGFigure.getGraphRect();
            if (rectangle2D.getWidth() < (double)f) {
                f = (float)rectangle2D.getWidth();
            }
            if (!(rectangle2D.getHeight() < (double)f2)) continue;
            f2 = (float)rectangle2D.getHeight();
        }
        float f3 = f;
        float f4 = f2;
        rectangle2D = this.getBoundingBoxOfFigures(arrayList);
        int n5 = (int)((float)rectangle2D.getWidth() / f3) + 1;
        int n6 = (int)((float)rectangle2D.getHeight() / f4) + 1;
        ArrayList[][] arrayListArray = new ArrayList[n5][n6];
        for (n4 = 0; n4 < n5; ++n4) {
            for (int i = 0; i < n6; ++i) {
                arrayListArray[n4][i] = new ArrayList();
            }
        }
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            SGFigure sGFigure = (SGFigure)arrayList.get(n4);
            Rectangle2D rectangle2D2 = sGFigure.getGraphRect();
            n3 = (int)((rectangle2D2.getCenterX() - rectangle2D.getX()) / (double)f3);
            n2 = (int)((rectangle2D2.getCenterY() - rectangle2D.getY()) / (double)f4);
            arrayListArray[n3][n2].add(sGFigure);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < n5; ++i) {
            boolean bl = false;
            for (n3 = 0; n3 < n6; ++n3) {
                if (arrayListArray[i][n3].size() == 0) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList2.add(new Integer(i));
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (n = 0; n < n6; ++n) {
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                if (arrayListArray[n2][n].size() == 0) continue;
                n3 = 1;
                break;
            }
            if (n3 == 0) continue;
            arrayList3.add(new Integer(n));
        }
        n = arrayList2.size();
        n3 = arrayList3.size();
        ArrayList[][] arrayListArray2 = new ArrayList[n][n3];
        for (int i = 0; i < n; ++i) {
            int n7 = (Integer)arrayList2.get(i);
            for (int j = 0; j < n3; ++j) {
                int n8 = (Integer)arrayList3.get(j);
                arrayListArray2[i][j] = arrayListArray[n7][n8];
            }
        }
        return arrayListArray2;
    }

    private boolean alignFiguresLeftAndBottom(ArrayList[][] arrayListArray) {
        int n;
        float f;
        float f2;
        float f3;
        float f4;
        int n2;
        int n3 = arrayListArray.length;
        int n4 = arrayListArray[0].length;
        float[][] fArray = new float[n3][n4];
        float[][] fArray2 = new float[n3][n4];
        float[][] fArray3 = new float[n3][n4];
        float[][] fArray4 = new float[n3][n4];
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                ArrayList arrayList = arrayListArray[i][n2];
                float f5 = 0.0f;
                f4 = 0.0f;
                f3 = 0.0f;
                f2 = 0.0f;
                for (int j = 0; j < arrayList.size(); ++j) {
                    SGFigure sGFigure = (SGFigure)arrayList.get(j);
                    Rectangle2D rectangle2D = sGFigure.getGraphRect();
                    f = (float)rectangle2D.getWidth();
                    float f6 = (float)rectangle2D.getHeight();
                    SGTuple2f sGTuple2f = new SGTuple2f();
                    SGTuple2f sGTuple2f2 = new SGTuple2f();
                    sGFigure.calcMargin(sGTuple2f, sGTuple2f2);
                    float f7 = sGTuple2f.x;
                    float f8 = sGTuple2f.y;
                    float f9 = sGTuple2f2.x;
                    float f10 = sGTuple2f2.y;
                    if (f7 + f6 > f5) {
                        f5 = f7 + f6;
                    }
                    if (f8 > f4) {
                        f4 = f8;
                    }
                    if (f9 > f3) {
                        f3 = f9;
                    }
                    if (!(f10 + f > f2)) continue;
                    f2 = f10 + f;
                }
                fArray[i][n2] = f5;
                fArray2[i][n2] = f4;
                fArray3[i][n2] = f3;
                fArray4[i][n2] = f2;
            }
        }
        float[] fArray5 = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            float f11 = 0.0f;
            for (int i = 0; i < n4; ++i) {
                f4 = fArray3[n2][i] + fArray4[n2][i];
                if (!(f4 > f11)) continue;
                f11 = f4;
            }
            fArray5[n2] = f11;
        }
        float[] fArray6 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            float f12 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                f3 = fArray[j][i] + fArray2[j][i];
                if (!(f3 > f12)) continue;
                f12 = f3;
            }
            fArray6[i] = f12;
        }
        float[] fArray7 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f13 = 0.0f;
            for (int j = 0; j < n4; ++j) {
                f2 = fArray3[i][j];
                if (!(f2 > f13)) continue;
                f13 = f2;
            }
            fArray7[i] = f13;
        }
        float[] fArray8 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f14 = 0.0f;
            for (int j = 0; j < n4; ++j) {
                float f15 = fArray4[i][j];
                if (!(f15 > f14)) continue;
                f14 = f15;
            }
            fArray8[i] = f14;
        }
        float[] fArray9 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            float f16 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                float f17 = fArray2[j][i];
                if (!(f17 > f16)) continue;
                f16 = f17;
            }
            fArray9[i] = f16;
        }
        float f18 = this.getMagnification() * this.getGridLineInterval();
        Rectangle2D rectangle2D = this.getPaperRect();
        float f19 = (float)rectangle2D.getX();
        float f20 = (float)rectangle2D.getY();
        float f21 = f19;
        f = f20;
        float[] fArray10 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f22 = f21 + fArray7[i];
            int n5 = (int)((f22 - f19) / f18) + 1;
            fArray10[i] = f19 + (float)n5 * f18;
            f21 = fArray10[i] + fArray8[i];
        }
        float[] fArray11 = new float[n4];
        for (n = 0; n < n4; ++n) {
            float f23 = f + fArray6[n] - fArray9[n];
            int n6 = (int)((f23 - f20) / f18) + 1;
            fArray11[n] = f20 + (float)n6 * f18;
            f = fArray11[n] + fArray9[n];
        }
        n = 1;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                ArrayList arrayList = arrayListArray[j][i];
                for (int k = 0; k < arrayList.size(); ++k) {
                    SGFigure sGFigure = (SGFigure)arrayList.get(k);
                    if (sGFigure == null) {
                        n = 0;
                        break;
                    }
                    if (sGFigure.setGraphRectLocationByLeftBottom(fArray10[j], fArray11[i])) continue;
                    return false;
                }
                if (n == 0) break;
            }
            if (n == 0) break;
        }
        return true;
    }

    private Float findCeilingValue(float[] fArray, float f) {
        float[] fArray2 = (float[])fArray.clone();
        Arrays.sort(fArray2);
        for (int i = 0; i < fArray2.length; ++i) {
            if (!(f <= fArray2[i])) continue;
            return new Float(fArray2[i]);
        }
        return null;
    }

    public boolean alignFiguresByGraphArea() {
        int n;
        Cloneable cloneable;
        float f;
        float f2;
        float f3;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Rectangle2D rectangle2D;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        if (arrayList.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D2 = this.mClientRect;
        float f4 = Float.MAX_VALUE;
        float f5 = Float.MAX_VALUE;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            rectangle2D = sGFigure.getGraphRect();
            if (rectangle2D.getWidth() < (double)f4) {
                f4 = (float)rectangle2D.getWidth();
            }
            if (!(rectangle2D.getHeight() < (double)f5)) continue;
            f5 = (float)rectangle2D.getHeight();
        }
        float f6 = f4;
        float f7 = f5;
        rectangle2D = this.getBoundingBoxOfFigures(arrayList);
        int n7 = (int)((float)rectangle2D.getWidth() / f6) + 1;
        int n8 = (int)((float)rectangle2D.getHeight() / f7) + 1;
        ArrayList[][] arrayListArray = new ArrayList[n7][n8];
        for (n6 = 0; n6 < n7; ++n6) {
            for (int i = 0; i < n8; ++i) {
                arrayListArray[n6][i] = new ArrayList();
            }
        }
        for (n6 = 0; n6 < arrayList.size(); ++n6) {
            SGFigure sGFigure = (SGFigure)arrayList.get(n6);
            Rectangle2D rectangle2D3 = sGFigure.getGraphRect();
            n5 = (int)((rectangle2D3.getCenterX() - rectangle2D.getX()) / (double)f6);
            n4 = (int)((rectangle2D3.getCenterY() - rectangle2D.getY()) / (double)f7);
            arrayListArray[n5][n4].add(sGFigure);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < n7; ++i) {
            boolean bl = false;
            for (n5 = 0; n5 < n8; ++n5) {
                if (arrayListArray[i][n5].size() == 0) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList2.add(new Integer(i));
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (n3 = 0; n3 < n8; ++n3) {
            n5 = 0;
            for (n4 = 0; n4 < n7; ++n4) {
                if (arrayListArray[n4][n3].size() == 0) continue;
                n5 = 1;
                break;
            }
            if (n5 == 0) continue;
            arrayList3.add(new Integer(n3));
        }
        n3 = arrayList2.size();
        n5 = arrayList3.size();
        ArrayList[][] arrayListArray2 = new ArrayList[n3][n5];
        for (int i = 0; i < n3; ++i) {
            int n9 = (Integer)arrayList2.get(i);
            for (int j = 0; j < n5; ++j) {
                int n10 = (Integer)arrayList3.get(j);
                arrayListArray2[i][j] = arrayListArray[n9][n10];
            }
        }
        float[][] fArray = new float[n3][n5];
        float[][] fArray2 = new float[n3][n5];
        float[][] fArray3 = new float[n3][n5];
        float[][] fArray4 = new float[n3][n5];
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n5; ++n2) {
                if (arrayListArray2[i][n2] == null) continue;
                ArrayList arrayList4 = arrayListArray2[i][n2];
                float f8 = 0.0f;
                f3 = 0.0f;
                f2 = 0.0f;
                f = 0.0f;
                for (int j = 0; j < arrayList4.size(); ++j) {
                    SGFigure sGFigure = (SGFigure)arrayList4.get(j);
                    Rectangle2D rectangle2D4 = sGFigure.getGraphRect();
                    SGTuple2f sGTuple2f = new SGTuple2f();
                    cloneable = new SGTuple2f();
                    sGFigure.calcMargin(sGTuple2f, (SGTuple2f)cloneable);
                    if (sGTuple2f.x + (float)rectangle2D4.getHeight() > f8) {
                        f8 = sGTuple2f.x + (float)rectangle2D4.getHeight();
                    }
                    if (sGTuple2f.y > f3) {
                        f3 = sGTuple2f.y;
                    }
                    if (((SGTuple2f)cloneable).x > f2) {
                        f2 = ((SGTuple2f)cloneable).x;
                    }
                    if (!(((SGTuple2f)cloneable).y + (float)rectangle2D4.getWidth() > f)) continue;
                    f = ((SGTuple2f)cloneable).y + (float)rectangle2D4.getWidth();
                }
                fArray[i][n2] = f8;
                fArray2[i][n2] = f3;
                fArray3[i][n2] = f2;
                fArray4[i][n2] = f;
            }
        }
        float[] fArray5 = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            float f9 = 0.0f;
            for (int i = 0; i < n5; ++i) {
                f3 = fArray3[n2][i] + fArray4[n2][i];
                if (!(f3 > f9)) continue;
                f9 = f3;
            }
            fArray5[n2] = f9;
        }
        float[] fArray6 = new float[n5];
        for (int i = 0; i < n5; ++i) {
            float f10 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                f2 = fArray[j][i] + fArray2[j][i];
                if (!(f2 > f10)) continue;
                f10 = f2;
            }
            fArray6[i] = f10;
        }
        float[] fArray7 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f11 = 0.0f;
            for (int j = 0; j < n5; ++j) {
                f = fArray3[i][j];
                if (!(f > f11)) continue;
                f11 = f;
            }
            fArray7[i] = f11;
        }
        float[] fArray8 = new float[n5];
        for (int i = 0; i < n5; ++i) {
            float f12 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                float f13 = fArray2[j][i];
                if (!(f13 > f12)) continue;
                f12 = f13;
            }
            fArray8[i] = f12;
        }
        float[] fArray9 = new float[n3];
        float f14 = (float)rectangle2D2.getX();
        for (int i = 0; i < n3; ++i) {
            fArray9[i] = f14 + fArray7[i];
            f14 += fArray5[i];
        }
        float[] fArray10 = new float[n5];
        float f15 = (float)rectangle2D2.getY();
        for (n = 0; n < n5; ++n) {
            fArray10[n] = f15 + fArray6[n] - fArray8[n];
            f15 += fArray6[n];
        }
        n = 1;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n3; ++j) {
                cloneable = arrayListArray2[j][i];
                for (int k = 0; k < ((ArrayList)cloneable).size(); ++k) {
                    SGFigure sGFigure = (SGFigure)((ArrayList)cloneable).get(k);
                    if (sGFigure == null) {
                        n = 0;
                        break;
                    }
                    if (sGFigure.setGraphRectLocationByLeftBottom(fArray9[j], fArray10[i])) continue;
                    return false;
                }
                if (n == 0) break;
            }
            if (n == 0) break;
        }
        return this.setFigureBoundingBox(0);
    }

    public boolean alignFiguresByGraphAreaNew() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        if (arrayList.size() == 0) {
            return true;
        }
        ArrayList[][] arrayListArray = this.getFigureListArray();
        if (arrayListArray == null) {
            return false;
        }
        if (arrayListArray.length == 0) {
            return false;
        }
        if (!this.alignFiguresLeftAndBottom(arrayListArray)) {
            return false;
        }
        return this.setFigureBoundingBox(0);
    }

    public boolean alignFiguresByBoundingBox() {
        boolean bl;
        int n;
        int n2;
        float f;
        int n3;
        SGFigure[][] sGFigureArray = this.getOrderedFigureArray();
        if (sGFigureArray == null) {
            return false;
        }
        if (sGFigureArray.length == 0) {
            return true;
        }
        int n4 = sGFigureArray.length;
        int n5 = sGFigureArray[0].length;
        Rectangle2D[][] rectangle2DArray = new Rectangle2D[n4][n5];
        boolean bl2 = true;
        for (int i = 0; i < n4; ++i) {
            for (n3 = 0; n3 < n5; ++n3) {
                if (sGFigureArray[i][n3] == null) {
                    bl2 = false;
                    break;
                }
                rectangle2DArray[i][n3] = sGFigureArray[i][n3].getBoundingBox();
            }
            if (!bl2) break;
        }
        float[] fArray = new float[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            Rectangle2D rectangle2D;
            float f2 = 0.0f;
            for (int i = 0; i < n4 && (rectangle2D = rectangle2DArray[i][n3]) != null; ++i) {
                float f3 = (float)rectangle2DArray[i][n3].getWidth();
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            fArray[n3] = f2;
        }
        float[] fArray2 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            Rectangle2D rectangle2D;
            float f4 = 0.0f;
            for (int j = 0; j < n5 && (rectangle2D = rectangle2DArray[i][j]) != null; ++j) {
                f = (float)rectangle2DArray[i][j].getHeight();
                if (!(f > f4)) continue;
                f4 = f;
            }
            fArray2[i] = f4;
        }
        Rectangle2D rectangle2D = this.getClientRect();
        float[] fArray3 = new float[n5];
        float f5 = (float)rectangle2D.getX();
        for (int i = 0; i < n5; ++i) {
            fArray3[i] = f5 + fArray[i] / 2.0f;
            f5 += fArray[i];
        }
        float[] fArray4 = new float[n4];
        f = (float)rectangle2D.getY();
        for (n2 = 0; n2 < n4; ++n2) {
            fArray4[n2] = f + fArray2[n2] / 2.0f;
            f += fArray2[n2];
        }
        bl2 = true;
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n5; ++i) {
                int n6 = n2 * n5 + i;
                SGFigure sGFigure = sGFigureArray[n2][i];
                if (sGFigure == null) {
                    bl2 = false;
                    break;
                }
                if (sGFigure.setCenter(fArray3[i], fArray4[n2])) continue;
                return false;
            }
            if (!bl2) break;
        }
        n2 = -1;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (n = 0; n < fArray.length; ++n) {
            f6 += fArray[n];
        }
        for (n = 0; n < fArray2.length; ++n) {
            f7 += fArray2[n];
        }
        Rectangle2D rectangle2D2 = this.getPaperRect();
        boolean bl3 = rectangle2D2.getWidth() < (double)f6;
        boolean bl4 = bl = rectangle2D2.getHeight() < (double)f7;
        if (bl3 & bl) {
            n2 = 0;
        } else if (bl3) {
            n2 = 1;
        } else if (bl) {
            n2 = 2;
        }
        return n2 == -1 || this.setFigureBoundingBox(n2);
    }

    public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
        ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
        arrayList.add(sGIUndoable);
        boolean bl = this.updateObjectHistory(arrayList);
        return bl;
    }

    public boolean updateObjectHistory(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < this.mCurrentStateCounter; ++i) {
            Object e = this.mUndoableObjectHistoryList.get(i);
            arrayList2.add(e);
        }
        arrayList2.add(new ArrayList(arrayList));
        this.mUndoableObjectHistoryList = arrayList2;
        ++this.mCurrentStateCounter;
        this.updateUndoItems();
        return true;
    }

    public boolean undo() {
        --this.mWindowStateCounter;
        WindowProperties windowProperties = (WindowProperties)this.mWindowPropertyHistoryList.get(this.mWindowStateCounter);
        this.setProperties(windowProperties);
        this.repaintAll();
        return true;
    }

    public boolean redo() {
        ++this.mWindowStateCounter;
        WindowProperties windowProperties = (WindowProperties)this.mWindowPropertyHistoryList.get(this.mWindowStateCounter);
        this.setProperties(windowProperties);
        this.repaintAll();
        return true;
    }

    boolean updateGraphRectOfAllFigures() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.updateGraphRect();
        }
        return true;
    }

    private boolean updateOnUndo() {
        this.clearAllFocusedObjectsInFigures();
        this.updateClientRect();
        this.updateGraphRectOfAllFigures();
        this.updateUndoItems();
        this.updateItemsByFigureNumbers();
        this.updateDataItem();
        this.updateGridItems();
        return true;
    }

    public boolean onUndo() {
        if (this.mCurrentStateCounter == 0) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter - 1);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.undo() : sGIUndoable.onUndo();
            if (bl) continue;
            return false;
        }
        --this.mCurrentStateCounter;
        this.updateOnUndo();
        return true;
    }

    public boolean onRedo() {
        if (this.mCurrentStateCounter == this.mUndoableObjectHistoryList.size()) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.redo() : sGIUndoable.onRedo();
            if (bl) continue;
            return false;
        }
        ++this.mCurrentStateCounter;
        this.updateOnUndo();
        return true;
    }

    public boolean isChanged() {
        return this.mChangedFlag;
    }

    public void setChanged(boolean bl) {
        this.mChangedFlag = bl;
    }

    private void updateUndoItems() {
        boolean bl = this.mCurrentStateCounter != 0;
        boolean bl2 = this.mCurrentStateCounter != this.mUndoableObjectHistoryList.size();
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemEnabled("Edit", "Undo", bl);
        sGMenuBar.setMenuItemEnabled("Edit", "Redo", bl2);
        SGToolBar sGToolBar = this.mToolBar;
        sGToolBar.setButtonEnabled("Undo", bl);
        sGToolBar.setButtonEnabled("Redo", bl2);
    }

    public void notifyToRoot() {
        this.updateHistoryTree();
    }

    private boolean updateHistoryTree() {
        return this.updateHistory();
    }

    private boolean createMenuBar() {
        SGMenuBar sGMenuBar = this.mMenuBar;
        this.setJMenuBar(sGMenuBar);
        sGMenuBar.addActionListener(this);
        sGMenuBar.addMenuListener(this);
        return true;
    }

    public boolean exportAsImage() {
        return this.toImage(1);
    }

    public boolean printImage() {
        return this.toImage(2);
    }

    private boolean toImage(int n) {
        boolean bl;
        int n2 = (int)this.mPaperSize.x;
        int n3 = (int)this.mPaperSize.y;
        InfoForExport infoForExport = new InfoForExport();
        ExportPanel exportPanel = new ExportPanel();
        exportPanel.setOpaque(true);
        exportPanel.setBackground(this.getPaperColor());
        exportPanel.setPreferredSize(new Dimension(n2, n3));
        this.beforeExport(exportPanel, infoForExport);
        SGIImageExportManager sGIImageExportManager = this.mImageExportManager;
        switch (n) {
            case 1: {
                bl = sGIImageExportManager.export(exportPanel, this, n2, n3);
                break;
            }
            case 2: {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(null);
                jPanel.setSize(n2, n3);
                jPanel.add(exportPanel);
                jPanel.setOpaque(true);
                jPanel.setBackground(exportPanel.getBackground());
                bl = sGIImageExportManager.print(jPanel, this, n2, n3);
                break;
            }
            default: {
                bl = false;
            }
        }
        this.afterExport(exportPanel, infoForExport);
        return bl;
    }

    private boolean beforeExport(ExportPanel exportPanel, InfoForExport infoForExport) {
        SGFigure sGFigure;
        int n;
        int n2;
        Serializable serializable;
        SGFigure sGFigure2;
        int n3;
        float f = this.mMagnification;
        float f2 = this.getHScrollValue();
        float f3 = this.getVScrollValue();
        ArrayList arrayList = this.getVisibleFigureListFromLayer();
        boolean bl = true;
        Rectangle rectangle = this.getPaperRect().getBounds();
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            sGFigure2 = (SGFigure)arrayList.get(n3);
            serializable = sGFigure2.getBoundingBox().getBounds();
            if (rectangle.contains((Rectangle)serializable)) continue;
            bl = false;
            break;
        }
        if (!bl) {
            SGUtility.showMessageDialog(this, "Some figures run off the edge of paper.", "Warning", 2);
        }
        this.setSelectionSymbolsVisible(false);
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            sGFigure2 = (SGFigure)arrayList.get(n3);
            sGFigure2.setSymbolsVisibleAroundAllObjects(false);
        }
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            serializable = (SGFigure)arrayList.get(i);
            sGTuple2fArray[i] = new SGTuple2f(((SGFigure)serializable).mGraphRectX, ((SGFigure)serializable).mGraphRectY);
        }
        this.zoom(1.0f);
        Rectangle2D rectangle2D = this.getClientRect();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            SGFigure sGFigure3 = (SGFigure)arrayList.get(n2);
            sGFigure3.setGraphRectLocation(sGFigure3.getGraphRectX() - (float)rectangle2D.getX(), sGFigure3.getGraphRectY() - (float)rectangle2D.getY());
        }
        n2 = (int)this.mPaperSize.x;
        int n4 = (int)this.mPaperSize.y;
        exportPanel.setOpaque(false);
        exportPanel.setLocation(0, 0);
        exportPanel.setSize(n2, n4);
        for (n = arrayList.size() - 1; n >= 0; --n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.setSize(new SGTuple2f(n2, n4));
            exportPanel.add(sGFigure);
            sGFigure.setViewBounds(null);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.setVisible(false);
        }
        infoForExport.mag = f;
        infoForExport.hValue = f2;
        infoForExport.vValue = f3;
        infoForExport.locationArray = sGTuple2fArray;
        infoForExport.visibleList = arrayList;
        return true;
    }

    private boolean afterExport(ExportPanel exportPanel, InfoForExport infoForExport) {
        SGFigure sGFigure;
        int n;
        float f = infoForExport.mag;
        float f2 = infoForExport.hValue;
        float f3 = infoForExport.vValue;
        SGTuple2f[] sGTuple2fArray = infoForExport.locationArray;
        ArrayList arrayList = infoForExport.visibleList;
        this.zoom(f);
        this.setScrollValue(this.mHScrollBar, f2);
        this.setScrollValue(this.mVScrollBar, f3);
        SGTuple2f sGTuple2f = this.getViewportSize();
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.mGraphRectX = sGTuple2fArray[n].x;
            sGFigure.mGraphRectY = sGTuple2fArray[n].y;
            sGFigure.setSize(sGTuple2f);
            sGFigure.updateGraphRect();
            sGFigure.setViewBounds();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.setVisible(true);
        }
        this.setSelectionSymbolsVisible(true);
        ArrayList arrayList2 = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure2 = (SGFigure)arrayList2.get(i);
            sGFigure2.setSymbolsVisibleAroundAllObjects(true);
        }
        return true;
    }

    public Element createElement(Document document) {
        Element element = document.createElement("Window");
        if (!this.writeProperty(element)) {
            return null;
        }
        return element;
    }

    public Element createElementForFocusedFiguresInBoundingBox(Document document) {
        Element element = document.createElement("Window");
        if (!this.writePropertyForFocusedFiguresInBoundingBox(element)) {
            return null;
        }
        return element;
    }

    public boolean createDOMTree(Document document) {
        boolean bl;
        switch (this.mPropertyFileCreationModeOfFigures) {
            case 0: {
                bl = this.createDOMTreeForAllFigures(document);
                break;
            }
            case 1: {
                bl = this.createDOMTreeForFocusedFiguresForDuplication(document);
                break;
            }
            case 2: {
                bl = this.createDOMTreeForFocusedFiguresInBoundingBox(document);
                break;
            }
            case 3: {
                bl = this.createDOMTreeForFocusedFiguresForDuplication(document);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return bl;
    }

    public boolean createDOMTree(Document document, int n) {
        this.mPropertyFileCreationModeOfFigures = n;
        return this.createDOMTree(document);
    }

    private boolean createDOMTreeForAllFigures(Document document) {
        Element element = document.getDocumentElement();
        Element element2 = this.createElement(document);
        if (element2 == null) {
            return false;
        }
        element.appendChild(element2);
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            Element element3 = sGFigure.createElement(document);
            if (element3 == null) {
                return false;
            }
            element2.appendChild(element3);
        }
        return true;
    }

    boolean createPropertyFileFromFocusedFigures() {
        this.mPropertyFileCreationModeOfFigures = 2;
        this.notifyToListener("save property");
        return true;
    }

    private boolean createDOMTreeForFocusedFiguresInBoundingBox(Document document) {
        Element element = document.getDocumentElement();
        Element element2 = this.createElementForFocusedFiguresInBoundingBox(document);
        if (element2 == null) {
            return false;
        }
        element.appendChild(element2);
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            Element element3 = sGFigure.createElementForFocusedInBoundingBox(document);
            if (element3 == null) {
                return false;
            }
            element2.appendChild(element3);
        }
        return true;
    }

    private boolean createDOMTreeForFocusedFiguresForDuplication(Document document) {
        Element element = document.getDocumentElement();
        Element element2 = this.createElement(document);
        if (element2 == null) {
            return false;
        }
        element.appendChild(element2);
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            Element element3 = sGFigure.createElementForFocusedForDuplication(document);
            if (element3 == null) {
                return false;
            }
            element2.appendChild(element3);
        }
        return true;
    }

    public boolean writePropertyForFocusedFiguresInBoundingBox(Element element) {
        Rectangle2D rectangle2D = this.getBoundingBoxOfFigures(this.getFocusedObjectsList());
        float f = (float)rectangle2D.getWidth() * 0.035277776f / this.mMagnification;
        float f2 = (float)rectangle2D.getHeight() * 0.035277776f / this.mMagnification;
        element.setAttribute("PaperWidth", Float.toString(f) + "cm");
        element.setAttribute("PaperHeight", Float.toString(f2) + "cm");
        this.writeProperty_(element);
        return true;
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("PaperWidth", Float.toString(this.mPaperSize.x * 0.035277776f) + "cm");
        element.setAttribute("PaperHeight", Float.toString(this.mPaperSize.y * 0.035277776f) + "cm");
        this.writeProperty_(element);
        return true;
    }

    private boolean writeProperty_(Element element) {
        element.setAttribute("GridVisible", Boolean.toString(this.isGridLineVisible()));
        element.setAttribute("GridInterval", Float.toString(this.getGridLineInterval() * 0.035277776f) + "cm");
        element.setAttribute("GridLineWidth", Float.toString(this.getGridLineWidth()) + "pt");
        element.setAttribute("BackgroundColor", SGUtilityText.getColorString(this.getPaperColor()));
        element.setAttribute("GridLineColor", SGUtilityText.getColorString(this.getGridLineColor()));
        return true;
    }

    boolean showPropertyDialogForSelectedFigures() {
        Container container;
        ArrayList arrayList = this.getFocusedObjectsList();
        ArrayList<SGPropertyDialog> arrayList2 = new ArrayList<SGPropertyDialog>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            container = sGFigure.getPropertyDialog();
            if (container == null) continue;
            arrayList2.add((SGPropertyDialog)container);
        }
        ArrayList arrayList3 = this.getFigureListFromMap();
        for (int i = 0; i < arrayList3.size(); ++i) {
            container = (SGFigure)arrayList3.get(i);
            ((SGFigure)container).clearFocusedObjects();
        }
        SGPropertyDialog sGPropertyDialog = (SGPropertyDialog)arrayList2.get(0);
        this.showPropertyDialog(sGPropertyDialog, arrayList);
        return true;
    }

    boolean showPropertyDialogForSelectedObjects(SGFigure sGFigure, SGIFigureElement sGIFigureElement) {
        ArrayList arrayList;
        SGFigure sGFigure2;
        int n;
        ArrayList arrayList2 = new ArrayList();
        ArrayList<SGPropertyDialog> arrayList3 = new ArrayList<SGPropertyDialog>();
        ArrayList arrayList4 = this.getVisibleFigureListFromMap();
        for (n = 0; n < arrayList4.size(); ++n) {
            sGFigure2 = (SGFigure)arrayList4.get(n);
            SGIFigureElement sGIFigureElement2 = sGFigure2.getIFigureElement(sGIFigureElement);
            arrayList = sGIFigureElement2.getPropertyDialogObserverList();
            if (arrayList.size() == 0) continue;
            arrayList2.addAll(arrayList);
            SGIPropertyDialogObserver sGIPropertyDialogObserver = (SGIPropertyDialogObserver)arrayList2.get(0);
            SGPropertyDialog sGPropertyDialog = sGIPropertyDialogObserver.getPropertyDialog();
            arrayList3.add(sGPropertyDialog);
        }
        if (arrayList2.size() == 0) {
            return true;
        }
        for (n = 0; n < arrayList3.size() - 1; ++n) {
            sGFigure2 = arrayList3.get(n);
            for (int i = n; i < arrayList3.size(); ++i) {
                arrayList = arrayList3.get(i);
                if (sGFigure2.getClass().equals(arrayList.getClass())) continue;
                return false;
            }
        }
        for (n = 0; n < arrayList4.size(); ++n) {
            sGFigure2 = (SGFigure)arrayList4.get(n);
            sGFigure2.clearFocusedObjectsOtherThan(sGIFigureElement);
            if (sGFigure2.equals(sGFigure)) continue;
            sGFigure2.setSelected(false);
        }
        this.getContentPane().repaint();
        SGPropertyDialog sGPropertyDialog = (SGPropertyDialog)arrayList3.get(0);
        this.showPropertyDialog(sGPropertyDialog, arrayList2);
        return true;
    }

    private void showPropertyDialog(SGPropertyDialog sGPropertyDialog, SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        ArrayList<SGIPropertyDialogObserver> arrayList = new ArrayList<SGIPropertyDialogObserver>();
        arrayList.add(sGIPropertyDialogObserver);
        this.showPropertyDialog(sGPropertyDialog, arrayList);
    }

    private void showPropertyDialog(SGPropertyDialog sGPropertyDialog, ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIPropertyDialogObserver sGIPropertyDialogObserver = (SGIPropertyDialogObserver)arrayList.get(i);
            sGPropertyDialog.addPropertyDialogObserver(sGIPropertyDialogObserver);
            sGIPropertyDialogObserver.prepare();
        }
        sGPropertyDialog.setDialogProperty();
        sGPropertyDialog.setLocation(this.getLocation());
        sGPropertyDialog.setVisible(true);
        sGPropertyDialog.removeAllPropertyDialogObserver();
        this.notifyToRoot();
    }

    static {
        float f = (float)SGUtilityNumber.getPowersOfTen(-1);
        BOUNDING_BOX_MARGIN = f / 0.035277776f;
    }

    public static class WindowProperties
    extends SGProperties {
        private ArrayList mVisibleFigureList = new ArrayList();
        private float mPaperWidth;
        private float mPaperHeight;
        private Color mBackgroundColor;
        private boolean mGridVisible;
        private Color mGridColor;
        private float mGridInverval;
        private float mGridLineWidth;

        public boolean equals(Object object) {
            if (!(object instanceof WindowProperties)) {
                return false;
            }
            WindowProperties windowProperties = (WindowProperties)object;
            if (!windowProperties.mVisibleFigureList.equals(this.mVisibleFigureList)) {
                return false;
            }
            if (windowProperties.mPaperWidth != this.mPaperWidth) {
                return false;
            }
            if (windowProperties.mPaperHeight != this.mPaperHeight) {
                return false;
            }
            if (!windowProperties.mBackgroundColor.equals(this.mBackgroundColor)) {
                return false;
            }
            if (windowProperties.mGridVisible != this.mGridVisible) {
                return false;
            }
            if (!windowProperties.mGridColor.equals(this.mGridColor)) {
                return false;
            }
            if (windowProperties.mGridInverval != this.mGridInverval) {
                return false;
            }
            return windowProperties.mGridLineWidth == this.mGridLineWidth;
        }

        public ArrayList getVisibleFigureList() {
            ArrayList arrayList = new ArrayList(this.mVisibleFigureList);
            return arrayList;
        }

        public Float getPaperWidth() {
            return new Float(this.mPaperWidth);
        }

        public Float getPaperHeight() {
            return new Float(this.mPaperHeight);
        }

        public Color getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public Color getGridColor() {
            return this.mGridColor;
        }

        public Boolean getGridVisible() {
            return this.mGridVisible;
        }

        public Float getGridInterval() {
            return new Float(this.mGridInverval);
        }

        public Float getGridLineWidth() {
            return new Float(this.mGridLineWidth);
        }

        public void setVisibleFigureList(ArrayList arrayList) {
            if (arrayList == null) {
                throw new IllegalArgumentException("list==null");
            }
            this.mVisibleFigureList = new ArrayList(arrayList);
        }

        public void setPaperWidth(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("w<0.0f");
            }
            this.mPaperWidth = f;
        }

        public void setPaperHeight(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("h<0.0f");
            }
            this.mPaperHeight = f;
        }

        public void setBackGroundColor(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("cl==null");
            }
            this.mBackgroundColor = color;
        }

        public void setGridColor(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("cl==null");
            }
            this.mGridColor = color;
        }

        public void setGridVisible(boolean bl) {
            this.mGridVisible = bl;
        }

        public void setGridInterval(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("num<0.0f");
            }
            this.mGridInverval = f;
        }

        public void setGridLineWidth(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("num<0.0f");
            }
            this.mGridLineWidth = f;
        }
    }

    private static class RulerPanel
    extends InnerPanel {
        private static final int RULER_WIDTH = 20;
        private static final int ANCHOR_SIZE = 12;
        private static final Color INNER_COLOR_1 = new Color(234, 238, 232);
        private static final Color INNER_COLOR_2 = new Color(124, 155, 64);
        private static final Color ANCHOR_INNER_COLOR = new Color(222, 222, 222);
        private static final float ANCHOR_EDGE_LINE_WIDTH = 4.0f;
        private static final Color ANCHOR_EDGE_LINE_COLOR = Color.WHITE;
        private static final Color LINE_COLOR = Color.BLACK;
        private static final float LINE_WIDTH = 2.0f;
        private static final BasicStroke LINE_STROKE = new BasicStroke(2.0f, 0, 0, 1.0f, new float[]{10.0f, 2.0f, 2.0f, 4.0f}, 0.0f);
        private Font mRulerFont = null;
        private Point2D mHorizontalLocation = null;
        private Point2D mVerticalLocation = null;
        private boolean mDrawHorizontalLineFlag = false;
        private boolean mDrawVerticalLineFlag = false;

        RulerPanel(SGDrawingWindow sGDrawingWindow) {
            super(sGDrawingWindow);
            this.setVisible(true);
            this.setOpaque(false);
            int n = SGUtilityText.getFontStyle("Plain");
            this.mRulerFont = new Font("Serif", n, 11);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.drawRuler(graphics2D);
            if (this.mDrawHorizontalLineFlag) {
                this.drawHorizontalLine(graphics2D);
            }
            if (this.mDrawVerticalLineFlag) {
                this.drawVerticalLine(graphics2D);
            }
            Point2D point2D = null;
            point2D = this.mDrawHorizontalLineFlag ? this.mHorizontalLocation : this.getHorizontalAnchorLocationFromPaper();
            this.drawHorizontalAnchor((int)point2D.getX(), (Graphics2D)graphics2D.create());
            point2D = null;
            point2D = this.mDrawVerticalLineFlag ? this.mVerticalLocation : this.getVerticalAnchorLocationFromPaper();
            this.drawVerticalAnchor((int)point2D.getY(), (Graphics2D)graphics2D.create());
        }

        private void drawHorizontalAnchor(int n, Graphics2D graphics2D) {
            int[] nArray = new int[7];
            int[] nArray2 = new int[7];
            int n2 = (int)this.getHorizontalAnchorLocationFromPaper().getY() - 1;
            nArray[0] = n + 3;
            nArray2[0] = n2 - 10;
            nArray[1] = nArray[0];
            nArray2[1] = n2 - 6;
            nArray[2] = n + 6;
            nArray2[2] = nArray2[1];
            nArray[3] = n;
            nArray2[3] = n2;
            nArray[4] = n - 6;
            nArray2[4] = nArray2[2];
            nArray[5] = n - 3;
            nArray2[5] = nArray2[4];
            nArray[6] = nArray[5];
            nArray2[6] = nArray2[0];
            this.drawAnchor(nArray, nArray2, 7, graphics2D);
        }

        private void drawVerticalAnchor(int n, Graphics2D graphics2D) {
            int[] nArray = new int[7];
            int[] nArray2 = new int[7];
            int n2 = (int)this.getVerticalAnchorLocationFromPaper().getX() - 1;
            nArray[0] = n2 - 10;
            nArray2[0] = n + 3;
            nArray[1] = n2 - 6;
            nArray2[1] = nArray2[0];
            nArray[2] = nArray[1];
            nArray2[2] = n + 6;
            nArray[3] = n2;
            nArray2[3] = n;
            nArray[4] = nArray[2];
            nArray2[4] = n - 6;
            nArray[5] = nArray[4];
            nArray2[5] = n - 3;
            nArray[6] = nArray[0];
            nArray2[6] = nArray2[5];
            this.drawAnchor(nArray, nArray2, 7, graphics2D);
        }

        private void drawAnchor(int[] nArray, int[] nArray2, int n, Graphics2D graphics2D) {
            Polygon polygon = new Polygon(nArray, nArray2, n);
            int n2 = nArray[6];
            int n3 = nArray2[6];
            int n4 = (nArray[2] + nArray[3]) / 2;
            int n5 = (nArray2[2] + nArray2[3]) / 2;
            GradientPaint gradientPaint = new GradientPaint(n2, n3, INNER_COLOR_1, n4, n5, INNER_COLOR_2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(polygon);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.draw(polygon);
        }

        private void drawHorizontalLine(Graphics2D graphics2D) {
            if (this.mHorizontalLocation == null) {
                return;
            }
            Point2D point2D = this.mHorizontalLocation;
            float f = (float)point2D.getX();
            Line2D.Float float_ = new Line2D.Float();
            ((Line2D)float_).setLine(point2D.getX(), this.getHorizontalAnchorLocationFromPaper().getY(), point2D.getX(), this.getHeight());
            graphics2D.setPaint(LINE_COLOR);
            graphics2D.setStroke(LINE_STROKE);
            graphics2D.draw(float_);
        }

        private void drawVerticalLine(Graphics2D graphics2D) {
            if (this.mVerticalLocation == null) {
                return;
            }
            Point2D point2D = this.mVerticalLocation;
            Line2D.Float float_ = new Line2D.Float();
            ((Line2D)float_).setLine(this.getVerticalAnchorLocationFromPaper().getX(), point2D.getY(), this.getWidth(), point2D.getY());
            graphics2D.setPaint(LINE_COLOR);
            graphics2D.setStroke(LINE_STROKE);
            graphics2D.draw(float_);
        }

        private boolean isPressed() {
            return this.mDrawHorizontalLineFlag | this.mDrawVerticalLineFlag;
        }

        private boolean pressed(MouseEvent mouseEvent) {
            int n;
            Point2D point2D = this.getHorizontalAnchorLocationFromPaper();
            int n2 = (int)point2D.getX();
            Rectangle rectangle = new Rectangle(n2 - 5, (n = (int)point2D.getY()) - 10, 10, 10);
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.mDrawHorizontalLineFlag = true;
                this.mHorizontalLocation = point2D;
                this.repaint();
                return true;
            }
            point2D = this.getVerticalAnchorLocationFromPaper();
            n2 = (int)point2D.getX();
            rectangle = new Rectangle(n2 - 10, (n = (int)point2D.getY()) - 5, 10, 10);
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.mDrawVerticalLineFlag = true;
                this.mVerticalLocation = point2D;
                this.repaint();
                return true;
            }
            this.mDrawHorizontalLineFlag = false;
            this.mDrawVerticalLineFlag = false;
            this.mHorizontalLocation = null;
            this.mVerticalLocation = null;
            this.repaint();
            return false;
        }

        private boolean dragged(MouseEvent mouseEvent) {
            this.mHorizontalLocation = mouseEvent.getPoint();
            this.mVerticalLocation = mouseEvent.getPoint();
            return true;
        }

        private boolean released(MouseEvent mouseEvent) {
            float f;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f2 = this.getPaperStartX();
            float f3 = this.getPaperStartY();
            float f4 = (float)rectangle2D.getWidth();
            float f5 = (float)rectangle2D.getHeight();
            if (this.mDrawHorizontalLineFlag) {
                f = ((float)n - f2) / this.mMagnification;
                if (f < 141.73228f) {
                    f = 141.73228f;
                }
                if (f > 2806.2993f) {
                    f = 2806.2993f;
                }
                this.mWnd.setPaperSizeRoundingOff(f, this.mWnd.getPaperHeight());
                this.mWnd.setChanged(true);
            }
            if (this.mDrawVerticalLineFlag) {
                f = ((float)n2 - f3) / this.mMagnification;
                if (f < 141.73228f) {
                    f = 141.73228f;
                }
                if (f > 2806.2993f) {
                    f = 2806.2993f;
                }
                this.mWnd.setPaperSizeRoundingOff(this.mWnd.getPaperWidth(), f);
                this.mWnd.setChanged(true);
            }
            if (this.mDrawHorizontalLineFlag | this.mDrawVerticalLineFlag) {
                this.mWnd.updateClientRect();
                this.mWnd.notifyToRoot();
                this.repaint();
            }
            this.mDrawHorizontalLineFlag = false;
            this.mDrawVerticalLineFlag = false;
            this.mHorizontalLocation = null;
            this.mVerticalLocation = null;
            return true;
        }

        private Point2D getHorizontalAnchorLocationFromPaper() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getWidth();
            Point2D.Float float_ = new Point2D.Float(f + 20.0f + f3, 20.0f);
            return float_;
        }

        private Point2D getVerticalAnchorLocationFromPaper() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getHeight();
            Point2D.Float float_ = new Point2D.Float(20.0f, f2 + 20.0f + f3);
            return float_;
        }

        private float getPaperStartX() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            return f + 20.0f;
        }

        private float getPaperStartY() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getY();
            return f + 20.0f;
        }

        private float getPaperEndX() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getWidth();
            return f + 20.0f + f2;
        }

        private float getPaperEndY() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getY();
            float f2 = (float)rectangle2D.getHeight();
            return f + 20.0f + f2;
        }

        private boolean drawRuler(Graphics2D graphics2D) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int[] nArray = new int[6];
            int[] nArray2 = new int[6];
            nArray[0] = 0;
            nArray2[0] = 0;
            nArray[1] = n;
            nArray2[1] = 0;
            nArray[2] = n;
            nArray2[2] = 20;
            nArray[3] = 20;
            nArray2[3] = 20;
            nArray[4] = 20;
            nArray2[4] = n2;
            nArray[5] = 0;
            nArray2[5] = n2;
            Polygon polygon = new Polygon(nArray, nArray2, 6);
            Color color = this.getBackground();
            Color color2 = Color.BLACK;
            graphics2D.setPaint(color);
            graphics2D.fill(polygon);
            graphics2D.setPaint(color2);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(polygon);
            this.drawNumbersAndLines(graphics2D);
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, 20.0f, 20.0f);
            graphics2D.setPaint(color);
            graphics2D.fill(float_);
            graphics2D.setPaint(color2);
            graphics2D.draw(float_);
            return true;
        }

        private boolean drawNumbersAndLines(Graphics2D graphics2D) {
            float f;
            int n;
            float f2;
            float f3;
            int n2;
            float f4;
            int n3;
            int n4;
            float f5 = this.mMagnification;
            int n5 = this.getWidth();
            int n6 = this.getHeight();
            Rectangle rectangle = new Rectangle(0, 0, n5 - 20, n6 - 20);
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            Rectangle2D rectangle2D2 = this.mWnd.getClientRect();
            Line2D.Float float_ = new Line2D.Float();
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(2.0f));
            float f6 = n5;
            ((Line2D)float_).setLine(20.0, 20.0, f6, 20.0);
            graphics2D.draw(float_);
            float f7 = n6;
            ((Line2D)float_).setLine(20.0, 20.0, 20.0, f7);
            graphics2D.draw(float_);
            Font font = this.mRulerFont;
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setFont(font);
            f6 = font.getSize();
            if (f5 < 0.5f) {
                n4 = 4;
                n3 = 8;
            } else if (f5 < 1.0f) {
                n4 = 2;
                n3 = 4;
            } else {
                n4 = 1;
                n3 = 4;
            }
            float f8 = f5 / 0.035277776f;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            float f9 = (float)rectangle2D.getX();
            float f10 = -f9;
            float f11 = f10 / f8;
            float f12 = (float)rectangle.getWidth() + f10;
            int n7 = (int)f11;
            if (n7 % n4 != 0) {
                n7 = n7 / n4 * n4;
            }
            int n8 = n7;
            while (!((f4 = f8 * (float)n8) > f12)) {
                arrayList.add(new Integer(n8));
                n8 += n4;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                n2 = (Integer)arrayList.get(i);
                f3 = (float)n2 * f8;
                f2 = f9 + 20.0f + f3;
                ((Line2D)float_).setLine(f2, 4.0, f2, 20.0);
                graphics2D.draw(float_);
                int n9 = (int)(f2 + 0.3f * f6);
                n = (int)f6 + 1;
                graphics2D.drawString(Integer.toString(n2), n9, n);
                for (int j = 0; j < n3; ++j) {
                    float f13 = f2 + 0.2f * (float)(j + 1) * f8 * (float)n4;
                    ((Line2D)float_).setLine(f13, 15.0, f13, 20.0);
                    graphics2D.draw(float_);
                }
            }
            arrayList = new ArrayList();
            f9 = (float)rectangle2D.getY();
            f10 = -f9;
            f11 = f10 / f8;
            f12 = (float)rectangle.getHeight() + f10;
            n7 = (int)f11;
            if (n7 % n4 != 0) {
                n7 = n7 / n4 * n4;
            }
            n8 = n7;
            while (!((f = f8 * (float)n8) > f12)) {
                arrayList.add(new Integer(n8));
                n8 += n4;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                int n10;
                n2 = (Integer)arrayList.get(i);
                f3 = (float)n2 * f8;
                f2 = f9 + 20.0f + f3;
                ((Line2D)float_).setLine(4.0, f2, 20.0, f2);
                graphics2D.draw(float_);
                n = (int)(f2 + f6 + 1.0f);
                char[] cArray = Integer.toString(n2).toCharArray();
                for (n10 = 0; n10 < cArray.length; ++n10) {
                    Character c = new Character(cArray[n10]);
                    graphics2D.drawString(c.toString(), 4, n);
                    n += (int)f6;
                }
                for (n10 = 0; n10 < n3; ++n10) {
                    float f14 = f2 + 0.2f * (float)(n10 + 1) * f8 * (float)n4;
                    ((Line2D)float_).setLine(15.0, f14, 20.0, f14);
                    graphics2D.draw(float_);
                }
            }
            return true;
        }
    }

    private static class BackgroundPanel
    extends InnerPanel {
        private boolean mGridVisibleFlag = true;
        private float mGridInterval = 28.346458f;
        private float mGridLineWidth = 1.0f;
        private Color mGridLineColor = SGDefaultValues.GRID_LINE_COLOR;
        private Color mPaperColor = SGDefaultValues.WINDOW_PAPER_COLOR;

        protected BackgroundPanel(SGDrawingWindow sGDrawingWindow) {
            super(sGDrawingWindow);
            this.setVisible(true);
            this.setOpaque(true);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getWidth();
            float f4 = (float)rectangle2D.getHeight();
            Rectangle2D rectangle2D2 = this.mWnd.getViewportBounds();
            float f5 = (float)rectangle2D2.getX();
            float f6 = (float)rectangle2D2.getY();
            float f7 = (float)rectangle2D2.getWidth();
            float f8 = (float)rectangle2D2.getHeight();
            graphics2D.setPaint(this.getPaperColor());
            graphics2D.fill(rectangle2D);
            Line2D.Float float_ = new Line2D.Float();
            if (this.isGridVisible()) {
                graphics2D.setStroke(new BasicStroke(this.getGridLineWidth()));
                graphics2D.setPaint(this.getGridLineColor());
                float[] fArray = this.getVerticalGridLocation();
                for (int i = 0; i < fArray.length; ++i) {
                    float f9 = fArray[i];
                    ((Line2D)float_).setLine(f9, f2, f9, f2 + f4);
                    graphics2D.draw(float_);
                }
                float[] fArray2 = this.getHorizontalGridLocation();
                for (int i = 0; i < fArray2.length; ++i) {
                    float f10 = fArray2[i];
                    ((Line2D)float_).setLine(f, f10, f + f3, f10);
                    graphics2D.draw(float_);
                }
            }
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(rectangle2D);
        }

        public float[] getVerticalGridLocation() {
            float f;
            float f2 = this.mMagnification * this.getGridInterval();
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f3 = (float)rectangle2D.getX();
            float f4 = (float)rectangle2D.getWidth();
            Rectangle2D rectangle2D2 = this.mWnd.getViewportBounds();
            float f5 = (float)rectangle2D2.getX();
            float f6 = (float)rectangle2D2.getWidth();
            ArrayList<Float> arrayList = new ArrayList<Float>();
            int n = (int)((f5 - f3) / f2) + 1;
            while (!((f = (float)n * f2 + f3) > f5 + f6) && !(f > f3 + f4)) {
                arrayList.add(new Float(f));
                ++n;
            }
            float[] fArray = new float[arrayList.size()];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = ((Float)arrayList.get(i)).floatValue();
            }
            return fArray;
        }

        public float[] getHorizontalGridLocation() {
            float f;
            float f2 = this.mMagnification * this.getGridInterval();
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f3 = (float)rectangle2D.getY();
            float f4 = (float)rectangle2D.getHeight();
            Rectangle2D rectangle2D2 = this.mWnd.getViewportBounds();
            float f5 = (float)rectangle2D2.getY();
            float f6 = (float)rectangle2D2.getHeight();
            ArrayList<Float> arrayList = new ArrayList<Float>();
            int n = (int)((f5 - f3) / f2) + 1;
            while (!((f = (float)n * f2 + f3) > f5 + f6) && !(f > f3 + f4)) {
                arrayList.add(new Float(f));
                ++n;
            }
            float[] fArray = new float[arrayList.size()];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = ((Float)arrayList.get(i)).floatValue();
            }
            return fArray;
        }

        public float getGridInterval() {
            return this.mGridInterval;
        }

        public Color getGridLineColor() {
            return this.mGridLineColor;
        }

        public float getGridLineWidth() {
            return this.mGridLineWidth;
        }

        public boolean isGridVisible() {
            return this.mGridVisibleFlag;
        }

        public void setGridInterval(float f) {
            this.mGridInterval = f;
        }

        public void setGridLineColor(Color color) {
            this.mGridLineColor = color;
        }

        public void setGridLineWidth(float f) {
            this.mGridLineWidth = f;
        }

        public void setGridVisible(boolean bl) {
            this.mGridVisibleFlag = bl;
        }

        public Color getPaperColor() {
            return this.mPaperColor;
        }

        public void setPaperColor(Color color) {
            this.mPaperColor = color;
        }
    }

    private static class ForegroundPanel
    extends InnerPanel {
        public static final float ANCHOR_SIZE = 6.0f;

        protected ForegroundPanel(SGDrawingWindow sGDrawingWindow) {
            super(sGDrawingWindow);
            this.setVisible(true);
            this.setOpaque(false);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            ArrayList arrayList = this.mWnd.getFocusedObjectsList();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                if (!sGFigure.isSelectionSymbolsVisible()) continue;
                Rectangle2D rectangle2D = sGFigure.getRubberBandRect();
                if (SGFigure.mRubberBandFlag & SGFigure.mRubberBandVisibleFlag) {
                    this.drawRubberBand(graphics2D, rectangle2D.getBounds());
                }
                Rectangle2D rectangle2D2 = sGFigure.getGraphRect();
                int n = (int)rectangle2D2.getX();
                int n2 = (int)rectangle2D2.getY();
                int n3 = (int)rectangle2D2.getWidth();
                int n4 = (int)rectangle2D2.getHeight();
                this.drawAnchor(graphics2D, n, n2);
                this.drawAnchor(graphics2D, n + n3, n2);
                this.drawAnchor(graphics2D, n, n2 + n4);
                this.drawAnchor(graphics2D, n + n3, n2 + n4);
                this.drawAnchor(graphics2D, n + n3 / 2, n2);
                this.drawAnchor(graphics2D, n, n2 + n4 / 2);
                this.drawAnchor(graphics2D, n + n3 / 2, n2 + n4);
                this.drawAnchor(graphics2D, n + n3, n2 + n4 / 2);
            }
        }

        private void drawAnchor(Graphics2D graphics2D, int n, int n2) {
            Ellipse2D.Float float_ = new Ellipse2D.Float((float)n - 3.0f, (float)n2 - 3.0f, 6.0f, 6.0f);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.draw(float_);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fill(float_);
        }

        private void drawRubberBand(Graphics2D graphics2D, Rectangle rectangle) {
            graphics2D.setPaint(Color.BLACK);
            float[] fArray = new float[]{4.0f, 2.0f};
            graphics2D.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, fArray, 0.0f));
            graphics2D.draw(rectangle);
        }
    }

    private static abstract class InnerPanel
    extends JPanel {
        protected float mMagnification = 1.0f;
        protected SGDrawingWindow mWnd = null;

        protected InnerPanel(SGDrawingWindow sGDrawingWindow) {
            this.mWnd = sGDrawingWindow;
        }

        public void setMagnification(float f) {
            this.mMagnification = f;
        }
    }

    public static class ExportPanel
    extends JPanel {
        private ArrayList mPrintableList = new ArrayList();
        private boolean mClipFlag = true;

        private ExportPanel() {
        }

        private void add(SGFigure sGFigure) {
            ArrayList arrayList = this.mPrintableList;
            arrayList.add(sGFigure);
            SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArrayFromLayer();
            for (int i = sGIFigureElementArray.length - 1; i >= 0; --i) {
                arrayList.add(sGIFigureElementArray[i]);
            }
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            ArrayList arrayList = this.mPrintableList;
            boolean bl = this.getClipFlag();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGIPaintable sGIPaintable = (SGIPaintable)arrayList.get(i);
                sGIPaintable.paintGraphics(graphics, bl);
            }
        }

        public boolean getClipFlag() {
            return this.mClipFlag;
        }

        public void setClipFlag(boolean bl) {
            this.mClipFlag = bl;
        }
    }

    private static class InfoForExport {
        float mag;
        float hValue;
        float vValue;
        SGTuple2f[] locationArray;
        ArrayList visibleList;

        private InfoForExport() {
        }
    }

    static class NodeMenuItem
    extends JMenuItem {
        SGINode node;

        NodeMenuItem(String string) {
            super(string);
        }

        SGINode getNode() {
            return this.node;
        }

        void setNode(SGINode sGINode) {
            this.node = sGINode;
        }
    }

    private class TreeMenuItemListener
    implements ActionListener {
        private TreeMenuItemListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            NodeMenuItem nodeMenuItem = (NodeMenuItem)object;
            SGINode sGINode = nodeMenuItem.node;
            SGIPropertyDialogObserver sGIPropertyDialogObserver = (SGIPropertyDialogObserver)((Object)sGINode);
            SGPropertyDialog sGPropertyDialog = sGIPropertyDialogObserver.getPropertyDialog();
            SGDrawingWindow.this.showPropertyDialog(sGPropertyDialog, sGIPropertyDialogObserver);
        }
    }
}

