/*
 * SGSignificantDifferenceSymbolDialog.java
 *
 * Created on 2004/06/17, 14:11
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.SpinnerNumberModel;

import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;



/**
 *
 * @author  kuromaru
 */
public class SGSignificantDifferenceSymbolDialog extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Significant Difference Symbol Properties";

    
    /** Creates new form SGSignificantDifferenceSymbolDialog */
    public SGSignificantDifferenceSymbolDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mPanel = new javax.swing.JPanel();
        mFontFamilyLabel = new javax.swing.JLabel();
        mFontStyleComboBox = new javax.swing.JComboBox();
        mFontSizeLabel = new javax.swing.JLabel();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mColorLabel = new javax.swing.JLabel();
        mLineWidthLabel1 = new javax.swing.JLabel();
        mLineWidthLabel2 = new javax.swing.JLabel();
        mFontSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mFontNameComboBox = new javax.swing.JComboBox();
        mColorButton = new javax.swing.JButton();
        mFormLabel = new javax.swing.JLabel();
        mFormSeparator = new javax.swing.JSeparator();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mSpaceLabel = new javax.swing.JLabel();
        mSpaceSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLocationLabel = new javax.swing.JLabel();
        mLocationSeparator = new javax.swing.JSeparator();
        mStringLabel = new javax.swing.JLabel();
        mStringSeparator = new javax.swing.JSeparator();
        mLeftXValueLabel = new javax.swing.JLabel();
        mLeftXValueTextField = new javax.swing.JTextField();
        mLeftYValueLabel = new javax.swing.JLabel();
        mLeftYValueTextField = new javax.swing.JTextField();
        mRightXValueLabel = new javax.swing.JLabel();
        mRightXValueTextField = new javax.swing.JTextField();
        mRightYValueLabel = new javax.swing.JLabel();
        mRightYValueTextField = new javax.swing.JTextField();
        mHorizontalYValueLabel = new javax.swing.JLabel();
        mHorizontalYValueTextField = new javax.swing.JTextField();
        mLineVisibleCheckBox = new javax.swing.JCheckBox();
        mFontStyleLabel = new javax.swing.JLabel();
        mCommonPanel = new javax.swing.JPanel();
        mLeftTopRadioButton = new javax.swing.JRadioButton();
        mLeftBottomRadioButton = new javax.swing.JRadioButton();
        mRightTopRadioButton = new javax.swing.JRadioButton();
        mRightBottomRadioButton = new javax.swing.JRadioButton();
        mScaleReferenceLabel2 = new javax.swing.JLabel();
        mScaleReferenceLabel1 = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mFontFamilyLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontFamilyLabel.setText("Family");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mFontFamilyLabel, gridBagConstraints);

        mFontStyleComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mFontStyleComboBox, gridBagConstraints);

        mFontSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mPanel.add(mFontSizeLabel, gridBagConstraints);

        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLineWidthSpinner, gridBagConstraints);

        mColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mPanel.add(mColorLabel, gridBagConstraints);

        mLineWidthLabel1.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel1.setText("Line");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        mPanel.add(mLineWidthLabel1, gridBagConstraints);

        mLineWidthLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel2.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mLineWidthLabel2, gridBagConstraints);

        mFontSizeSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mPanel.add(mFontSizeSpinner, gridBagConstraints);

        mFontNameComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mFontNameComboBox, gridBagConstraints);

        mColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mPanel.add(mColorButton, gridBagConstraints);

        mFormLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFormLabel.setText("Form");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mFormLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 45, 5, 5);
        mPanel.add(mFormSeparator, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        mPanel.add(mRightSpaceLabel, gridBagConstraints);

        mSpaceLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mSpaceLabel.setText("Space");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mSpaceLabel, gridBagConstraints);

        mSpaceSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mSpaceSpinner, gridBagConstraints);

        mLocationLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLocationLabel.setText("Location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mPanel.add(mLocationLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(10, 4, 5, 5);
        mPanel.add(mLocationSeparator, gridBagConstraints);

        mStringLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mStringLabel.setText("String");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mStringLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 50, 5, 5);
        mPanel.add(mStringSeparator, gridBagConstraints);

        mLeftXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLeftXValueLabel.setText("Left X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mLeftXValueLabel, gridBagConstraints);

        mLeftXValueTextField.setColumns(6);
        mLeftXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mLeftXValueTextField.setPreferredSize(new java.awt.Dimension(72, 22));
        mLeftXValueTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mLeftXValueTextFieldActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLeftXValueTextField, gridBagConstraints);

        mLeftYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLeftYValueLabel.setText("Left Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mLeftYValueLabel, gridBagConstraints);

        mLeftYValueTextField.setColumns(6);
        mLeftYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mLeftYValueTextField.setPreferredSize(new java.awt.Dimension(72, 22));
        mLeftYValueTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mLeftYValueTextFieldActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLeftYValueTextField, gridBagConstraints);

        mRightXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mRightXValueLabel.setText("Right X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mRightXValueLabel, gridBagConstraints);

        mRightXValueTextField.setColumns(6);
        mRightXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mRightXValueTextField.setPreferredSize(new java.awt.Dimension(72, 22));
        mRightXValueTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mRightXValueTextFieldActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mRightXValueTextField, gridBagConstraints);

        mRightYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mRightYValueLabel.setText("Right Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mRightYValueLabel, gridBagConstraints);

        mRightYValueTextField.setColumns(6);
        mRightYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mRightYValueTextField.setPreferredSize(new java.awt.Dimension(72, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mRightYValueTextField, gridBagConstraints);

        mHorizontalYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mHorizontalYValueLabel.setText("Horizontal Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mHorizontalYValueLabel, gridBagConstraints);

        mHorizontalYValueTextField.setColumns(6);
        mHorizontalYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mHorizontalYValueTextField.setPreferredSize(new java.awt.Dimension(72, 22));
        mHorizontalYValueTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mHorizontalYValueTextFieldActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mHorizontalYValueTextField, gridBagConstraints);

        mLineVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineVisibleCheckBox.setText("Line Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 5, 5);
        mPanel.add(mLineVisibleCheckBox, gridBagConstraints);

        mFontStyleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontStyleLabel.setText("Style");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mFontStyleLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mPanel, gridBagConstraints);

        mCommonPanel.setLayout(new java.awt.GridBagLayout());

        mLeftTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftTopRadioButton, gridBagConstraints);

        mLeftBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftBottomRadioButton, gridBagConstraints);

        mRightTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightTopRadioButton, gridBagConstraints);

        mRightBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightBottomRadioButton, gridBagConstraints);

        mScaleReferenceLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mCommonPanel.add(mScaleReferenceLabel2, gridBagConstraints);

        mScaleReferenceLabel1.setFont(new java.awt.Font("Dialog", 1, 12));
        mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        mCommonPanel.add(mScaleReferenceLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mCommonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    private void mHorizontalYValueTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mHorizontalYValueTextFieldActionPerformed
        // ɏR[hǉ:
    }//GEN-LAST:event_mHorizontalYValueTextFieldActionPerformed

    private void mLeftYValueTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mLeftYValueTextFieldActionPerformed
        // ɏR[hǉ:
    }//GEN-LAST:event_mLeftYValueTextFieldActionPerformed

    private void mRightXValueTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mRightXValueTextFieldActionPerformed
        // ɏR[hǉ:
    }//GEN-LAST:event_mRightXValueTextFieldActionPerformed

    private void mLeftXValueTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mLeftXValueTextFieldActionPerformed
        // ɏR[hǉ:
    }//GEN-LAST:event_mLeftXValueTextFieldActionPerformed
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JButton mColorButton;
    private javax.swing.JLabel mColorLabel;
    private javax.swing.JPanel mCommonPanel;
    private javax.swing.JLabel mFontFamilyLabel;
    private javax.swing.JComboBox mFontNameComboBox;
    private javax.swing.JLabel mFontSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFontSizeSpinner;
    private javax.swing.JComboBox mFontStyleComboBox;
    private javax.swing.JLabel mFontStyleLabel;
    private javax.swing.JLabel mFormLabel;
    private javax.swing.JSeparator mFormSeparator;
    private javax.swing.JLabel mHorizontalYValueLabel;
    private javax.swing.JTextField mHorizontalYValueTextField;
    private javax.swing.JRadioButton mLeftBottomRadioButton;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JRadioButton mLeftTopRadioButton;
    private javax.swing.JLabel mLeftXValueLabel;
    private javax.swing.JTextField mLeftXValueTextField;
    private javax.swing.JLabel mLeftYValueLabel;
    private javax.swing.JTextField mLeftYValueTextField;
    private javax.swing.JCheckBox mLineVisibleCheckBox;
    private javax.swing.JLabel mLineWidthLabel1;
    private javax.swing.JLabel mLineWidthLabel2;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JLabel mLocationLabel;
    private javax.swing.JSeparator mLocationSeparator;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JRadioButton mRightBottomRadioButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JRadioButton mRightTopRadioButton;
    private javax.swing.JLabel mRightXValueLabel;
    private javax.swing.JTextField mRightXValueTextField;
    private javax.swing.JLabel mRightYValueLabel;
    private javax.swing.JTextField mRightYValueTextField;
    private javax.swing.JLabel mScaleReferenceLabel1;
    private javax.swing.JLabel mScaleReferenceLabel2;
    private javax.swing.JLabel mSpaceLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mSpaceSpinner;
    private javax.swing.JLabel mStringLabel;
    private javax.swing.JSeparator mStringSeparator;
    // ϐ錾̏I//GEN-END:variables


    
    /**
     * 
     */
    public void actionPerformed( ActionEvent e )
    {
    	super.actionPerformed(e);
    	
		Object source = e.getSource();
		String command = e.getActionCommand();

    	if( source.equals( this.mLineVisibleCheckBox ) )
    	{
    		this.setLineComponentEnabled( this.mLineVisibleCheckBox.isSelected() );
    	}
    }

    
	/**
	 * 
	 * @return
	 */
	public Number getLeftXValue()
	{
		return this.getNumber( this.mLeftXValueTextField );
	}

	
	/**
	 * 
	 * @return
	 */
	public Number getLeftYValue()
	{
		return this.getNumber( this.mLeftYValueTextField );
	}


	/**
	 * 
	 * @return
	 */
	public Number getRightXValue()
	{
		return this.getNumber( this.mRightXValueTextField );
	}

	
	/**
	 * 
	 * @return
	 */
	public Number getRightYValue()
	{
		return this.getNumber( this.mRightYValueTextField );
	}

	
	/**
	 * 
	 * @return
	 */
	public Number getHorizontalYValue()
	{
		return this.getNumber( this.mHorizontalYValueTextField );
	}
	
	
	/**
	 * 
	 * @return
	 */
	public boolean getLineVisible()
	{
		return this.mLineVisibleCheckBox.isSelected();
	}

	
	/**
	 * 
	 */
	public Number getSpace()
	{
		return this.mSpaceSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Number getFontSize()
	{
		return this.mFontSizeSpinner.getNumber();
	}
	
	
	/**
	 * 
	 */
	public String getFontName()
	{
		return (String)this.mFontNameComboBox.getSelectedItem();
	}
	

	/**
	 * 
	 */
	public int getFontStyle()
	{
		final String item = (String)this.mFontStyleComboBox.getSelectedItem();
		return SGUtilityText.getFontStyle(item);
	}
	
	
	/**
	 * 
	 */
	public ArrayList getTextColorList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mColorButton.getBackground() );
		return list;
	}


	/**
	 * 
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}

	

	/**
	 * 
	 * @param value
	 */
	public void setLeftXValue( final double value )
	{
		this.mLeftXValueTextField.setText( Double.toString(value) );
	}

	
	/**
	 * 
	 * @param value
	 */
	public void setLeftYValue( final double value )
	{
		this.mLeftYValueTextField.setText( Double.toString(value) );
	}

	
	/**
	 * 
	 * @param value
	 */
	public void setRightXValue( final double value )
	{
		this.mRightXValueTextField.setText( Double.toString(value) );
	}

	
	/**
	 * 
	 * @param value
	 */
	public void setRightYValue( final double value )
	{
		this.mRightYValueTextField.setText( Double.toString(value) );
	}

	
	/**
	 * 
	 * @param value
	 */
	public void setHorizontalYValue( final double value )
	{
		this.mHorizontalYValueTextField.setText( Double.toString(value) );
	}

	
	/**
	 * 
	 * @param b
	 */
	public void setLineVisible( final boolean b )
	{
		this.mLineVisibleCheckBox.setSelected(b);
	}


	/**
	 * 
	 * @param b
	 */
	private void setLineComponentEnabled( final boolean b )
	{
		this.mLineWidthLabel2.setEnabled(b);
		this.mLineWidthSpinner.setEnabled(b);
	}
	
	
	/**
	 * 
	 */
	public boolean setSpace( final float space )
	{
		this.mSpaceSpinner.setValue( new Double(space) );
		return true;
	}



	/**
	 * 
	 */
	public boolean setFontSize( final float size )
	{
		this.mFontSizeSpinner.setValue( new Double(size) );
		return true;
	}
	
	
	/**
	 * 
	 */
	public boolean setFontName( final String name )
	{
		this.mFontNameComboBox.setSelectedItem( name );
		return true;
	}
	
	
	/**
	 * 
	 */
	public boolean setFontStyle( final int style )
	{
		final String styleName = SGUtilityText.getFontStyleName( style );
		this.mFontStyleComboBox.setSelectedItem( styleName );
		return true;
	}


	/**
	 * 
	 */
	public boolean setColorList( final ArrayList cList )
	{
		if( cList==null )
		{
			return false;
		}
		if( cList.size()==0 )
		{
			return false;
		}
		Color cl = (Color)cList.get(0);
		this.mColorButton.setBackground( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float width )
	{
		this.mLineWidthSpinner.setValue( new Double(width) );
		return true;
	}
	
	
	
	/**
	 * 
	 */
	public ArrayList getColorSelectionComponentList()
	{
		final ArrayList list = new ArrayList();
		list.add( this.mColorButton );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		final ArrayList list = this.getActiveComponentListFromSpinners();
		list.add( this.mLeftXValueTextField );
		list.add( this.mLeftYValueTextField );
		list.add( this.mRightXValueTextField );
		list.add( this.mRightYValueTextField );
		list.add( this.mHorizontalYValueTextField );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mFontSizeSpinner );
		list.add( this.mSpaceSpinner );
		list.add( this.mLineWidthSpinner );
		return list;
	}



	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGSignificantDifferenceSymbolDialog.TITLE );


		//
		{
			final String fontArray[] = SGUtility.getAvailableFontNames();
			for(int ii=0 ; ii<fontArray.length ; ii++)
			{
				this.mFontNameComboBox.addItem( fontArray[ii] );
			}
	
			final String[] styleNameArray = {
				SGIConstants.FONT_PLAIN,
				SGIConstants.FONT_ITALIC,
				SGIConstants.FONT_BOLD,
				SGIConstants.FONT_BOLD_ITALIC
			};
			for( int ii=0; ii<styleNameArray.length; ii++ )
			{
				this.mFontStyleComboBox.addItem( styleNameArray[ii] );
			}
	
		}
	
		this.pack();

		
		//
		// create a button group
		//
		
		{
			ButtonGroup bg = new ButtonGroup();
			bg.add( this.mLeftBottomRadioButton );
			bg.add( this.mLeftTopRadioButton );
			bg.add( this.mRightBottomRadioButton );
			bg.add( this.mRightTopRadioButton );
			bg.add( this.mNoAxisSelectionRadioButton );
		}
	
	
		//
		// spinner model
		//

		// spinner
		this.mSpaceSpinner.initProperties(
			new SpinnerNumberModel( 0.1, -1.0, 1.0, 0.05 ),
			SGSpinner.SPINNER_UNIT_CM );
	
		// font size
		this.mFontSizeSpinner.initProperties(
			this.getFontSizeSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );
	
		// line width
		this.mLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );

		
//		this.mLeftXValueTextField.addActionListener(this);
//		this.mLeftYValueTextField.addActionListener(this);
//		this.mRightXValueTextField.addActionListener(this);
//		this.mRightYValueTextField.addActionListener(this);
//		this.mHorizontalYValueTextField.addActionListener(this);
		
		this.mLineVisibleCheckBox.addActionListener(this);
		

		// FύX{^ɃANVXiǉ
		this.mColorButton.addActionListener(this);
	
	
		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mColorButton;
	
		
{
	this.mOKButton.addActionListener(this);
	this.mCancelButton.addActionListener(this);
	this.mPreviewButton.addActionListener(this);
}

	
		return true;
	}
	
	
	
	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener listener )
	{
		// OK,Cancel,Preview
		this.mOKButton.addActionListener(listener);
		this.mCancelButton.addActionListener(listener);
		this.mPreviewButton.addActionListener(listener);

		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener( listener );
		}
		
		this.mLeftXValueTextField.addActionListener( listener );
		this.mLeftYValueTextField.addActionListener( listener );
		this.mRightXValueTextField.addActionListener( listener );
		this.mRightYValueTextField.addActionListener( listener );
		this.mHorizontalYValueTextField.addActionListener( listener );

		return true;
	}
	

	/**
	 * 
	 */
	public boolean removeActionListener()
	{
		ActionListener[] array = this.mOKButton.getActionListeners();
		for( int ii=0; ii<array.length; ii++ )
		{
			this.mOKButton.removeActionListener( array[ii] );
			this.mCancelButton.removeActionListener( array[ii] );
			this.mPreviewButton.removeActionListener( array[ii] );

			final ArrayList sList = this.getSpinnerList();
			for( int jj=0; jj<sList.size(); jj++ )
			{
				SGSpinner spinner = (SGSpinner)sList.get(jj);
				spinner.getFormattedTextField().removeActionListener( array[ii] );
			}

			this.mLeftXValueTextField.removeActionListener( array[ii] );
			this.mLeftYValueTextField.removeActionListener( array[ii] );
			this.mRightXValueTextField.removeActionListener( array[ii] );
			this.mRightYValueTextField.removeActionListener( array[ii] );
			this.mHorizontalYValueTextField.removeActionListener( array[ii] );
		}

		return true;
	}



	/**
	 * 
	 */
	public SGSignificantDifferenceElement.SigDiffPropertiesWithAxes getProperties()
	{

		SGSignificantDifferenceElement.SigDiffPropertiesWithAxes p
			= new SGSignificantDifferenceElement.SigDiffPropertiesWithAxes();

		Color col = this.mColorButton.getBackground();
		p.setColor( col );
		
		
		Number leftX = this.getLeftXValue();
		if( leftX==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.leftXValue = leftX.doubleValue();
		}

		Number leftY = this.getLeftYValue();
		if( leftY==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.leftYValue = leftY.doubleValue();
		}


		Number rightX = this.getRightXValue();
		if( rightX==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.rightXValue = rightX.doubleValue();
		}

		Number rightY = this.getRightYValue();
		if( rightY==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.rightYValue = rightY.doubleValue();
		}

		
		Number horizontalY = this.getHorizontalYValue();
		if( horizontalY==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.horizontalYValue = horizontalY.doubleValue();
		}

		
		Number space = this.getSpace();
		if( space==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.space = space.floatValue()/SGIConstants.CM_POINT_RATIO;
		}

		Number fontSize = this.getFontSize();
		if( fontSize==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.fontSize = fontSize.floatValue();
		}

		p.fontName = this.getFontName();
		p.fontStyle = this.getFontStyle();

		
		final boolean lineVisible = this.getLineVisible();
		p.lineVisible = lineVisible;

		
		Number lineWidth = this.getLineWidth();
		if( lineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.lineWidth = lineWidth.floatValue();
		}


		return p;

	}

	
	
	/**
	 * 
	 * @return
	 */
	public String getXAxisLocation()
	{
		String str = null;
		if( this.mLeftBottomRadioButton.isSelected() || this.mRightBottomRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_BOTTOM;
		}
		else if( this.mLeftTopRadioButton.isSelected() || this.mRightTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_TOP;
		}
		return str;
	}
	

	
	/**
	 * 
	 * @return
	 */
	public String getYAxisLocation()
	{
		String str = null;
		if( this.mLeftBottomRadioButton.isSelected() || this.mLeftTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_LEFT;
		}
		else if( this.mRightBottomRadioButton.isSelected() || this.mRightTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_RIGHT;
		}
		return str;
	}


	
	/**
	 * 
	 */
	private JRadioButton mNoAxisSelectionRadioButton = new JRadioButton();

    
	/**
	 * 
	 */
	public boolean setAxisRadioButton( final int configX, final int configY )
	{

		switch( configX )
		{
			case SGIAxisElement.AXIS_HORIZONTAL_1 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftBottomRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightBottomRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			case SGIAxisElement.AXIS_HORIZONTAL_2 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftTopRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightTopRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			default :
			{
				return false;
			}
		}

		return true;
	}

	
}

