
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JPanel;


/**
 * A panel class holding an Image object.
 */
public class SGImagePanel extends JPanel
{

	/**
	 * An object of the image.
	 */
	private Image mImage = null;


	/**
	 * Location of the image.
	 */
	private Point mLocation = new Point();


	/**
	 *  
	 *
	 */
	public SGImagePanel()
	{
		super();
	}


	/**
	 * 
	 * @param image
	 */
	public SGImagePanel( Image image )
	{
		super();
		this.setImage(image);
	}


	/**
	 * 
	 * @param image
	 */
	public SGImagePanel( Image image, final int x, final int y )
	{
		super();
		this.setImage(image);
		this.setImageLocation(x,y);
	}


	/**
	 * 
	 * @param x
	 * @param y
	 * @return
	 */
	public boolean setImageLocation( final int x, final int y )
	{
		this.mLocation.x = x;
		this.mLocation.y = y;
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public Point getImageLocation()
	{
		return this.mLocation;
	}



	/**
	 * 
	 * @param image
	 * @return
	 */
	public boolean setImage( final Image image )
	{
		this.mImage = image;
		return true;
	}



	/**
	 * Returns the image.
	 * @return
	 */
	public Image getImage()
	{
		return this.mImage;
	}


	/**
	 * 
	 */
	public void paintComponent( Graphics g )
	{
		if( mImage == null )
		{
			return;
		}
		
		super.paintComponent(g);

		// draw the image
		final int width = mImage.getWidth( this );
		final int height = mImage.getHeight( this );
		g.drawImage(
			mImage,
			this.mLocation.x,
			this.mLocation.y,
			width,
			height,
			this
		);
	}


}
