/*
 * 쐬: 2004/06/29
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGFileChooser;


/**
 * @author kuromaru
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public abstract class SGFileChooserWizardDialog extends SGWizardDialog
{

	/**
	 * File chooser dialog.
	 */
	protected JFileChooser mFileChooser = new SGFileChooser();


	/**
	 * 
	 */
	public SGFileChooserWizardDialog()
	{
		super();
	}


	/**
	 * Creates new form SGFileChooserWizardDialog
	 * 
	 */
	public SGFileChooserWizardDialog(java.awt.Frame parent, boolean modal)
	{
		super(parent, modal);
	}



	/**
	 * Set the selected file to the file chooser.
	 * @param f - file
	 */
	public void setSelectedFile( File f )
	{
		this.mFileChooser.setSelectedFile(f);
	}



	/**
	 * Set the file name to the file chooser.
	 * @param dir - directory name
	 * @param name - file name
	 * @return a File object
	 */
	public File setFile( String dir, String name )
	{
		if( name==null )
		{
			name = "";
		}

		// set current directory
		this.mFileChooser.setCurrentDirectory( new File(dir) );

		// create the full path name
		String path = dir + FILE_SEPARATOR + name;
		File f = new File(path);

		// set selected file
		if( f.exists() )
		{
			this.mFileChooser.setSelectedFile(f);
		}

		return f;
	}

	
	/**
	 * 
	 * @return
	 */
	public File getSelectedFile()
	{
		if( this.mFileChooser==null )
		{
			return null;
		}
		else
		{
			return this.mFileChooser.getSelectedFile();
		}
	}
	
	
	/**
	 * Sets the current file filter to the attribute.
	 * @param ff
	 */
	public void setFileFilter( FileFilter ff )
	{
		this.mFileChooser.setFileFilter(ff);
	}

	 
	 
	/**
	 * 
	 */
	long mShowFileChooserTime = 0L;


	long lastUsed()
	{
		return this.mShowFileChooserTime;
	}
	

	/**
	 * Open the file chooser dialog.
	 * @return List of selected files.
	 */
	protected ArrayList openFileChooser()
	{
		// show open dialog
		this.mShowFileChooserTime = System.currentTimeMillis();
		int ret = this.mFileChooser.showOpenDialog(this);

		// get selected files
		ArrayList fileList = new ArrayList();
		switch( ret )
		{
			// selected
			case JFileChooser.APPROVE_OPTION :
			{
				if( this.mFileChooser.isMultiSelectionEnabled() )
				{
					File[] files = this.mFileChooser.getSelectedFiles();
					for( int ii=0; ii<files.length; ii++ )
					{
						fileList.add( files[ii] );
					}
				}
				else
				{
					fileList.add( this.mFileChooser.getSelectedFile() );
				}
				break;
			}

			// canceled
			case JFileChooser.CANCEL_OPTION :
			{
				break;
			}

			// error
			case JFileChooser.ERROR_OPTION :
			{
				return null;
			}

			default :
			{
				
			}
		}

		
		return fileList;

	}



}
