/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGStringElementDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SGStringElement
extends SGFigureElement
implements SGIStringElement,
SGIStringConstants,
CaretListener,
ActionListener {
    private SGIAxisElement mAxisElement = null;
    private ArrayList mLabelElementList = new ArrayList();
    private LabelElement mEditedLabelElement = null;
    private int mFocusedX = 0;
    private int mFocusedY = 0;
    private float mFrameLineWidth = 1.0f;
    private JTextField mEditField = null;
    public static final int BOUNDARY_LINE_WIDTH = 6;
    private Point mPressedPoint = null;
    private SGStringElementDialog mDialog = null;

    public SGStringElement() {
        this.initEditField();
    }

    public String toString() {
        return new String("SGStringElement");
    }

    private boolean initEditField() {
        JTextField jTextField = this.mEditField = new JTextField(10);
        this.setLayout(null);
        this.add(jTextField);
        jTextField.setVisible(false);
        jTextField.addActionListener(this);
        jTextField.addCaretListener(this);
        return true;
    }

    public void setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
    }

    public boolean addString(int n, int n2) {
        if (!this.getGraphRect().contains(n, n2)) {
            return false;
        }
        this.clearFocusedObjects();
        this.mFocusedX = n;
        this.mFocusedY = n2;
        JTextField jTextField = this.mEditField;
        jTextField.setVisible(true);
        int n3 = SGUtilityText.getFontStyle("Plain");
        Font font = new Font("Serif", n3, (int)(this.mMagnification * 16.0f));
        jTextField.setFont(font);
        Rectangle2D rectangle2D = font.getStringBounds("   ", new FontRenderContext(null, false, false));
        int n4 = this.mFocusedX - this.mEditField.getInsets().left;
        int n5 = this.mFocusedY - (int)(this.mMagnification * 16.0f / 2.0f);
        int n6 = (int)(rectangle2D.getWidth() + (double)(this.mMagnification * 16.0f));
        int n7 = (int)(rectangle2D.getHeight() + (double)(this.mMagnification * 16.0f));
        jTextField.setLocation(n4, n5);
        jTextField.setSize(n6, n7);
        jTextField.setText("");
        jTextField.requestFocus();
        this.repaint();
        return true;
    }

    public void paintComponent(Graphics graphics) {
        JTextField jTextField;
        Cloneable cloneable;
        LabelElement labelElement;
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        ArrayList arrayList = this.getVisibleStringElementList();
        for (n = 0; n < arrayList.size(); ++n) {
            labelElement = (LabelElement)arrayList.get(n);
            labelElement.drawString(graphics2D);
            if (!labelElement.mFrameFlag) continue;
            labelElement.drawBoundingBox(graphics2D);
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < arrayList.size(); ++n) {
                labelElement = (LabelElement)arrayList.get(n);
                cloneable = labelElement.getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsChildObject(cloneable, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList arrayList2 = new ArrayList();
            this.getFocusedObjectsList(arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                cloneable = (LabelElement)arrayList2.get(i);
                ArrayList arrayList3 = ((LabelElement)cloneable).getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsFocusedObject(arrayList3, graphics2D);
            }
        }
        if ((jTextField = this.mEditField).isVisible()) {
            graphics2D.setPaint(Color.GRAY);
            graphics2D.setStroke(new BasicStroke(6.0f));
            graphics2D.draw(jTextField.getBounds());
            graphics2D.setStroke(new BasicStroke(2.0f));
            jTextField.repaint();
        }
    }

    protected ArrayList getVisibleStringElementList() {
        ArrayList<LabelElement> arrayList = new ArrayList<LabelElement>();
        for (int i = 0; i < this.mLabelElementList.size(); ++i) {
            LabelElement labelElement = (LabelElement)this.mLabelElementList.get(i);
            if (!labelElement.isVisible()) continue;
            arrayList.add(labelElement);
        }
        return arrayList;
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleStringElementList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList2.get(i);
            if (!sGISelectable.isSelected()) continue;
            arrayList.add(sGISelectable);
        }
        return true;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        LabelElement labelElement = (LabelElement)sGISelectable;
        labelElement.setVisible(false);
        return true;
    }

    private boolean setVisibleStringElement(ArrayList arrayList) {
        return this.setVisibleDrawingElement(this.mLabelElementList, arrayList);
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIGraphElement || sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGILegendElement)) {
            if (sGIFigureElement instanceof SGIAxisElement) {
                SGIAxisElement sGIAxisElement = (SGIAxisElement)sGIFigureElement;
                bl = this.synchronizedToAxisElement(sGIAxisElement);
            } else if (!(sGIFigureElement instanceof SGIAxisBreakElement || sGIFigureElement instanceof SGISignificantDifferenceElement || sGIFigureElement instanceof SGITimingLineElement)) {
                bl = sGIFigureElement.synchronizeArgument(this);
            }
        }
        return bl;
    }

    private boolean synchronizedToAxisElement(SGIAxisElement sGIAxisElement) {
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error();
    }

    public boolean zoom(float f) {
        if (!this.terminateEditField()) {
            return false;
        }
        if (!super.zoom(f)) {
            return false;
        }
        for (int i = 0; i < this.mLabelElementList.size(); ++i) {
            LabelElement labelElement = (LabelElement)this.mLabelElementList.get(i);
            labelElement.zoom(f);
        }
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        if (!super.setGraphRect(f, f2, f3, f4)) {
            return false;
        }
        if (!this.terminateEditField()) {
            return false;
        }
        for (int i = 0; i < this.mLabelElementList.size(); ++i) {
            LabelElement labelElement = (LabelElement)this.mLabelElementList.get(i);
            labelElement.updateDrawingElements();
        }
        return true;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        Cloneable cloneable;
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        Rectangle2D rectangle2D = this.getGraphRect();
        ArrayList arrayList = this.getVisibleStringElementList();
        ArrayList<Rectangle2D> arrayList2 = new ArrayList<Rectangle2D>();
        for (int i = 0; i < arrayList.size(); ++i) {
            cloneable = (LabelElement)arrayList.get(i);
            arrayList2.add(((SGDrawingElementString2DExtended)((Object)cloneable)).getElementBounds());
        }
        if (arrayList2.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D2 = SGUtility.createUnion(arrayList2);
        cloneable = new ArrayList();
        ((ArrayList)cloneable).add(rectangle2D);
        ((ArrayList)cloneable).add(rectangle2D2);
        Rectangle2D rectangle2D3 = SGUtility.createUnion((ArrayList)cloneable);
        float f = (float)(rectangle2D.getY() - rectangle2D3.getY());
        float f2 = (float)(rectangle2D3.getY() + rectangle2D3.getHeight() - (rectangle2D.getY() + rectangle2D.getHeight()));
        float f3 = (float)(rectangle2D.getX() - rectangle2D3.getX());
        float f4 = (float)(rectangle2D3.getX() + rectangle2D3.getWidth() - (rectangle2D.getX() + rectangle2D.getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        if (!super.onMouseClicked(mouseEvent)) {
            return false;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        boolean bl = this.onEdge(n, n2);
        ArrayList arrayList = this.getVisibleStringElementList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            if (bl && labelElement.equals(this.mEditedLabelElement)) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 2) {
                    JDialog jDialog = labelElement.getDialog();
                    jDialog.setVisible(true);
                    this.hideEditField();
                }
                return true;
            }
            if (!labelElement.contains(n, n2)) continue;
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (n3 == 1) {
                    if (labelElement.isSelected()) {
                        this.mEditedLabelElement = labelElement;
                        this.mFocusedX = (int)labelElement.getX();
                        this.mFocusedY = (int)labelElement.getY();
                        this.showEditField(labelElement);
                    } else {
                        this.updateFocusedObjectsList(labelElement, mouseEvent);
                    }
                }
            } else if (SwingUtilities.isRightMouseButton(mouseEvent) & n3 == 1) {
                JPopupMenu jPopupMenu = labelElement.getPopupMenu();
                jPopupMenu.show(this, n, n2);
            }
            return true;
        }
        return false;
    }

    private boolean terminateEditField() {
        return !(this.mEditedLabelElement == null ? !this.addStringElementFromTextField() : !this.commitEdit());
    }

    private boolean commitEdit() {
        String string = this.mEditedLabelElement.getString();
        String string2 = this.mEditField.getText();
        if (SGUtilityText.isValidString(string2)) {
            this.mEditedLabelElement.setString(string2);
            if (!string.equals(string2)) {
                this.mEditedLabelElement.setChanged(true);
                this.notifyToRoot();
            }
        }
        this.mEditedLabelElement = null;
        this.hideEditField();
        this.repaint();
        return true;
    }

    private boolean hideEditField() {
        this.mEditField.setText("");
        this.mEditField.setVisible(false);
        return true;
    }

    private boolean showEditField(LabelElement labelElement) {
        JTextField jTextField = this.mEditField;
        Rectangle2D rectangle2D = labelElement.getElementBounds();
        Rectangle2D rectangle2D2 = labelElement.getStringRect();
        float f = labelElement.getMagnification() * labelElement.getFontSize();
        int n = (int)(rectangle2D.getX() - (double)jTextField.getInsets().left);
        int n2 = (int)(rectangle2D.getY() - (double)(f / 2.0f));
        int n3 = (int)(rectangle2D2.getWidth() + (double)f);
        int n4 = (int)(rectangle2D2.getHeight() + (double)f);
        jTextField.setLocation(n, n2);
        jTextField.setSize(n3, n4);
        jTextField.setFont(new Font(labelElement.getFontName(), labelElement.getFontStyle(), (int)f));
        jTextField.setForeground(labelElement.getColor(0));
        jTextField.setText(labelElement.getString());
        jTextField.setVisible(true);
        jTextField.requestFocus();
        jTextField.setCaretPosition(0);
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        int n;
        if (!super.onMousePressed(mouseEvent)) {
            return false;
        }
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        ArrayList arrayList = this.getFocusedObjectsList();
        ArrayList arrayList2 = this.getVisibleStringElementList();
        boolean bl = false;
        for (n = arrayList2.size() - 1; n >= 0; --n) {
            LabelElement labelElement = (LabelElement)arrayList2.get(n);
            if (!labelElement.contains(n2, n3)) continue;
            labelElement.mFrameFlag = true;
            if (arrayList.contains(labelElement)) {
                this.mPressedPoint = mouseEvent.getPoint();
                labelElement.mTemporaryProperties = labelElement.getProperties();
            }
            bl = true;
            break;
        }
        if (bl) {
            this.setMouseCursor(13);
        } else {
            n = this.onEdge(n2, n3) ? 1 : 0;
            if (this.mEditedLabelElement != null && n != 0) {
                bl = true;
            } else if (this.mEditField.isVisible()) {
                this.terminateEditField();
            }
        }
        return bl;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (!super.onMouseDragged(mouseEvent)) {
            return false;
        }
        int n = mouseEvent.getX() - this.mPressedPoint.x;
        int n2 = mouseEvent.getY() - this.mPressedPoint.y;
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            labelElement.translate(n, n2);
        }
        this.mPressedPoint = mouseEvent.getPoint();
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        if (!super.onMouseReleased(mouseEvent)) {
            return false;
        }
        ArrayList arrayList = this.getFocusedObjectsList();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            Rectangle2D rectangle2D = labelElement.getElementBounds();
            bl |= rectangle2D.contains(mouseEvent.getPoint());
        }
        if (bl) {
            this.setMouseCursor(12);
        } else {
            this.setMouseCursor(0);
        }
        return true;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            labelElement.mTemporaryProperties = labelElement.getProperties();
        }
        return true;
    }

    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            SGProperties sGProperties = labelElement.mTemporaryProperties;
            SGProperties sGProperties2 = labelElement.getProperties();
            if (sGProperties2.equals(sGProperties)) continue;
            labelElement.setChanged(true);
        }
        return true;
    }

    public boolean onEdge(int n, int n2) {
        if (!this.mEditField.isVisible()) {
            return false;
        }
        Rectangle rectangle = this.mEditField.getBounds();
        int n3 = rectangle.x - 6;
        int n4 = rectangle.y - 6;
        int n5 = rectangle.width + 12;
        int n6 = rectangle.height + 12;
        Rectangle rectangle2 = new Rectangle(n3, n4, n5, n6);
        boolean bl = rectangle.contains(n, n2);
        boolean bl2 = rectangle2.contains(n, n2);
        boolean bl3 = !bl & bl2;
        return bl3;
    }

    public boolean isResizable(double d, double d2) {
        for (int i = 0; i < this.mLabelElementList.size(); ++i) {
            LabelElement labelElement = (LabelElement)this.mLabelElementList.get(i);
            Rectangle2D rectangle2D = labelElement.getElementBounds();
            if (!(d < rectangle2D.getWidth()) && !(d2 < rectangle2D.getHeight())) continue;
            return false;
        }
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        for (int i = this.mLabelElementList.size() - 1; i >= 0; --i) {
            LabelElement labelElement = (LabelElement)this.mLabelElementList.get(i);
            boolean bl = labelElement.contains(n, n2);
            labelElement.mFrameFlag = bl;
            if (!bl) continue;
            this.setMouseCursor(12);
            this.repaint();
            return true;
        }
        this.setMouseCursor(0);
        this.repaint();
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mEditField)) {
            this.terminateEditField();
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        float f;
        Cloneable cloneable;
        JTextField jTextField = this.mEditField;
        String string = jTextField.getText();
        Font font = null;
        if (this.mEditedLabelElement != null) {
            cloneable = this.mEditedLabelElement;
            f = ((SGDrawingElementString)((Object)cloneable)).getFontSize();
            font = new Font(((SGDrawingElementString)((Object)cloneable)).getFontName(), ((SGDrawingElementString)((Object)cloneable)).getFontStyle(), (int)(((SGDrawingElement)((Object)cloneable)).getMagnification() * f));
        } else {
            f = 16.0f;
            font = new Font("Serif", SGUtilityText.getFontStyle("Plain"), (int)(this.mMagnification * f));
        }
        cloneable = font.getStringBounds(string, new FontRenderContext(null, false, false));
        double d = ((RectangularShape)cloneable).getWidth();
        if (d > (double)jTextField.getWidth()) {
            jTextField.setSize((int)(((RectangularShape)cloneable).getWidth() + (double)(this.mMagnification * f)), jTextField.getHeight());
        }
        this.repaint();
    }

    private boolean addStringElementFromTextField() {
        String string = this.mEditField.getText();
        if (SGUtilityText.isValidString(string)) {
            LabelElement labelElement = new LabelElement(this.mEditField.getText());
            labelElement.setMagnification(this.mMagnification);
            labelElement.setLocation(this.mFocusedX, this.mFocusedY);
            SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
            SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
            labelElement.mXAxis = sGAxis;
            labelElement.mYAxis = sGAxis2;
            this.mLabelElementList.add(labelElement);
            labelElement.initPropertiesHistory();
            this.setChanged(true);
            this.notifyToRoot();
        }
        this.hideEditField();
        this.repaint();
        return true;
    }

    private boolean removeString(LabelElement labelElement) {
        for (int i = this.mLabelElementList.size() - 1; i >= 0; --i) {
            LabelElement labelElement2 = (LabelElement)this.mLabelElementList.get(i);
            if (!labelElement2.equals(labelElement)) continue;
            this.mLabelElementList.remove(labelElement);
            return true;
        }
        return false;
    }

    private boolean moveLabelToFront(LabelElement labelElement) {
        return this.moveObjectToFront(labelElement, this.mLabelElementList);
    }

    private boolean moveLabelToBack(LabelElement labelElement) {
        return this.moveObjectToBack(labelElement, this.mLabelElementList);
    }

    private boolean hideLabel(LabelElement labelElement) {
        return this.hideObject(labelElement);
    }

    public String getTagName() {
        return "Labels";
    }

    public Element createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        ArrayList arrayList = this.getVisibleStringElementList();
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            Element element2 = labelElement.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return element;
    }

    public boolean writeProperty(Element element) {
        return true;
    }

    public boolean readProperty(Element element) {
        NodeList nodeList = element.getElementsByTagName("Label");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            LabelElement labelElement = new LabelElement();
            Element element2 = (Element)node;
            if (!labelElement.readProperty(element2)) {
                return false;
            }
            labelElement.initPropertiesHistory();
            this.mLabelElementList.add(labelElement);
        }
        return true;
    }

    public boolean undo() {
        boolean bl = super.undo();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChange();
        return true;
    }

    public boolean redo() {
        boolean bl = super.redo();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChange();
        return true;
    }

    public boolean updateHistory() {
        return this.updateHistory_(this.getVisibleStringElementList());
    }

    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        ArrayList arrayList = this.getVisibleStringElementList();
        for (int i = 0; i < arrayList.size(); ++i) {
            LabelElement labelElement = (LabelElement)arrayList.get(i);
            if (!labelElement.isChanged()) continue;
            return true;
        }
        return false;
    }

    private boolean createDialog() {
        SGStringElementDialog sGStringElementDialog;
        this.mDialog = sGStringElementDialog = new SGStringElementDialog(this.mDialogOwner, true);
        return true;
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createDialog();
        return true;
    }

    public Object copy() {
        return null;
    }

    public SGProperties getProperties() {
        StringElementProperties stringElementProperties = new StringElementProperties();
        stringElementProperties.visibleStringElementList = this.getVisibleStringElementList();
        return stringElementProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof StringElementProperties)) {
            return false;
        }
        StringElementProperties stringElementProperties = (StringElementProperties)sGProperties;
        this.setVisibleStringElement(stringElementProperties.visibleStringElementList);
        return true;
    }

    public static class StringElementProperties
    extends SGProperties {
        ArrayList visibleStringElementList = new ArrayList();

        public boolean equals(Object object) {
            if (!(object instanceof StringElementProperties)) {
                return false;
            }
            StringElementProperties stringElementProperties = (StringElementProperties)object;
            return stringElementProperties.visibleStringElementList.equals(this.visibleStringElementList);
        }
    }

    public static class LabelProperties
    extends SGDrawingElementString.StringProperties {
        SGAxis xAxis = null;
        SGAxis yAxis = null;

        public boolean equals(Object object) {
            if (!(object instanceof LabelProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            LabelProperties labelProperties = (LabelProperties)object;
            if (!labelProperties.xAxis.equals(this.xAxis)) {
                return false;
            }
            return labelProperties.yAxis.equals(this.yAxis);
        }
    }

    class LabelElement
    extends SGDrawingElementString2DExtended
    implements ActionListener,
    WindowListener,
    SGIUndoable,
    SGISelectable,
    SGIMovable,
    SGICopiable {
        private boolean mSelectedFlag = false;
        protected SGAxis mXAxis = null;
        protected SGAxis mYAxis = null;
        private JPopupMenu mPopupMenu = new JPopupMenu();
        private boolean mFrameFlag = false;
        private SGProperties mTemporaryProperties = null;
        private boolean mChangedFlag = false;
        private ArrayList mStringElementPropertyHistoryList = new ArrayList();
        private int mStringElementStateCounter = 0;
        private int mCurrentStateCounter = 0;
        protected ArrayList mUndoableObjectHistoryList = new ArrayList();

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }

        protected LabelElement() {
            this.init();
        }

        protected LabelElement(String string) {
            super(string);
            this.init();
        }

        private boolean init() {
            int n = SGUtilityText.getFontStyle("Plain");
            if (n == -1) {
                return false;
            }
            this.setFont("Serif", n, 16.0f);
            this.setAngle(0.0f);
            this.setColor(SGDefaultValues.LABEL_COLOR);
            this.createPopupMenu();
            return true;
        }

        public Object copy() {
            LabelElement labelElement = new LabelElement();
            labelElement.setProperties(this.getProperties());
            labelElement.setLocation(this.getX(), this.getY());
            labelElement.setMagnification(this.mMagnification);
            return labelElement;
        }

        protected LabelElement(LabelElement labelElement) {
            super(labelElement);
            this.mX = labelElement.mX;
            this.mY = labelElement.mY;
            this.mMagnification = labelElement.mMagnification;
            this.updateDrawingElements();
            this.createPopupMenu();
        }

        private double getXValue() {
            SGAxis sGAxis = this.mXAxis;
            double d = SGStringElement.this.calcValue(this.getX(), sGAxis, true);
            d = SGStringElement.this.getNumberInRangeOrder(d, sGAxis);
            return d;
        }

        private double getYValue() {
            SGAxis sGAxis = this.mYAxis;
            double d = SGStringElement.this.calcValue(this.getY(), sGAxis, false);
            d = SGStringElement.this.getNumberInRangeOrder(d, sGAxis);
            return d;
        }

        public void translate(int n, int n2) {
            this.setLocation(this.getX() + (float)n, this.getY() + (float)n2);
        }

        private void drawBoundingBox(Graphics2D graphics2D) {
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setPaint(Color.BLACK);
            graphics2D.draw(this.getElementBounds());
        }

        private ArrayList getAnchorPointList() {
            ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
            Rectangle2D rectangle2D = this.getElementBounds();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getWidth();
            float f4 = (float)rectangle2D.getHeight();
            Point2D.Float float_ = new Point2D.Float(f, f2);
            Point2D.Float float_2 = new Point2D.Float(f, f2 + f4);
            Point2D.Float float_3 = new Point2D.Float(f + f3, f2);
            Point2D.Float float_4 = new Point2D.Float(f + f3, f2 + f4);
            arrayList.add(float_);
            arrayList.add(float_2);
            arrayList.add(float_3);
            arrayList.add(float_4);
            return arrayList;
        }

        private boolean createPopupMenu() {
            this.mPopupMenu.setBounds(0, 0, 100, 100);
            JMenuItem jMenuItem = new JMenuItem("Move to Front");
            jMenuItem.addActionListener(this);
            this.mPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Move to Back");
            jMenuItem.addActionListener(this);
            this.mPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Delete");
            jMenuItem.addActionListener(this);
            this.mPopupMenu.add(jMenuItem);
            this.mPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Property");
            jMenuItem.addActionListener(this);
            this.mPopupMenu.add(jMenuItem);
            return true;
        }

        private JPopupMenu getPopupMenu() {
            return this.mPopupMenu;
        }

        private JDialog getDialog() {
            SGStringElement.this.mDialog.setActionListener(this);
            SGStringElement.this.mDialog.addWindowListener(this);
            SGStringElement.this.mDialog.setLocation(SGStringElement.this.mDialogOwner.getLocation());
            this.mFrameFlag = true;
            SGStringElement.this.mDialog.setColorButtonBorder(true);
            this.setDialogProperty();
            this.mTemporaryProperties = this.getProperties();
            SGStringElement.this.mEditField.setVisible(false);
            return SGStringElement.this.mDialog;
        }

        public String getTagName() {
            return "Label";
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            String string = "cm";
            String string2 = "pt";
            String string3 = SGIConstants.degree;
            element.setAttribute("XAxisPosition", SGStringElement.this.mAxisElement.getAxisLocation(this.mXAxis));
            element.setAttribute("YAxisPosition", SGStringElement.this.mAxisElement.getAxisLocation(this.mYAxis));
            element.setAttribute("XValue", Double.toString(this.getXValue()));
            element.setAttribute("YValue", Double.toString(this.getYValue()));
            element.setAttribute("Text", this.getString());
            element.setAttribute("FontName", this.getFontName());
            element.setAttribute("FontSize", Float.toString(this.getFontSize()) + string2);
            element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.getFontStyle()));
            element.setAttribute("StringColor", SGUtilityText.getColorListString(this.getColorList()));
            element.setAttribute("Angle", Float.toString(this.getAngle() / ((float)Math.PI / 180)) + string3);
            return true;
        }

        public boolean readProperty(Element element) {
            SGDrawingElementString.StringProperties stringProperties = this.readProperty_(element);
            if (stringProperties == null) {
                return false;
            }
            return this.setProperties(stringProperties);
        }

        private SGDrawingElementString.StringProperties readProperty_(Element element) {
            String string = SGIConstants.degree;
            String string2 = null;
            Number number = null;
            Object var8_5 = null;
            Object var9_6 = null;
            ArrayList arrayList = null;
            string2 = element.getAttribute("XAxisPosition");
            if (string2.length() == 0) {
                return null;
            }
            SGAxis sGAxis = SGStringElement.this.mAxisElement.getAxis(string2);
            string2 = element.getAttribute("YAxisPosition");
            if (string2.length() == 0) {
                return null;
            }
            SGAxis sGAxis2 = SGStringElement.this.mAxisElement.getAxis(string2);
            string2 = element.getAttribute("XValue");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getDouble(string2);
            if (number == null) {
                return null;
            }
            double d = number.doubleValue();
            float f = SGStringElement.this.calcLocation(d, sGAxis, true);
            float f2 = (f - SGStringElement.this.mGraphRectX) / this.mMagnification;
            string2 = element.getAttribute("YValue");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getDouble(string2);
            if (number == null) {
                return null;
            }
            double d2 = number.doubleValue();
            float f3 = SGStringElement.this.calcLocation(d2, sGAxis2, false);
            float f4 = (f3 - SGStringElement.this.mGraphRectY) / this.mMagnification;
            string2 = element.getAttribute("Text");
            if (string2.length() == 0) {
                return null;
            }
            String string3 = string2;
            string2 = element.getAttribute("FontName");
            if (string2.length() == 0) {
                return null;
            }
            String string4 = string2;
            string2 = element.getAttribute("FontSize");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getFloat(string2, "pt");
            if (number == null) {
                return null;
            }
            float f5 = number.floatValue();
            string2 = element.getAttribute("FontStyle");
            if (string2.length() == 0) {
                return null;
            }
            int n = SGUtilityText.getFontStyle(string2);
            if (n == -1) {
                return null;
            }
            string2 = element.getAttribute("StringColor");
            if (string2.length() == 0) {
                return null;
            }
            arrayList = SGUtilityText.getColorList(string2);
            if (arrayList == null) {
                return null;
            }
            ArrayList arrayList2 = arrayList;
            string2 = element.getAttribute("Angle");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getFloat(string2, string);
            if (number == null) {
                return null;
            }
            float f6 = number.floatValue() * ((float)Math.PI / 180);
            LabelProperties labelProperties = new LabelProperties();
            labelProperties.setX(f2);
            labelProperties.setY(f4);
            labelProperties.setText(string3);
            labelProperties.setFontName(string4);
            labelProperties.setFontSize(f5);
            labelProperties.setFontStyle(n);
            labelProperties.setColorList(arrayList2);
            labelProperties.setAngle(f6);
            labelProperties.xAxis = sGAxis;
            labelProperties.yAxis = sGAxis2;
            labelProperties.setVisible(true);
            return labelProperties;
        }

        private LabelProperties getPropertiesFromDialog() {
            SGStringElementDialog sGStringElementDialog = SGStringElement.this.mDialog;
            LabelProperties labelProperties = sGStringElementDialog.getProperties();
            if (labelProperties == null) {
                return null;
            }
            labelProperties.setVisible(this.isVisible());
            labelProperties.setText(new String(this.mString));
            return labelProperties;
        }

        private boolean setDialogProperty() {
            SGStringElementDialog sGStringElementDialog = SGStringElement.this.mDialog;
            double d = SGStringElement.this.calcValue(this.getX(), this.mXAxis, true);
            double d2 = SGStringElement.this.calcValue(this.getY(), this.mYAxis, false);
            d = SGStringElement.this.getNumberInRangeOrder(d, this.mXAxis);
            d2 = SGStringElement.this.getNumberInRangeOrder(d2, this.mYAxis);
            sGStringElementDialog.setXValue(new Double(d));
            sGStringElementDialog.setYValue(new Double(d2));
            sGStringElementDialog.setFontSize(new Float(this.mFontSize));
            sGStringElementDialog.setFontName(this.mFontName);
            sGStringElementDialog.setFontStyle(this.mFontStyle);
            sGStringElementDialog.setAngle(new Float(this.mAngle / ((float)Math.PI / 180)));
            sGStringElementDialog.setTextColorList(this.mColorList);
            this.setDialogPropertyOfAxis();
            return true;
        }

        private boolean setDialogPropertyOfAxis() {
            int n;
            int n2;
            SGStringElementDialog sGStringElementDialog = SGStringElement.this.mDialog;
            boolean bl = sGStringElementDialog.setAxisRadioButton(n2 = SGStringElement.this.mAxisElement.getConfigurationInPlane(this.mXAxis), n = SGStringElement.this.mAxisElement.getConfigurationInPlane(this.mYAxis));
            return bl;
        }

        private boolean setPropertyWithDialog() {
            float f;
            float f2;
            SGStringElementDialog sGStringElementDialog = SGStringElement.this.mDialog;
            LabelProperties labelProperties = sGStringElementDialog.getProperties();
            if (labelProperties == null) {
                return false;
            }
            labelProperties.setVisible(this.isVisible());
            labelProperties.setText(new String(this.mString));
            String string = sGStringElementDialog.getXAxisLocation();
            SGAxis sGAxis = SGStringElement.this.mAxisElement.getAxis(string);
            String string2 = sGStringElementDialog.getYAxisLocation();
            SGAxis sGAxis2 = SGStringElement.this.mAxisElement.getAxis(string2);
            labelProperties.xAxis = sGAxis;
            labelProperties.yAxis = sGAxis2;
            Number number = sGStringElementDialog.getXValue();
            if (number == null) {
                SGUtility.showIllegalInputErrorMessageDialog(sGStringElementDialog);
                return false;
            }
            Number number2 = sGStringElementDialog.getYValue();
            if (number2 == null) {
                SGUtility.showIllegalInputErrorMessageDialog(sGStringElementDialog);
                return false;
            }
            double d = number.doubleValue();
            double d2 = number2.doubleValue();
            double d3 = SGStringElement.this.calcValue(this.getX(), sGAxis, true);
            double d4 = SGStringElement.this.calcValue(this.getY(), sGAxis2, false);
            d3 = SGStringElement.this.getNumberInRangeOrder(d3, sGAxis);
            d4 = SGStringElement.this.getNumberInRangeOrder(d4, sGAxis2);
            if (d == d3) {
                f2 = this.mX;
            } else {
                f = SGStringElement.this.calcLocation(d, sGAxis, true);
                f2 = (f - SGStringElement.this.mGraphRectX) / this.mMagnification;
            }
            if (d2 == d4) {
                f = this.mY;
            } else {
                float f3 = SGStringElement.this.calcLocation(d2, sGAxis2, false);
                f = (f3 - SGStringElement.this.mGraphRectY) / this.mMagnification;
            }
            labelProperties.setX(f2);
            labelProperties.setY(f);
            return this.setProperties(labelProperties);
        }

        public SGTuple2f getLocation() {
            float f = this.mMagnification * this.mX + SGStringElement.this.mGraphRectX;
            float f2 = this.mMagnification * this.mY + SGStringElement.this.mGraphRectY;
            return new SGTuple2f(f, f2);
        }

        public boolean setLocation(float f, float f2) {
            SGDrawingElementString sGDrawingElementString;
            int n;
            float f3 = f - this.getX();
            float f4 = f2 - this.getY();
            this.mX = (f - SGStringElement.this.mGraphRectX) / this.mMagnification;
            this.mY = (f2 - SGStringElement.this.mGraphRectY) / this.mMagnification;
            for (n = 0; n < this.mBaseElementList.size(); ++n) {
                sGDrawingElementString = (SGDrawingElementString)this.mBaseElementList.get(n);
                sGDrawingElementString.translate(f3, f4);
            }
            for (n = 0; n < this.mSubscriptElementList.size(); ++n) {
                sGDrawingElementString = (SGDrawingElementString)this.mSubscriptElementList.get(n);
                if (sGDrawingElementString == null) continue;
                sGDrawingElementString.translate(f3, f4);
            }
            for (n = 0; n < this.mSuperscriptElementList.size(); ++n) {
                sGDrawingElementString = (SGDrawingElementString)this.mSuperscriptElementList.get(n);
                if (sGDrawingElementString == null) continue;
                sGDrawingElementString.translate(f3, f4);
            }
            return true;
        }

        public SGProperties getProperties() {
            LabelProperties labelProperties = new LabelProperties();
            if (!this.getProperties(labelProperties)) {
                return null;
            }
            return labelProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof LabelProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            LabelProperties labelProperties = (LabelProperties)sGProperties;
            labelProperties.xAxis = this.mXAxis;
            labelProperties.yAxis = this.mYAxis;
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof LabelProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            LabelProperties labelProperties = (LabelProperties)sGProperties;
            this.mXAxis = labelProperties.xAxis;
            this.mYAxis = labelProperties.yAxis;
            return true;
        }

        public boolean isChanged() {
            return this.mChangedFlag;
        }

        public void setChanged(boolean bl) {
            this.mChangedFlag = bl;
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object.equals(SGStringElement.this.mDialog)) {
                this.onCanceled();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            if (string.equals("Move to Front")) {
                SGStringElement.this.moveLabelToFront(this);
            } else if (string.equals("Move to Back")) {
                SGStringElement.this.moveLabelToBack(this);
            } else if (string.equals("Delete")) {
                SGStringElement.this.hideLabel(this);
                SGStringElement.this.clearFocusedObjects();
            } else if (string.equals("Property")) {
                this.getDialog().setVisible(true);
            }
            if (string.equals("OK") || SGStringElement.this.mDialog.getActiveComponentList().contains(object) ? !this.onOK() : (string.equals("Cancel") ? !this.onCanceled() : string.equals("Preview") && !this.onPreviewed())) {
                return;
            }
            SGStringElement.this.notifyChange();
            SGStringElement.this.repaint();
        }

        private boolean onOK() {
            boolean bl = this.setPropertyWithDialog();
            if (!bl) {
                return false;
            }
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.mChangedFlag = true;
            }
            this.mTemporaryProperties = null;
            this.mFrameFlag = false;
            this.notifyToRoot();
            SGStringElement.this.notifyChange();
            SGStringElement.this.mDialog.setVisible(false);
            SGStringElement.this.mDialog.removeActionListener();
            SGStringElement.this.mDialog.removeWindowListener(this);
            return true;
        }

        private boolean onCanceled() {
            boolean bl = this.recover();
            if (!bl) {
                return false;
            }
            SGStringElement.this.notifyChange();
            this.mTemporaryProperties = null;
            SGStringElement.this.mDialog.setVisible(false);
            SGStringElement.this.mDialog.removeActionListener();
            SGStringElement.this.mDialog.removeWindowListener(this);
            return true;
        }

        private boolean onPreviewed() {
            boolean bl = this.setPropertyWithDialog();
            if (!bl) {
                return false;
            }
            SGStringElement.this.notifyChange();
            return true;
        }

        private boolean recover() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            return true;
        }

        public boolean initPropertiesHistory() {
            this.addStringPropertyHistory(this.getProperties());
            return true;
        }

        private boolean addStringPropertyHistory(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGDrawingElementString.StringProperties)) {
                return false;
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mStringElementStateCounter; ++i) {
                arrayList.add(this.mStringElementPropertyHistoryList.get(i));
            }
            arrayList.add(sGProperties);
            this.mStringElementPropertyHistoryList = arrayList;
            return true;
        }

        public boolean undo() {
            --this.mStringElementStateCounter;
            SGProperties sGProperties = (SGProperties)this.mStringElementPropertyHistoryList.get(this.mStringElementStateCounter);
            return this.setProperties(sGProperties);
        }

        public boolean redo() {
            ++this.mStringElementStateCounter;
            SGProperties sGProperties = (SGProperties)this.mStringElementPropertyHistoryList.get(this.mStringElementStateCounter);
            return this.setProperties(sGProperties);
        }

        public boolean onUndo() {
            return this.undo();
        }

        public boolean onRedo() {
            return this.redo();
        }

        public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
            ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
            arrayList.add(sGIUndoable);
            boolean bl = this.updateObjectHistory(arrayList);
            return bl;
        }

        public boolean updateObjectHistory(ArrayList arrayList) {
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.mCurrentStateCounter; ++i) {
                Object e = this.mUndoableObjectHistoryList.get(i);
                arrayList2.add(e);
            }
            arrayList2.add(new ArrayList(arrayList));
            this.mUndoableObjectHistoryList = arrayList2;
            ++this.mCurrentStateCounter;
            return true;
        }

        public boolean updateHistory() {
            if (this.isChanged()) {
                this.updateThisObjectHistory();
                this.setChanged(false);
                this.updateObjectHistory(this);
            }
            return true;
        }

        public boolean updateThisObjectHistory() {
            ++this.mStringElementStateCounter;
            this.addStringPropertyHistory(this.getProperties());
            return true;
        }

        public void notifyToRoot() {
            SGStringElement.this.notifyToRootFromFigureElement();
        }
    }
}

