/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGSignificantDifferenceElement;

public class SGSignificantDifferenceSymbolDialog
extends SGPropertyDialog {
    public static final String TITLE = "Significant Difference Symbol Properties";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JButton mColorButton;
    private JLabel mColorLabel;
    private JPanel mCommonPanel;
    private JLabel mFontFamilyLabel;
    private JComboBox mFontNameComboBox;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private JComboBox mFontStyleComboBox;
    private JLabel mFontStyleLabel;
    private JLabel mFormLabel;
    private JSeparator mFormSeparator;
    private JLabel mHorizontalYValueLabel;
    private JTextField mHorizontalYValueTextField;
    private JRadioButton mLeftBottomRadioButton;
    private JLabel mLeftSpaceLabel;
    private JRadioButton mLeftTopRadioButton;
    private JLabel mLeftXValueLabel;
    private JTextField mLeftXValueTextField;
    private JLabel mLeftYValueLabel;
    private JTextField mLeftYValueTextField;
    private JCheckBox mLineVisibleCheckBox;
    private JLabel mLineWidthLabel1;
    private JLabel mLineWidthLabel2;
    private SGSpinner mLineWidthSpinner;
    private JLabel mLocationLabel;
    private JSeparator mLocationSeparator;
    private JButton mOKButton;
    private JPanel mPanel;
    private JButton mPreviewButton;
    private JRadioButton mRightBottomRadioButton;
    private JLabel mRightSpaceLabel;
    private JRadioButton mRightTopRadioButton;
    private JLabel mRightXValueLabel;
    private JTextField mRightXValueTextField;
    private JLabel mRightYValueLabel;
    private JTextField mRightYValueTextField;
    private JLabel mScaleReferenceLabel1;
    private JLabel mScaleReferenceLabel2;
    private JLabel mSpaceLabel;
    private SGSpinner mSpaceSpinner;
    private JLabel mStringLabel;
    private JSeparator mStringSeparator;
    private JRadioButton mNoAxisSelectionRadioButton = new JRadioButton();

    public SGSignificantDifferenceSymbolDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mPanel = new JPanel();
        this.mFontFamilyLabel = new JLabel();
        this.mFontStyleComboBox = new JComboBox();
        this.mFontSizeLabel = new JLabel();
        this.mLineWidthSpinner = new SGSpinner();
        this.mColorLabel = new JLabel();
        this.mLineWidthLabel1 = new JLabel();
        this.mLineWidthLabel2 = new JLabel();
        this.mFontSizeSpinner = new SGSpinner();
        this.mFontNameComboBox = new JComboBox();
        this.mColorButton = new JButton();
        this.mFormLabel = new JLabel();
        this.mFormSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mSpaceLabel = new JLabel();
        this.mSpaceSpinner = new SGSpinner();
        this.mLocationLabel = new JLabel();
        this.mLocationSeparator = new JSeparator();
        this.mStringLabel = new JLabel();
        this.mStringSeparator = new JSeparator();
        this.mLeftXValueLabel = new JLabel();
        this.mLeftXValueTextField = new JTextField();
        this.mLeftYValueLabel = new JLabel();
        this.mLeftYValueTextField = new JTextField();
        this.mRightXValueLabel = new JLabel();
        this.mRightXValueTextField = new JTextField();
        this.mRightYValueLabel = new JLabel();
        this.mRightYValueTextField = new JTextField();
        this.mHorizontalYValueLabel = new JLabel();
        this.mHorizontalYValueTextField = new JTextField();
        this.mLineVisibleCheckBox = new JCheckBox();
        this.mFontStyleLabel = new JLabel();
        this.mCommonPanel = new JPanel();
        this.mLeftTopRadioButton = new JRadioButton();
        this.mLeftBottomRadioButton = new JRadioButton();
        this.mRightTopRadioButton = new JRadioButton();
        this.mRightBottomRadioButton = new JRadioButton();
        this.mScaleReferenceLabel2 = new JLabel();
        this.mScaleReferenceLabel1 = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new BevelBorder(0));
        this.mFontFamilyLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyLabel.setText("Family");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mFontFamilyLabel, gridBagConstraints);
        this.mFontStyleComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mFontStyleComboBox, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mPanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLineWidthSpinner, gridBagConstraints);
        this.mColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mPanel.add((Component)this.mColorLabel, gridBagConstraints);
        this.mLineWidthLabel1.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel1.setText("Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 2;
        this.mPanel.add((Component)this.mLineWidthLabel1, gridBagConstraints);
        this.mLineWidthLabel2.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel2.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mLineWidthLabel2, gridBagConstraints);
        this.mFontSizeSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mPanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mFontNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mFontNameComboBox, gridBagConstraints);
        this.mColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mPanel.add((Component)this.mColorButton, gridBagConstraints);
        this.mFormLabel.setFont(new Font("Dialog", 3, 12));
        this.mFormLabel.setText("Form");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mFormLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 45, 5, 5);
        this.mPanel.add((Component)this.mFormSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        this.mPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mSpaceLabel.setFont(new Font("Dialog", 0, 12));
        this.mSpaceLabel.setText("Space");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mSpaceLabel, gridBagConstraints);
        this.mSpaceSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mSpaceSpinner, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mPanel.add((Component)this.mLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 4, 5, 5);
        this.mPanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        this.mStringLabel.setFont(new Font("Dialog", 3, 12));
        this.mStringLabel.setText("String");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mStringLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 50, 5, 5);
        this.mPanel.add((Component)this.mStringSeparator, gridBagConstraints);
        this.mLeftXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mLeftXValueLabel.setText("Left X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mLeftXValueLabel, gridBagConstraints);
        this.mLeftXValueTextField.setColumns(6);
        this.mLeftXValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mLeftXValueTextField.setPreferredSize(new Dimension(72, 22));
        this.mLeftXValueTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGSignificantDifferenceSymbolDialog.this.mLeftXValueTextFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLeftXValueTextField, gridBagConstraints);
        this.mLeftYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mLeftYValueLabel.setText("Left Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mLeftYValueLabel, gridBagConstraints);
        this.mLeftYValueTextField.setColumns(6);
        this.mLeftYValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mLeftYValueTextField.setPreferredSize(new Dimension(72, 22));
        this.mLeftYValueTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGSignificantDifferenceSymbolDialog.this.mLeftYValueTextFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLeftYValueTextField, gridBagConstraints);
        this.mRightXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mRightXValueLabel.setText("Right X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mRightXValueLabel, gridBagConstraints);
        this.mRightXValueTextField.setColumns(6);
        this.mRightXValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mRightXValueTextField.setPreferredSize(new Dimension(72, 22));
        this.mRightXValueTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGSignificantDifferenceSymbolDialog.this.mRightXValueTextFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mRightXValueTextField, gridBagConstraints);
        this.mRightYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mRightYValueLabel.setText("Right Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mRightYValueLabel, gridBagConstraints);
        this.mRightYValueTextField.setColumns(6);
        this.mRightYValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mRightYValueTextField.setPreferredSize(new Dimension(72, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mRightYValueTextField, gridBagConstraints);
        this.mHorizontalYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mHorizontalYValueLabel.setText("Horizontal Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mHorizontalYValueLabel, gridBagConstraints);
        this.mHorizontalYValueTextField.setColumns(6);
        this.mHorizontalYValueTextField.setFont(new Font("Dialog", 0, 12));
        this.mHorizontalYValueTextField.setPreferredSize(new Dimension(72, 22));
        this.mHorizontalYValueTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGSignificantDifferenceSymbolDialog.this.mHorizontalYValueTextFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mHorizontalYValueTextField, gridBagConstraints);
        this.mLineVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mLineVisibleCheckBox.setText("Line Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        this.mPanel.add((Component)this.mLineVisibleCheckBox, gridBagConstraints);
        this.mFontStyleLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mFontStyleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.mCommonPanel.setLayout(new GridBagLayout());
        this.mLeftTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftTopRadioButton, gridBagConstraints);
        this.mLeftBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mLeftBottomRadioButton, gridBagConstraints);
        this.mRightTopRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightTopRadioButton, gridBagConstraints);
        this.mRightBottomRadioButton.setFont(new Font("Dialog", 1, 12));
        this.mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.mCommonPanel.add((Component)this.mRightBottomRadioButton, gridBagConstraints);
        this.mScaleReferenceLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel2, gridBagConstraints);
        this.mScaleReferenceLabel1.setFont(new Font("Dialog", 1, 12));
        this.mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        this.mCommonPanel.add((Component)this.mScaleReferenceLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mCommonPanel, gridBagConstraints);
        this.pack();
    }

    private void mHorizontalYValueTextFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void mLeftYValueTextFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void mRightXValueTextFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void mLeftXValueTextFieldActionPerformed(ActionEvent actionEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object.equals(this.mLineVisibleCheckBox)) {
            this.setLineComponentEnabled(this.mLineVisibleCheckBox.isSelected());
        }
    }

    public Number getLeftXValue() {
        return this.getNumber(this.mLeftXValueTextField);
    }

    public Number getLeftYValue() {
        return this.getNumber(this.mLeftYValueTextField);
    }

    public Number getRightXValue() {
        return this.getNumber(this.mRightXValueTextField);
    }

    public Number getRightYValue() {
        return this.getNumber(this.mRightYValueTextField);
    }

    public Number getHorizontalYValue() {
        return this.getNumber(this.mHorizontalYValueTextField);
    }

    public boolean getLineVisible() {
        return this.mLineVisibleCheckBox.isSelected();
    }

    public Number getSpace() {
        return this.mSpaceSpinner.getNumber();
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public String getFontName() {
        return (String)this.mFontNameComboBox.getSelectedItem();
    }

    public int getFontStyle() {
        String string = (String)this.mFontStyleComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public ArrayList getTextColorList() {
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(this.mColorButton.getBackground());
        return arrayList;
    }

    public Number getLineWidth() {
        return this.mLineWidthSpinner.getNumber();
    }

    public void setLeftXValue(double d) {
        this.mLeftXValueTextField.setText(Double.toString(d));
    }

    public void setLeftYValue(double d) {
        this.mLeftYValueTextField.setText(Double.toString(d));
    }

    public void setRightXValue(double d) {
        this.mRightXValueTextField.setText(Double.toString(d));
    }

    public void setRightYValue(double d) {
        this.mRightYValueTextField.setText(Double.toString(d));
    }

    public void setHorizontalYValue(double d) {
        this.mHorizontalYValueTextField.setText(Double.toString(d));
    }

    public void setLineVisible(boolean bl) {
        this.mLineVisibleCheckBox.setSelected(bl);
    }

    private void setLineComponentEnabled(boolean bl) {
        this.mLineWidthLabel2.setEnabled(bl);
        this.mLineWidthSpinner.setEnabled(bl);
    }

    public boolean setSpace(float f) {
        this.mSpaceSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFontSize(float f) {
        this.mFontSizeSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFontName(String string) {
        this.mFontNameComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFontStyle(int n) {
        String string = SGUtilityText.getFontStyleName(n);
        this.mFontStyleComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setColorList(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        if (arrayList.size() == 0) {
            return false;
        }
        Color color = (Color)arrayList.get(0);
        this.mColorButton.setBackground(color);
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidthSpinner.setValue(new Double(f));
        return true;
    }

    public ArrayList getColorSelectionComponentList() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.mColorButton);
        return arrayList;
    }

    public ArrayList getActiveComponentList() {
        ArrayList arrayList = this.getActiveComponentListFromSpinners();
        arrayList.add(this.mLeftXValueTextField);
        arrayList.add(this.mLeftYValueTextField);
        arrayList.add(this.mRightXValueTextField);
        arrayList.add(this.mRightYValueTextField);
        arrayList.add(this.mHorizontalYValueTextField);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mSpaceSpinner);
        arrayList.add(this.mLineWidthSpinner);
        return arrayList;
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        Object object = SGUtility.getAvailableFontNames();
        for (int i = 0; i < ((String[])object).length; ++i) {
            this.mFontNameComboBox.addItem(object[i]);
        }
        String[] stringArray = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontStyleComboBox.addItem(stringArray[i]);
        }
        this.pack();
        object = new ButtonGroup();
        ((ButtonGroup)object).add(this.mLeftBottomRadioButton);
        ((ButtonGroup)object).add(this.mLeftTopRadioButton);
        ((ButtonGroup)object).add(this.mRightBottomRadioButton);
        ((ButtonGroup)object).add(this.mRightTopRadioButton);
        ((ButtonGroup)object).add(this.mNoAxisSelectionRadioButton);
        this.mSpaceSpinner.initProperties(new SpinnerNumberModel(0.1, -1.0, 1.0, 0.05), " cm");
        this.mFontSizeSpinner.initProperties(this.getFontSizeSpinnerNumberModel(), " pt");
        this.mLineWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        this.mLineVisibleCheckBox.addActionListener(this);
        this.mColorButton.addActionListener(this);
        this.mFocusedColorSetButton = this.mColorButton;
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        return true;
    }

    public boolean setActionListener(ActionListener actionListener) {
        this.mOKButton.addActionListener(actionListener);
        this.mCancelButton.addActionListener(actionListener);
        this.mPreviewButton.addActionListener(actionListener);
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            sGSpinner.getFormattedTextField().addActionListener(actionListener);
        }
        this.mLeftXValueTextField.addActionListener(actionListener);
        this.mLeftYValueTextField.addActionListener(actionListener);
        this.mRightXValueTextField.addActionListener(actionListener);
        this.mRightYValueTextField.addActionListener(actionListener);
        this.mHorizontalYValueTextField.addActionListener(actionListener);
        return true;
    }

    public boolean removeActionListener() {
        ActionListener[] actionListenerArray = this.mOKButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.mOKButton.removeActionListener(actionListenerArray[i]);
            this.mCancelButton.removeActionListener(actionListenerArray[i]);
            this.mPreviewButton.removeActionListener(actionListenerArray[i]);
            ArrayList arrayList = this.getSpinnerList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGSpinner sGSpinner = (SGSpinner)arrayList.get(j);
                sGSpinner.getFormattedTextField().removeActionListener(actionListenerArray[i]);
            }
            this.mLeftXValueTextField.removeActionListener(actionListenerArray[i]);
            this.mLeftYValueTextField.removeActionListener(actionListenerArray[i]);
            this.mRightXValueTextField.removeActionListener(actionListenerArray[i]);
            this.mRightYValueTextField.removeActionListener(actionListenerArray[i]);
            this.mHorizontalYValueTextField.removeActionListener(actionListenerArray[i]);
        }
        return true;
    }

    public SGSignificantDifferenceElement.SigDiffPropertiesWithAxes getProperties() {
        boolean bl;
        SGSignificantDifferenceElement.SigDiffPropertiesWithAxes sigDiffPropertiesWithAxes = new SGSignificantDifferenceElement.SigDiffPropertiesWithAxes();
        Color color = this.mColorButton.getBackground();
        sigDiffPropertiesWithAxes.setColor(color);
        Number number = this.getLeftXValue();
        if (number == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        sigDiffPropertiesWithAxes.leftXValue = number.doubleValue();
        Number number2 = this.getLeftYValue();
        if (number2 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        sigDiffPropertiesWithAxes.leftYValue = number2.doubleValue();
        Number number3 = this.getRightXValue();
        if (number3 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        sigDiffPropertiesWithAxes.rightXValue = number3.doubleValue();
        Number number4 = this.getRightYValue();
        if (number4 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        sigDiffPropertiesWithAxes.rightYValue = number4.doubleValue();
        Number number5 = this.getHorizontalYValue();
        if (number5 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        sigDiffPropertiesWithAxes.horizontalYValue = number5.doubleValue();
        Number number6 = this.getSpace();
        if (number6 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        sigDiffPropertiesWithAxes.space = number6.floatValue() / 0.035277776f;
        Number number7 = this.getFontSize();
        if (number7 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        sigDiffPropertiesWithAxes.fontSize = number7.floatValue();
        sigDiffPropertiesWithAxes.fontName = this.getFontName();
        sigDiffPropertiesWithAxes.fontStyle = this.getFontStyle();
        sigDiffPropertiesWithAxes.lineVisible = bl = this.getLineVisible();
        Number number8 = this.getLineWidth();
        if (number8 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        sigDiffPropertiesWithAxes.lineWidth = number8.floatValue();
        return sigDiffPropertiesWithAxes;
    }

    public String getXAxisLocation() {
        String string = null;
        if (this.mLeftBottomRadioButton.isSelected() || this.mRightBottomRadioButton.isSelected()) {
            string = "Bottom";
        } else if (this.mLeftTopRadioButton.isSelected() || this.mRightTopRadioButton.isSelected()) {
            string = "Top";
        }
        return string;
    }

    public String getYAxisLocation() {
        String string = null;
        if (this.mLeftBottomRadioButton.isSelected() || this.mLeftTopRadioButton.isSelected()) {
            string = "Left";
        } else if (this.mRightBottomRadioButton.isSelected() || this.mRightTopRadioButton.isSelected()) {
            string = "Right";
        }
        return string;
    }

    public boolean setAxisRadioButton(int n, int n2) {
        block0 : switch (n) {
            case 0: {
                switch (n2) {
                    case 2: {
                        this.mLeftBottomRadioButton.setSelected(true);
                        break block0;
                    }
                    case 3: {
                        this.mRightBottomRadioButton.setSelected(true);
                        break block0;
                    }
                }
                return false;
            }
            case 1: {
                switch (n2) {
                    case 2: {
                        this.mLeftTopRadioButton.setSelected(true);
                        break block0;
                    }
                    case 3: {
                        this.mRightTopRadioButton.setSelected(true);
                        break block0;
                    }
                }
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

