/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertySettingListener;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGAxisBreakSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisBreakSymbolConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisBreakSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisBreakSymbolDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SGAxisBreakElement
extends SGFigureElement
implements SGIAxisBreakElement,
SGIAxisBreakSymbolConstants {
    private SGIAxisElement mAxisElement = null;
    private ArrayList mAxisBreakSymbolList = new ArrayList();
    private SGAxisBreakSymbolDialog mDialog = null;
    private Point mPressedPoint = null;

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createDialog();
        return true;
    }

    private boolean createDialog() {
        SGAxisBreakSymbolDialog sGAxisBreakSymbolDialog;
        this.mDialog = sGAxisBreakSymbolDialog = new SGAxisBreakSymbolDialog(this.mDialogOwner, true);
        return true;
    }

    public String toString() {
        return "SGAxisBreakElement";
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIGraphElement || sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGILegendElement)) {
            if (sGIFigureElement instanceof SGIAxisElement) {
                bl = this.synchronizeToAxisElement((SGIAxisElement)sGIFigureElement);
            } else if (!(sGIFigureElement instanceof SGIAxisBreakElement || sGIFigureElement instanceof SGISignificantDifferenceElement || sGIFigureElement instanceof SGITimingLineElement)) {
                bl = sGIFigureElement.synchronizeArgument(this);
            }
        }
        return bl;
    }

    private boolean synchronizeToAxisElement(SGIAxisElement sGIAxisElement) {
        ArrayList arrayList = this.getVisibleAxisBreakSymbolList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            axisBreakSymbol.setDrawingElementsLocation();
        }
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error();
    }

    public void setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
    }

    public String getTagName() {
        return "AxisBreakSymbols";
    }

    public boolean writeProperty(Element element) {
        return true;
    }

    public boolean readProperty(Element element) {
        NodeList nodeList = element.getElementsByTagName("AxisBreakSymbol");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            AxisBreakSymbol axisBreakSymbol = new AxisBreakSymbol();
            Element element2 = (Element)node;
            if (!axisBreakSymbol.readProperty(element2)) {
                return false;
            }
            axisBreakSymbol.initPropertiesHistory();
            this.mAxisBreakSymbolList.add(axisBreakSymbol);
        }
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        this.setLocationOfAllDrawingElements();
        return true;
    }

    private boolean setLocationOfAllDrawingElements() {
        for (int i = 0; i < this.mAxisBreakSymbolList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(i);
            axisBreakSymbol.setDrawingElementsLocation();
        }
        return true;
    }

    public boolean zoom(float f) {
        super.zoom(f);
        for (int i = 0; i < this.mAxisBreakSymbolList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(i);
            axisBreakSymbol.zoom(f);
        }
        return true;
    }

    public void paintComponent(Graphics graphics) {
        Cloneable cloneable;
        AxisBreakSymbol axisBreakSymbol;
        int n;
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        ArrayList arrayList = this.getVisibleAxisBreakSymbolList();
        for (n = 0; n < arrayList.size(); ++n) {
            axisBreakSymbol = (AxisBreakSymbol)arrayList.get(n);
            axisBreakSymbol.drawSymbol(graphics2D);
            if (!axisBreakSymbol.mFrameFlag) continue;
            axisBreakSymbol.drawBoundingBox(graphics2D);
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < arrayList.size(); ++n) {
                axisBreakSymbol = (AxisBreakSymbol)arrayList.get(n);
                cloneable = axisBreakSymbol.getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsChildObject(cloneable, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList arrayList2 = new ArrayList();
            this.getFocusedObjectsList(arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                cloneable = (AxisBreakSymbol)arrayList2.get(i);
                ArrayList arrayList3 = ((AxisBreakSymbol)cloneable).getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsFocusedObject(arrayList3, graphics2D);
            }
        }
    }

    protected ArrayList getVisibleAxisBreakSymbolList() {
        ArrayList<AxisBreakSymbol> arrayList = new ArrayList<AxisBreakSymbol>();
        for (int i = 0; i < this.mAxisBreakSymbolList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(i);
            if (!axisBreakSymbol.isVisible()) continue;
            arrayList.add(axisBreakSymbol);
        }
        return arrayList;
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleAxisBreakSymbolList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList2.get(i);
            if (!sGISelectable.isSelected()) continue;
            arrayList.add(sGISelectable);
        }
        return true;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)sGISelectable;
        axisBreakSymbol.setVisible(false);
        return true;
    }

    public Element createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        ArrayList arrayList = this.getVisibleAxisBreakSymbolList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            Element element2 = axisBreakSymbol.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return element;
    }

    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        ArrayList arrayList = this.getVisibleAxisBreakSymbolList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isChanged()) continue;
            return true;
        }
        return false;
    }

    private boolean setVisibleAxisBreakSymbols(ArrayList arrayList) {
        return this.setVisibleDrawingElement(this.mAxisBreakSymbolList, arrayList);
    }

    public boolean addAxisBreakSymbol(int n, int n2) {
        if (!this.getGraphRect().contains(n, n2)) {
            return false;
        }
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        return this.addAxisBreakSymbol(sGAxis, sGAxis2, n, n2);
    }

    public boolean addAxisBreakSymbol(SGAxis sGAxis, SGAxis sGAxis2, int n, int n2) {
        AxisBreakSymbol axisBreakSymbol = new AxisBreakSymbol(28.346458f, 14.173229f, 0.5f, 0.0f, true);
        axisBreakSymbol.addColor(SGDefaultValues.AXIS_BREAK_INNER_COLOR);
        axisBreakSymbol.setLineColor(SGDefaultValues.AXIS_BREAK_LINE_COLOR);
        axisBreakSymbol.setLineWidth(1.5f);
        axisBreakSymbol.setMagnification(this.mMagnification);
        axisBreakSymbol.mXAxis = sGAxis;
        axisBreakSymbol.mYAxis = sGAxis2;
        axisBreakSymbol.setLocation(n, n2);
        axisBreakSymbol.setAxisValue();
        this.mAxisBreakSymbolList.add(axisBreakSymbol);
        this.setChanged(true);
        axisBreakSymbol.initPropertiesHistory();
        this.notifyToRoot();
        return true;
    }

    protected boolean setAllDrawingElementsLocation() {
        ArrayList arrayList = this.getVisibleAxisBreakSymbolList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (axisBreakSymbol.setDrawingElementsLocation()) continue;
            return false;
        }
        return true;
    }

    public boolean updateHistory() {
        return this.updateHistory_(this.getVisibleAxisBreakSymbolList());
    }

    public boolean undo() {
        boolean bl = super.undo();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChange();
        return true;
    }

    public boolean redo() {
        boolean bl = super.redo();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChange();
        return true;
    }

    public void translateSelectedObjects(int n, int n2) {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            axisBreakSymbol.translate(n, n2);
        }
    }

    public boolean clearFocusedObjects() {
        return super.clearFocusedObjects();
    }

    private boolean moveAxisBreakSymbolToFront(AxisBreakSymbol axisBreakSymbol) {
        return this.moveObjectToFront(axisBreakSymbol, this.mAxisBreakSymbolList);
    }

    private boolean moveAxisBreakSymbolToBack(AxisBreakSymbol axisBreakSymbol) {
        return this.moveObjectToBack(axisBreakSymbol, this.mAxisBreakSymbolList);
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        if (!super.onMouseClicked(mouseEvent)) {
            return false;
        }
        ArrayList arrayList = this.getVisibleAxisBreakSymbolList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!this.clickDrawingElements(axisBreakSymbol, mouseEvent)) continue;
            return true;
        }
        return false;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            axisBreakSymbol.mTemporaryProperties = axisBreakSymbol.getProperties();
        }
        return true;
    }

    private boolean clickDrawingElements(AxisBreakSymbol axisBreakSymbol, MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        if (axisBreakSymbol.contains(n, n2)) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 1) {
                this.updateFocusedObjectsList(axisBreakSymbol, mouseEvent);
                if (axisBreakSymbol.isSelected()) {
                    axisBreakSymbol.mTempLocationInSymbol = new Point(n - (int)axisBreakSymbol.getX(), n2 - (int)axisBreakSymbol.getY());
                }
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 2) {
                axisBreakSymbol.showProeprtyDialog();
            } else if (SwingUtilities.isRightMouseButton(mouseEvent) & n3 == 1) {
                axisBreakSymbol.getPopupMenu().show(this, n, n2);
            }
            return true;
        }
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        if (!super.onMousePressed(mouseEvent)) {
            return false;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        ArrayList arrayList = this.getFocusedObjectsList();
        ArrayList arrayList2 = this.getVisibleAxisBreakSymbolList();
        for (int i = arrayList2.size() - 1; i >= 0; --i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList2.get(i);
            if (!axisBreakSymbol.contains(n, n2)) continue;
            this.mPressedPoint = mouseEvent.getPoint();
            this.setMouseCursor(13);
            return true;
        }
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (!super.onMouseDragged(mouseEvent)) {
            return false;
        }
        if (this.mPressedPoint == null) {
            return false;
        }
        int n = mouseEvent.getX() - this.mPressedPoint.x;
        int n2 = mouseEvent.getY() - this.mPressedPoint.y;
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            axisBreakSymbol.translate(n, n2);
            axisBreakSymbol.setAxisValue();
            axisBreakSymbol.setDrawingElementsLocation();
        }
        this.mPressedPoint = mouseEvent.getPoint();
        return true;
    }

    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            SGProperties sGProperties = axisBreakSymbol.mTemporaryProperties;
            SGProperties sGProperties2 = axisBreakSymbol.getProperties();
            if (sGProperties2.equals(sGProperties)) continue;
            axisBreakSymbol.setChanged(true);
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        if (!super.onMouseReleased(mouseEvent)) {
            return false;
        }
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            Rectangle2D rectangle2D = axisBreakSymbol.getElementBounds();
            if (rectangle2D.contains(mouseEvent.getPoint())) {
                this.setMouseCursor(12);
                continue;
            }
            this.setMouseCursor(0);
        }
        this.notifyToRoot();
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        for (int i = this.mAxisBreakSymbolList.size() - 1; i >= 0; --i) {
            boolean bl;
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(i);
            axisBreakSymbol.mFrameFlag = bl = axisBreakSymbol.contains(n, n2);
            if (!bl) continue;
            this.setMouseCursor(12);
            this.repaint();
            return true;
        }
        this.setMouseCursor(0);
        return false;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        Cloneable cloneable;
        Cloneable cloneable2;
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
        for (int i = 0; i < this.mAxisBreakSymbolList.size(); ++i) {
            cloneable2 = (AxisBreakSymbol)this.mAxisBreakSymbolList.get(i);
            if (!((SGDrawingElement)((Object)cloneable2)).isVisible()) continue;
            cloneable = ((SGAxisBreakSymbol2D)((Object)cloneable2)).getElementBounds();
            arrayList.add(cloneable);
        }
        Rectangle2D rectangle2D = null;
        if (arrayList.size() != 0) {
            rectangle2D = SGUtility.createUnion(arrayList);
        }
        cloneable2 = this.getGraphRect();
        cloneable = new ArrayList();
        ((ArrayList)cloneable).add(cloneable2);
        if (rectangle2D != null) {
            ((ArrayList)cloneable).add(rectangle2D);
        }
        Rectangle2D rectangle2D2 = SGUtility.createUnion((ArrayList)cloneable);
        float f = (float)(((RectangularShape)cloneable2).getY() - rectangle2D2.getY());
        float f2 = (float)(rectangle2D2.getY() + rectangle2D2.getHeight() - (((RectangularShape)cloneable2).getY() + ((RectangularShape)cloneable2).getHeight()));
        float f3 = (float)(((RectangularShape)cloneable2).getX() - rectangle2D2.getX());
        float f4 = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() - (((RectangularShape)cloneable2).getX() + ((RectangularShape)cloneable2).getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    public SGProperties getProperties() {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.visibleAxisBreakSymbolList = this.getVisibleAxisBreakSymbolList();
        return axisProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisProperties)) {
            return false;
        }
        AxisProperties axisProperties = (AxisProperties)sGProperties;
        boolean bl = this.setVisibleAxisBreakSymbols(axisProperties.visibleAxisBreakSymbolList);
        return bl;
    }

    public Object copy() {
        return null;
    }

    public static class AxisBreakSymbolWithAxesProperties
    extends SGAxisBreakSymbol.AxisBreakSymbolProperties {
        public static final String[] keys = new String[]{"XValue", "YValue"};
        protected SGAxis mXAxis = null;
        protected SGAxis mYAxis = null;

        public boolean equals(Object object) {
            if (!(object instanceof AxisBreakSymbolWithAxesProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = (AxisBreakSymbolWithAxesProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                String string = keys[i];
                String string2 = this.getProperty(string);
                if (string2.equals(axisBreakSymbolWithAxesProperties.getProperty(keys[i]))) continue;
                return false;
            }
            if (!this.mXAxis.equals(axisBreakSymbolWithAxesProperties.mXAxis)) {
                return false;
            }
            return this.mYAxis.equals(axisBreakSymbolWithAxesProperties.mYAxis);
        }

        public Double getXValue() {
            String string = this.getProperty("XValue");
            return SGUtilityText.getDouble(string);
        }

        public Double getYValue() {
            String string = this.getProperty("YValue");
            return SGUtilityText.getDouble(string);
        }

        public boolean setXValue(double d) {
            this.setProperty("XValue", Double.toString(d));
            return true;
        }

        public boolean setYValue(double d) {
            this.setProperty("YValue", Double.toString(d));
            return true;
        }
    }

    class AxisBreakSymbol
    extends SGAxisBreakSymbol2D
    implements ActionListener,
    SGIPropertySettingListener,
    SGIUndoable,
    SGISelectable,
    SGIMovable,
    SGICopiable {
        protected SGAxis mXAxis = null;
        protected SGAxis mYAxis = null;
        protected double mXValue;
        protected double mYValue;
        protected boolean mFrameFlag = false;
        protected SGProperties mTemporaryProperties = null;
        protected Point mTempLocationInSymbol = null;
        private JPopupMenu mPopupMenu = new JPopupMenu();
        private ArrayList mAxisBreakSymbolPropertyHistoryList = new ArrayList();
        private int mElementStateCounter = 0;
        private int mCurrentStateCounter = 0;
        protected ArrayList mUndoableObjectHistoryList = new ArrayList();
        private boolean mChangedFlag = false;
        private boolean mSelectedFlag = false;

        protected AxisBreakSymbol() {
            this.init();
        }

        protected AxisBreakSymbol(float f, float f2, float f3, float f4, boolean bl) {
            super(f, f2, f3, f4, bl);
            this.init();
        }

        private boolean init() {
            this.createPopupMenu();
            return true;
        }

        public Object copy() {
            AxisBreakSymbol axisBreakSymbol = new AxisBreakSymbol();
            axisBreakSymbol.setProperties(this.getProperties());
            axisBreakSymbol.setLocation(this.getX(), this.getY());
            axisBreakSymbol.setMagnification(this.mMagnification);
            return axisBreakSymbol;
        }

        JPopupMenu getPopupMenu() {
            return this.mPopupMenu;
        }

        private boolean createPopupMenu() {
            this.mPopupMenu.setBounds(0, 0, 100, 100);
            JMenuItem jMenuItem = new JMenuItem("Move to Front");
            jMenuItem.addActionListener(this);
            this.mPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Move to Back");
            jMenuItem.addActionListener(this);
            this.mPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Delete");
            jMenuItem.addActionListener(this);
            this.mPopupMenu.add(jMenuItem);
            this.mPopupMenu.addSeparator();
            jMenuItem = new JMenuItem("Property");
            jMenuItem.addActionListener(this);
            this.mPopupMenu.add(jMenuItem);
            return true;
        }

        public SGTuple2f getLocation() {
            float f = this.mMagnification * this.mLocation.x + SGAxisBreakElement.this.mGraphRectX;
            float f2 = this.mMagnification * this.mLocation.y + SGAxisBreakElement.this.mGraphRectY;
            return new SGTuple2f(f, f2);
        }

        public void setLocation(float f, float f2) {
            float f3 = f - this.getX();
            float f4 = f2 - this.getY();
            this.mLocation.x = (f - SGAxisBreakElement.this.mGraphRectX) / this.mMagnification;
            this.mLocation.y = (f2 - SGAxisBreakElement.this.mGraphRectY) / this.mMagnification;
            this.create();
        }

        public void translate(int n, int n2) {
            this.setLocation(this.getX() + (float)n, this.getY() + (float)n2);
            this.setAxisValue();
            this.setDrawingElementsLocation();
        }

        private void drawBoundingBox(Graphics2D graphics2D) {
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setPaint(Color.BLACK);
            graphics2D.draw(this.getElementBounds());
        }

        private ArrayList getAnchorPointList() {
            ArrayList arrayList = this.getAnchorPointList(this.mCurve1);
            ArrayList arrayList2 = this.getAnchorPointList(this.mCurve2);
            ArrayList arrayList3 = new ArrayList();
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
            return arrayList3;
        }

        private ArrayList getAnchorPointList(Shape shape) {
            ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
            PathIterator pathIterator = shape.getPathIterator(null);
            ArrayList arrayList2 = SGUtilityJava2D.getSegmentList(pathIterator);
            Point2D point2D = (Point2D)arrayList2.get(0);
            Point2D point2D2 = (Point2D)arrayList2.get(arrayList2.size() - 1);
            Point2D.Float float_ = new Point2D.Float();
            ((Point2D)float_).setLocation((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
            arrayList.add(point2D);
            arrayList.add(point2D2);
            arrayList.add(float_);
            return arrayList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            if (string.equals("Move to Front")) {
                SGAxisBreakElement.this.moveAxisBreakSymbolToFront(this);
            } else if (string.equals("Move to Back")) {
                SGAxisBreakElement.this.moveAxisBreakSymbolToBack(this);
            } else if (string.equals("Delete")) {
                SGAxisBreakElement.this.hideObject(this);
                SGAxisBreakElement.this.clearFocusedObjects();
            } else if (string.equals("Property")) {
                this.showProeprtyDialog();
            }
        }

        public boolean setDrawingElementsLocation() {
            float f = SGAxisBreakElement.this.calcLocation(this.mXValue, this.mXAxis, true);
            float f2 = SGAxisBreakElement.this.calcLocation(this.mYValue, this.mYAxis, false);
            this.setLocation(f, f2);
            return true;
        }

        public boolean setAxisValue() {
            double d = SGAxisBreakElement.this.calcValue(this.getX(), this.mXAxis, true);
            double d2 = SGAxisBreakElement.this.calcValue(this.getY(), this.mYAxis, false);
            this.mXValue = SGAxisBreakElement.this.getNumberInRangeOrder(d, this.mXAxis);
            this.mYValue = SGAxisBreakElement.this.getNumberInRangeOrder(d2, this.mYAxis);
            return true;
        }

        public String getTagName() {
            return "AxisBreakSymbol";
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            String string = "cm";
            String string2 = "pt";
            String string3 = SGIConstants.degree;
            element.setAttribute("XValue", Double.toString(this.mXValue));
            element.setAttribute("YValue", Double.toString(this.mYValue));
            element.setAttribute("XAxisPosition", SGAxisBreakElement.this.mAxisElement.getAxisLocation(this.mXAxis));
            element.setAttribute("YAxisPosition", SGAxisBreakElement.this.mAxisElement.getAxisLocation(this.mYAxis));
            element.setAttribute("Length", Float.toString(this.mLength * 0.035277776f) + string);
            element.setAttribute("Interval", Float.toString(this.mInterval * 0.035277776f) + string);
            element.setAttribute("Distortion", Float.toString(this.mDistortion));
            element.setAttribute("Angle", Float.toString(this.mAngle / ((float)Math.PI / 180)) + string3);
            element.setAttribute("LineWidth", Float.toString(this.mLineWidth) + string2);
            element.setAttribute("Horizontal", Boolean.toString(this.mForHorizontalAxisFlag));
            element.setAttribute("LineColor", SGUtilityText.getColorString(this.mLineColor));
            element.setAttribute("InnerColor", SGUtilityText.getColorListString(this.getColorList()));
            return true;
        }

        public boolean readProperty(Element element) {
            SGAxisBreakSymbol.AxisBreakSymbolProperties axisBreakSymbolProperties = this.readProperty_(element);
            if (axisBreakSymbolProperties == null) {
                return false;
            }
            return this.setProperties(axisBreakSymbolProperties);
        }

        public SGAxisBreakSymbol.AxisBreakSymbolProperties readProperty_(Element element) {
            String string = SGIConstants.degree;
            String string2 = null;
            Number number = null;
            Color color = null;
            Boolean bl = null;
            ArrayList arrayList = null;
            string2 = element.getAttribute("XValue");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getDouble(string2);
            if (number == null) {
                return null;
            }
            double d = number.doubleValue();
            string2 = element.getAttribute("YValue");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getDouble(string2);
            if (number == null) {
                return null;
            }
            double d2 = number.doubleValue();
            string2 = element.getAttribute("XAxisPosition");
            if (string2.length() == 0) {
                return null;
            }
            int n = SGAxisBreakElement.this.mAxisElement.getConfigurationInCube(string2);
            SGAxis sGAxis = SGAxisBreakElement.this.mAxisElement.getAxisInCube(n);
            if (sGAxis == null) {
                return null;
            }
            string2 = element.getAttribute("YAxisPosition");
            if (string2.length() == 0) {
                return null;
            }
            int n2 = SGAxisBreakElement.this.mAxisElement.getConfigurationInCube(string2);
            SGAxis sGAxis2 = SGAxisBreakElement.this.mAxisElement.getAxisInCube(n2);
            if (sGAxis2 == null) {
                return null;
            }
            string2 = element.getAttribute("Length");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getFloat(string2, "cm");
            if (number == null) {
                return null;
            }
            float f = number.floatValue() / 0.035277776f;
            string2 = element.getAttribute("Interval");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getFloat(string2, "cm");
            if (number == null) {
                return null;
            }
            float f2 = number.floatValue() / 0.035277776f;
            string2 = element.getAttribute("Distortion");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getFloat(string2);
            if (number == null) {
                return null;
            }
            float f3 = number.floatValue();
            string2 = element.getAttribute("Angle");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getFloat(string2, string);
            if (number == null) {
                return null;
            }
            float f4 = number.floatValue() * ((float)Math.PI / 180);
            string2 = element.getAttribute("LineWidth");
            if (string2.length() == 0) {
                return null;
            }
            number = SGUtilityText.getFloat(string2, "pt");
            if (number == null) {
                return null;
            }
            float f5 = number.floatValue();
            string2 = element.getAttribute("Horizontal");
            if (string2.length() == 0) {
                return null;
            }
            bl = SGUtilityText.getBoolean(string2);
            if (bl == null) {
                return null;
            }
            boolean bl2 = bl;
            string2 = element.getAttribute("LineColor");
            if (string2.length() == 0) {
                return null;
            }
            color = SGUtilityText.getColorFromString(string2);
            if (color == null) {
                return null;
            }
            Color color2 = color;
            string2 = element.getAttribute("InnerColor");
            if (string2.length() == 0) {
                return null;
            }
            arrayList = SGUtilityText.getColorList(string2);
            if (arrayList == null) {
                return null;
            }
            ArrayList arrayList2 = arrayList;
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = new AxisBreakSymbolWithAxesProperties();
            axisBreakSymbolWithAxesProperties.setXValue(d);
            axisBreakSymbolWithAxesProperties.setYValue(d2);
            axisBreakSymbolWithAxesProperties.mXAxis = sGAxis;
            axisBreakSymbolWithAxesProperties.mYAxis = sGAxis2;
            axisBreakSymbolWithAxesProperties.setLength(f);
            axisBreakSymbolWithAxesProperties.setInterval(f2);
            axisBreakSymbolWithAxesProperties.setDistortion(f3);
            axisBreakSymbolWithAxesProperties.setAngle(f4);
            axisBreakSymbolWithAxesProperties.setLineWidth(f5);
            axisBreakSymbolWithAxesProperties.setHorizontal(bl2);
            axisBreakSymbolWithAxesProperties.setLineColor(color2);
            axisBreakSymbolWithAxesProperties.setColorList(arrayList2);
            axisBreakSymbolWithAxesProperties.setVisible(true);
            return axisBreakSymbolWithAxesProperties;
        }

        private boolean showProeprtyDialog() {
            SGAxisBreakSymbolDialog sGAxisBreakSymbolDialog = SGAxisBreakElement.this.mDialog;
            sGAxisBreakSymbolDialog.addPropertySettingListener(this);
            sGAxisBreakSymbolDialog.setLocation(SGAxisBreakElement.this.mDialogOwner.getLocation());
            this.setDialogProperty();
            sGAxisBreakSymbolDialog.setColorButtonBorder(true);
            this.createTemporaryPropertyObject();
            sGAxisBreakSymbolDialog.setVisible(true);
            sGAxisBreakSymbolDialog.removeAllPropertySettingListeners();
            return true;
        }

        private boolean setDialogProperty() {
            SGAxisBreakSymbolDialog sGAxisBreakSymbolDialog = SGAxisBreakElement.this.mDialog;
            this.setDialogPropertyOfAxis();
            sGAxisBreakSymbolDialog.setXValue(new Double(this.mXValue));
            sGAxisBreakSymbolDialog.setYValue(new Double(this.mYValue));
            sGAxisBreakSymbolDialog.setLength(new Float(this.mLength * 0.035277776f));
            sGAxisBreakSymbolDialog.setInterval(new Float(this.mInterval * 0.035277776f));
            sGAxisBreakSymbolDialog.setDistortion(new Float(this.mDistortion));
            sGAxisBreakSymbolDialog.setAngle(new Float(this.mAngle / ((float)Math.PI / 180)));
            sGAxisBreakSymbolDialog.setLineWidth(new Float(this.mLineWidth));
            sGAxisBreakSymbolDialog.setHorizontal(this.mForHorizontalAxisFlag);
            sGAxisBreakSymbolDialog.setLineColor(this.mLineColor);
            sGAxisBreakSymbolDialog.setInnerColor(this.getColor(0));
            return true;
        }

        private boolean setDialogPropertyOfAxis() {
            int n;
            int n2;
            SGAxisBreakSymbolDialog sGAxisBreakSymbolDialog = SGAxisBreakElement.this.mDialog;
            boolean bl = sGAxisBreakSymbolDialog.setAxisRadioButton(n2 = SGAxisBreakElement.this.mAxisElement.getConfigurationInPlane(this.mXAxis), n = SGAxisBreakElement.this.mAxisElement.getConfigurationInPlane(this.mYAxis));
            return bl;
        }

        public boolean createTemporaryPropertyObject() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        public boolean commit() {
            if (!this.setPropertiesFromDialog()) {
                return false;
            }
            this.notifyToRoot();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            if (!this.create()) {
                return false;
            }
            return this.setDrawingElementsLocation();
        }

        public boolean preview() {
            return this.setPropertiesFromDialog();
        }

        private boolean setPropertiesFromDialog() {
            SGAxisBreakSymbolDialog sGAxisBreakSymbolDialog = SGAxisBreakElement.this.mDialog;
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = sGAxisBreakSymbolDialog.getProperties();
            if (axisBreakSymbolWithAxesProperties == null) {
                return false;
            }
            axisBreakSymbolWithAxesProperties.setProperty("Visible", Boolean.TRUE.toString());
            String string = sGAxisBreakSymbolDialog.getXAxisLocation();
            SGAxis sGAxis = SGAxisBreakElement.this.mAxisElement.getAxis(string);
            String string2 = sGAxisBreakSymbolDialog.getYAxisLocation();
            SGAxis sGAxis2 = SGAxisBreakElement.this.mAxisElement.getAxis(string2);
            axisBreakSymbolWithAxesProperties.mXAxis = sGAxis;
            axisBreakSymbolWithAxesProperties.mYAxis = sGAxis2;
            if (!axisBreakSymbolWithAxesProperties.equals(this.mTemporaryProperties)) {
                this.setChanged(true);
            }
            if (!this.setProperties(axisBreakSymbolWithAxesProperties)) {
                return false;
            }
            if (!this.create()) {
                return false;
            }
            if (!this.setDrawingElementsLocation()) {
                return false;
            }
            SGAxisBreakElement.this.repaint();
            return true;
        }

        public boolean initPropertiesHistory() {
            this.addAxisBreakSymbolPropertyHistory(this.getProperties());
            return true;
        }

        private boolean addAxisBreakSymbolPropertyHistory(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGAxisBreakSymbol.AxisBreakSymbolProperties)) {
                return false;
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.mElementStateCounter; ++i) {
                arrayList.add(this.mAxisBreakSymbolPropertyHistoryList.get(i));
            }
            arrayList.add(sGProperties);
            this.mAxisBreakSymbolPropertyHistoryList = arrayList;
            return true;
        }

        public boolean undo() {
            --this.mElementStateCounter;
            SGAxisBreakSymbol.AxisBreakSymbolProperties axisBreakSymbolProperties = (SGAxisBreakSymbol.AxisBreakSymbolProperties)this.mAxisBreakSymbolPropertyHistoryList.get(this.mElementStateCounter);
            this.setProperties(axisBreakSymbolProperties);
            this.create();
            this.setDrawingElementsLocation();
            return true;
        }

        public boolean redo() {
            ++this.mElementStateCounter;
            SGAxisBreakSymbol.AxisBreakSymbolProperties axisBreakSymbolProperties = (SGAxisBreakSymbol.AxisBreakSymbolProperties)this.mAxisBreakSymbolPropertyHistoryList.get(this.mElementStateCounter);
            this.setProperties(axisBreakSymbolProperties);
            this.create();
            this.setDrawingElementsLocation();
            return true;
        }

        public boolean onUndo() {
            return this.undo();
        }

        public boolean onRedo() {
            return this.redo();
        }

        public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
            ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
            arrayList.add(sGIUndoable);
            boolean bl = this.updateObjectHistory(arrayList);
            return bl;
        }

        public boolean updateObjectHistory(ArrayList arrayList) {
            ArrayList arrayList2 = new ArrayList();
            for (int i = 0; i < this.mCurrentStateCounter; ++i) {
                Object e = this.mUndoableObjectHistoryList.get(i);
                arrayList2.add(e);
            }
            arrayList2.add(new ArrayList(arrayList));
            this.mUndoableObjectHistoryList = arrayList2;
            ++this.mCurrentStateCounter;
            return true;
        }

        public boolean updateHistory() {
            if (this.isChanged()) {
                this.updateThisObjectHistory();
                this.setChanged(false);
                this.updateObjectHistory(this);
            }
            return true;
        }

        public boolean updateThisObjectHistory() {
            ++this.mElementStateCounter;
            this.addAxisBreakSymbolPropertyHistory(this.getProperties());
            return true;
        }

        public boolean isChanged() {
            return this.mChangedFlag;
        }

        public void setChanged(boolean bl) {
            this.mChangedFlag = bl;
        }

        public void notifyToRoot() {
            SGAxisBreakElement.this.notifyToRootFromFigureElement();
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof AxisBreakSymbolWithAxesProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = (AxisBreakSymbolWithAxesProperties)sGProperties;
            Double d = axisBreakSymbolWithAxesProperties.getXValue();
            if (d == null) {
                return false;
            }
            this.mXValue = d;
            Double d2 = axisBreakSymbolWithAxesProperties.getYValue();
            if (d2 == null) {
                return false;
            }
            this.mYValue = d2;
            this.mXAxis = axisBreakSymbolWithAxesProperties.mXAxis;
            this.mYAxis = axisBreakSymbolWithAxesProperties.mYAxis;
            return true;
        }

        public SGProperties getProperties() {
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = new AxisBreakSymbolWithAxesProperties();
            if (!this.getProperties(axisBreakSymbolWithAxesProperties)) {
                return null;
            }
            return axisBreakSymbolWithAxesProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof AxisBreakSymbolWithAxesProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = (AxisBreakSymbolWithAxesProperties)sGProperties;
            axisBreakSymbolWithAxesProperties.setXValue(this.mXValue);
            axisBreakSymbolWithAxesProperties.setYValue(this.mYValue);
            axisBreakSymbolWithAxesProperties.mXAxis = this.mXAxis;
            axisBreakSymbolWithAxesProperties.mYAxis = this.mYAxis;
            return true;
        }

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }
    }

    public static class AxisProperties
    extends SGProperties {
        ArrayList visibleAxisBreakSymbolList = new ArrayList();

        AxisProperties() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof AxisProperties)) {
                return false;
            }
            AxisProperties axisProperties = (AxisProperties)object;
            return axisProperties.visibleAxisBreakSymbolList.equals(this.visibleAxisBreakSymbolList);
        }
    }
}

