/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGISignificantDifferenceSymbolConstants;

public abstract class SGSignificantDifferenceSymbol
extends SGDrawingElement
implements SGISignificantDifferenceSymbolConstants,
SGIDrawingElementConstants {
    protected float mX;
    protected float mY;
    protected float mWidth;
    protected float mPerpendicularHeight1;
    protected float mPerpendicularHeight2;
    protected float mSpace;
    protected float mLineWidth;
    protected boolean mLineVisibleFlag = true;

    public boolean isLineVisible() {
        return this.mLineVisibleFlag;
    }

    public void setLineVisible(boolean bl) {
        this.mLineVisibleFlag = bl;
    }

    public SGSignificantDifferenceSymbol() {
    }

    public SGSignificantDifferenceSymbol(float f, float f2, float f3, float f4, float f5) {
        this.setLocation(f, f2);
        this.setSize(f3, f4, f5);
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public float getX1() {
        return this.getX();
    }

    public float getX2() {
        return this.getX1() + this.getWidth();
    }

    public float getY1() {
        return this.getY() + this.getPerpendicularHeight1();
    }

    public float getY2() {
        return this.getY() + this.getPerpendicularHeight2();
    }

    public float getWidth() {
        return this.mWidth * this.mMagnification;
    }

    public float getPerpendicularHeight1() {
        return this.mPerpendicularHeight1 * this.mMagnification;
    }

    public float getPerpendicularHeight2() {
        return this.mPerpendicularHeight2 * this.mMagnification;
    }

    public float getSpace() {
        return this.mSpace * this.mMagnification;
    }

    public abstract SGDrawingElementString getStringElement();

    public String getText() {
        return this.getStringElement().getString();
    }

    public float getFontSize() {
        return this.getStringElement().getFontSize();
    }

    public int getFontStyle() {
        return this.getStringElement().getFontStyle();
    }

    public String getFontName() {
        return this.getStringElement().getFontName();
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public Color getColor() {
        return this.getColor(0);
    }

    public boolean setColorList(ArrayList arrayList) {
        super.setColorList(arrayList);
        this.getStringElement().setColorList(arrayList);
        return true;
    }

    public boolean setColor(Color color) {
        super.setColor(color);
        this.getStringElement().setColor(color);
        return true;
    }

    public boolean addColor(Color color) {
        super.addColor(color);
        this.getStringElement().addColor(color);
        return true;
    }

    public boolean setLocation(float f, float f2) {
        this.setX(f);
        this.setY(f2);
        return true;
    }

    public boolean setX(float f) {
        this.mX = f;
        return true;
    }

    public boolean setY(float f) {
        this.mY = f;
        return true;
    }

    public boolean setSize(float f, float f2, float f3) {
        this.setWidth(f);
        this.setPerpendicularHeight1(f2);
        this.setPerpendicularHeight2(f3);
        return true;
    }

    public boolean setWidth(float f) {
        this.mWidth = f / this.mMagnification;
        return true;
    }

    public boolean setPerpendicularHeight1(float f) {
        this.mPerpendicularHeight1 = f / this.mMagnification;
        return true;
    }

    public boolean setPerpendicularHeight2(float f) {
        this.mPerpendicularHeight2 = f / this.mMagnification;
        return true;
    }

    public boolean setSpace(float f) {
        if ((double)f < 0.0) {
            throw new IllegalArgumentException("space < 0.0");
        }
        this.mSpace = f / this.mMagnification;
        return true;
    }

    public boolean setText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("text==null");
        }
        this.getStringElement().setString(string);
        return true;
    }

    public boolean setLineWidth(float f) {
        if (f < Float.MIN_VALUE) {
            throw new IllegalArgumentException("lineWidth < Float.MIN_VALUE");
        }
        this.mLineWidth = f;
        return true;
    }

    public boolean setFont(String string, int n, float f) {
        if (f < Float.MIN_VALUE) {
            throw new IllegalArgumentException("size < Float.MIN_VALUE");
        }
        this.getStringElement().setFont(string, n, f);
        return true;
    }

    public boolean isFlippingHorizontal() {
        return this.mWidth < 0.0f;
    }

    public boolean isFlippingVertical() {
        return this.isFlippingVertical1() && this.isFlippingVertical2();
    }

    public boolean isFlippingVertical1() {
        return this.mPerpendicularHeight1 < 0.0f;
    }

    public boolean isFlippingVertical2() {
        return this.mPerpendicularHeight2 < 0.0f;
    }

    public boolean isFlippingVerticalLeft() {
        return !this.isFlippingHorizontal() ? this.isFlippingVertical1() : this.isFlippingVertical2();
    }

    public boolean isFlippingVerticalRight() {
        return !this.isFlippingHorizontal() ? this.isFlippingVertical2() : this.isFlippingVertical1();
    }

    public float getLeftHeight() {
        if (!this.isFlippingHorizontal()) {
            return this.getPerpendicularHeight1();
        }
        return this.getPerpendicularHeight2();
    }

    public float getRightHeight() {
        if (!this.isFlippingHorizontal()) {
            return this.getPerpendicularHeight2();
        }
        return this.getPerpendicularHeight1();
    }

    public boolean setLeftHeight(float f) {
        if (!this.isFlippingHorizontal()) {
            this.setPerpendicularHeight1(f);
        } else {
            this.setPerpendicularHeight2(f);
        }
        return true;
    }

    public boolean setRightHeight(float f) {
        if (!this.isFlippingHorizontal()) {
            this.setPerpendicularHeight2(f);
        } else {
            this.setPerpendicularHeight1(f);
        }
        return true;
    }

    public boolean setNodePointLocation(float f, float f2, float f3, float f4, float f5) {
        float f6 = f3 - f;
        this.setX(f);
        this.setWidth(f6);
        this.setY(f5);
        float f7 = f2 - f5;
        float f8 = f4 - f5;
        this.setPerpendicularHeight1(f7);
        this.setPerpendicularHeight2(f8);
        return true;
    }

    public SGProperties getProperties() {
        SigDiffProperties sigDiffProperties = new SigDiffProperties();
        if (!this.getProperties(sigDiffProperties)) {
            return null;
        }
        return sigDiffProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SigDiffProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        SigDiffProperties sigDiffProperties = (SigDiffProperties)sGProperties;
        sigDiffProperties.space = this.mSpace;
        sigDiffProperties.lineVisible = this.mLineVisibleFlag;
        sigDiffProperties.lineWidth = this.mLineWidth;
        sigDiffProperties.text = this.getText();
        sigDiffProperties.fontName = this.getFontName();
        sigDiffProperties.fontSize = this.getFontSize();
        sigDiffProperties.fontStyle = this.getFontStyle();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SigDiffProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SigDiffProperties sigDiffProperties = (SigDiffProperties)sGProperties;
        this.mSpace = sigDiffProperties.space;
        this.setText(sigDiffProperties.text);
        this.setFont(sigDiffProperties.fontName, sigDiffProperties.fontStyle, sigDiffProperties.fontSize);
        this.setLineVisible(sigDiffProperties.lineVisible);
        this.setLineWidth(sigDiffProperties.lineWidth);
        return true;
    }

    public static class SigDiffProperties
    extends SGDrawingElement.DrawingElementProperties {
        public float space;
        public float lineWidth;
        public String text;
        public String fontName;
        public float fontSize;
        public int fontStyle;
        public boolean lineVisible;

        public boolean equals(Object object) {
            if (!(object instanceof SigDiffProperties)) {
                return false;
            }
            SigDiffProperties sigDiffProperties = (SigDiffProperties)object;
            if (sigDiffProperties.space != this.space) {
                return false;
            }
            if (sigDiffProperties.lineWidth != this.lineWidth) {
                return false;
            }
            if (!sigDiffProperties.text.equals(this.text)) {
                return false;
            }
            if (!sigDiffProperties.fontName.equals(this.fontName)) {
                return false;
            }
            if (sigDiffProperties.fontSize != this.fontSize) {
                return false;
            }
            if (sigDiffProperties.fontStyle != this.fontStyle) {
                return false;
            }
            return sigDiffProperties.lineVisible == this.lineVisible;
        }
    }
}

