/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;

public class SGSpinner
extends JSpinner
implements SGIConstants,
PropertyChangeListener {
    public static final String SPINNER_UNIT_CM = " cm";
    public static final String SPINNER_UNIT_MM = " mm";
    public static final String SPINNER_UNIT_PT = " pt";
    public static final String SPINNER_UNIT_INCH = " inch";
    public static final String SPINNER_UNIT_DEGREE = SGIConstants.degree;
    public static final int DEFAULT_DIGIT_FOR_ROUND_OUT = -3;
    private int mDigitForRoundOut = -3;
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_ON_STEP = 1;
    private String mTempString = null;

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        Object object = propertyChangeEvent.getSource();
        if (object.equals(this.getFormattedTextField()) && (string = this.mTempString) != null) {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)object;
            String string2 = jFormattedTextField.getText();
            if (!string.equals(string2)) {
                String string3 = this.getUnit();
                if (!this.isInteger()) {
                    String string4 = SGUtilityNumber.removeUnit(string, string3);
                    String string5 = SGUtilityNumber.removeUnit(string2, string3);
                    Float f = Float.valueOf(string4);
                    Float f2 = Float.valueOf(string5);
                    Number number = this.getValueOnStepInside(f.floatValue(), f2.floatValue());
                    if (number == null) {
                        number = f2;
                    }
                    this.setValue(number);
                }
            }
            this.mTempString = null;
        }
    }

    public boolean initProperties(SpinnerNumberModel spinnerNumberModel, String string) {
        this.setModel(spinnerNumberModel);
        if (string != null) {
            this.setSuffix(string);
        }
        JFormattedTextField jFormattedTextField = this.getFormattedTextField();
        jFormattedTextField.setFocusLostBehavior(3);
        jFormattedTextField.setHorizontalAlignment(2);
        jFormattedTextField.addPropertyChangeListener(this);
        this.setMinimumFractionDigits(1);
        this.setMaximumFractionDigits(2);
        return true;
    }

    public DecimalFormat getDecimalFormat() {
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.getEditor();
        DecimalFormat decimalFormat = numberEditor.getFormat();
        return decimalFormat;
    }

    public boolean setMinimumFractionDigits(int n) {
        this.getDecimalFormat().setMinimumFractionDigits(n);
        return true;
    }

    public boolean setMaximumFractionDigits(int n) {
        this.getDecimalFormat().setMaximumFractionDigits(n);
        return true;
    }

    public JFormattedTextField getFormattedTextField() {
        JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.getEditor();
        JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
        return jFormattedTextField;
    }

    public boolean setSuffix(String string) {
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.getEditor();
        DecimalFormat decimalFormat = numberEditor.getFormat();
        decimalFormat.setPositiveSuffix(string);
        decimalFormat.setNegativeSuffix(string);
        return true;
    }

    public String getSuffix() {
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.getEditor();
        DecimalFormat decimalFormat = numberEditor.getFormat();
        return decimalFormat.getPositiveSuffix();
    }

    public int getDigitForRoundingOut() {
        return this.mDigitForRoundOut;
    }

    public boolean setDigitForRoundingOut(int n) {
        this.mDigitForRoundOut = n;
        return true;
    }

    public boolean isInteger() {
        DecimalFormat decimalFormat = this.getDecimalFormat();
        int n = decimalFormat.getMinimumFractionDigits();
        int n2 = decimalFormat.getMaximumFractionDigits();
        return n == 0 && n2 == 0;
    }

    public Number getNumber() {
        try {
            this.commitEdit2();
        }
        catch (Exception exception) {
            return null;
        }
        Object object = this.getValue();
        return (Number)object;
    }

    public boolean setText(String string) {
        this.getFormattedTextField().setText(string);
        return true;
    }

    public void commitEdit() throws ParseException {
        this.commit(1);
        super.commitEdit();
        this.mTempString = this.getFormattedTextField().getText();
    }

    void clearTemporaryValues() {
        this.mTempString = null;
    }

    public void commitEdit2() throws ParseException {
        this.commit(0);
        super.commitEdit();
    }

    private boolean commit(int n) throws ParseException {
        JFormattedTextField jFormattedTextField = this.getFormattedTextField();
        String string = jFormattedTextField.getText();
        String string2 = this.parseString(string, n);
        if (string2 != null) {
            jFormattedTextField.setText(string2);
            jFormattedTextField.commitEdit();
        } else {
            throw new ParseException("parseSting failed.", 0);
        }
        return true;
    }

    private String parseString(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        JFormattedTextField jFormattedTextField = this.getFormattedTextField();
        String string2 = this.getUnit();
        if (string2 == null) {
            Float f = null;
            try {
                f = Float.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            if (this.isInteger()) {
                float f2 = ((Number)f).floatValue();
                int n2 = (int)Math.rint(f2);
                int n3 = this.getMinimumValue().intValue();
                int n4 = this.getMaximumValue().intValue();
                if (n2 < n3) {
                    n2 = n3;
                }
                if (n2 > n4) {
                    n2 = n4;
                }
                String string3 = Integer.toString(n2);
                return string3;
            }
            return ((Object)f).toString();
        }
        String string4 = null;
        Number number = null;
        try {
            number = this.isInteger() ? (Number)Integer.valueOf(string) : (Number)Float.valueOf(string);
            string4 = number.toString() + this.getSpinnerUnit(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string4 = string;
        }
        String string5 = null;
        string5 = SGUtilityNumber.isLengthUnit(string2) ? SGUtilityNumber.convertString(string4, string2) : SGUtilityNumber.removeUnit(string4, string2);
        if (string5 == null) {
            return null;
        }
        if (this.isInteger()) {
            int n5 = Integer.valueOf(string5);
            int n6 = this.getMinimumValue().intValue();
            int n7 = this.getMaximumValue().intValue();
            if (n5 < n6) {
                n5 = n6;
            }
            if (n5 > n7) {
                n5 = n7;
            }
            String string6 = new Integer(n5).toString() + this.getSpinnerUnit(string2);
            return string6;
        }
        float f = Float.valueOf(string5).floatValue();
        float f3 = this.getMinimumValue().floatValue();
        float f4 = this.getMaximumValue().floatValue();
        if (f < f3) {
            f = f3;
        }
        if (f > f4) {
            f = f4;
        }
        float f5 = 0.0f;
        switch (n) {
            case 0: {
                f5 = (float)SGUtilityNumber.roundOffNumber(f, this.mDigitForRoundOut);
                break;
            }
            case 1: {
                f5 = f;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        String string7 = new Float(f5).toString() + this.getSpinnerUnit(string2);
        return string7;
    }

    public String getSpinnerUnit(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (string.equals("cm")) {
            string2 = SPINNER_UNIT_CM;
        } else if (string.equals("mm")) {
            string2 = SPINNER_UNIT_MM;
        } else if (string.equals("pt")) {
            string2 = SPINNER_UNIT_PT;
        } else if (string.equals("inch")) {
            string2 = SPINNER_UNIT_INCH;
        } else if (string.equals(SGIConstants.degree)) {
            string2 = SPINNER_UNIT_DEGREE;
        }
        return string2;
    }

    public String getUnit() {
        JFormattedTextField jFormattedTextField = this.getFormattedTextField();
        String string = this.getSuffix();
        String string2 = null;
        if (string.equals(SPINNER_UNIT_CM)) {
            string2 = "cm";
        } else if (string.equals(SPINNER_UNIT_MM)) {
            string2 = "mm";
        } else if (string.equals(SPINNER_UNIT_INCH)) {
            string2 = "inch";
        } else if (string.equals(SPINNER_UNIT_PT)) {
            string2 = "pt";
        } else if (string.equals(SPINNER_UNIT_DEGREE)) {
            string2 = SGIConstants.degree;
        }
        return string2;
    }

    public Number getMinimumValue() {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.getModel();
        return (Number)((Object)spinnerNumberModel.getMinimum());
    }

    public Number getMaximumValue() {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.getModel();
        return (Number)((Object)spinnerNumberModel.getMaximum());
    }

    public Number getStepSize() {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.getModel();
        return spinnerNumberModel.getStepSize();
    }

    private Number getValueOnStepInside(float f, float f2) {
        float f3;
        float f4;
        if (f < f2) {
            f4 = f;
            f3 = f2;
        } else if (f2 < f) {
            f4 = f2;
            f3 = f;
        } else {
            return null;
        }
        float f5 = this.getMinimumValue().floatValue();
        float f6 = this.getMaximumValue().floatValue();
        float f7 = this.getStepSize().floatValue();
        if (f7 < Float.MIN_VALUE) {
            throw new Error();
        }
        Float f8 = null;
        int n = 0;
        int n2 = this.mDigitForRoundOut;
        while (true) {
            float f9;
            float f10;
            if (f4 < (f10 = (float)SGUtilityNumber.roundOffNumber(f9 = f5 + (float)n * f7, n2))) {
                if (!(f10 < f3)) break;
                f8 = new Float(f10);
                break;
            }
            ++n;
        }
        return f8;
    }
}

