/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.io.IOException;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class Gradient {
    private int ratio;
    private int endRatio;
    private Color color;
    private Color endColor;

    public Gradient(int ratio, Color color) {
        this.ratio = ratio;
        this.color = color;
    }

    public Gradient(int ratio, int endRatio, Color color, Color endColor) {
        this(ratio, color);
        this.endRatio = endRatio;
        this.endColor = endColor;
    }

    public Gradient(SWFInputStream input, boolean hasAlpha, boolean isMorphStyle) throws IOException {
        this.ratio = input.readUnsignedByte();
        this.color = input.readColor(hasAlpha);
        if (isMorphStyle) {
            this.endRatio = input.readUnsignedByte();
            this.endColor = input.readColor(true);
        }
    }

    public void write(SWFOutputStream swf, boolean hasAlpha) throws IOException {
        swf.writeUnsignedByte(this.ratio);
        swf.writeColor(this.color, hasAlpha);
        if (this.endColor != null) {
            swf.writeUnsignedByte(this.endRatio);
            swf.writeColor(this.endColor, true);
        }
    }

    public String toString() {
        return "Gradient " + this.ratio + ", " + this.color + (this.endColor != null ? ", " + this.endRatio + ", " + this.endColor : "");
    }
}

