/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGSignificantDifferenceSymbol;

public class SGSignificantDifferenceSymbolDialog
extends SGPropertyDialog {
    public static final String TITLE = "Significant Difference Symbol Dialog";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JButton mColorButton;
    private JLabel mColorLabel;
    private JComboBox mFontFamilyNameComboBox;
    private JLabel mFontFamilyNameLabel;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private JComboBox mFontStyleComboBox;
    private JLabel mLeftSpaceLabel;
    private JLabel mLineWidthLabel;
    private SGSpinner mLineWidthSpinner;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mSpaceLabel;
    private SGSpinner mSpaceSpinner;
    private JLabel mStringLabel;
    private JSeparator mStringSeparator;
    private JPanel mTextPanel;

    public SGSignificantDifferenceSymbolDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mTextPanel = new JPanel();
        this.mFontFamilyNameLabel = new JLabel();
        this.mFontStyleComboBox = new JComboBox();
        this.mFontSizeLabel = new JLabel();
        this.mLineWidthSpinner = new SGSpinner();
        this.mColorLabel = new JLabel();
        this.mLineWidthLabel = new JLabel();
        this.mFontSizeSpinner = new SGSpinner();
        this.mFontFamilyNameComboBox = new JComboBox();
        this.mColorButton = new JButton();
        this.mStringLabel = new JLabel();
        this.mStringSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mSpaceLabel = new JLabel();
        this.mSpaceSpinner = new SGSpinner();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mOKButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mTextPanel.setLayout(new GridBagLayout());
        this.mTextPanel.setBorder(new BevelBorder(0));
        this.mFontFamilyNameLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyNameLabel.setText("Font");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mTextPanel.add((Component)this.mFontFamilyNameLabel, gridBagConstraints);
        this.mFontStyleComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mFontStyleComboBox, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mTextPanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mLineWidthSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTextPanel.add((Component)this.mLineWidthSpinner, gridBagConstraints);
        this.mColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mTextPanel.add((Component)this.mColorLabel, gridBagConstraints);
        this.mLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel.setText("Line Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTextPanel.add((Component)this.mLineWidthLabel, gridBagConstraints);
        this.mFontSizeSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mFontFamilyNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mFontFamilyNameComboBox, gridBagConstraints);
        this.mColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mColorButton, gridBagConstraints);
        this.mStringLabel.setFont(new Font("MS Sans Serif", 3, 12));
        this.mStringLabel.setText("String");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mStringLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 55, 5, 5);
        this.mTextPanel.add((Component)this.mStringSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mTextPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        this.mTextPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mSpaceLabel.setFont(new Font("Dialog", 0, 12));
        this.mSpaceLabel.setText("Space");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTextPanel.add((Component)this.mSpaceLabel, gridBagConstraints);
        this.mSpaceSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTextPanel.add((Component)this.mSpaceSpinner, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mTextPanel, gridBagConstraints);
        this.pack();
    }

    public static void main(String[] stringArray) {
        new SGSignificantDifferenceSymbolDialog((Frame)new JFrame(), true).show();
    }

    public Number getSpace() {
        return this.mSpaceSpinner.getNumber();
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public String getFontFamilyName() {
        return (String)this.mFontFamilyNameComboBox.getSelectedItem();
    }

    public int getFontStyle() {
        String string = (String)this.mFontStyleComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public ArrayList getTextColorList() {
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(this.mColorButton.getBackground());
        return arrayList;
    }

    public Number getLineWidth() {
        return this.mLineWidthSpinner.getNumber();
    }

    public boolean setSpace(float f) {
        this.mSpaceSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFontSize(float f) {
        this.mFontSizeSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFontFamilyName(String string) {
        this.mFontFamilyNameComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFontStyle(int n) {
        String string = SGUtilityText.getFontStyleName(n);
        this.mFontStyleComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setColorList(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        if (arrayList.size() == 0) {
            return false;
        }
        Color color = (Color)arrayList.get(0);
        this.mColorButton.setBackground(color);
        return true;
    }

    public boolean setLineWidth(float f) {
        this.mLineWidthSpinner.setValue(new Double(f));
        return true;
    }

    public ArrayList getColorSelectionComponentList() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.mColorButton);
        return arrayList;
    }

    public ArrayList getActiveComponentList() {
        ArrayList arrayList = this.getActiveComponentListFromSpinners();
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mSpaceSpinner);
        arrayList.add(this.mLineWidthSpinner);
        return arrayList;
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = SGUtility.getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontFamilyNameComboBox.addItem(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.mFontStyleComboBox.addItem(stringArray2[i]);
        }
        this.pack();
        this.mSpaceSpinner.initProperties(new SpinnerNumberModel(0.1, 0.0, 1.0, 0.01), " cm");
        this.mFontSizeSpinner.initProperties(this.getFontSizeSpinnerNumberModel(), " pt");
        this.mLineWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        this.mColorButton.addActionListener(this);
        this.mFocusedColorSetButton = this.mColorButton;
        return true;
    }

    public boolean setActionListener(ActionListener actionListener) {
        this.mOKButton.addActionListener(actionListener);
        this.mCancelButton.addActionListener(actionListener);
        this.mPreviewButton.addActionListener(actionListener);
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            sGSpinner.getFormattedTextField().addActionListener(actionListener);
        }
        return true;
    }

    public boolean removeActionListener() {
        ActionListener[] actionListenerArray = this.mOKButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.mOKButton.removeActionListener(actionListenerArray[i]);
            this.mCancelButton.removeActionListener(actionListenerArray[i]);
            this.mPreviewButton.removeActionListener(actionListenerArray[i]);
            ArrayList arrayList = this.getSpinnerList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGSpinner sGSpinner = (SGSpinner)arrayList.get(j);
                sGSpinner.getFormattedTextField().removeActionListener(actionListenerArray[i]);
            }
        }
        return true;
    }

    public SGSignificantDifferenceSymbol.SigDiffProperties getProperties() {
        SGSignificantDifferenceSymbol.SigDiffProperties sigDiffProperties = new SGSignificantDifferenceSymbol.SigDiffProperties();
        Number number = this.getSpace();
        if (number == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        sigDiffProperties.space = number.floatValue() / 0.035277776f;
        Number number2 = this.getFontSize();
        if (number2 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        sigDiffProperties.fontSize = number2.floatValue();
        sigDiffProperties.fontFamilyName = this.getFontFamilyName();
        sigDiffProperties.fontStyle = this.getFontStyle();
        Number number3 = this.getLineWidth();
        if (number3 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        sigDiffProperties.lineWidth = number3.floatValue();
        sigDiffProperties.colorList = this.getTextColorList();
        return sigDiffProperties;
    }
}

