/*
 * Decompiled with CFR 0.152.
 */
package sakana.util;

import java.io.InputStream;
import java.util.ArrayDeque;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import sakana.resource.ConfigDefinition;
import sakana.util.AutoMapper;

public class XmlReader
extends AutoMapper {
    private static XmlReader own = null;
    private InputStream in;

    public static XmlReader getInstance() {
        if (own == null) {
            own = new XmlReader();
        }
        return own;
    }

    private XmlReader() {
    }

    public void setXmlInputStream(InputStream in) {
        this.in = in;
    }

    @Override
    public String getUnCashedString(Object key) {
        return this.getValue((ConfigDefinition)((Object)key));
    }

    @Override
    public int getUnCashedInt(Object key) {
        return Integer.parseInt(this.getUnCashedString(key));
    }

    private String getValue(ConfigDefinition key) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.in);
            Element root = doc.getDocumentElement();
            ArrayDeque<ConfigDefinition> stack = new ArrayDeque<ConfigDefinition>();
            ConfigDefinition def = key;
            while (def.getParent() != null) {
                stack.push(def);
                def = def.getParent();
            }
            Element element = root;
            while (!stack.isEmpty()) {
                def = (ConfigDefinition)((Object)stack.pop());
                NodeList nodeList = element.getElementsByTagName(def.getTag().getTagName());
                Element elem = null;
                int i = 0;
                while (i < nodeList.getLength()) {
                    String attrValue;
                    elem = (Element)nodeList.item(i);
                    String defAttr = def.getTag().getAttributeName();
                    if (defAttr == null || (attrValue = elem.getAttribute(defAttr)).equals(def.getAttrValue())) break;
                    ++i;
                }
                element = elem;
            }
            return element.getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

