/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : TurnDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/19
 *    Last                 : 2003/02/19
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

#include "Trace.h"
#define _TURNDLG_
#include "TurnDlg.h"





/* -------------------------------------------------------------------
 * CANCEL
 */
void turn_dlg_cancel_pushed(GtkWidget *widget, TURN_DLG *turn_dlg)
{
	turn_dlg->x_pos = 0;
	turn_dlg->y_pos = 0;
	turn_dlg->angle = 0;
	turn_dlg->repeats = 0;
}



/* -------------------------------------------------------------------
 * OK
 */
void turn_dlg_ok_pushed(GtkWidget *widget, TURN_DLG *turn_dlg)
{
	char str[256];


	/* ƥȥȥ꡼ʸ */
	if (turn_dlg->x_pos_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(turn_dlg->x_pos_entry)));
		turn_dlg->x_pos = atof(str);
	}

	if (turn_dlg->y_pos_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(turn_dlg->y_pos_entry)));
		turn_dlg->y_pos = atof(str);
	}

	if (turn_dlg->angle_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(turn_dlg->angle_entry)));
		turn_dlg->angle = atof(str);
	}

	if (turn_dlg->repeats_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(turn_dlg->repeats_entry)));
		turn_dlg->repeats = atoi(str);
	}

}



/* -------------------------------------------------------------------
 * 줿٥
 * key_press_event
 */
static gint turn_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, TURN_DLG *turn_dlg)
{
//	g_print("sagcad.c : turn_dlg_key_press_event  state:%d  keyval:0x%x  length:%d  string:%s\n", 
//			event->state, event->keyval, event->length, event->string);


	if (event->keyval == 0xff0d || event->keyval == 0xff8d) {		/* Enter */
		/* ե x_pos_entry  Enter ʤե y_pos_entry ˰ܤ */
		if (GTK_WIDGET( turn_dlg->x_pos_entry) == GTK_WINDOW(turn_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(turn_dlg->dialog), turn_dlg->y_pos_entry);
			gtk_entry_select_region(GTK_ENTRY(turn_dlg->y_pos_entry), 0, GTK_ENTRY(turn_dlg->y_pos_entry)->text_length);
		}
		/* ե y_pos_entry  Enter ʤե angle_entry ˰ܤ */
		else if (GTK_WIDGET(turn_dlg->y_pos_entry) == GTK_WINDOW(turn_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(turn_dlg->dialog), turn_dlg->angle_entry);
			gtk_entry_select_region(GTK_ENTRY(turn_dlg->angle_entry), 0, GTK_ENTRY(turn_dlg->angle_entry)->text_length);
		}
		/* ե angle_entry  Enter ʤե repeats_entry ˰ܤ */
		else if (GTK_WIDGET(turn_dlg->angle_entry) == GTK_WINDOW(turn_dlg->dialog)->focus_widget) {
			gtk_window_set_focus(GTK_WINDOW(turn_dlg->dialog), turn_dlg->repeats_entry);
			gtk_entry_select_region(GTK_ENTRY(turn_dlg->repeats_entry), 0, GTK_ENTRY(turn_dlg->repeats_entry)->text_length);
		}
		/* ե repeats_entry  Enter ʤ齪 */
		else if (GTK_WIDGET(turn_dlg->repeats_entry) == GTK_WINDOW(turn_dlg->dialog)->focus_widget) {
			turn_dlg_ok_pushed(widget, turn_dlg);
			gtk_main_quit();
		}
	}
	return TRUE; 
}



/* -------------------------------------------------------------------
 * ԡڰư/ʣ̡
 * 
 */
gint TurnDialog(TURN_DLG *turn_dlg)
{
//	GtkWidget *dialog;
	char str[256];

	GtkWidget *main_vbox;
		GtkWidget *hbox;
			GtkWidget *label_vbox;
				GtkWidget *x_pos_label;
				GtkWidget *y_pos_label;
				GtkWidget *angle_label;
				GtkWidget *repeats_label;
			GtkWidget *entry_vbox;
//				GtkWidget *x_pos_entry;
//				GtkWidget *y_pos_entry;
//				GtkWidget *angle_entry;
//				GtkWidget *repeats_entry;
		GtkWidget *separator;
		GtkWidget *action_hbox;
			GtkWidget *cancel_buttun;
			GtkWidget *ok_buttun;


	/*  */
	turn_dlg->dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_position(GTK_WINDOW(turn_dlg->dialog), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(turn_dlg->dialog), _("Turn [Move/Copy] Setting") );
	gtk_signal_connect( GTK_OBJECT(turn_dlg->dialog), "key_press_event",
						GTK_SIGNAL_FUNC(turn_dlg_key_press_event), turn_dlg);


	main_vbox = gtk_vbox_new(0, 5);
	gtk_container_add(GTK_CONTAINER(turn_dlg->dialog), main_vbox);
	gtk_container_border_width(GTK_CONTAINER(turn_dlg->dialog), 5);
	gtk_widget_show(main_vbox);



	hbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), 
						hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);

	/* ѥ졼(separator) */
	separator = gtk_hseparator_new();
	gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
	gtk_widget_show(separator);

	action_hbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start( GTK_BOX(main_vbox), 
						action_hbox, TRUE, TRUE, 0);
	gtk_widget_show(action_hbox);


		label_vbox = gtk_vbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), label_vbox, TRUE, TRUE, 0);
		gtk_widget_show(label_vbox);

		entry_vbox = gtk_vbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), entry_vbox, TRUE, TRUE, 0);
		gtk_widget_show(entry_vbox);


			x_pos_label = gtk_label_new( _("Starting Point X") );
			gtk_widget_set_usize (x_pos_label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), x_pos_label, TRUE, TRUE, 0);
			gtk_widget_show(x_pos_label);

			y_pos_label = gtk_label_new( _("Starting Point Y") );
			gtk_widget_set_usize (y_pos_label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), y_pos_label, TRUE, TRUE, 0);
			gtk_widget_show(y_pos_label);

			angle_label = gtk_label_new( _("Angle") );
			gtk_widget_set_usize (angle_label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), angle_label, TRUE, TRUE, 0);
			gtk_widget_show(angle_label);

			repeats_label = gtk_label_new( _("Number of times") );
			gtk_widget_set_usize (repeats_label, 100, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), repeats_label, TRUE, TRUE, 0);
			gtk_widget_show(repeats_label);


			/* ƥȥȥ꡼ */
			/* ž */
			turn_dlg->x_pos_entry = gtk_entry_new();
			gtk_widget_set_usize (turn_dlg->x_pos_entry, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), turn_dlg->x_pos_entry, TRUE, TRUE, 1);
			/*  */
			FloatOut_n(str, turn_dlg->x_pos, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(turn_dlg->x_pos_entry), str);
			gtk_entry_select_region( GTK_ENTRY(turn_dlg->x_pos_entry), 0, 
									 GTK_ENTRY(turn_dlg->x_pos_entry)->text_length);
			//gtk_signal_connect (GTK_OBJECT(entry), "activate", GTK_SIGNAL_FUNC(entry_callback), NULL);
			gtk_widget_show(turn_dlg->x_pos_entry);

			/* ž */
			turn_dlg->y_pos_entry = gtk_entry_new();
			gtk_widget_set_usize (turn_dlg->y_pos_entry, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), turn_dlg->y_pos_entry, TRUE, TRUE, 1);
			/*  */
			FloatOut_n(str, turn_dlg->y_pos, 6, 0);
			gtk_entry_set_text(GTK_ENTRY(turn_dlg->y_pos_entry), str);
			//gtk_entry_select_region( GTK_ENTRY(turn_dlg->y_pos_entry), 0, 
			//						   GTK_ENTRY(turn_dlg->y_pos_entry)->text_length);
			gtk_widget_show(turn_dlg->y_pos_entry);

			/*  */
			turn_dlg->angle_entry = gtk_entry_new();
			gtk_widget_set_usize (turn_dlg->angle_entry, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), turn_dlg->angle_entry, TRUE, TRUE, 1);
			gtk_entry_set_text(GTK_ENTRY(turn_dlg->angle_entry), "0");
			//gtk_entry_select_region( GTK_ENTRY(turn_dlg->angle_entry), 0, 
			//						   GTK_ENTRY(turn_dlg->angle_entry)->text_length);
			gtk_widget_show(turn_dlg->angle_entry);

			/*  */
			turn_dlg->repeats_entry = gtk_entry_new();
			gtk_widget_set_usize (turn_dlg->repeats_entry, 150, 20);
			gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), turn_dlg->repeats_entry, TRUE, TRUE, 1);
			gtk_entry_set_text(GTK_ENTRY(turn_dlg->repeats_entry), "1");
			//gtk_entry_select_region(GTK_ENTRY(turn_dlg->repeats_entry), 0, GTK_ENTRY(turn_dlg->repeats_entry)->text_length);
			gtk_widget_show(turn_dlg->repeats_entry);



		/* CANCELܥ */
		cancel_buttun = gtk_button_new_with_label("CANCEL");
		gtk_widget_set_usize (cancel_buttun, 80, 20);
		gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
		gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(turn_dlg_cancel_pushed), turn_dlg);
		gtk_signal_connect( GTK_OBJECT(cancel_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
		gtk_widget_show(cancel_buttun);

		/* OKܥ */
		ok_buttun = gtk_button_new_with_label("OK");
		gtk_widget_set_usize (ok_buttun, 80, 20);
		gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
		gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(turn_dlg_ok_pushed), turn_dlg);
		gtk_signal_connect(GTK_OBJECT(ok_buttun), "clicked", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	//	  GTK_WIDGET_SET_FLAGS(ok_buttun, GTK_CAN_DEFAULT);
	//	  gtk_widget_grab_default(ok_buttun);
		gtk_widget_show(ok_buttun);


	/*  ե x_pos_entry  */
	gtk_window_set_focus(GTK_WINDOW(turn_dlg->dialog), turn_dlg->x_pos_entry);
//	GTK_WINDOW(turn_dlg->dialog)->focus_widget = GTK_WIDGET(turn_dlg->x_pos_entry);


	/* ̤ɽ */
	gtk_window_set_modal(GTK_WINDOW(turn_dlg->dialog), TRUE);
	/* ᥤ󥦥ɥǤʤ褦 */
	gtk_window_set_transient_for(GTK_WINDOW(turn_dlg->dialog), GTK_WINDOW(turn_dlg->parent));


	/* Ļ֤ */
	gtk_widget_show(turn_dlg->dialog);
	/* ᥤ󥤥٥ȥ롼 */
	gtk_main();
	gtk_widget_destroy(turn_dlg->dialog);
	return 0; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : TurnDlg.c
 * ====================================================================
 */
