/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Select.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2002/09/08
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>

#include <stdio.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include "intl.h"

#include "types.h"
#include "MemoryLeak.h"
#include "List_cad.h"
#include "List_Dimension.h"
#include "List_PolyLine.h"
#include "List_insert.h"
#include "List_Ellipse.h"
#include "List_Vertex.h"
#include "List_Block.h"
#include "List_Undo.h"
#include "List_Select.h"
#include "global.h"
#include "etc.h"
#include "sagcad.h"
#include "Trace.h"
#include "Ellipse.h"
#include "Draw.h"
#include "spline.h"
#include "B_spline.h"
#include "MsgBox.h"
#include "Dimension.h"
#include "Mouse.h"
#include "InputBox.h"
#include "Line_dlg.h"
#include "OutsideProcess.h"

#define _SELECT_
#include "Select.h"



/* -------------------------------------------------------
 * 쥯ȥ⡼
 *	
 * X, Y 		 ɸ (X , Y)
 *	
 * SelectFrag	 
 *	  ޷	 1 : 
 *				 2 : 
 *				 4 : ߸
 *				 8 : 
 *				15 : ޷
 * 
 *	  ˡ޷	16 : 
 *				32 : Ⱦ
 *				64 : 濴
 *			   128 : Ǥ
 *			   256 : ˡ޷
 *			   512 : ݥ饤
 *			  1024 : ֥å
 *			  2048 : ʱ
 * 
 * Type 		 0 : ʣԲ
 *				 1 : ʣ
 * 
 */
int MouseSelect(GtkWidget *widget, double X, double Y, int SelectFrag, int Type)
{
	SELECT DumySelect, RetSelect;
	int dumy, i, No;
	CAD *ReP;			//1
	char str1[256], str2[256], str[256];


	Already = 0;

	/* ޥå(Ǥ) */
	if ( (SelectFrag & 128) == 128 ) {
		/* åɥ⡼ɤʤ */
		if ((sagcad_system.GridMode & 2) == 2) {
			X = sagcad_system.Grid * (int)(X / sagcad_system.Grid);
			Y = sagcad_system.Grid * (int)(Y / sagcad_system.Grid);
		}
		
		/* ------------------------------------------
		 * MouseUp() ˤ󤿤ϽʤƤ
		 * Select[0].Data ˣΤ餻롣
		 */
		mouse_select_frag.index = 1;
		mouse_select_frag.diagram_point.Nuru_point = NULL;
		mouse_select_frag.x = sg(X, 6);
		mouse_select_frag.y = sg(Y, 6);
		/* Select Data ꥹȤκǸɲ */
		select_list_add_last(&mouse_select_frag);
		(*ReturnFunc)(widget, 2, 0, 0);
		return 1;
	}



	/* -----------------------------------------------------
	 * ݥ饤ǡ 
	 * SelectFrag = 512   
	 * index : 8
	 * 
	 */
	if ( (SelectFrag & 512) == 512 ) {
		mouse_select_frag.diagram_point.polyline_point = PolyLine_search(X, Y);
		/* Ĥʤ */
		if (mouse_select_frag.diagram_point.polyline_point == NULL) {
			/* ---------------------------------------
			 * MouseUp() ˤ󤿤ϽʤƤ
			 * Select[0].Data ˣΤ餻롣
			 */
			mouse_select_frag.index = 0;
			mouse_select_frag.diagram_point.Nuru_point = NULL;
			mouse_select_frag.x = X;
			mouse_select_frag.y = Y;
			//return 0;
		}

		/* Ĥä */
		else {
			mouse_select_frag.index = 8;
			mouse_select_frag.x = X;
			mouse_select_frag.y = Y;


			/* ---------------------------------------
			 * WAIT  ޷ä,BrinkEnd ؿǺɽ롣
			 * ԤȤ˵ưȤgѤؿ
			 * 1 : ˴ؿƤӽФ(1=1000)
			 * 2 : ƤӽФؿ
			 * 3 : ؿϤ
			 */
			PolyLineDraw(drawing_area, mouse_select_frag.diagram_point.polyline_point, SCD_HIDE);
			UpDate();
			gtk_timeout_add(sagcad_system.Wait, BrinkEnd, (gpointer)&mouse_select_frag);
			return 1;
		}
	}



	/* -----------------------------------------------------
	 * ʱߥǡ 
	 * SelectFrag = 2048
	 * index = 16
	 */
	if ( (SelectFrag & 2048) == 2048 ) {
		mouse_select_frag.diagram_point.ellipse_point = ellipse_search(X, Y);
		/* Ĥʤ */
		if (mouse_select_frag.diagram_point.ellipse_point == NULL) {
			/* ---------------------------------------
			 * MouseUp() ˤ󤿤ϽʤƤ
			 * Select[0].Data ˣΤ餻롣
			 */
			mouse_select_frag.index = 0;
			mouse_select_frag.diagram_point.Nuru_point = NULL;
			mouse_select_frag.x = X;
			mouse_select_frag.y = Y;
			//return 0;
		}

		/* Ĥä */
		else {
			mouse_select_frag.index = 16;
			mouse_select_frag.x = X;
			mouse_select_frag.y = Y;


			/* ---------------------------------------
			 * WAIT  ޷ä,BrinkEnd ؿǺɽ롣
			 * ԤȤ˵ưȤgѤؿ
			 * 1 : ˴ؿƤӽФ(1=1000)
			 * 2 : ƤӽФؿ
			 * 3 : ؿϤ
			 */
			EllipseDraw(drawing_area, mouse_select_frag.diagram_point.ellipse_point, SCD_HIDE);
			UpDate();
			gtk_timeout_add(sagcad_system.Wait, BrinkEnd, (gpointer)&mouse_select_frag);
			return 1;
		}
	}



	/* ˡǡ */
	if( (SelectFrag & 256) == 256 ) {
		mouse_select_frag.diagram_point.dimension_point = SnpLook(X, Y);
		/* Ĥʤ */
		if (mouse_select_frag.diagram_point.dimension_point == NULL) {
			/* ---------------------------------------
			 * MouseUp() ˤ󤿤ϽʤƤ
			 * Select[0].Data ˣΤ餻롣
			 */
			mouse_select_frag.index = 0;
			mouse_select_frag.diagram_point.Nuru_point = NULL;
			mouse_select_frag.x = X;
			mouse_select_frag.y = Y;
			//return 0;
		}

		/* Ĥä */
		else {
			mouse_select_frag.index = 3;
			mouse_select_frag.x = X;
			mouse_select_frag.y = Y;


			/* ---------------------------------------
			 * WAIT  ޷ä,BrinkEnd ؿǺɽ롣
			 * ԤȤ˵ưȤgѤؿ
			 * 1 : ˴ؿƤӽФ(1=1000)
			 * 2 : ƤӽФؿ
			 * 3 : ؿϤ
			 */
			DimensionDraw(drawing_area, mouse_select_frag.diagram_point.dimension_point, SCD_HIDE);
			UpDate();
			gtk_timeout_add(sagcad_system.Wait, BrinkEnd, (gpointer)&mouse_select_frag);
			return 1;
		}
	}



	/* ˡ⡼ɤΤȤ */
	if(mode > 500 && mode < 600) {
		if((SelectFrag & 16) == 16 || (SelectFrag & 32) == 32
			 || (SelectFrag & 64) == 64 || (SelectFrag & 1) == 1)
		{
			/* ޷ü */
			DumySelect.x = X;
			DumySelect.y = Y;
			dumy = TanTenLook(&DumySelect);
			if(dumy != 0) {
				/*
				 * MouseUp() ˤ󤿤ϽʤƤ
				 * mouse_select_frag.index ˣΤ餻롣
				 */
				mouse_select_frag.index = 0;
				mouse_select_frag.diagram_point.Nuru_point = NULL;
				mouse_select_frag.x = 0;
				mouse_select_frag.y = 0;

				/* Select Data ꥹȤκǸɲ */
				select_list_add_last(&DumySelect);
				ReturnFunc(widget, 1, 0, 0);
				return 1;
			}
			return 0;
		}
	}




	/* -----------------------------------------------------
	 * ֥ 쥯  
	 * 
	 * -----------------------------------------------------
	 */
	ReP = NULL;
	/* -------------------------------------------
	 * ֥󥯤᤯ޥΥܥȤ
	 * 쥯ȤλƤ Already = 1
	 *
	 * ֥󥯤᤯ޥΥܥȤ
	 * 쥯ȤĤʤäޤϴλƤʤȤ Already = 0
	 */
	Already = 0;

	No = 1;
	i = 0;
	while (No != 0) {
		/* Ȥꤢǡõ */
		dumy = MouseSelectL(X, Y, SelectFrag, &RetSelect);
		/* 褿餽ˤ̵*/
		if ( dumy == 0) {
			/* -----------------------------------
			 * ܥΥȤ(MouseUp)˥ǡʤ
			 * ޤϤ٤ƥ쥯ȤƤ뤳Ȥ
			 * Select[0].Data ˣΤ餻롣
			 */
			mouse_select_frag.index = 0;
			mouse_select_frag.diagram_point.Nuru_point = NULL;
			mouse_select_frag.x = 0;
			mouse_select_frag.y = 0;
			/* ơʥСɽ */
			sprintf(str, _(" There is not a diagram there. or already chosen.") );
			StatusMsg(str);
			//beep();
			return 0;
		}


		/* ---------------------------------------
		 * 򤵤ƤΤФʤ(򥻥å)
		 * (Type == 0:ʣԲ) 
		 */
		if (Type == 0) {
			/* ޷쥯ȤƤ뤫ǧ 
			 * 0:ޤ	1:Ѥ
			 */
			No = SelectCheck(RetSelect.diagram_point.cad_point);
			if (i == 0) {
				ReP = RetSelect.diagram_point.cad_point;
				i++;
			}
			else {
				if (ReP == RetSelect.diagram_point.cad_point) {
					/* ---------------------------
					 * ܥΥȤ(MouseUp)˥ǡʤ
					 * ޤϤ٤ƥ쥯ȤƤ뤳Ȥ 		
					 * mouse_select_frag.index ˣΤ餻롣
					 */
					mouse_select_frag.index = 0;
					mouse_select_frag.diagram_point.Nuru_point = NULL;
					mouse_select_frag.x = 0;
					mouse_select_frag.y = 0;
					/* ǡʥСɽ */
					sprintf(str, _("It is already chosen.") );
					StatusMsg(str);
					//Beep;
					return 0;
				}
			}
		}
		/* ---------------------------------------
		 * 򤵤ƤΤ֡(ѥå)
		 */
		else if (Type == 2) {
			/* ޷쥯ȤƤ뤫ǧ 
			 * 0:ޤ	1:Ѥ
			 */
			if (SelectCheck(RetSelect.diagram_point.cad_point) == 1) No = 0;
			if (i == 0) {
				ReP = RetSelect.diagram_point.cad_point;
				i++;
			}
			else {
				if (ReP == RetSelect.diagram_point.cad_point) {
					/* ---------------------------
					 * ܥΥȤ(MouseUp)˥ǡʤ
					 * ޤϤ٤ƥ쥯ȤƤ뤳Ȥ 		
					 * mouse_select_frag.index ˣΤ餻롣
					 */
					mouse_select_frag.index = 0;
					mouse_select_frag.diagram_point.Nuru_point = NULL;
					mouse_select_frag.x = 0;
					mouse_select_frag.y = 0;
					/* ǡʥСɽ */
					sprintf(str, _(" It isn't yet chosen.") );
					StatusMsg(str);
					//Beep;
					return 0;
				}
			}
		}
		else {
			/* ǡ No = 0 */
			No = 0;
		}
	}


	/* ǡĤäȤν */
	if (RetSelect.diagram_point.cad_point != NULL && No == 0) {
		/* ---------------------------------------
		 * ޥ򲡤
		 * MdX & MdY ˤκɸϡ
		 *	
		 * ޥȤκɸ
		 * MdX & MdY ȤΤǡ쥯Ȥ뤫롣
		 */
		mouse_select_frag.index = 2;
		mouse_select_frag.diagram_point.cad_point = RetSelect.diagram_point.cad_point;
		mouse_select_frag.x = sg(X, 6);
		mouse_select_frag.y = sg(Y, 6);


		/* ---------------------------------------
		 * ǡʥСɽ
		 * ܥ򲡤Ƥ֤ɽ
		 */
		DataInfo(&mouse_select_frag, str2);				/* ޷ǡ */
		sprintf(str1,"Search %s", str2);				/*  */
		StatusMsg(str1); 								/* ơСɽ */


		/* ---------------------------------------
		 * WAIT  ޷ä,BrinkEnd ؿǺɽ롣
		 * ֤Ȥ˵ưȤ˻Ѥؿ
		 * 1 : ˴ؿƤӽФ(1=1000)
		 * 2 : ƤӽФؿ
		 * 3 : ؿϤ
		 */
		SelectCadDraw (widget, mouse_select_frag.diagram_point.cad_point, SCD_HIDE);
		gtk_timeout_add(sagcad_system.Wait, BrinkEnd, (gpointer)&mouse_select_frag);
		return 1;
	}


	/* ǡĤʤäν */
	else {
		//Beep;
		return 0;
	}
	return 0;
}





/* -------------------------------------------------------
 * MouseSelect ؿΥ֥󥯤ˤäƾä줿޷ɽ
 */
gint BrinkEnd(gpointer data)
{
//char str[256];
//g_print("Mouse.c : BrinkEnd() : Already = %d  index = %d\n", Already, ((SELECT *)data)->index);

	/* -----------------------------------------------------
	 * ֥󥯤äȤޥΥܥƤʤ
	 * ޤϥ쥯ȿ޷ʤ
	 * äȤκɽϡꥸʥ륫顼
	 */
	if (Already == 0 && data != NULL) {
		SelectDraw (drawing_area, (SELECT *)data, SCD_ORG, UPDATE_ON);
	}

	/* -----------------------------------------------------
	 * ֥󥯤äȤޥΥܥƤ롣
	 * 쥯ȤλƤ롣
	 * äȤκɽϡ쥯ȥ顼
	 * ȤθϺɽߤʤΤ Select[0].Data  0 ֤Τ
	 * ɽʤ
	 */
	else if (Already == 1 && data != NULL && ((SELECT *)data)->index != 0) {
		SelectDraw (drawing_area, (SELECT *)data, SCD_SELECT, UPDATE_ON);
	}
	return FALSE;
}





/* -------------------------------------------------------
 * ޷ǡ
 */
int DataInfo(SELECT *select, char *str)
{
	char str1[256], str2[256];
	long no;


	if (select->diagram_point.Nuru_point == NULL) return 0;



	/* Mouse Point Data */
	if (select->index == 1) {

	}

	/* CAD Data */
	else if (select->index == 2) {
		/* ǡθ(CAD Data  Data No.  long ͤ) */
		no = cad_search_cad_to_num(select->diagram_point.cad_point, &cad_list_info);

		/* ǡΤȤ */
		if(select->diagram_point.cad_point->code == 0) {
			FloatOut(str2, select->diagram_point.cad_point->sx, 0);
			strcpy(str1, "(");
			strcat(str1, str2);
			strcat(str1, ",");
			FloatOut(str2, select->diagram_point.cad_point->sy, 0);
			strcat(str1, str2);
			strcat(str1, ")");
			sprintf(str, " CAD No.%d [POINT %s", (int)no, str1);
		}

		/* ǡΤȤ */
		else if(select->diagram_point.cad_point->code == 1) {
			strcpy(str1, "(");
			FloatOut(str2, select->diagram_point.cad_point->sx, 0);
			strcat(str1, str2);
			strcat(str1, ",");
			FloatOut(str2, select->diagram_point.cad_point->sy, 0);
			strcat(str1, str2);
			strcat(str1, ")-(");
			FloatOut(str2, select->diagram_point.cad_point->ex, 0);
			strcat(str1, str2);
			strcat(str1, ",");
			FloatOut(str2, select->diagram_point.cad_point->ey, 0);
			strcat(str1, str2);
			strcat(str1, ")");
			sprintf(str, " CAD No.%d [LINE %s", (int) no, str1);
		}

		/* ߸̥ǡΤȤ */
		else if(select->diagram_point.cad_point->code == 2) {
			strcpy(str1, "(");
			FloatOut(str2, select->diagram_point.cad_point->cx, 0);
			strcat(str1, str2);
			strcat(str1, ",");
			FloatOut(str2, select->diagram_point.cad_point->cy, 0);
			strcat(str1, str2);
			strcat(str1, "), R");
			FloatOut(str2, select->diagram_point.cad_point->r, 0);
			strcat(str1, str2);
			strcat(str1, ", (");
			FloatOut(str2, select->diagram_point.cad_point->sx, 0);
			strcat(str1, str2);
			strcat(str1, ",");
			FloatOut(str2, select->diagram_point.cad_point->sy, 0);
			strcat(str1, str2);
			strcat(str1, ")-(");
			FloatOut(str2, select->diagram_point.cad_point->ex, 0);
			strcat(str1, str2);
			strcat(str1, ",");
			FloatOut(str2, select->diagram_point.cad_point->ey, 0);
			strcat(str1, str2);
			strcat(str1, ")");
			sprintf(str, " CAD No.%d [ARC %s", (int) no, str1);
		}

		/* ߥǡΤȤ */
		else if(select->diagram_point.cad_point->code == 4)
		{
			strcpy(str1, "(");
			FloatOut(str2, select->diagram_point.cad_point->cx, 0);
			strcat(str1, str2);
			strcat(str1, ",");
			FloatOut(str2, select->diagram_point.cad_point->cy, 0);
			strcat(str1, str2);
			strcat(str1, "), R");
			FloatOut(str2, select->diagram_point.cad_point->r, 0);
			strcat(str1, str2);
			sprintf(str, " CAD No.%d [CIRCLE] %s", (int) no, str1);
		}
		else return 0;
	}


	/* Dimension Data */
	else if (select->index == 3) {
		/* ǡθ(DIMENSION Data  Data No.  long ͤ) */
		no = dimension_search_dimension_to_num(select->diagram_point.dimension_point, &dimension_list_info);
		sprintf(str, " DIMENSION No.%d ", (int)no);
	}


	/* polyline Data */
	else if (select->index == 8) {
		/* ǡθ(POLYLINE Data  Data No.  long ͤ) */
		no = polyline_search_polyline_to_num(select->diagram_point.polyline_point, &polyline_list_info);
		if (select->diagram_point.polyline_point->code == 8) {
			if (  (select->diagram_point.polyline_point->frag & 1) == 1  ) {
				sprintf(str, _(" POLYLINE No.%d [broken line (close)") , (int)no);
			}
			else {
				sprintf(str, _(" POLYLINE No.%d [broken line (open)") , (int)no);
			}
		}
		else if (select->diagram_point.polyline_point->code == 16) {
			if (  (select->diagram_point.polyline_point->frag & 1) == 1  ) {
				sprintf(str, _(" POLYLINE No.%d [spline(close)]") , (int)no);
			}
			else {
				sprintf(str, _(" POLYLINE No.%d [spline(open)]") , (int)no);
			}
		}
		else if (select->diagram_point.polyline_point->code == 32) {
			sprintf(str, " POLYLINE No.%d [¥ץ饤]", (int)no);
		}
		else {
			sprintf(str, " POLYLINE No.%d ", (int)no);
		}
	}


	/* ellipse Data */
	else if (select->index == 16) {
		/* ǡθ(ELLIPSE Data  Data No.  long ͤ) */
		no = ellipse_search_ellipse_to_num(select->diagram_point.ellipse_point, &ellipse_list_info);

		strcpy(str1, "(");
		FloatOut(str2, select->diagram_point.ellipse_point->cx, 0);
		strcat(str1, str2);
		strcat(str1, ",");
		FloatOut(str2, select->diagram_point.ellipse_point->cy, 0);
		strcat(str1, str2);
		strcat(str1, "), a = ");
//g_print ("DataInfo() : call\n");
		FloatOut(str2, get_ellipse_a(*select->diagram_point.ellipse_point), 0);
		strcat(str1, str2);
		strcat(str1, ", b = ");
		FloatOut(str2, get_ellipse_b(*select->diagram_point.ellipse_point), 0);
		strcat(str1, str2);
		strcat(str1, ", angle = ");
		FloatOut(str2, get_ellipse_angle(*select->diagram_point.ellipse_point), 0);
		strcat(str1, str2);

		strcat(str1, ", sa = ");
		FloatOut(str2, select->diagram_point.ellipse_point->sa, 0);
		strcat(str1, str2);
		strcat(str1, ", ea = ");
		FloatOut(str2, select->diagram_point.ellipse_point->ea, 0);
		strcat(str1, str2);


		sprintf(str, " ELLIPSE No.%d %s", (int)no, str1);
	}


	/* Error Data */
	else {
		// 
	}


	return 1;
}




/* -------------------------------------------------------
 * 쥯ȥ⡼ɤ Sub
 */
int MouseSelectL(double x, double y, int SelectFrag, SELECT *RetSelect)
{
	CAD *Ret;

	if (mode == 200) {
		/* õ */
		if ((SelectFrag & 1) == 1) {
			Ret = TenLook(x, y);
			if (Ret != NULL) {
				RetSelect->index = 2;
				RetSelect->diagram_point.cad_point = Ret;
				RetSelect->x = 0;
				RetSelect->y = 0;
				return 1;
			}
		}
	}

	Ret = Look(x, y, SelectFrag);
	if (Ret != NULL) {
		RetSelect->index = 2;
		RetSelect->diagram_point.cad_point = Ret;
		RetSelect->x = 0;
		RetSelect->y = 0;
		return 1;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * õ
 * ޥɤɸ (x , y) 顢˶ᤤ [߸̡] õ
 * ( DC ͤᤤ )
 *	
 *   CAD *	 CAD Data ؤΥݥ󥿤֤
 *   CAD_LIST StartData
 */
CAD *Look(double x, double y, int SelectFrag)
{
//#define LOOK
	CAD_LIST *p;
	int debug = 0;

#ifdef LOOK
	debug = 1;
#endif

	if (StartData == NULL && cad_list_info.head != NULL) {
		if (debug > 0) g_print("Look Function in StartData = NULL\n");
		StartData = cad_list_info.tail;
	}
	else if (cad_list_info.head == NULL) {
		if (debug > 0) g_print("Look CAD Data ʤ");
		return NULL;
	}

	/* p  StartData  */
	p = StartData;

	/* -----------------------------------------------------
	 * p ǸΥǡ tail ʤ p ǽΥǡ head ˤ롣
	 * ʳʤ顢p ̥ǡ(StartData 褫õ
	 */
	if (debug > 0) g_print("Look Function Start StartData = %d\n", (int)cad_search_cad_to_num(p->cad, &cad_list_info));
	if (p == cad_list_info.tail) {
		p = cad_list_info.head;
	}
	else if (p != cad_list_info.tail) { 
		p = p->next;
	}
	if (debug > 0) g_print("Look : First Search Start Data No = %d\n", (int)cad_search_cad_to_num(p->cad, &cad_list_info));


	/* p  ǡκǸޤǤõ */
	while (p != NULL) {
		if (TenCheck(x, y, p) != 0 && (SelectFrag & 1) == 1) {
			/* ----------------------------------------------
			 * Ĥä硢Υǡ̿޷
			 * ǽΥǡȤ뤿 StartData 롣
			 */
			StartData = p;
			if (debug > 0) g_print("    Look (point) : First Search Data No = %d  <YES>\n", (int)cad_search_cad_to_num(p->cad, &cad_list_info));
			return p->cad;
		}
		if (LineCheck(x, y, p) != 0 && (SelectFrag & 2) == 2) {
			StartData = p;
			if (debug > 0) g_print("    Look (line) : First Search Data No = %d  <YES>\n", (int)cad_search_cad_to_num(p->cad, &cad_list_info));
			return p->cad;
		}
		if (ArcCheck(x, y, p) != 0 && (SelectFrag & 4) == 4) {
			StartData = p;
			if (debug > 0) g_print("    Look (arc) : First Search Data No = %d  <YES>\n", (int)cad_search_cad_to_num(p->cad, &cad_list_info));
			return p->cad;
		}
		if (CirCheck(x, y, p) != 0 && (SelectFrag & 8) == 8) {
			StartData = p;
			if (debug > 0) g_print("    Look (circle) : First Search Data No = %d  <YES>\n", (int)cad_search_cad_to_num(p->cad, &cad_list_info));
			return p->cad;
		}
		if (debug > 0) g_print("    Look : First Search Data No = %d  <NO>\n", (int)cad_search_cad_to_num(p->cad, &cad_list_info));
		p = p->next;
	}


	/* -----------------------------------------------------
	 * StartData  tail ä
	 * ǽ餫ǸޤõƤ뤫餳θνϤʤ
	 */
	if (StartData == cad_list_info.tail) {
		if (debug > 0) g_print("Look First Search Only Return\n");
		return NULL;
	}


	/* ------------------------------------------------------------
	 * ǡκǽ餫 StartData ޤǤõ
	 */
	p =  cad_list_info.head;
	if (debug > 0) g_print("Look : Second Search Start Data No = %d\n", (int)cad_search_cad_to_num(p->cad, &cad_list_info));
	while (p != NULL && p != StartData->next) {
		if (TenCheck(x, y, p) != 0 && (SelectFrag & 1) == 1) {
			StartData = p;
			if (debug > 0) g_print("    Look : Second Search Data No = %d  <YES>\n", (int)cad_search_cad_to_num(p->cad, &cad_list_info));
			return p->cad;
		}
		if (LineCheck(x, y, p) != 0 && (SelectFrag & 2) == 2) {
			StartData = p;
			if (debug > 0) g_print("    Look : Second Search Data No = %d  <YES>\n", (int)cad_search_cad_to_num(p->cad, &cad_list_info));
			return p->cad;
		}
		if (ArcCheck(x, y, p) != 0 && (SelectFrag & 4) == 4) {
			StartData = p;
			if (debug > 0) g_print("    Look : Second Search Data No = %d  <YES>\n", (int)cad_search_cad_to_num(p->cad, &cad_list_info));
			return p->cad;
		}
		if (CirCheck(x, y, p) != 0 && (SelectFrag & 8) == 8) {
			StartData = p;
			if (debug > 0) g_print("    Look : Second Search Data No = %d  <YES>\n", (int)cad_search_cad_to_num(p->cad, &cad_list_info));
			return p->cad;
		}
		if (debug > 0) g_print("    Look : Second Search Data No = %d  <NO>\n", (int)cad_search_cad_to_num(p->cad, &cad_list_info));
		p = p->next;
	}
	StartData = p;
	if (debug > 0) g_print("Look : Second Search Return StartData = %d\n",  (int)cad_search_cad_to_num(StartData->cad, &cad_list_info));
	return NULL;
}





/* -------------------------------------------------------------------
 * 쥯ȿ޷Υ쥤䡼ѹ
 *	
 * Change_Frag 1 : ư
 * Change_Frag 2 : ʣ
 */
int Change_Layer(int Change_Frag)
{
	CAD NewCad;
	DIMENSION NewDimension;
	POLYLINE Newpolyline;
	ELLIPSE NewEllipse;

	CAD_LIST *cp;
	DIMENSION_LIST *dp;
	POLYLINE_LIST *pp;
	ELLIPSE_LIST *ep;

	SELECT_LIST *sp;
	int LayerNo, Ret = 0;
	char str[256], org[256];

	VERTEX_LIST *v;
	VERTEX vertex;


	/* ϥܥåɽ */
	if (Change_Frag == 1) {
		Ret = InputBox( _("Layer Move") , _("The layer in the movement place.") , _("(The hexadecimal number.)") , org);
	}
	else if (Change_Frag == 2) {
		Ret = InputBox( _("Layer Copy") , _("The layer in the copy place."), _("(The hexadecimal number.)") , org);
	}
//Ret = 0; /* ---ȤǤȤ */

	if (Ret == -1) return 0;
	if (strstr(org, "0x") == NULL) {
		strcpy(str, "0x");
		strcat(str, org);
	}
	else {
		strcpy(str, org);
	}
	LayerNo = atoi16(str);
	if (LayerNo < 0 || LayerNo > 255) return 0;


	if (select_list_info.head != NULL) undo_index_plus();
	/* ư */
	if (Change_Frag == 1) {
		sp = select_list_info.head;
		while (sp != NULL) {

			/* οޤä */
			SelectDraw(drawing_area, sp->select, SCD_HIDE, UPDATE_OFF);

			/* ޷ǡ */
			if (sp->select->index == 2 || sp->select->index == 4) {
				NewCad = *sp->select->diagram_point.cad_point;
				NewCad.layer = LayerNo;
				/* CAD Data ѹ롢 Undo Baffer ˽ */
				cp = cad_list_edit_with_undo(
							cad_search_cad(sp->select->diagram_point.cad_point, &cad_list_info), 
							&NewCad, 
							&cad_list_info);
			}

			/* ˡǡ */
			else if (sp->select->index == 3) {
				NewDimension = *sp->select->diagram_point.dimension_point;
				NewDimension.Layer = LayerNo;
				/* DIMENSION Data ѹ롢 Undo Baffer ˽ */
				dp = dimension_list_edit_with_undo(
							dimension_search_dimension(sp->select->diagram_point.dimension_point, &dimension_list_info), 
							&NewDimension, &dimension_list_info);
			}

			/* ǡ */
			else if (sp->select->index == 8) {
				Newpolyline = *sp->select->diagram_point.polyline_point;
				Newpolyline.layer = LayerNo;
				sp->select->diagram_point.polyline_point->layer = LayerNo;
				/* POLYLINE Data ѹ롢 Undo Baffer ˽ */
				pp = polyline_list_edit_with_undo(
							polyline_search_polyline(sp->select->diagram_point.polyline_point, &polyline_list_info), 
							&Newpolyline, 
							&polyline_list_info);
			}

			/* ʱߥǡ */
			else if (sp->select->index == 16) {
				NewEllipse = *sp->select->diagram_point.ellipse_point;
				NewEllipse.layer = LayerNo;
				/* ELLIPSE Data ѹ롢 Undo Baffer ˽ */
				ep = ellipse_list_edit_with_undo(
							ellipse_search_ellipse(sp->select->diagram_point.ellipse_point, &ellipse_list_info), 
							&NewEllipse, 
							&ellipse_list_info);
			}

			/* ư褬ɽʤɽ */
			if (Layer[LayerNo].draw == 1) {
				SelectDraw(drawing_area, sp->select, SCD_SELECT, UPDATE_OFF);
			}
			sp = sp->next;
		}
	}



	/* ʣ */
	else if (Change_Frag == 2) {
		sp = select_list_info.head;
		while (sp != NULL) {

			/* οޤäɽ */
			SelectDraw(drawing_area, sp->select, SCD_HIDE, UPDATE_OFF);
			SelectDraw(drawing_area, sp->select, SCD_ORG, UPDATE_OFF);

			/* ޷ǡ */
			if (sp->select->index == 2 || sp->select->index == 4) {
				NewCad = *sp->select->diagram_point.cad_point;
				NewCad.layer = LayerNo;
				/* CAD Data ꥹȤκǽɲ */
				cp = cad_list_add_first_with_undo(&NewCad, &cad_list_info);
				sp->select->diagram_point.cad_point = cp->cad;
			}

			/* ˡǡ */
			else if (sp->select->index == 3) {
				NewDimension = *sp->select->diagram_point.dimension_point;
				NewDimension.Layer = LayerNo;
				/* Dimension Data ꥹȤκǽɲ */
				dp = dimension_list_add_first_with_undo(&NewDimension, &dimension_list_info);
				sp->select->diagram_point.dimension_point = dp->dimension;
			}

			/* ǡ */
			if (sp->select->index == 8) {
				Newpolyline = *sp->select->diagram_point.polyline_point;
				Newpolyline.layer = LayerNo;

				v = sp->select->diagram_point.polyline_point->vertex_list_info.head;
				while (v != NULL) {
					vertex = *v->vertex;
					vertex_list_add_last(&vertex, &Newpolyline.vertex_list_info);
					v = v->next;
				}

				/* POLYLINE Data ꥹȤκǽɲ */
				pp = polyline_list_add_first(&Newpolyline, &polyline_list_info);
				sp->select->diagram_point.polyline_point = pp->polyline;
			}

			/* ʱߥǡ */
			else if (sp->select->index == 16) {
				NewEllipse = *sp->select->diagram_point.ellipse_point;
				NewEllipse.layer = LayerNo;
				/* CAD Data ꥹȤκǽɲ */
				ep = ellipse_list_add_first_with_undo(&NewEllipse, &ellipse_list_info);
				sp->select->diagram_point.ellipse_point = ep->ellipse;
			}

			/* ư褬ɽʤɽ */
			if (Layer[LayerNo].draw == 1) {
				SelectDraw(drawing_area, sp->select, SCD_SELECT, UPDATE_OFF);
			}
			sp = sp->next;
		}
	}
	UpDate();
	return 1;
}





/* -------------------------------------------------------------------
 * ǡ⤫顢ӣţ
 *  : int
 *		: RtnDumy.sx1 = sa	RtnDumy.sy1 = ea
 */
int iSaEa(CAD_LIST *p, struct RtnDat *RtnDumy)
{
	struct RtnDat rtn;

	rtn.sx[1] = p->cad->cx;
	rtn.sy[1] = p->cad->cy;
	rtn.ex[1] = p->cad->sx;
	rtn.ey[1] = p->cad->sy;
	la(&rtn);
	RtnDumy->sx[1] = rtn.angle;

	rtn.sx[1] = p->cad->cx;
	rtn.sy[1] = p->cad->cy;
	rtn.ex[1] = p->cad->ex;
	rtn.ey[1] = p->cad->ey;
	la(&rtn);
	RtnDumy->sy[1] = rtn.angle;
	return 1;
}





/* -------------------------------------------------------
 * ޷ǡ *p α߸̤Ф angle ϱ߸̤ SA EA 椫
 *  : int	1: 	0
 */
int ArcIn(CAD_LIST *p, double Angle)
{
	double SA, EA;
	struct RtnDat rtn;
	
	/* ӣ ţ롣 */
	iSaEa(p, &rtn);
	SA = rtn.sx[1];
	EA = rtn.sy[1];
	
	/* --- <	> --- */
	if(SA < EA) {
		if(sg(Angle, 6) >= sg(SA, 6) && sg(Angle, 6) <= sg(EA, 6)) {
			return 1;
		}
	}
	else if(SA > EA) {
		if(sg(Angle, 6) >= sg(SA, 6) || sg(Angle, 6) <= sg(EA, 6)) {
			return 1;
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * õ
 * ޥɤɸ (x , y) 顢˶ᤤõ
 * ( DC ͤᤤ )
 *	
 *   CAD *	 CAD Data ؤΥݥ󥿤֤
 *   CAD_LIST StartData
 */
CAD *TenLook(double x, double y)
{
	CAD_LIST *p;


	/* StartData */
	if (StartData == NULL && cad_list_info.head != NULL) {
		StartData = cad_list_info.tail;
	}
	/* CAD DATA ʤ */
	else if (cad_list_info.head == NULL) {
		return NULL;
	}

	/* p  StartData  */
	p = StartData;

	/* -----------------------------------------------------
	 * p ǸΥǡ tail ʤ p ǽΥǡ head ˤ롣
	 * ʳʤ顢p ̥ǡ(StartData 褫õ
	 */
	if (p == cad_list_info.tail) {
		p = cad_list_info.head;
	}
	else if (p != cad_list_info.tail) { 
		p = p->next;
	}


	/* p  ǡκǸޤǤõ */
	while (p != NULL) {
		if (TenCheck(x, y, p) != 0) {
			/* ----------------------------------------------
			 * Ĥä硢Υǡ̿޷
			 * ǽΥǡȤ뤿 StartData 롣
			 */
			StartData = p;
			return p->cad;
		}
		p = p->next;
	}

	/* -----------------------------------------------------
	 * StartData  tail ä
	 * ǽ餫ǸޤõƤ뤫餳θνϤʤ
	 */
	if (StartData == cad_list_info.tail) {
		return NULL;
	}

	/* ------------------------------------------------------------
	 * ǡκǽ餫 StartData ޤǤõ
	 */
	p =  cad_list_info.head;
	while (p != NULL && p != StartData->next) {
		if (TenCheck(x, y, p) != 0) {
			/* ----------------------------------------------
			 * Ĥä硢Υǡ̿޷
			 * ǽΥǡȤ뤿 StartData 롣
			 */
			StartData = p;
			return p->cad;
		}
		p = p->next;
	}
	StartData = p;
	return NULL;
}





/* -------------------------------------------------------
 * õ (sub)
 * ɸ (x , y) ǡ i Ǥ뤫å
 * (DC ͤᤤͤ)
 */
int TenCheck(double x, double y, CAD_LIST *p)
{
	struct RtnDat PPH;


//	if (cad_search_cad(p->cad) == NULL) return 0;

	if (p->cad->code == 0) {
		if (Layer[p->cad->layer].draw != 0) {
			PPH.sx[1] = p->cad->sx;
			PPH.sy[1] = p->cad->sy;
			PPH.ex[1] = x;
			PPH.ey[1] = y;
			pp(&PPH);
			if (PPH.l <= DC) {
				return 1;
			}
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * õ
 * ޥɤɸ (x , y) 顢˶ᤤõ
 * ( DC ͤᤤ )
 *	
 *   CAD *	 CAD Data ؤΥݥ󥿤֤
 *   CAD_LIST StartData
 */
CAD *LineLook(double x, double y)
{
	CAD_LIST *p;


	if (StartData == NULL && cad_list_info.head != NULL) {
		StartData = cad_list_info.tail;
	}
	else if (cad_list_info.head == NULL) {
		return NULL;
	}

	/* p  StartData  */
	p = StartData;

	/* -----------------------------------------------------
	 * p ǸΥǡ tail ʤ p ǽΥǡ head ˤ롣
	 * ʳʤ顢p ̥ǡ(StartData 褫õ
	 */
	if (p == cad_list_info.tail) {
		p = cad_list_info.head;
	}
	else if (p != cad_list_info.tail) { 
		p = p->next;
	}


	/* p  ǡκǸޤǤõ */
	while (p != NULL) {
		if (LineCheck(x, y, p) != 0) {
			/* ----------------------------------------------
			 * Ĥä硢Υǡ̿޷
			 * ǽΥǡȤ뤿 StartData 롣
			 */
			StartData = p;
			return p->cad;
		}
		p = p->next;
	}


	/* -----------------------------------------------------
	 * StartData  tail ä
	 * ǽ餫ǸޤõƤ뤫餳θνϤʤ
	 */
	if (StartData == cad_list_info.tail) {
		return NULL;
	}


	/* ------------------------------------------------------------
	 * ǡκǽ餫 StartData ޤǤõ
	 */
	p =  cad_list_info.head;
	while (p != NULL && p != StartData->next) {
		if (LineCheck(x, y, p) != 0) {
			/* ----------------------------------------------
			 * Ĥä硢Υǡ̿޷
			 * ǽΥǡȤ뤿 StartData 롣
			 */
			StartData = p;
			return p->cad;
		}
		p = p->next;
	}
	StartData = p;
	return NULL;
}





/* -------------------------------------------------------
 * õ (sub)
 */
int LineCheck(double x, double y, CAD_LIST *p)
{
	struct RtnDat PLPH, PPH, LAH;
	double L0, L1, A1, L2, A2;


	/* Фõ */
	if (p->cad->code == 1) {
		/* ɽƤ쥤䡼õ */
		if (Layer[p->cad->layer].draw != 0) {
			/* κǶ */
			PLPH.sx[2] = x;
			PLPH.sy[2] = y;
			PLPH.sx[1] = p->cad->sx;
			PLPH.sy[1] = p->cad->sy;
			PLPH.ex[1] = p->cad->ex;
			PLPH.ey[1] = p->cad->ey;
			plp(&PLPH);
			/* Ƕ	 PLPH.ex[2] , PLPH.ey[2] */
			
			/* ȺǶεΥ */
			PPH.sx[1] = x;
			PPH.sy[1] = y;
			PPH.ex[1] = PLPH.ex[2];
			PPH.ey[1] = PLPH.ey[2];
			pp(&PPH);
			/* Υ PPH.L */
			L0 = PPH.l;
			
			/* Υ DC ʾʤõƤǤϤʤ*/
			if (L0 > DC) {
				return 0;
			}
			
			
			/* n齪γ٤ȵΥ */
			PPH.sx[1] = p->cad->sx;
			PPH.sy[1] = p->cad->sy;
			PPH.ex[1] = p->cad->ex;
			PPH.ey[1] = p->cad->ey;
			pp(&PPH);
			/* Υ PPH.L */
			L1 = PPH.l;
			
			LAH.sx[1] = p->cad->sx;
			LAH.sy[1] = p->cad->sy;
			LAH.ex[1] = p->cad->ex;
			LAH.ey[1] = p->cad->ey;
			la(&LAH);
			/*  LAH.ANGLE */
			A1 = LAH.angle;
			
			/* nǶγ٤ȵΥ */
			PPH.sx[1] = p->cad->sx;
			PPH.sy[1] = p->cad->sy;
			PPH.ex[1] = PLPH.ex[2];
			PPH.ey[1] = PLPH.ey[2];
			pp(&PPH);
			/* Υ PPH.L */
			L2 = PPH.l;

			LAH.sx[1] = p->cad->sx;
			LAH.sy[1] = p->cad->sy;
			LAH.ex[1] = PLPH.ex[2];
			LAH.ey[1] = PLPH.ey[2];
			la(&LAH);
			/*  LAH.ANGLE */
			A2 = LAH.angle;
			
			/* nγ٤ƱǡnǶޤǤĹĹΤĹ(L1>L2)*/
			if (A1 + (1/pow(10, compa_digits)) > A2 
				&& 
				A1 - (1/pow(10, compa_digits)) < A2) 
			{
//			if (sg(A1, 1) == sg(A2, 1)) {
				if (L1 > L2) {
					return 1;
				}
			}
			else {
				return 0;
			}
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ߸̤õ
 * ޥɤɸ (x , y) 顢˶ᤤ߸̤õ
 * ( DC ͤᤤ )
 *	
 *   CAD *	 CAD Data ؤΥݥ󥿤֤
 *   CAD_LIST StartData
 */
CAD *ArcLook(double x, double y)
{
	CAD_LIST *p;
	
	if (StartData == NULL && cad_list_info.head != NULL) {
		StartData = cad_list_info.tail;
	}
	else if (cad_list_info.head == NULL) {
		return NULL;
	}

	/* p  StartData  */
	p = StartData;

	/* -----------------------------------------------------
	 * p ǸΥǡ tail ʤ p ǽΥǡ head ˤ롣
	 * ʳʤ顢p ̥ǡ(StartData 褫õ
	 */
	if (p == cad_list_info.tail) {
		p = cad_list_info.head;
	}
	else if (p != cad_list_info.tail) { 
		p = p->next;
	}


	/* p  ǡκǸޤǤõ */
	while (p != NULL) {
		if (ArcCheck(x, y, p) != 0) {
			/* ----------------------------------------------
			 * Ĥä硢Υǡ̿޷
			 * ǽΥǡȤ뤿 StartData 롣
			 */
			StartData = p;
			return p->cad;
		}
		p = p->next;
	}

	/* -----------------------------------------------------
	 * StartData  tail ä
	 * ǽ餫ǸޤõƤ뤫餳θνϤʤ
	 */
	if (StartData == cad_list_info.tail) {
		return NULL;
	}

	/* ------------------------------------------------------------
	 * ǡκǽ餫 StartData ޤǤõ
	 */
	p =  cad_list_info.head;
	while (p != NULL && p != StartData->next) {
		if (ArcCheck(x, y, p) != 0) {
			/* ----------------------------------------------
			 * Ĥä硢Υǡ̿޷
			 * ǽΥǡȤ뤿 StartData 롣
			 */
			StartData = p;
			return p->cad;
		}
		p = p->next;
	}
	StartData = p;
	return NULL;
}





/* -------------------------------------------------------
 * ߸̤õ (sub)
 * ޥɤɸ (x , y) 顢˶ᤤ߸̤õ
 * DCͤᤤͤα߸̡
 * ǡ i ο޷ˤĤʤƤ޷򥻥쥯Ȥ
 */
int ArcCheck( double x , double y , CAD_LIST *p)
{
	double MAXR , MINR , CL , SA ,EA ;
	struct RtnDat LAH, ISAEA;


	if (p->cad->code == 2) {
		if (Layer[p->cad->layer].draw != 0) {
			/* ޤޥκɸȱߤ濴εΥȾ£Ҥˤʤ뤫å*/
			CL = sqrt((x - p->cad->cx) * (x - p->cad->cx) + (y - p->cad->cy) * (y - p->cad->cy));
			MAXR = p->cad->r + DC;
			MINR = p->cad->r - DC;
			if (MAXR > CL && MINR < CL) {
				/* ӣ ţ롣*/
				iSaEa(p, &ISAEA);
				SA = ISAEA.sx[1];
				EA = ISAEA.sy[1];
				/* ߤ濴饯åؤγ */
				LAH.sx[1] = p->cad->cx;
				LAH.sy[1] = p->cad->cy;
				LAH.ex[1] = x;
				LAH.ey[1] = y;
				la(&LAH);
				
				if (SA < EA) {
					if (LAH.angle > SA && LAH.angle < EA) {
						return (1);
					}
				}
				else if (SA > EA) {
					if (LAH.angle >= SA || LAH.angle <= EA) {
						return (1);
					}
				}
			}
		}
	}
	return 0;
}





/* -------------------------------------------------------------------
 * ߤõ
 * ޥɤɸ (x , y) 顢˶ᤤߤõ
 * ( DC ͤᤤ )
 *	
 *   CAD *	 CAD Data ؤΥݥ󥿤֤
 *   CAD_LIST StartData
 */
CAD *CirLook(double x, double y)
{
	CAD_LIST *p;
	
	if (StartData == NULL && cad_list_info.head != NULL) {
		StartData = cad_list_info.tail;
	}
	else if (cad_list_info.head == NULL) {
		return NULL;
	}

	/* p  StartData  */
	p = StartData;

	/* -----------------------------------------------------
	 * p ǸΥǡ tail ʤ p ǽΥǡ head ˤ롣
	 * ʳʤ顢p ̥ǡ(StartData 褫õ
	 */
	if (p == cad_list_info.tail) {
		p = cad_list_info.head;
	}
	else if (p != cad_list_info.tail) { 
		p = p->next;
	}


	/* p  ǡκǸޤǤõ */
	while (p != NULL) {
		if (CirCheck(x, y, p) != 0) {
			/* ----------------------------------------------
			 * Ĥä硢Υǡ̿޷
			 * ǽΥǡȤ뤿 StartData 롣
			 */
			StartData = p;
			return p->cad;
		}
		p = p->next;
	}

	/* -----------------------------------------------------
	 * StartData  tail ä
	 * ǽ餫ǸޤõƤ뤫餳θνϤʤ
	 */
	if (StartData == cad_list_info.tail) {
		return NULL;
	}

	/* ------------------------------------------------------------
	 * ǡκǽ餫 StartData ޤǤõ
	 */
	p =  cad_list_info.head;
	while (p != NULL && p != StartData->next) {
		if (CirCheck(x, y, p) != 0) {
			/* ----------------------------------------------
			 * Ĥä硢Υǡ̿޷
			 * ǽΥǡȤ뤿 StartData 롣
			 */
			StartData = p;
			return p->cad;
		}
		p = p->next;
	}
	StartData = p;
	return NULL;
}





/* -------------------------------------------------------
 * ߤõ (sub)
 * ޥɤɸ (x , y) 顢˶ᤤߤõ
 * DCͤᤤͤαߡ
 */
int CirCheck(double x, double y, CAD_LIST *p)
{
	double MAXR , MINR , CL ;

	if (p->cad->code == 4) {
		if (Layer[p->cad->layer].draw != 0) {
			/* ޤޥκɸȱߤ濴εΥȾ£ҤˤʤΤõ*/
			CL = sqrt((x - p->cad->cx) * (x - p->cad->cx) + (y - p->cad->cy) * (y - p->cad->cy));
			MAXR = p->cad->r + DC;
			MINR = p->cad->r - DC;
			if (MAXR > CL && MINR < CL) {
				return 1;
			}
		}
	}
	return 0;
}


/* -------------------------------------------------------
 * 쥯ȿ޷ѹ
 */
int Change_Line_Style(void)
{
	int style;
	long color;
	SELECT_LIST *ps;

	style = NowStyle;
	color = NowColor;

	Line_set_dlg(&style, &color);

	/* -----------------------------------------------------------------
	 * ޷
	 */
	if (select_list_info.head != NULL) {
		ps = select_list_info.head;
		while (ps != NULL) {

			/* CAD Data */
			if (ps->select->index == 2 || ps->select->index == 4) {
				ps->select->diagram_point.cad_point->color = color;
				ps->select->diagram_point.cad_point->style = style;
			}

			/* DIMENSION Data */
			else if (ps->select->index == 3) {
				ps->select->diagram_point.dimension_point->text_color = color;
				ps->select->diagram_point.dimension_point->Assist_color = color;
			}

			/* POLYLINE Data */
			else if (ps->select->index == 8) {
				ps->select->diagram_point.polyline_point->color = color;
				ps->select->diagram_point.polyline_point->style = style;
			}

			/* ELLIPSE Data */
			else if (ps->select->index == 16) {
				ps->select->diagram_point.ellipse_point->color = color;
				ps->select->diagram_point.ellipse_point->style = style;
			}

			SelectDraw(drawing_area, ps->select, SCD_HIDE, UPDATE_OFF);
			SelectDraw(drawing_area, ps->select, SCD_SELECT, UPDATE_OFF);

			ps = ps->next;
		}
	}
	return 1;
}



/* -------------------------------------------------------
 * ǡ i ο޷쥯ȤƤ뤫ǧ
 *	
 *   int	i  ǡʥС
 *   int	0򤵤Ƥʤ 	1Ѥ
 */
int SelectCheck(CAD *data)
{
	SELECT_LIST *p;

	p = select_list_info.head;
	while (p != NULL) {
		if (p->select->diagram_point.cad_point == data) 
			return 1;
		p = p->next;
	}
	return 0;
}




/* -------------------------------------------------------
 * ǺlѤˤäݤΤõ
 * 쥯ȥǡ롣
 *	
 *   int	0:쥯ȿ޷̵	1:쥯ȿ޷ͭꡣ
 */
int SqSelect(GtkWidget *widget , double Mode310X1, double Mode310Y1, double Mode310X2, double Mode310Y2)
{
	double Dumy;
	CAD_LIST *p;
	DIMENSION_LIST *dp;
	POLYLINE_LIST *pp;
	ELLIPSE_LIST *pe;
	VERTEX_LIST *pv;
	SELECT slt;
	POINT s_point, e_point;
	int ATTA;

	SELECT_LIST *ps;


	/*
	 * ǺlѤˤäݤΤõ쥯ȥǡ롣
	 * ǤǤϤޤФʤ
	 * 쥤䡼ɽƤʤΤФʤ
	 * ꤵƤǤ֡
	 */
	if (Mode310X1 > Mode310X2) {
		Dumy = Mode310X1;
		Mode310X1 = Mode310X2;
		Mode310X2 = Dumy;
	}

	if ( Mode310Y1 > Mode310Y2) {
		Dumy = Mode310Y1;
		Mode310Y1 = Mode310Y2;
		Mode310Y2 = Dumy;
	}


	/* -----------------------------------------------------
	 * ޷ǡ 
	 */
	p = cad_list_info.head;
	while (p != NULL) {
		if ( Layer[p->cad->layer].draw != 0) {
			ATTA = 0;
			/*  */
			if (( p->cad->code == 0) && ( (DcObj & 1) == 1 )
					&& ( Mode310X1 < p->cad->sx && Mode310X2 > p->cad->sx)
						&& ( Mode310Y1 < p->cad->sy && Mode310Y2 > p->cad->sy)) {
				ATTA = 1;
			}

			/*  */
			else if (( p->cad->code == 1) && ( (DcObj & 2) == 2 )
					&& ( Mode310X1 < p->cad->sx && Mode310X2 > p->cad->sx)
						&& ( Mode310Y1 < p->cad->sy && Mode310Y2 > p->cad->sy)
							&& ( Mode310X1 < p->cad->ex && Mode310X2 > p->cad->ex)
								&& ( Mode310Y1 < p->cad->ey && Mode310Y2 > p->cad->ey)) {
				ATTA = 1;
			}

			/* ߸ */
			else if (( p->cad->code == 2) && ( (DcObj & 4) == 4 )
					&& ( Mode310X1 < p->cad->sx && Mode310X2 > p->cad->sx )
						&& ( Mode310Y1 < p->cad->sy && Mode310Y2 > p->cad->sy )
							&& ( Mode310X1 < p->cad->ex && Mode310X2 > p->cad->ex )
								&& ( Mode310Y1 < p->cad->ey && Mode310Y2 > p->cad->ey)) {
				ATTA = 1;
			}

			/*  */
			else if ((p->cad->code == 4 ) && ( (DcObj & 8) == 8 )
					&& ( Mode310X1 < p->cad->cx + p->cad->r && Mode310X2 > p->cad->cx + p->cad->r )
						&& ( Mode310Y1 < p->cad->cy && Mode310Y2 > p->cad->cy )
							&& ( Mode310X1 < p->cad->cx && Mode310X2 > p->cad->cx )
								&& ( Mode310Y1 < p->cad->cy+p->cad->r && Mode310Y2 > p->cad->cy+p->cad->r )
									&& (Mode310X1 < p->cad->cx-p->cad->r && Mode310X2 > p->cad->cx-p->cad->r)
										&& (Mode310Y1<p->cad->cy-p->cad->r && Mode310Y2>p->cad->cy-p->cad->r)) {
				ATTA = 1;
			}


			/* ޷Ĥä */
			if (ATTA == 1) {
				/* Ʊǡʤä Return 0 */
				if (SelectCheck(p->cad) == 0) {
					slt.index = 2;
					slt.x = 0;
					slt.y = 0;
					slt.diagram_point.cad_point = p->cad;
					/* Select Data ꥹȤκǸɲ */
					select_list_add_last(&slt);
//					SelectCadDraw(widget, p->cad, SCD_SELECT);
				}
			}
		}
		p = p->next;
	}



	/* -----------------------------------------------------
	 * ˡǡ 
	 */
	dp = dimension_list_info.head;
	while (dp != NULL) {
		if ( Layer[dp->dimension->Layer].draw != 0) {
			if ( (DcObj & 256) == 256 
					&& ( Mode310X1 < dp->dimension->SearchPointX && Mode310X2 > dp->dimension->SearchPointX)
						&& ( Mode310Y1 < dp->dimension->SearchPointY && Mode310Y2 > dp->dimension->SearchPointY)) {
				/* Ʊǡʤä Return 0 */
				if (SelectDimensionCheck(dp->dimension) == 0) {
					slt.index = 3;
					slt.x = 0;
					slt.y = 0;
					slt.diagram_point.dimension_point = dp->dimension;
					/* Select Data ꥹȤκǸɲ */
					select_list_add_last(&slt);
//					DimensionDraw (drawing_area, dp->dimension, SCD_SELECT);
				}
			}
		}
		dp = dp->next;
	}



	/* -----------------------------------------------------
	 * ǡ 
	 */
	pp = polyline_list_info.head;
	while (pp != NULL) {
		if ( Layer[pp->polyline->layer].draw != 0) {
			ATTA = 0;
			if ( (DcObj & 512) == 512 ) {
				pv = pp->polyline->vertex_list_info.head;
				while (pv != NULL) {
					if (
						(
							Mode310X1 < pv->vertex->x 
							&& 
							Mode310X2 > pv->vertex->x 
						)
						&& 
						(
							Mode310Y1 < pv->vertex->y 
							&& 
							Mode310Y2 > pv->vertex->y 
						)
						) 
					{
						ATTA++;
					}
					pv = pv->next;
				}

				if (pp->polyline->index == ATTA) {
					/* Ʊǡʤä Return 0 */
					if (SelectPolyLineCheck(pp->polyline) == 0) {
						slt.index = 8;
						slt.x = 0;
						slt.y = 0;
						slt.diagram_point.polyline_point = pp->polyline;
						/* Select Data ꥹȤκǸɲ */
						select_list_add_last(&slt);
//						PolyLineDraw(drawing_area, pp->polyline, SCD_SELECT);
					}
				}
			}
		}
		pp = pp->next;
	}



	/* -----------------------------------------------------
	 * ʱߥǡ 
	 */
	pe = ellipse_list_info.head;
	while (pe != NULL) {
		if ( Layer[pe->ellipse->layer].draw != 0) {

			/*   */
			get_ellipse_se_point(*pe->ellipse, &s_point, &e_point);

			if (
					((DcObj & 2048) == 2048)
					&& 
					( Mode310X1 < s_point.x && Mode310X2 > s_point.x )
					&& 
					( Mode310Y1 < s_point.y && Mode310Y2 > s_point.y )
					&& 
					( Mode310X1 < e_point.x && Mode310X2 > e_point.x )
					&& 
					( Mode310Y1 < e_point.y && Mode310Y2 > e_point.y)
				) 
			{
				/* ޷Ĥä */
				/* Ʊǡʤä Return 0 */
				if (SelectEllipseCheck(pe->ellipse) == 0) {
					slt.index = 16;
					slt.x = 0;
					slt.y = 0;
					slt.diagram_point.ellipse_point = pe->ellipse;
					/* Select Data ꥹȤκǸɲ */
					select_list_add_last(&slt);
//					SelectDraw(widget, select_list_info.tail->select, SCD_SELECT, UPDATE_OFF);
				}
			}
		}
		pe = pe->next;
	}



	/* -----------------------------------------------------------------
	 * ޷
	 */
	if (select_list_info.head != NULL) {
		ps = select_list_info.head;
		while (ps != NULL) {
			SelectDraw(widget, ps->select, SCD_SELECT, UPDATE_OFF);
			ps = ps->next;
		}
	}
	UpDate();


	if (select_list_info.head != NULL) return 1;
	return 0;
}





/* -------------------------------------------------------
 * ޷֤롣󥻥Ǹο᤹
 *	
 * 򤵤Ƥ޷ 1 ֤0 ᤹
 *	
 * ޷ 	 DrawType
 *     DrawType = 1	SCD_SELECT
 * ο	    DrawType = 0	SCD_ORG
 *       DrawType = 2	SCD_HIDE
 * 	
 */
void SelectCadDraw(GtkWidget *widget, CAD *cad, int DrawType)
{
	long SelectCadDrawColor = cad->color;


	if (cad == NULL) {
		MsgBox("SagCAD error", "CAD Data is NULL !", "SelectCadDraw error", NULL, NULL, "OK");
		return;
	}

	if ( DrawType == SCD_SELECT) SelectCadDrawColor = sagcad_color.Select;
	else if ( DrawType == SCD_ORG) SelectCadDrawColor = cad->color;
	else if ( DrawType == SCD_HIDE) SelectCadDrawColor = sagcad_color.Back;

	/* ΤȤ */
	if ( cad->code == 0) {
		if ( Layer[cad->layer].draw != 0) {
			PointDraw(widget, cad->sx, cad->sy, cad->style, sagcad_color.Back);
			PointDraw(widget, cad->sx, cad->sy, cad->style, SelectCadDrawColor);
		}
	}
	/* ľΤȤ */
	else if ( cad->code == 1) {
		if ( Layer[cad->layer].draw != 0) {
			LineDraw(widget, cad->sx, cad->sy, cad->ex, cad->ey, cad->style, sagcad_color.Back);
			LineDraw(widget, cad->sx, cad->sy, cad->ex, cad->ey, cad->style, SelectCadDrawColor);
		}
	}
	/* ߸̤ΤȤ */
	else if ( cad->code == 2) {
		if ( Layer[cad->layer].draw != 0) {
			/* ߸̤ */
			ArcDraw(widget, cad->cx, cad->cy, cad->r, cad->sx, cad->sy, cad->ex, cad->ey, cad->style, sagcad_color.Back);
			ArcDraw(widget, cad->cx, cad->cy, cad->r, cad->sx, cad->sy, cad->ex, cad->ey, cad->style, SelectCadDrawColor);
		}
	}
	/* ߤΤȤ */
	else if ( cad->code == 4) {
		if ( Layer[cad->layer].draw != 0) {
			/* ߤ */
			CircleDraw(widget, cad->cx, cad->cy, cad->r, cad->style, sagcad_color.Back);
			CircleDraw(widget, cad->cx, cad->cy, cad->r, cad->style, SelectCadDrawColor);
		}
	}
	UpDate();
}





/* -------------------------------------------------------
 * 쥯ȿ޷
 */
void SelectDelete(GtkWidget *widget)
{
	SELECT_LIST *p;
	char str[256];


	if (select_list_info.head == NULL) return;

	undo_index_plus();

	p = select_list_info.head;
	while (p != NULL) {

		SelectDraw(widget, p->select, SCD_HIDE, UPDATE_OFF);

		/* CAD DATA */
		if (p->select->index == 2 || p->select->index == 4) {
			/* CAD Data κǽ (κǤϤʤUndo Buffer ذܤ) */
			cad_list_delete_Undo(cad_search_cad(p->select->diagram_point.cad_point, &cad_list_info), 
								 &cad_list_info);
		}

		/* DIMENSION DATA */
		else if (p->select->index == 3) {
			/* Dimension Data κǽ (κǤϤʤUndo Buffer ذܤ) */
			dimension_list_delete_Undo(dimension_search_dimension(p->select->diagram_point.dimension_point, 
									   &dimension_list_info), &dimension_list_info);
		}

		/* POLYLINE DATA */
		else if (p->select->index == 8) {
			/* PolyLine Data κǽ (κǤϤʤUndo Buffer ذܤ) */
			polyline_list_delete_Undo(
					polyline_search_polyline(p->select->diagram_point.polyline_point, &polyline_list_info), 
					&polyline_list_info);
		}

		/* ELLIPSE DATA */
		else if (p->select->index == 16) {
			/* ELLIPSE Data κǽ (κǤϤʤUndo Buffer ذܤ) */
			ellipse_list_delete_Undo(
					ellipse_search_ellipse(p->select->diagram_point.ellipse_point, &ellipse_list_info), 
					&ellipse_list_info);
		}
		p = p->next;
	}

	/*	ꥹȤ */
	select_list_all_free();
	StartData = NULL;

	/* åɽ */
	sprintf(str, _("It deleted a diagram.") );
	StatusMsg(str);
	UpDate();
}





/* -------------------------------------------------------
 * 쥯ȿ޷
 */
void SelectCancel(GtkWidget *widget)
{
	SELECT_LIST *p;
	char str[256];


	if (SelectChainFrag == 1 || SelectChainFrag == 2) {
		SelectChainFrag = 0;
		OP_SelectList = NULL;
	}
	if (Chain2_OnlyOne_mode == 211) {
		SelectChain2_OnlyOne (0);
		SelectChainFrag = 0;
		OP_SelectList = NULL;
	}
	if (SelectColorFrag == 1) {
		SelectColorFrag = 0;
		OP_SelectList = NULL;
	}

	if (outside_process_on == 1) {
		outside_process_on = 0;
	}


	/* ------------------------------------------------
	 * 򤵤Ƥǡο򸵤ο
	 * ɽ롣
	 */
	p = select_list_info.head;
	while (p != NULL) {
		SelectDraw(drawing_area, p->select, SCD_HIDE, UPDATE_OFF);
		SelectDraw(drawing_area, p->select, SCD_ORG, UPDATE_OFF);
		p = p->next;
	}

	/* ˡΰַɽä */
	if (Dim_old.Text[0] != '\0') {
		DimensionDraw(drawing_area, &Dim_old, SCD_HIDE);
		Dim_old.Text[0] = '\0';
		
		/*  */
		Dim_old.diagram_of_char_index = 0;
		if (Dim_old.diagram_of_char != NULL) {
			xfree(Dim_old.diagram_of_char);
		}
		Dim_old.diagram_of_char = NULL;

		/*  */
		Dim_old.index = 0;
		if (Dim_old.AssistLine != NULL) {
			xfree(Dim_old.AssistLine);
		}
		Dim_old.AssistLine = NULL;
	}


	/* ꥹȤ */
	select_list_all_free();
	UpDate();

	mode = 0;
	ReturnFunc = MouseRet_Non;
	/* åɽ */
	sprintf(str, _(" A command was canceled.") );
	StatusMsg(str);
}





/* -------------------------------------------------------
 * CAD ǡ p_cad Ʊο޷򥻥쥯Ȥ
 */
int SelectMaskColor(CAD *p_cad)
{
	CAD_LIST *p;
	SELECT select;
	
	if (cad_list_info.head == NULL) return 0;
	p = cad_list_info.head;
	/* p  ǡκǸޤǤõ */
	while (p != NULL) {
		if (Layer[p->cad->layer].draw != 0) {
			if (p->cad->color == p_cad->color) {
				if (SelectCheck(p->cad) == 0) {
					select.index = 2;
					select.x = 0;
					select.y = 0;
					select.diagram_point.cad_point = p->cad;
					/* Select Data ꥹȤκǸɲ */
					select_list_add_last(&select);
					SelectCadDraw(drawing_area, p->cad, SCD_SELECT);
				}
			}
		}
		p = p->next;
	}
	SelectChainFrag = 0;
	SelectColorFrag = 0;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return 1;
}





/* -------------------------------------------------------
 * CAD ǡ p_cad ο޷ˤĤʤƤ޷򥻥쥯Ȥ
 */
int SelectChain(CAD *p_cad)
{
	SELECT select;
	CAD_LIST *p;


#ifdef ONE_SHOT_DEBUG
	OneShotLog("Select.c : SelectChain() : in\n");
#endif


	p = cad_list_info.head;
	/* CAD DATA ǽ餫Ǹ1ޤ */
	while (p != NULL) {
		if (Layer[p->cad->layer].draw != 0 && p->cad->code != 0) {
			/* nn */
			if (	(p_cad->sx + (1/pow(10, compa_digits)) > p->cad->sx) 
					&& 
					(p_cad->sx - (1/pow(10, compa_digits)) < p->cad->sx) 
					&& 
					(p_cad->sy + (1/pow(10, compa_digits)) > p->cad->sy) 
					&& 
					(p_cad->sy - (1/pow(10, compa_digits)) < p->cad->sy) ) 
			{
//			if (sg(p->cad->sx, 3) == sg(p_cad->sx, 3) && sg(p->cad->sy, 3) == sg(p_cad->sy, 3)) {
				if (SelectCheck(p->cad) == 0) {
					select.index = 2;
					select.x = 0;
					select.y = 0;
					select.diagram_point.cad_point = p->cad;
					/* Select Data ꥹȤκǸɲ */
					select_list_add_last(&select);
					SelectCadDraw(drawing_area, p->cad, SCD_SELECT);
					SelectChain(p->cad);
				}
			}
			/* nȽ */
			else if (	(p_cad->ex + (1/pow(10, compa_digits)) > p->cad->sx) 
						&& 
						(p_cad->ex - (1/pow(10, compa_digits)) < p->cad->sx) 
						&& 
						(p_cad->ey + (1/pow(10, compa_digits)) > p->cad->sy) 
						&& 
						(p_cad->ey - (1/pow(10, compa_digits)) < p->cad->sy) ) 
			{
//			else if (sg(p->cad->sx, 3) == sg(p_cad->ex, 3) && sg(p->cad->sy, 3) == sg(p_cad->ey, 3)) {
				if (SelectCheck(p->cad) == 0) {
					select.index = 2;
					select.x = 0;
					select.y = 0;
					select.diagram_point.cad_point = p->cad;
					/* Select Data ꥹȤκǸɲ */
					select_list_add_last(&select);
					SelectCadDraw(drawing_area, p->cad, SCD_SELECT);
					SelectChain(p->cad);
				}
			}
			/* n */
			else if (	(p_cad->sx + (1/pow(10, compa_digits)) > p->cad->ex) 
						&& 
						(p_cad->sx - (1/pow(10, compa_digits)) < p->cad->ex) 
						&& 
						(p_cad->sy + (1/pow(10, compa_digits)) > p->cad->ey) 
						&& 
						(p_cad->sy - (1/pow(10, compa_digits)) < p->cad->ey) ) 
			{
//			else if (sg(p->cad->ex, 3) == sg(p_cad->sx, 3) && sg(p->cad->ey, 3) == sg(p_cad->sy, 3)) {
				if (SelectCheck(p->cad) == 0) {
					select.index = 2;
					select.x = 0;
					select.y = 0;
					select.diagram_point.cad_point = p->cad;
					/* Select Data ꥹȤκǸɲ */
					select_list_add_last(&select);
					SelectCadDraw(drawing_area, p->cad, SCD_SELECT);
					SelectChain(p->cad);
				}
			}
			/* Ƚ */
			else if (	(p_cad->ex + (1/pow(10, compa_digits)) > p->cad->ex) 
						&& 
						(p_cad->ex - (1/pow(10, compa_digits)) < p->cad->ex) 
						&& 
						(p_cad->ey + (1/pow(10, compa_digits)) > p->cad->ey) 
						&& 
						(p_cad->ey - (1/pow(10, compa_digits)) < p->cad->ey) ) 
			{
//			else if (sg(p->cad->ex, 3) == sg(p_cad->ex, 3) && sg(p->cad->ey, 3) == sg(p_cad->ey, 3)) {
				if (SelectCheck(p->cad) == 0) {
					select.index = 2;
					select.x = 0;
					select.y = 0;
					select.diagram_point.cad_point = p->cad;
					/* Select Data ꥹȤκǸɲ */
					select_list_add_last(&select);
					SelectCadDraw(drawing_area, p->cad, SCD_SELECT);
					SelectChain(p->cad);
				}
			}
		}
		p = p->next;
	}
	SelectChainFrag = 0;
	SelectColorFrag = 0;
	(*ReturnFunc)(drawing_area, 1, 0, 0);
	return 1;
}





/* -------------------------------------------------------
 * < üؿ > ˡ񤯤Ȥˡ뤿δؿ
 * ޷Ǥü
 * (ϻOR߸̤ϻOR
 *ߤ濴ؼټʿԤȤθ濴)
 *	
 *  : int i;	޷ǡ
 *  : int		0:쥯ȤƤʤ	1:쥯ȤƤ롣
 */
int TanTenLook(SELECT *a)
{
	CAD_LIST *p;
	struct RtnDat RTN;


	p = cad_list_info.head;
	while (p != NULL) {
		/* ǡΤȤ */
		if(p->cad->code == 0) {
			if(Layer[p->cad->layer].draw != 0) {
				if (( (DcObj & 1) == 1 )) {
					RTN.sx[1] = p->cad->sx;
					RTN.sy[1] = p->cad->sy;
					RTN.ex[1] = a->x;
					RTN.ey[1] = a->y;
					pp(&RTN);
					if(RTN.l <= DC) {
						a->index = 1;
						a->diagram_point.cad_point = p->cad;
						a->x = p->cad->sx;
						a->y = p->cad->sy;
						return 1;
					}
				}
			}
		}
		
		
		/* ǡΤȤ */
		if(p->cad->code == 1) {
			if (Layer[p->cad->layer].draw != 0) {
				if (( (DcObj & 16) == 16 )) {
					RTN.sx[1] = p->cad->sx;
					RTN.sy[1] = p->cad->sy;
					RTN.ex[1] = a->x;
					RTN.ey[1] = a->y;
					pp(&RTN);
					if(RTN.l <= DC) {
						a->index = 1;
						a->diagram_point.cad_point = p->cad;
						a->x = p->cad->sx;
						a->y = p->cad->sy;
						return 1;
					}
					RTN.sx[1] = p->cad->ex;
					RTN.sy[1] = p->cad->ey;
					RTN.ex[1] = a->x;
					RTN.ey[1] = a->y;
					pp(&RTN);
					if(RTN.l <= DC) {
						a->index = 1;
						a->diagram_point.cad_point = p->cad;
						a->x = p->cad->ex;
						a->y = p->cad->ey;
						return 1;
					}
				}
			}
		}
		
		
		/* ߸̥ǡΤȤ */
		if(p->cad->code == 2) {
			if (Layer[p->cad->layer].draw != 0) {
				if (( (DcObj & 16) == 16 )) {
					// ߸̤濴
					// RTN.sx[1] = p->cad->cx;
					// RTN.sy[1] = p->cad->cy;
					// RTN.ex[1] = a->x;
					// RTN.ey[1] = a->y;
					// pp(&RTN);
					// if(RTN.l <= DC)
					// {
					//	 a->diagram_point.cad_point = p->cad;
					//	 a->x = p->cad->cx;
					//	 a->y = p->cad->cy;
					//	 return 1;
					// }
					// ߸̤n
					RTN.sx[1] = p->cad->sx;
					RTN.sy[1] = p->cad->sy;
					RTN.ex[1] = a->x;
					RTN.ey[1] = a->y;
					pp(&RTN);
					if(RTN.l <= DC) {
						a->index = 1;
						a->diagram_point.cad_point = p->cad;
						a->x = p->cad->sx;
						a->y = p->cad->sy;
						return 1;
					}
					// ߸̤ν
					RTN.sx[1] = p->cad->ex;
					RTN.sy[1] = p->cad->ey;
					RTN.ex[1] = a->x;
					RTN.ey[1] = a->y;
					pp(&RTN);
					if(RTN.l <= DC) {
						a->index = 1;
						a->diagram_point.cad_point = p->cad;
						a->x = p->cad->ex;
						a->y = p->cad->ey;
						return 1;
					}
				}
			}
		}
		
		
		/* ߥǡΤȤ */
		if (p->cad->code == 4 || p->cad->code == 2) {
			if (Layer[p->cad->layer].draw != 0) {
				if (( (DcObj & 64) == 64 )) {
					/* ߤ濴 */
					RTN.sx[1] = p->cad->cx;
					RTN.sy[1] = p->cad->cy;
					RTN.ex[1] = a->x;
					RTN.ey[1] = a->y;
					pp(&RTN);
					if(RTN.l <= DC) {
						a->index = 1;
						a->diagram_point.cad_point = p->cad;
						a->x = p->cad->cx;
						a->y = p->cad->cy;
						return 1;
					}
				}
				
				
				if (( (DcObj & 32) == 32 )) {
					/* ߤ 0  */
					RTN.sx[1] = p->cad->cx + p->cad->r;
					RTN.sy[1] = p->cad->cy;
					RTN.ex[1] = a->x;
					RTN.ey[1] = a->y;
					pp(&RTN);
					if(RTN.l <= DC) {
//int ArcIn(CAD_LIST *p, double Angle)
						if((p->cad->code == 2) && (ArcIn(p, 0) == 1)) {
							a->index = 1;
							a->diagram_point.cad_point = p->cad;
							a->x = p->cad->cx + p->cad->r;
							a->y = p->cad->cy;
							return 1;
						}
						else if(p->cad->code == 4) {
							a->index = 1;
							a->diagram_point.cad_point = p->cad;
							a->x = p->cad->cx + p->cad->r;
							a->y = p->cad->cy;
							return 1;
						}
					}
					
					/* ߤ 90  */
					RTN.sx[1] = p->cad->cx;
					RTN.sy[1] = p->cad->cy + p->cad->r;
					RTN.ex[1] = a->x;
					RTN.ey[1] = a->y;
					pp(&RTN);
					if(RTN.l <= DC) {
						if((p->cad->code == 2) && (ArcIn(p, 90) == 1)) {
							a->index = 1;
							a->diagram_point.cad_point = p->cad;
							a->x = p->cad->cx;
							a->y = p->cad->cy + p->cad->r;
							return 1;
						}
						else if(p->cad->code == 4) {
							a->index = 1;
							a->diagram_point.cad_point = p->cad;
							a->x = p->cad->cx;
							a->y = p->cad->cy + p->cad->r;
							return 1;
						}
					}
					
					/* ߤ 180  */
					RTN.sx[1] = p->cad->cx - p->cad->r;
					RTN.sy[1] = p->cad->cy;
					RTN.ex[1] = a->x;
					RTN.ey[1] = a->y;
					pp(&RTN);
					if(RTN.l <= DC) {
						if((p->cad->code == 2) && (ArcIn(p, 180) == 1)) {
							a->index = 1;
							a->diagram_point.cad_point = p->cad;
							a->x = p->cad->cx - p->cad->r;
							a->y = p->cad->cy;
							return 1;
						}
						else if(p->cad->code == 4) {
							a->index = 1;
							a->diagram_point.cad_point = p->cad;
							a->x = p->cad->cx - p->cad->r;
							a->y = p->cad->cy;
							return 1;
						}
					}
					
					/* ߤ 270  */
					RTN.sx[1] = p->cad->cx;
					RTN.sy[1] = p->cad->cy - p->cad->r;
					RTN.ex[1] = a->x;
					RTN.ey[1] = a->y;
					pp(&RTN);
					if(RTN.l <= DC) {
						if((p->cad->code == 2) && (ArcIn(p, 270) == 1)) {
							a->index = 1;
							a->diagram_point.cad_point = p->cad;
							a->x = p->cad->cx;
							a->y = p->cad->cy - p->cad->r;
							return 1;
						}
						else if(p->cad->code == 4) {
							a->index = 1;
							a->diagram_point.cad_point = p->cad;
							a->x = p->cad->cx;
							a->y = p->cad->cy - p->cad->r;
							return 1;
						}
					}
				}
			}
		}
		p = p->next;
	}
	a->index = 0;
	a->diagram_point.cad_point = NULL;
	a->x = 0;
	a->y = 0;
	return 0;
}





/* -------------------------------------------------------
 * ˡؿ	ԽΤȤˡõδؿ
 *	
 *	
 * ޥɤɸ (x , y) 顢˶ᤤˡõ
 * (DC ͤᤤͤˡ)
 *	
 *  : int ˡǡʥС֤
 *	
 */
DIMENSION *SnpLook(double x, double y)
{
//define SNPLOOK_TEST
#ifdef SNPLOOK_TEST
char str[256];
#endif

	DIMENSION_LIST *p;
	struct RtnDat PPH;


	p = dimension_list_info.head;
	while (p != NULL && p->dimension != NULL) {
		/* ɽ쥤䡼Τ */
		if (Layer[p->dimension->Layer].draw != 0) {
			PPH.sx[1] = p->dimension->SearchPointX;
			PPH.sy[1] = p->dimension->SearchPointY;
			PPH.ex[1] = x;
			PPH.ey[1] = y;
			pp(&PPH);
			if (PPH.l <= (2 * DC) ) {
				if (SelectDimensionCheck(p->dimension) == 0)
					return p->dimension;
			}
		}
		p = p->next;
	}
	return NULL;
}





/* -------------------------------------------------------
 * Dimension Data 쥯ȤƤ뤫ǧ
 *	
 *   DIMENSION *data
 *   int	0򤵤Ƥʤ 	1Ѥ
 */
int SelectDimensionCheck(DIMENSION *data)
{
	SELECT_LIST *p;

	p = select_list_info.head;
	while (p != NULL) {
		if (p->select->diagram_point.dimension_point == data) 
			return 1;
		p = p->next;
	}
	return 0;
}





/* -------------------------------------------------------------------
 * 󣲥쥯
 * 
 * (Frag == 0) start Data 
 * (Frag == 2) start Data ϤΤޤޤõ
 * (Frag == 4) start Data Ѥõ
 */
int SelectChain2(CAD *start, int frag)
{
//#define SELECTCHAIN2
	int debug = 0;


#ifdef SELECTCHAIN2
	debug = 1;
	if (debug > 0) g_print("Select.c : SelectChain2() : in\n");
#endif


	/* start Data  */
	if (frag == 0) {
		if (debug > 0) g_print("Select.c : SelectChain2() : (Frag == 0) start Data  !\n");

		Chain2[1].diagram_point.cad_point = start;
		Chain2[1].index = 2;
		Chain2[2].diagram_point.cad_point = start;
		Chain2[2].index = 4;
		Chain2Data = 2;
		Chain2index = 1;
		Chain2_OnlyOne_mode = 211;
//		KeepReturnFunc = ReturnFunc;
//		ReturnFunc = MouseRet_ChainOne;
//		(*ReturnFunc)(drawing_area, 1, 0, 0);
		SelectChain2_OnlyOne(3);
	}

	/* start Data ϤΤޤޤõ */
	else if (frag == 2) {
		if (debug > 0) g_print("Select.c : SelectChain2() : (Frag == 2) start Data ϤΤޤޤõ !\n");
		SelectChain2_Search(start->ex, start->ey);
	}

	/* start Data Ѥõ */
	else if (frag == 4) {
		if (debug > 0) g_print("Select.c : SelectChain2() : (Frag == 4) start Data Ѥõ !\n");
		SelectChain2_Search(start->sx, start->sy);
	}

	if (debug > 0) g_print("Select.c : SelectChain2() : out\n");
	return 1;
}





/* -------------------------------------------------------------------
 * (x,y) ü˻Ŀ޷ʣõ
 * SelectChain2_OnlyOne ǰĤ򥻥쥯Ȥ
 *	
 */
int SelectChain2_Search(double x, double y)
{
//#define DEBUG_SELECTCHAIN2_SEARCH
	CAD_LIST *p;
	int debug = 0;

	Chain2Data = 0;


#ifdef DEBUG_SELECTCHAIN2_SEARCH
	debug = 1;
	if (debug > 0) g_print("Select.c : SelectChain2_Search() : in\n");
#endif


	if (debug > 0) g_print("õ(%f , %f)  ORGN(%f, %f)\n", sg(x, 3), sg(y, 3), x, y);


	/* ƿ޷ */
	p = cad_list_info.head;
	/* -------------------------------------------
	 * ǸޤǸĤʤ硢 p  NULL  
	 * äƥ롼פȴ롣
	 */
	while(p != NULL) {
		/* ɽƤơǤʤ */
		if (Layer[p->cad->layer].draw != 0 && p->cad->code != 0 && p->cad->code != 4) {


			if (debug > 0) g_print("(%f , %f)  (%f , %f)\n", 
						   sg(p->cad->sx, 3), sg(p->cad->sy, 3), sg(p->cad->ex, 3), sg(p->cad->ey, 3));
			if (debug > 0) g_print("SG Ƚ() = %d    Ƚ() = %d\n", 
				(sg(x, 2) == sg(p->cad->sx, 2)) && (sg(y, 2) == sg(p->cad->sy, 2)), 
				(sg(x, 2) == sg(p->cad->ex, 2) && sg(y, 2) == sg(p->cad->ey, 2)) );
			if (debug > 0) g_print("digȽ() = %d    Ƚ() = %d\n", 
					( (x + (1/pow(10, compa_digits)) > p->cad->sx) && (x - (1/pow(10, compa_digits)) < p->cad->sx) && (y + (1/pow(10, compa_digits)) > p->cad->sy) &&  (y - (1/pow(10, compa_digits)) < p->cad->sy) ), 
				( (x + (1/pow(10, compa_digits)) > p->cad->ex) && (x - (1/pow(10, compa_digits)) < p->cad->ex) && (y + (1/pow(10, compa_digits)) > p->cad->ey) &&  (y - (1/pow(10, compa_digits)) < p->cad->ey) ) 
				);
			if (debug > 0) g_print("dig = %f\n", (1/pow(10, compa_digits)));


			/* Ȱ */
//			if (	(sg(x, compa_digits) == sg(p->cad->sx, compa_digits)) 
//					&& 
//					(sg(y, compa_digits) == sg(p->cad->sy, compa_digits)) ) { 
			if (	(x + (1/pow(10, compa_digits)) > p->cad->sx) 
					&& 
					(x - (1/pow(10, compa_digits)) < p->cad->sx) 
					&& 
					(y + (1/pow(10, compa_digits)) > p->cad->sy) 
					&&	
					(y - (1/pow(10, compa_digits)) < p->cad->sy) ) 
			{
				/* ǡ i ο޷쥯ȤƤʤʤ */
				if (SelectCheck(p->cad) == 0) {
					if (debug > 0) g_print("--- << Ȱ >> ---\n");
					Chain2Data++;
					Chain2[Chain2Data].index = 2;
					Chain2[Chain2Data].diagram_point.cad_point = p->cad;
					Chain2[Chain2Data].x = 0;
					Chain2[Chain2Data].y = 0;
				}
				else {
					if (debug > 0) g_print("˿޷쥯ȤƤ()\n");
				}
			}

			/* Ȱ */
//			else if (	(sg(x, compa_digits) == sg(p->cad->ex, compa_digits)) 
//						&& 
//						(sg(y, compa_digits) == sg(p->cad->ey, compa_digits)) ) {
			else if (	(x + (1/pow(10, compa_digits)) > p->cad->ex) 
						&& 
						(x - (1/pow(10, compa_digits)) < p->cad->ex) 
						&& 
						(y + (1/pow(10, compa_digits)) > p->cad->ey) 
						&&	
						(y - (1/pow(10, compa_digits)) < p->cad->ey) ) 
			{
				/* ǡ i ο޷쥯ȤƤʤʤ */
				if (SelectCheck(p->cad) == 0) {
					if (debug > 0) g_print("--- << Ȱ >> ---\n");
					Chain2Data++;
					Chain2[Chain2Data].index = 4;
					Chain2[Chain2Data].diagram_point.cad_point = p->cad;
					Chain2[Chain2Data].x = 0;
					Chain2[Chain2Data].y = 0;
				}
				else {
					if (debug > 0) g_print("˿޷쥯ȤƤ()\n");
				}
			}
		}
		p = p->next;
	}

if (debug > 0) g_print("Select.c : SelectChain2_Search() : 1\n");

	/* ³޷ĤʤȤ */
	if (Chain2Data == 0) {
if (debug > 0) g_print("Select.c : SelectChain2_Search() : 2\n");
		Chain2_OnlyOne_mode = 0;
		if (debug > 0) g_print("Select.c : SelectChain2_Search() : ³޷Ĥʤ : 󣲽λ\n");
		
		MsgBox("SagCAD", _(" It ends chain 2.") , " ", NULL, NULL, "OK");
		ReturnFunc = KeepReturnFunc;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		return 0;
	}

	/* ³޷ĤΤȤ */
	else if (Chain2Data == 1) {
if (debug > 0) g_print("Select.c : SelectChain2_Search() : 2-2\n");
		if (debug > 0) g_print("Select.c : SelectChain2_Search() : ³޷Ĥ\n");
		select_list_add_last( &Chain2[1] );
		SelectCadDraw(drawing_area, select_list_info.tail->select->diagram_point.cad_point, SCD_SELECT);

		if (Chain2[1].index == 2) 
			SelectChain2(select_list_info.tail->select->diagram_point.cad_point, 2);
		else if (Chain2[1].index == 4) 
			SelectChain2(select_list_info.tail->select->diagram_point.cad_point, 4);
	}

	/* ³޷İʾ夢Ȥ */
	else if (Chain2Data > 1) {
if (debug > 0) g_print("Select.c : SelectChain2_Search() : 2-3\n");
		if (debug > 0) g_print("Select.c : SelectChain2_Search() : ³޷İʾ夢\n");
		Chain2index = 1;
		Chain2_OnlyOne_mode = 211;
		SelectChain2_OnlyOne(3);
	}

	if (debug > 0) g_print("Select.c : SelectChain2_Search() : out\n");
	return 1;
}





/* -------------------------------------------------------------------
 * ⡼
 * (ȥ꡼Ƥ޷椫Ūο޷)
 *	
 *  : int Frag
 *	  0:CANCEL	  1:YES    2:NO
 *	  3:Frag = 2 ƱΥǥåäʤʽѡ
 *	  5:
 *	
 *  : 
 *	  Chain2		: 쥯ȥǡǡ
 *	  Chain2index	: ǥå
 *	  Chain2Data	: ǡ
 *	
 *	
 */
void SelectChain2_OnlyOne(int Frag)
{
//#define SELECTCHAIN2_ONLYONE
	int Old_Draw;
	char str[256];
	int debug = 0;


#ifdef SELECTCHAIN2_ONLYONE
	debug = 1;
	if (debug > 0) g_print("Select.c : SelectChain2_OnlyOne() : in\n");
#endif

/*
	if (Frag == 5) {
		Chain2[1].cad = select_list_info.tail->select->diagram_point.cad_point;
		Chain2[1].index = 1;
		Chain2[2].cad = select_list_info.tail->select->diagram_point.cad_point;
		Chain2[2].index = 2;
		Chain2Data = 2;
		Chain2index = 1;
		Chain2_OnlyOne_mode = 211;
		SelectChain2_OnlyOne(3);
		return;
	}
*/

	sprintf(str, _(" Does it go to here? [Yes:(Left/RET)] [No:(Right/SPC)] [Cancel:(Center/ESC)]") );
	StatusMsg(str);


	/* 㤦 (NO) ο޷ */
	if (Frag == 2) {
		if (Chain2index == Chain2Data) Chain2index = 1;
		else	Chain2index++;
	}
	/* Υǡ */
	if (Chain2index == 1) Old_Draw = Chain2Data;
	else Old_Draw = Chain2index - 1;


	/* ޷ */
	if (Frag == 2) {
		SelectChain2_Draw(*Chain2[Old_Draw].diagram_point.cad_point, Chain2[Old_Draw].index, SCD_HIDE);
		SelectCadDraw(drawing_area, Chain2[Old_Draw].diagram_point.cad_point, SCD_ORG);
	}
	if (Frag == 2 || Frag == 3) 
		SelectChain2_Draw(*Chain2[Chain2index].diagram_point.cad_point, Chain2[Chain2index].index, 3);


	/*  (OK) */
	if (Frag == 1) {
		if (select_list_info.tail->select->diagram_point.cad_point == Chain2[Chain2index].diagram_point.cad_point) {
			//MsgBox("SagCAD", "쥯ȺѤߥǡ", "SelectChain2_OnlyOne()", NULL, NULL, "OK");
			select_list_info.tail->select->index = Chain2[Chain2index].index;
		}
		else {
			//MsgBox("SagCAD", "쥯ȥꥹȤɲ", "SelectChain2_OnlyOne()", NULL, NULL, "OK");
			/* Select Data ꥹȤκǸɲ */
			select_list_add_last( &Chain2[Chain2index] );
		}

		SelectChain2_Draw(*select_list_info.tail->select->diagram_point.cad_point, select_list_info.tail->select->index, SCD_HIDE);
		SelectCadDraw(drawing_area, select_list_info.tail->select->diagram_point.cad_point, SCD_SELECT);
		Chain2_OnlyOne_mode = 0;
		Chain2Data = 0;
		Chain2index = 0;
		SelectChain2(select_list_info.tail->select->diagram_point.cad_point, select_list_info.tail->select->index);
		if (debug > 0) g_print("Select.c : SelectChain2_OnlyOne() :  (frag = 1)\n");
		if (debug > 0) g_print("Select.c : SelectChain2_OnlyOne() : out 1\n");
		return;
	}

	/* 󥻥 (CANCEL) */
	else if (Frag == 0) {
		SelectChain2_Draw(*Chain2[Chain2index].diagram_point.cad_point, Chain2[Chain2index].index, SCD_HIDE);
		SelectCadDraw(drawing_area, Chain2[Chain2index].diagram_point.cad_point, SCD_ORG);
		Chain2_OnlyOne_mode = 0;
		Chain2Data = 0;
		Chain2index = 0;
		Redraw();
		if (debug > 0) g_print("Select.c : SelectChain2_OnlyOne() : 󥻥 (frag = 0)\n");
//		MessageBox(NULL, "Cancel ޤ", "SelectChain2_OnlyOne", MB_OK);
		ReturnFunc = KeepReturnFunc;
		(*ReturnFunc)(drawing_area, 1, 0, 0);
		if (debug > 0) g_print("Select.c : SelectChain2_OnlyOne() : out 2\n");
		return;
	}
}





/* -------------------------------------------------------------------
 * ǡ i ο޷ɽ
 *	
 * ޷ 	 DrawType
 * 		: DrawType = 1	SCD_SELECT
 * ο		: DrawType = 0	SCD_ORG
 * á		: DrawType = 2	SCD_HIDE
 * ץ	: DrawType = 3	SCD_CAM
 *	
 */
void SelectChain2_Draw(CAD cad, int frag, int DrawType)
{
//#define SELECTCHAIN2_DRAW
	long SelectCadDrawColor = sagcad_color.Cam;
	int debug = 0;


#ifdef SELECTCHAIN2_DRAW
	debug = 1;
	g_print ("Select.c : SelectChain2_Draw() : in\n");
#endif


	if ( DrawType == 1) SelectCadDrawColor = sagcad_color.Select;
	else if ( DrawType == 0)	SelectCadDrawColor = cad.color;
	else if ( DrawType == 2)	SelectCadDrawColor = sagcad_color.Back;
	else if ( DrawType == 3)	SelectCadDrawColor = sagcad_color.Cam;

	if ( Layer[cad.layer].draw != 0) {
		/* ΤȤ */
		if (cad.code == 1) {
			if (DrawType ==0 || DrawType == 1) {
				if (frag == 2) {
					SelectChain2_S_Bow(cad.sx, cad.sy, cad.ex, cad.ey, sagcad_color.Back);
					SelectCadDraw(drawing_area, &cad, DrawType);
				}
				else if (frag == 4) {
					SelectChain2_S_Bow(cad.ex, cad.ey, cad.sx, cad.sy, sagcad_color.Back);
					SelectCadDraw(drawing_area, &cad, DrawType);
				}
			}
			else {
				if (frag == 2) {
					SelectChain2_S_Bow(cad.sx, cad.sy, cad.ex, cad.ey, sagcad_color.Back);
					SelectChain2_S_Bow(cad.sx, cad.sy, cad.ex, cad.ey, SelectCadDrawColor);
				}
				else if (frag == 4) {
					SelectChain2_S_Bow(cad.ex, cad.ey, cad.sx, cad.sy, sagcad_color.Back);
					SelectChain2_S_Bow(cad.ex, cad.ey, cad.sx, cad.sy, SelectCadDrawColor);
				}
			}
		}
		/* ߸̤ΤȤ */
		else if ( cad.code == 2) {
			if (DrawType ==0 || DrawType == 1) {
				SelectChain2_ArcBow(cad.cx, cad.cy, cad.r, cad.sx, cad.sy, cad.ex, cad.ey, sagcad_color.Back, frag);
				SelectCadDraw(drawing_area, &cad, DrawType);
			}
			else {
				SelectChain2_ArcBow(cad.cx, cad.cy, cad.r, cad.sx, cad.sy, cad.ex, cad.ey, sagcad_color.Back, frag);
				SelectChain2_ArcBow(cad.cx, cad.cy, cad.r, cad.sx, cad.sy, cad.ex, cad.ey, SelectCadDrawColor, frag);
			}
		}
	}
	UpDate();
	if (debug > 0) g_print ("Select.c : SelectChain2_Draw() : out\n");
}





/* -------------------------------------------------------------------
 * 
 *	
 */
int SelectChain2_S_Bow(double SX, double SY, double EX, double EY, long color)
{
	struct RtnDat LAH, PAPH;
	double EX1, EY1, EX2, EY2;


	/* ------------------------------------------------ */
	/* LA	ľγ */
	/*		 (A.sx[1],A.SY[1]),(A.ex[1],A.EY[1]) */
	/*				 Ans A.ANGLE */
	/* ------------------------------------------------ */
	LAH.sx[1] = EX;
	LAH.sy[1] = EY;
	LAH.ex[1] = SX;
	LAH.ey[1] = SY;
	la(&LAH);
	/* ------------------------------------------------ */
	/* PAP	ȳ٤ȵΥľν */
	/*		 (A.sx[1] , A.sy[1]) , A.ANGLE , A.l */
	/*				 Ans  (A.ex[1] , A.EY[1]) */
	/* ------------------------------------------------ */
	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle + sagcad_dimension.arrow_angle;
	PAPH.l = 3;//ArrowLength(DRAW_CONST) * 2; /* DRAW_DISP */
	pap(&PAPH);

	EX1 = PAPH.ex[1];
	EY1 = PAPH.ey[1];

	PAPH.sx[1] = EX;
	PAPH.sy[1] = EY;
	PAPH.angle = LAH.angle - sagcad_dimension.arrow_angle;
	PAPH.l = 3;//ArrowLength(DRAW_CONST) * 2;
	pap(&PAPH);
	EX2 = PAPH.ex[1];
	EY2 = PAPH.ey[1];

	LineDraw(drawing_area, SX, SY, EX, EY, 1, color);
	LineDraw(drawing_area, EX, EY, EX1, EY1, 1, color);
	LineDraw(drawing_area, EX, EY, EX2, EY2, 1, color);

	return 0;
}





/* -------------------------------------------------------------------
 * (߸)
 *	
 * frag : 4 : 
 *		: 2 : 
 */
int SelectChain2_ArcBow(double CX, double CY, double R, double SX, double SY, double EX, double EY, long color, int frag)
{
	/* Dumy = ArcBow(CX, CY, R, SA,EA, INDEX) */

	struct RtnDat PAPH, LAH;
	double SA, EA;
	double SX1, SY1, SX2, SY2;
	double EX1, EY1, EX2, EY2;


	if (frag == 4) {
		/* 濴γ SA 롣 */
		/* LA	  ľγ */
		LAH.sx[1] = CX;
		LAH.sy[1] = CY;
		LAH.ex[1] = SX;
		LAH.ey[1] = SY;
		la(&LAH);
		SA = LAH.angle;
		if(SA > 360) SA = SA - 360;

		PAPH.sx[1] = SX;
		PAPH.sy[1] = SY;
		PAPH.angle = SA + 90 - sagcad_dimension.arrow_angle;
		PAPH.l = 3;//ArrowLength(DRAW_CONST) * 2;
		pap(&PAPH);
		SX1 = PAPH.ex[1];
		SY1 = PAPH.ey[1];

		PAPH.sx[1] = SX;
		PAPH.sy[1] = SY;
		PAPH.angle = SA + 90 + sagcad_dimension.arrow_angle;
		PAPH.l = 3;//ArrowLength(DRAW_CONST) * 2;
		pap(&PAPH);
		SX2 = PAPH.ex[1];
		SY2 = PAPH.ey[1];

		LineDraw(drawing_area, SX, SY, SX1, SY1, 1, color);
		LineDraw(drawing_area, SX, SY, SX2, SY2, 1, color);
	}


	if (frag == 2) {
		/* 濴齪γ EA 롣 */
		/* LA	  ľγ */
		LAH.sx[1] = CX;
		LAH.sy[1] = CY;
		LAH.ex[1] = EX;
		LAH.ey[1] = EY;
		la(&LAH);
		EA = LAH.angle;
		if(EA > 360) EA = EA - 360;

		PAPH.sx[1] = EX;
		PAPH.sy[1] = EY;
		PAPH.angle = EA - 90 - sagcad_dimension.arrow_angle;
		PAPH.l = 3;//ArrowLength(DRAW_CONST) * 2;
		pap(&PAPH);
		EX1 = PAPH.ex[1];
		EY1 = PAPH.ey[1];

		PAPH.sx[1] = EX;
		PAPH.sy[1] = EY;
		PAPH.angle = EA - 90 + sagcad_dimension.arrow_angle;
		PAPH.l = 3;//ArrowLength(DRAW_CONST) * 2;
		pap(&PAPH);
		EX2 = PAPH.ex[1];
		EY2 = PAPH.ey[1];

		LineDraw(drawing_area, EX, EY, EX1, EY1, 1, color);
		LineDraw(drawing_area, EX, EY, EX2, EY2, 1, color);
	}

	ArcDraw(drawing_area, CX, CY, R, SX, SY, EX, EY, 1, color);

	return 0;
}





/* -------------------------------------------------------
 * õ (sub)
 * 0 : ʤä
 * 1 : ä
 */
int LineDataCheck(double sx, double sy, double ex, double ey, double x, double y)
{
//#define LINE_DATA_CHECK
	struct RtnDat PLPH, PPH, LAH;
	double L0, L1, A1, L2, A2;
	int debug = 0;


#ifdef LINE_DATA_CHECK
	debug = 1;
#endif


	if (debug > 0) {
		g_print("Select.c : LineDataCheck() : in\n");
		g_print("LINE (%f,%f)-(%f,%f) PicPoint(%f,%f)\n", sx, sy, ex, ey, x, y);
	}


	/* κǶ */
	PLPH.sx[2] = x;
	PLPH.sy[2] = y;
	PLPH.sx[1] = sx;
	PLPH.sy[1] = sy;
	PLPH.ex[1] = ex;
	PLPH.ey[1] = ey;
	plp(&PLPH);
	/* Ƕ	 PLPH.ex[2] , PLPH.ey[2] */
	
	/* ȺǶεΥ */
	PPH.sx[1] = x;
	PPH.sy[1] = y;
	PPH.ex[1] = PLPH.ex[2];
	PPH.ey[1] = PLPH.ey[2];
	pp(&PPH);
	/* Υ PPH.L */
	L0 = PPH.l;
	
	/* Υ DC ʾʤõƤǤϤʤ*/
	if (L0 > DC) {
		if (debug > 0) g_print("Select.c : LineDataCheck() : ΥƤ [L0(%f) > DC(%f)]\n", L0, DC);
		if (debug > 0) g_print("Select.c : LineDataCheck() : out\n");
		return 0;
	}
	
	
	/* n齪γ٤ȵΥ */
	PPH.sx[1] = sx;
	PPH.sy[1] = sy;
	PPH.ex[1] = ex;
	PPH.ey[1] = ey;
	pp(&PPH);
	/* Υ PPH.L */
	L1 = PPH.l;
	
	LAH.sx[1] = sx;
	LAH.sy[1] = sy;
	LAH.ex[1] = ex;
	LAH.ey[1] = ey;
	la(&LAH);
	/*  LAH.ANGLE */
	A1 = LAH.angle;
	
	/* nǶγ٤ȵΥ */
	PPH.sx[1] = sx;
	PPH.sy[1] = sy;
	PPH.ex[1] = PLPH.ex[2];
	PPH.ey[1] = PLPH.ey[2];
	pp(&PPH);
	/* Υ PPH.L */
	L2 = PPH.l;

	LAH.sx[1] = sx;
	LAH.sy[1] = sy;
	LAH.ex[1] = PLPH.ex[2];
	LAH.ey[1] = PLPH.ey[2];
	la(&LAH);
	/*  LAH.ANGLE */
	A2 = LAH.angle;
	
	/* nγ٤ƱǡnǶޤǤĹĹΤĹ(L1>L2)*/
	if ( (A1 + 1 > A2) && (A1 - 1 < A2) ) {
		if (L1 > L2) {
			if (debug > 0) g_print("Select.c : LineDataCheck() : ä\n");
			if (debug > 0) g_print("Select.c : LineDataCheck() : out\n");
			return 1;
		}
	}
	else {
		if (debug > 0) g_print("Select.c : LineDataCheck() : ΥƤʤɡϰϳ\n");
		if (debug > 0) g_print("Select.c : LineDataCheck() : out\n");
		return 0;
	}

	if (debug > 0) g_print("Select.c : LineDataCheck() : out\n");
	return 0;
}





/* -------------------------------------------------------
 * ޤõ
 *	
 *	
 */
int normal_polyline_search(POLYLINE *polyline, double px, double py)
{
//#define NORMAL_POLYLINE_SEARCH
	int i, Ret = 0;
	double old_x = 0, old_y = 0;
	VERTEX_LIST *pv;
	int debug = 0;


#ifdef NORMAL_POLYLINE_SEARCH
	debug = 1;
	g_print("Select.c : normal_polyline_search : in\n");
#endif



	pv = polyline->vertex_list_info.head;
	if (pv == NULL) {
		g_print("Vertex is No Data\n");
		return 0;
	}

	if (pv != NULL) {
		i = 0;
		while (pv != NULL) {
			if (i == 0) {
				// 
			}
			else {
				if (debug > 0) g_print("Select.c : normal_polyline_search : Search %d \n", i);
				Ret = LineDataCheck(old_x, old_y, pv->vertex->x, pv->vertex->y, px, py);
				if (Ret != 0) {
					return Ret;
				}
				if (debug > 0) g_print("Select.c : normal_polyline_search : ʤä\n");
			}
			old_x = pv->vertex->x;
			old_y = pv->vertex->y;

			i++;
			pv = pv->next;
		}


		if ((polyline->frag & 1) == 1) {
			if (debug > 0) g_print("Select.c : normal_polyline_search : Search close last\n");
			Ret = LineDataCheck(old_x, old_y, 
								polyline->vertex_list_info.head->vertex->x, polyline->vertex_list_info.head->vertex->y, 
								px, py);
			if (Ret != 0) {
				return Ret;
			}
			if (debug > 0) g_print("Select.c : normal_polyline_search : ʤä\n");
		}
	}

	return Ret;
}





/* -------------------------------------------------------
 * ץ饤õ
 *	
 *	
 */
int open_spline_search(POLYLINE *polyline, double px, double py)
{
	int i;
	double pitch;
	static double old_x = 0, old_y = 0;

	double u, v;
	double *x, *y, *p, *a, *b;
	double *h, *d;

	int n, split, Ret = 0;
	VERTEX_LIST *pv;


//OneShotLog("Select.c : open_spline_search() : in\n");


	n = (int)vertex_list_num(&polyline->vertex_list_info);
	split = polyline->split * n;

//	vertex = polyline->vertex;

	x = (double *) xmalloc( n * sizeof(double) );
	y = (double *) xmalloc( n * sizeof(double) );
	p = (double *) xmalloc( n * sizeof(double) );
	a = (double *) xmalloc( n * sizeof(double) );
	b = (double *) xmalloc( n * sizeof(double) );

	h = (double *) xmalloc( n * sizeof(double) );
	d = (double *) xmalloc( n * sizeof(double) );


	pv = polyline->vertex_list_info.head;
	i = 0;
	while (pv != NULL) {
		x[i] = pv->vertex->x;
		y[i] = pv->vertex->y;
		p[i] = 0;
		a[i] = 0;
		b[i] = 0;

		h[i] = 0;
		d[i] = 0;

		i++;
		pv = pv->next;
	}


	open_maketable2(n, p, x, y, a, b, h, d);

	pitch = 1.0/(double)split;
	for (i = 0; i <= split ; i++) {
		open_spline2(n, pitch * (double)i, &u, &v, p, x, y, a, b);
		if (i == 0) {
//OneShotLog("Select.c : open_spline_search() : i = 0 ǥѥ\n");
			// pset
		}
		else {
			Ret = LineDataCheck(old_x, old_y, u, v, px, py);
			if (Ret != 0) {
				xfree(x);
				xfree(y);
				xfree(p);
				xfree(a);
				xfree(b);

				xfree(h);
				xfree(d);
//OneShotLog("Select.c : open_spline_search() : ä\n");
//OneShotLog("Select.c : open_spline_search() : out\n");
				return Ret;
			}
			//OneShotLog("Select.c : open_spline_search() : ʤ\n");
			//LineDraw(drawing_area, old_x, old_y, u, v, 1, 0xffffff);
		}
		old_x = u;
		old_y = v;
	}


	xfree(x);
	xfree(y);
	xfree(p);
	xfree(a);
	xfree(b);

	xfree(h);
	xfree(d);

//OneShotLog("Select.c : open_spline_search() : out\n");
	return Ret;
}





/* -------------------------------------------------------
 * ĥץ饤õ
 * 
 * Ʊ vertex ΥǡǸդ­
 */
int close_spline_search(POLYLINE *polyline, double px, double py)
{
	int i;
	double pitch;
	static double old_x = 0, old_y = 0;

	double u, v;
	double *x, *y, *p, *a, *b;
	double *h, *d, *w;

	int n, split, Ret = 0;
	VERTEX_LIST *pv;

//OneShotLog("Select.c : close_spline_search() : in\n");

	n = (int)vertex_list_num(&polyline->vertex_list_info);
	split = polyline->split * n;


	x = (double *) xmalloc( (n+1) * sizeof(double) );
	y = (double *) xmalloc( (n+1) * sizeof(double) );
	p = (double *) xmalloc( (n+1) * sizeof(double) );
	a = (double *) xmalloc( (n+1) * sizeof(double) );
	b = (double *) xmalloc( (n+1) * sizeof(double) );

	h = (double *) xmalloc( (n+1) * sizeof(double) );
	d = (double *) xmalloc( (n+1) * sizeof(double) );
	w = (double *) xmalloc( (n+1) * sizeof(double) );

	pv = polyline->vertex_list_info.head;
	i = 0;
	while (pv != NULL) {
		x[i] = pv->vertex->x;
		y[i] = pv->vertex->y;
		p[i] = 0;
		a[i] = 0;
		b[i] = 0;

		h[i] = 0;
		d[i] = 0;
		w[i] = 0;

		i++;
		pv = pv->next;
	}
	x[i] = polyline->vertex_list_info.head->vertex->x;
	y[i] = polyline->vertex_list_info.head->vertex->y;
	p[i] = 0;
	a[i] = 0;
	b[i] = 0;

	h[i] = 0;
	d[i] = 0;
	w[i] = 0;




	close_maketable2(n, p, x, y, a, b, h, d, w);
	pitch = 1.0/(double)split;
	for (i = 0; i <= split ; i++) {
		close_spline2(n, pitch * i, &u, &v, p, x, y, a, b);
		if (i == 0) {
			// pset
		}
		else {
			Ret = LineDataCheck(old_x, old_y, u, v, px, py);
			if (Ret != 0) {
				xfree(x);
				xfree(y);
				xfree(p);
				xfree(a);
				xfree(b);

				xfree(h);
				xfree(d);
				xfree(w);
				return Ret;
			}
			//LineDraw(drawing_area, old_x, old_y, u, v, 1, 0xffffff);
		}
		old_x = u;
		old_y = v;
	}


	xfree(x);
	xfree(y);
	xfree(p);
	xfree(a);
	xfree(b);

	xfree(h);
	xfree(d);
	xfree(w);

	return Ret;
}





/* -------------------------------------------------------
 * ¥ץ饤õ
 *	
 *	
 */
int b_spline_search(POLYLINE *polyline, double px, double py)
{
	int i, j;
	double u, s1, s2, s3, s4;
	double x, y;
	static double old_x = 0, old_y = 0;
	VERTEX *dummy_vertex = NULL;
	VERTEX *vertex;
	VERTEX_LIST *pv;

	VERTEX sp = {0,0};
	VERTEX ep = {0,0};
	VERTEX ap1 = {0,0};
	VERTEX ap2 = {0,0};

	int n, Ret = 0;
	double pitch;


	pitch = polyline->pitch;

	n = (int)vertex_list_num(&polyline->vertex_list_info);
	vertex = (VERTEX *) xmalloc( (n + 1) * sizeof(VERTEX) );

	pv = polyline->vertex_list_info.head;
	i = 0;
	while (pv != NULL) {
		vertex[i] = *pv->vertex;
		i++;
		pv = pv->next;
	}


	if (n == 3) {
		dummy_vertex = (VERTEX *)xmalloc( 7 * sizeof(VERTEX) );
		j = 0;
		dummy_vertex[j].x = vertex[0].x;
		dummy_vertex[j].y = vertex[0].y;
		for (i = 1 ; i < n ; i++) {
			sp.x = vertex[i-1].x;
			sp.y = vertex[i-1].y;
			ep.x = vertex[i].x;
			ep.y = vertex[i].y;
			split3(sp, ep, &ap1, &ap2);
			j++;
			dummy_vertex[j].x = ap1.x;
			dummy_vertex[j].y = ap1.y;
			j++;
			dummy_vertex[j].x = ap2.x;
			dummy_vertex[j].y = ap2.y;
			j++;
			dummy_vertex[j].x = vertex[i].x;
			dummy_vertex[j].y = vertex[i].y;
		}
		n = 7;
	}
	else if (n > 3 && n < 7) {
		dummy_vertex = (VERTEX *)xmalloc(((n * 2) - 1) * sizeof(VERTEX));
		j = 0;
		dummy_vertex[j].x = vertex[0].x;
		dummy_vertex[j].y = vertex[0].y;
		for (i = 1 ; i < n ; i++) {
			sp.x = vertex[i-1].x;
			sp.y = vertex[i-1].y;
			ep.x = vertex[i].x;
			ep.y = vertex[i].y;
			split2(sp, ep, &ap1);
			j++;
			dummy_vertex[j].x = ap1.x;
			dummy_vertex[j].y = ap1.y;
			j++;
			dummy_vertex[j].x = vertex[i].x;
			dummy_vertex[j].y = vertex[i].y;
		}
		n = (n * 2) - 1;
	}
	else if (n > 6) {
		dummy_vertex = (VERTEX *)xmalloc( n * sizeof(VERTEX) );
		for (i = 0 ; i < n ; i++) {
			dummy_vertex[i].x = vertex[i].x;
			dummy_vertex[i].y = vertex[i].y;
		}
	}



	for (i = 0 ; i < n-3 ; i++) {
		for (u = 0.0 ; u <= 1.0 + pitch/2 ; u = u + pitch) {
			/* ǽζ */
			if (i == 0) {
				spl1(u, &s1, &s2, &s3, &s4);
			}
			/* ܤζ */
			else if (i == 1) {
				spl2(u, &s1, &s2, &s3, &s4);
			}
			/* ֤ζ */
			else if (i > 1 && i < n-5) {
				spl3(u, &s1, &s2, &s3, &s4);
			}
			/* Ǹ夫飲ܤζ */
			else if (i > 1 && i == n-5) {
				spl4(u, &s1, &s2, &s3, &s4);
			}
			/* Ǹζ */
			else if (i > 2 && i == n-4) {
				spl5(u, &s1, &s2, &s3, &s4);
			}
			x = s1*dummy_vertex[i].x + s2*dummy_vertex[i+1].x + s3*dummy_vertex[i+2].x + s4*dummy_vertex[i+3].x;
			y = s1*dummy_vertex[i].y + s2*dummy_vertex[i+1].y + s3*dummy_vertex[i+2].y + s4*dummy_vertex[i+3].y;
			if (u == 0) {
				//pset;
			}
			else {
				Ret = LineDataCheck(old_x, old_y, x, y, px, py);
				if (Ret != 0) {
					xfree(dummy_vertex);
					return Ret;
				}
				//LineDraw(drawing_area, old_x, old_y, x, y, 1, 0xffffff);
			}
			old_x = x;
			old_y = y;
		}
	}

	xfree(dummy_vertex);
	return Ret;
}





/* -------------------------------------------------------
 * õᥤ
 * 
 */
POLYLINE *PolyLine_search(double x, double y)
{
//#define POLYLINE_SEARCH

	POLYLINE_LIST *p;
	int debug = 0;


#ifdef POLYLINE_SEARCH
	debug = 1;
#endif


	if (PolyLineStartData == NULL && polyline_list_info.head != NULL) {
		PolyLineStartData = polyline_list_info.tail;
	}
	else if (polyline_list_info.head == NULL) {
		return NULL;
	}

	/* p  PolyLineStartData  */
	p = PolyLineStartData;

	/* -----------------------------------------------------
	 * p ǸΥǡ tail ʤ p ǽΥǡ head ˤ롣
	 * ʳʤ顢p ̥ǡ(PolyLineStartData 褫õ
	 */
	if (p == polyline_list_info.tail) {
		p = polyline_list_info.head;
	}
	else if (p != polyline_list_info.tail) { 
		p = p->next;
	}


	/* p  ǡκǸޤǤõ */
	while (p != NULL) {
		if (Layer[p->polyline->layer].draw == 1) {
			if (debug > 0) g_print("Select.c : PolyLine_search() : in\n");

			/* ---------------------------------------------
			 * ץ饤
			 */
			if (p->polyline->code == 16) {
				if (debug > 0) g_print("Select.c : PolyLine_search() : search spline 1\n");

				/* ĤƤȤ(Ķ) */
				if ((p->polyline->frag & 1) == 1) {
					if (debug > 0) g_print("Select.c : PolyLine_search() : search close spline 1\n");
					if (close_spline_search(p->polyline, x, y) != 0) {
						/* Ĥä */
						PolyLineStartData = p;
						if (debug > 0) {
							g_print("Select.c : PolyLine_search() : ץ饤(Ķ)ߤĤä 1\n");
						}
						if (SelectPolyLineCheck(p->polyline) == 0) {
							return p->polyline;
						}
					}
				}

				/* () */
				else {
					if (debug > 0) g_print("Select.c : PolyLine_search() : search open spline 1\n");
					if (open_spline_search(p->polyline, x, y) != 0) {
						/* Ĥä */
						PolyLineStartData = p;
						if (debug > 0) {
							g_print("Select.c : PolyLine_search() : ץ饤()ߤĤä 1\n");
						}
						if (SelectPolyLineCheck(p->polyline) == 0)
							return p->polyline;
					}
				}
			}


			/* ---------------------------------------------
			 * ¥ץ饤
			 */
			else if (p->polyline->code == 32) {
				if (debug > 0) g_print("Select.c : PolyLine_search() : search B-spline 1\n");
				if (b_spline_search(p->polyline, x, y) != 0) {
					/* Ĥä */
					PolyLineStartData = p;
					if (debug > 0) {
						g_print("Select.c : PolyLine_search() : ¥ץ饤ߤĤä 1\n");
					}
					if (SelectPolyLineCheck(p->polyline) == 0)
						return p->polyline;
				}
			}


			/* ---------------------------------------------
			 * ޤ
			 */
			else if (p->polyline->code == 8) {
				if (debug > 0) g_print("Select.c : PolyLine_search() : search polyline 1\n");
				if (normal_polyline_search(p->polyline, x, y) != 0) {
					/* Ĥä */
					PolyLineStartData = p;
					if (debug > 0) {
						g_print("Select.c : PolyLine_search() : ޤߤĤä 1\n");
					}
					if (SelectPolyLineCheck(p->polyline) == 0)
						return p->polyline;
				}
			}
		}
		else {
			//
		}

		p = p->next;
	}


	/* -----------------------------------------------------
	 * PolyLineStartData  tail ä
	 * ǽ餫ǸޤõƤ뤫餳θνϤʤ
	 */
	if (PolyLineStartData == polyline_list_info.tail) {
		return NULL;
	}


	/* ------------------------------------------------------------
	 * ǡκǽ餫 PolyLineStartData ޤǤõ
	 */
	p =  polyline_list_info.head;
	while (p != NULL && p != PolyLineStartData->next) {
		if(Layer[p->polyline->layer].draw == 1) {

			/* ---------------------------------------------
			 * ץ饤
			 */
			if (p->polyline->code == 16) {

				/* ĤƤȤ(Ķ) */
				if ((p->polyline->frag & 1) == 1) {
					if (close_spline_search(p->polyline, x, y) != 0) {
						/* Ĥä */
						PolyLineStartData = p;
						if (debug > 0) {
							g_print("Select.c : PolyLine_search() : ץ饤(Ķ)ߤĤä 2\n");
						}
						if (SelectPolyLineCheck(p->polyline) == 0)
							return p->polyline;
					}
				}

				/* ץ饤() */
				else {
					if (open_spline_search(p->polyline, x, y) != 0) {
						/* Ĥä */
						PolyLineStartData = p;
						if (debug > 0) {
							g_print("Select.c : PolyLine_search() : ץ饤()ߤĤä 2\n");
						}
						if (SelectPolyLineCheck(p->polyline) == 0)
							return p->polyline;
					}
				}
			}


			/* ---------------------------------------------
			 * ¥ץ饤
			 */
			else if (p->polyline->code == 32) {
				if (b_spline_search(p->polyline, x, y) != 0) {
						/* Ĥä */
						PolyLineStartData = p;
						if (debug > 0) {
							g_print("Select.c : PolyLine_search() : ¥ץ饤ߤĤä 2\n");
						}
						if (SelectPolyLineCheck(p->polyline) == 0)
							return p->polyline;
				}
			}

			/* ---------------------------------------------
			 * ޤ
			 */
			else if (p->polyline->code == 8) {
				if (normal_polyline_search(p->polyline, x, y) != 0) {
						/* Ĥä */
						PolyLineStartData = p;
						if (debug > 0) {
							g_print("Select.c : PolyLine_search() : ޤߤĤä 2\n");
						}
						if (SelectPolyLineCheck(p->polyline) == 0)
							return p->polyline;
				}
			}

		}
		else {
			//
		}

		p = p->next;
	}
	PolyLineStartData = p;
	return NULL;
}





/* -------------------------------------------------------
 * polyline Data 쥯ȤƤ뤫ǧ
 *	
 *   POLYLINE *data
 *   int	0򤵤Ƥʤ 	1Ѥ
 */
int SelectPolyLineCheck(POLYLINE *data)
{
	SELECT_LIST *p;

	p = select_list_info.head;
	while (p != NULL) {
		if (p->select->diagram_point.polyline_point == data) 
			return 1;
		p = p->next;
	}
	return 0;
}





/* -------------------------------------------------------
 * ޷֤롣󥻥Ǹο᤹
 * 
 * 򤵤Ƥ޷ 1 ֤0 ᤹
 * 
 * diagram_type
 *     CAD       : 2 or 4
 *     DIMENSION : 3
 *     POLYLINE  : 8
 *     ELLIPSE   : 16
 *     INSERT    : 32
 * 
 * ޷ DrawType
 *     DrawType = 1	SCD_SELECT
 * ο    DrawType = 0	SCD_ORG
 *       DrawType = 2	SCD_HIDE
 * 
 * UpDate
 *     1 : Τ򤹤ɽ
 *     0 : ɽ
 * 
 */
int SelectDraw(GtkWidget *widget, SELECT *select, int DrawType, int update)
{
	/* CAD Data */
	if (select->index == 2 || select->index == 4) {
		if (select->diagram_point.cad_point == NULL) {
			MsgBox("SagCAD error", "CAD Data is NULL !", "SelectDraw()", NULL, NULL, "OK");
			return 0;
		}
		if (Layer[select->diagram_point.cad_point->layer].draw == 1) {
			CadDraw(widget, select->diagram_point.cad_point, DrawType, update);
		}
	}

	/* DIMENSION Data */
	else if (select->index == 3) {
		if (select->diagram_point.dimension_point == NULL) {
			MsgBox("SagCAD error", "Dimension Data is NULL !", "SelectDraw()", NULL, NULL, "OK");
			return 0;
		}
		if (Layer[select->diagram_point.dimension_point->Layer].draw == 1) {
			DimensionDraw (drawing_area, select->diagram_point.dimension_point, DrawType);
		}
	}

	/* POLYLINE Data */
	else if (select->index == 8) {
		if (select->diagram_point.polyline_point == NULL) {
			MsgBox("SagCAD error", "PolyLine Data is NULL !", "SelectDraw()", NULL, NULL, "OK");
			return 0;
		}
		if (Layer[select->diagram_point.polyline_point->layer].draw == 1) {
			PolyLineDraw (widget, select->diagram_point.polyline_point, DrawType);
		}
	}

	/* ELLIPSE Data */
	else if (select->index == 16) {
		if (select->diagram_point.ellipse_point == NULL) {
			MsgBox("SagCAD error", "ELLIPSE Data is NULL !", "SelectDraw()", NULL, NULL, "OK");
			return 0;
		}
		if (Layer[select->diagram_point.ellipse_point->layer].draw == 1) {
			EllipseDraw (widget, select->diagram_point.ellipse_point, DrawType);
		}
	}

	/* INSERT Data */
	else if (select->index == 32) {
		//
	}


	if (update == UPDATE_ON) {
		UpDate();
	}


	return 1;
}





/* ====================================================================
 * ===	Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *	  Project			   : SagCAD
 *	  Source			   : select.c
 * ====================================================================
 */





/* -------------------------------------------------------
 * ޷֤롣󥻥Ǹο᤹
 * 
 * 򤵤Ƥ޷ 1 ֤0 ᤹
 * 
 * DrawType
 *     SCD_ORG     : 0 : 
 *     SCD_SELECT  : 1 : 
 *     SCD_HIDE    : 2 : طʿ(õ)
 * 
 * UpDate
 *     UPDATE_ON  : 1 : Τ򤹤ɽ
 *     UPDATE_OFF : 0 : ɽ
 * 
 */
int CadDraw(GtkWidget *widget, CAD *cad, int DrawType, int update)
{
	long SelectCadDrawColor = cad->color;


	if (cad == NULL) {
		MsgBox("SagCAD error", "CAD Data is NULL !", "SelectCadDraw error", NULL, NULL, "OK");
		return 0;
	}

	if ( DrawType == SCD_SELECT) SelectCadDrawColor = sagcad_color.Select;
	else if ( DrawType == SCD_ORG) SelectCadDrawColor = cad->color;
	else if ( DrawType == SCD_HIDE) SelectCadDrawColor = sagcad_color.Back;

	/* ΤȤ */
	if ( cad->code == 0) {
		if ( Layer[cad->layer].draw != 0) {
			PointDraw(widget, cad->sx, cad->sy, cad->style, sagcad_color.Back);
			PointDraw(widget, cad->sx, cad->sy, cad->style, SelectCadDrawColor);
		}
	}
	/* ľΤȤ */
	else if ( cad->code == 1) {
		if ( Layer[cad->layer].draw != 0) {
			LineDraw(widget, cad->sx, cad->sy, cad->ex, cad->ey, cad->style, sagcad_color.Back);
			LineDraw(widget, cad->sx, cad->sy, cad->ex, cad->ey, cad->style, SelectCadDrawColor);
		}
	}
	/* ߸̤ΤȤ */
	else if ( cad->code == 2) {
		if ( Layer[cad->layer].draw != 0) {
			/* ߸̤ */
			ArcDraw(widget, cad->cx, cad->cy, cad->r, cad->sx, cad->sy, cad->ex, cad->ey, cad->style, sagcad_color.Back);
			ArcDraw(widget, cad->cx, cad->cy, cad->r, cad->sx, cad->sy, cad->ex, cad->ey, cad->style, SelectCadDrawColor);
		}
	}
	/* ߤΤȤ */
	else if ( cad->code == 4) {
		if ( Layer[cad->layer].draw != 0) {
			/* ߤ */
			CircleDraw(widget, cad->cx, cad->cy, cad->r, cad->style, sagcad_color.Back);
			CircleDraw(widget, cad->cx, cad->cy, cad->r, cad->style, SelectCadDrawColor);
		}
	}

	if (update == UPDATE_ON) {
		UpDate();
	}

	return 1;
}





/* -------------------------------------------------------
 * ʱߤõ
 * 
 */
int ellipse_search_sub(ELLIPSE *ellipse, double px, double py)
{
//#define ELLIPSE_SEARCH_SUB
	struct RtnDat rtn;
	double a, b, angle;
	double l1, l2, pic_angle;
	double x1, y1, x2, y2;
	int debug = 0;


#ifdef ELLIPSE_SEARCH_SUB
	debug = 1;
	if (debug > 0) g_print("Select.c : ellipse_search_sub() : in\n");
#endif

	/* -----------------------------------------------------
	 * ʱߤǤ
	 */
	
	/* 濴Ĺΰ֤γ٤ȵΥ */
	/* -------------------------------------------------------------------
	 * la : [8] ľγ
	 */
	rtn.sx[1] = ellipse->cx;
	rtn.sy[1] = ellipse->cy;
	rtn.ex[1] = ellipse->cx + ellipse->dx;
	rtn.ey[1] = ellipse->cy + ellipse->dy;
	la(&rtn);
	angle = rtn.angle;
	if (debug > 0) g_print("Select.c : ellipse_search_sub() : angle = %f\n", angle);

	/* -------------------------------------------------------------------
	 * pp : [9] ֤εΥ
	 */
	pp(&rtn);
	a = rtn.l;
	b = a * ellipse->k;
	if (debug > 0) g_print("Select.c : ellipse_search_sub() : a = %f  b = %f\n", a, b);

	/*  */
	x1 = -1 * (sqrt(a*a - b*b)) + ellipse->cx;
	y1 = 0 + ellipse->cy;
	x2 = sqrt(a*a - b*b) + ellipse->cx;
	y2 = 0 + ellipse->cy;
	rotation(&x1, &y1, ellipse->cx, ellipse->cy, angle);
	rotation(&x2, &y2, ellipse->cx, ellipse->cy, angle);
	if (debug > 0) g_print("Select.c : ellipse_search_sub() :  (%f,%f) (%f,%f)\n", x1, y1, x2, y2);


	/* (px,py)  εΥδطǡDC2ܤȽ */
	/* -------------------------------------------------------------------
	 * pp : [9] ֤εΥ
	 */
	rtn.sx[1] = x1;
	rtn.sy[1] = y1;
	rtn.ex[1] = px;
	rtn.ey[1] = py;
	pp(&rtn);
	l1 = rtn.l;

	rtn.sx[1] = x2;
	rtn.sy[1] = y2;
	rtn.ex[1] = px;
	rtn.ey[1] = py;
	pp(&rtn);
	l2 = rtn.l;

	if (debug > 0) g_print("Select.c : ellipse_search_sub() : l1 + l2 = %f  OK = %f  DC = %f\n", l1 + l2, 2*a, DC);

	if ( (l1 + l2) + DC > (2*a) && (l1 + l2) - DC < (2*a) ) {
		if (debug > 0) g_print("Select.c : ellipse_search_sub() : Click On Ellipse\n");
		//
	}
	else {
		if (debug > 0) g_print("Select.c : ellipse_search_sub() : Click Not On Ellipse\n");
		return 0;
	}


	/* ϳѡλѤȽ */
	/* ԥåʱߤФ٤ */
	/* -------------------------------------------------------------------
	 * la : [8] ľγ
	 */
	rtn.sx[1] = ellipse->cx;
	rtn.sy[1] = ellipse->cy;
	rtn.ex[1] = px;
	rtn.ey[1] = py;
	la(&rtn);
	pic_angle = rtn.angle - angle;
	
	while (pic_angle < 0 || pic_angle > 360) {
		if (pic_angle > 360) pic_angle = pic_angle - 360;
		if (pic_angle < 0) pic_angle = pic_angle + 360;
	}


	if (debug > 0) {
		g_print("Select.c : ellipse_search_sub() : pic_angle = %f  Ellipse sa = %f  ea = %f\n", 
				 pic_angle, ellipse->sa, ellipse->ea);
	}


	if (ellipse->sa < ellipse->ea) {
		if (debug > 0) g_print("Select.c : ellipse_search_sub() : sa (%f) < ea (%f)\n", ellipse->sa, ellipse->ea);

		if (pic_angle > ellipse->sa && pic_angle < ellipse->ea) {
			if (debug > 0) g_print("Select.c : ellipse_search_sub() : sa < pic (%f) < ea ---> OK !!\n", pic_angle);
			return 1;
		}
	}
	else if (ellipse->sa > ellipse->ea) {
		if (debug > 0) g_print("Select.c : ellipse_search_sub() : sa (%f) > ea (%f)\n", ellipse->sa, ellipse->ea);

		if (pic_angle > ellipse->sa || pic_angle < ellipse->ea) {
			if (debug > 0) g_print("Select.c : ellipse_search_sub() : pic (%f) > sa  pic (%f) < ea ---> OK !!\n", 
					pic_angle, pic_angle);
			return 1;
		}
	}
	else {
		return 0;
	}

	return 0;
}





/* -------------------------------------------------------
 * ʱõᥤ
 * 
 */
ELLIPSE *ellipse_search(double x, double y)
{
//#define ELLIPSE_SEARCH

	ELLIPSE_LIST *p;
//	static ELLIPSE_LIST *StartData = NULL;
	int debug = 0;


#ifdef ELLIPSE_SEARCH
	debug = 1;
#endif


	if (EllipseStartData == NULL && ellipse_list_info.head != NULL) {
		EllipseStartData = ellipse_list_info.tail;
	}
	else if (ellipse_list_info.head == NULL) {
		return NULL;
	}

	/* p  EllipseStartData  */
	p = EllipseStartData;

	/* -----------------------------------------------------
	 * p ǸΥǡ tail ʤ p ǽΥǡ head ˤ롣
	 * ʳʤ顢p ̥ǡ(EllipseStartData 褫õ
	 */
	if (p == ellipse_list_info.tail) {
		p = ellipse_list_info.head;
	}
	else if (p != ellipse_list_info.tail) { 
		p = p->next;
	}


	/* p  ǡκǸޤǤõ */
	while (p != NULL) {
		if(Layer[p->ellipse->layer].draw == 1) {
			if (debug > 0) g_print("Select.c : ellipse_search() : in\n");
			/* ---------------------------------------------
			 * ʱ
			 */
			if (debug > 0) g_print("Select.c : ellipse_search() : search ellipse 1\n");
			if (ellipse_search_sub(p->ellipse, x, y) != 0) {
				/* Ĥä */
				EllipseStartData = p;
				if (debug > 0) {
					g_print("Select.c : ellipse_search() : ʱߤߤĤä 1\n");
				}
				if (SelectEllipseCheck(p->ellipse) == 0)
					return p->ellipse;
			}
		}
		else {
			//
		}
		p = p->next;
	}


	/* -----------------------------------------------------
	 * EllipseStartData  tail ä
	 * ǽ餫ǸޤõƤ뤫餳θνϤʤ
	 */
	if (EllipseStartData == ellipse_list_info.tail) {
		return NULL;
	}


	/* ------------------------------------------------------------
	 * ǡκǽ餫 EllipseStartData ޤǤõ
	 */
	p =  ellipse_list_info.head;
	while (p != NULL && p != EllipseStartData->next) {
		if(Layer[p->ellipse->layer].draw == 1) {
			/* ---------------------------------------------
			 * ʱ
			 */
			if (ellipse_search_sub(p->ellipse, x, y) != 0) {
					/* Ĥä */
					EllipseStartData = p;
					if (debug > 0) {
						g_print("Select.c : ellipse_search() : ʱߤߤĤä 2\n");
					}
					if (SelectEllipseCheck(p->ellipse) == 0)
						return p->ellipse;
			}
		}
		else {
			//
		}
		p = p->next;
	}
	EllipseStartData = p;
	return NULL;
}





/* -------------------------------------------------------
 * ELLIPSE Data 쥯ȤƤ뤫ǧ
 *	
 *   ELLIPSE *data
 *   int	0򤵤Ƥʤ 	1Ѥ
 */
int SelectEllipseCheck(ELLIPSE *data)
{
	SELECT_LIST *p;

	p = select_list_info.head;
	while (p != NULL) {
		if (p->select->diagram_point.ellipse_point == data) 
			return 1;
		p = p->next;
	}
	return 0;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Select.c
 * ====================================================================
 */
