/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : Ellipse.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/04/22
 *    Last                 : 2003/04/22
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "MemoryLeak.h"
#include "types.h"
#include "List_cad.h"
#include "List_Ellipse.h"
//#include "CopyFunc.h"
#include "Trace.h"

#define _ELLIPSE_
#include "Ellipse.h"





/* -------------------------------------------------------------------
 * Ĺ a 
 * 
 */
double get_ellipse_a(ELLIPSE ellipse)
{
	struct RtnDat rtn;

	rtn.sx[1] = ellipse.cx;
	rtn.sy[1] = ellipse.cy;
	rtn.ex[1] = ellipse.cx + ellipse.dx;
	rtn.ey[1] = ellipse.cy + ellipse.dy;
	pp(&rtn);
	return rtn.l;
}


/* -------------------------------------------------------------------
 * û b 
 * 
 */
double get_ellipse_b(ELLIPSE ellipse)
{
	return (get_ellipse_a(ellipse) * ellipse.k);
}


/* -------------------------------------------------------------------
 * ʱߤη
 * 
 */
double get_ellipse_angle(ELLIPSE ellipse)
{
	struct RtnDat rtn;


	rtn.sx[1] = ellipse.cx;
	rtn.sy[1] = ellipse.cy;
	rtn.ex[1] = ellipse.cx + ellipse.dx;
	rtn.ey[1] = ellipse.cy + ellipse.dy;
	la(&rtn);
	angle_check(&rtn.angle);
	return rtn.angle;
}


/* -------------------------------------------------------------------
 * ʱߤλȽ
 * 
 */
int get_ellipse_se_point(ELLIPSE ellipse, POINT *s_point, POINT *e_point)
{
	double RAD, DX, DY;




	/*  */
	RAD = degrad(get_ellipse_angle(ellipse));

	s_point->x = get_ellipse_a(ellipse) * cos(degrad(ellipse.sa)) + ellipse.cx;
	s_point->y = get_ellipse_b(ellipse) * sin(degrad(ellipse.sa)) + ellipse.cy;

	DX = s_point->x - ellipse.cx;
	DY = s_point->y - ellipse.cy;
	s_point->x = sg((DX * cos(RAD) - DY * sin(RAD)) + ellipse.cx, calcu_digits);
	s_point->y = sg((DY * cos(RAD) + DX * sin(RAD)) + ellipse.cy, calcu_digits);


	/*  */
	RAD = degrad(get_ellipse_angle(ellipse));

	e_point->x = get_ellipse_a(ellipse) * cos(degrad(ellipse.ea)) + ellipse.cx;
	e_point->y = get_ellipse_b(ellipse) * sin(degrad(ellipse.ea)) + ellipse.cy;

	DX = e_point->x - ellipse.cx;
	DY = e_point->y - ellipse.cy;
	e_point->x = sg((DX * cos(RAD) - DY * sin(RAD)) + ellipse.cx, calcu_digits);
	e_point->y = sg((DY * cos(RAD) + DX * sin(RAD)) + ellipse.cy, calcu_digits);

	return 1;
}


/* -------------------------------------------------------------------
 * ʱߤξ
 * 
 */
int get_ellipse_focus(ELLIPSE ellipse, POINT *focus1, POINT *focus2)
{
	double a, b, angle;


	a = get_ellipse_a(ellipse);
	b = get_ellipse_b(ellipse);
	angle = get_ellipse_angle(ellipse);

	/*  */
	focus1->x = -1 * (sqrt(a*a - b*b)) + ellipse.cx;
	focus1->y = 0 + ellipse.cy;
	focus2->x = sqrt(a*a - b*b) + ellipse.cx;
	focus2->y = 0 + ellipse.cy;

	rotation(&focus1->x, &focus1->y, ellipse.cx, ellipse.cy, angle);
	rotation(&focus2->x, &focus2->y, ellipse.cx, ellipse.cy, angle);

	return 1;
}





/* -------------------------------------------------------------------
 * ʱߤȳ٤ʱ߾
 * 
 */
int get_ellipse_point_from_angle (ELLIPSE ellipse, double angle, POINT *point)
{
//#define GET_ELLIPSE_POINT_FROM_ANGLE
	struct RtnDat rtn;
	POINT point1, point2;
	double angle1, angle2;
	ELLIPSE eps;
	int debug = 0;


#ifdef GET_ELLIPSE_POINT_FROM_ANGLE
	debug = 1;
#endif


	if (sg(angle, 3) == 360) angle = 0;
	if (debug > 0) g_print ("get_ellipse_point_from_angle() : in\n");
	eps = ellipse;
	eps.dx = get_ellipse_a(ellipse);
	eps.dy = 0;


	rtn.sx[1] = ellipse.cx;
	rtn.sy[1] = ellipse.cy;
	rtn.angle = angle;
	rtn.l = 50;
	pap(&rtn);
	rtn.type = 0;

	lep(&rtn, eps, 10);

	point1.x = rtn.sx[2];
	point1.y = rtn.sy[2];
	point2.x = rtn.sx[3];
	point2.y = rtn.sy[3];

	if (debug > 0) g_print ("    p1 (%f,%f)     p2 (%f,%f)\n", point1.x, point1.y, point2.x, point2.y);

	
	rtn.sx[1] = ellipse.cx;
	rtn.sy[1] = ellipse.cy;
	rtn.ex[1] = point1.x;
	rtn.ey[1] = point1.y;
	la(&rtn);
	angle1 = rtn.angle;

	rtn.sx[1] = ellipse.cx;
	rtn.sy[1] = ellipse.cy;
	rtn.ex[1] = point2.x;
	rtn.ey[1] = point2.y;
	la(&rtn);
	angle2 = rtn.angle;

	if (debug > 0) g_print ("    angle1 = %f   angle2 = %f   angle = %f\n", angle1, angle2, angle);

	if ((angle1 + 1) > angle && (angle1 - 1) < angle) {
		rotation(&point1.x, &point1.y, ellipse.cx, ellipse.cy, get_ellipse_angle(ellipse));
		point->x = point1.x;
		point->y = point1.y;
		if (debug > 0) g_print ("    (%f,%f)\n", point->x, point->y);
		return 1;
	}
	else if ((angle2 + 1) > angle && (angle2 - 1) < angle) {
		rotation(&point2.x, &point2.y, ellipse.cx, ellipse.cy, get_ellipse_angle(ellipse));
		point->x = point2.x;
		point->y = point2.y;
		if (debug > 0) g_print ("    (%f,%f)\n", point->x, point->y);
		return 1;
	}



	if (debug > 0) g_print ("get_ellipse_point_from_angle() : out\n");
	return 0;
}





/* -------------------------------------------------------------------
 * ʱߤʱ߾γ٤
 * 
 */
double get_ellipse_angle_from_point (ELLIPSE ellipse, POINT point)
{
	struct RtnDat rtn;


	rotation(&point.x, &point.y, ellipse.cx, ellipse.cy, (-1 * get_ellipse_angle(ellipse)));

	/* -------------------------------------------------------------------
	 * la : ľγ
	 */
	rtn.sx[1] = ellipse.cx;
	rtn.sy[1] = ellipse.cy;
	rtn.ex[1] = point.x;
	rtn.ey[1] = point.y;
	la(&rtn);
	angle_check(&rtn.angle);

	return rtn.angle;
}





/* -------------------------------------------------------
 *  (px, py) ϡʱ߾Ǥ뤫Ƚ
 * 
 */
int point_on_ellipse (ELLIPSE *ellipse, double px, double py)
{
//#define POINT_ON_ELLIPSE
	struct RtnDat rtn;
	double angle = 0;
	double pic_angle;
	int debug = 0;


#ifdef POINT_ON_ELLIPSE
	debug = 1;
	if (debug > 0) g_print("List_Ellipse.c : point_on_ellipse() : in\n");
#endif


	/* ʱ߾ˤ뤫 */
	if (point_in_ellipse(ellipse, px, py, 0.000001) != 3) {
		return 0;
	}


	/* ϳѡλѤȽ */
	/* ԥåʱߤФ٤ */
	/* -------------------------------------------------------------------
	 * la : [8] ľγ
	 */
	rtn.sx[1] = ellipse->cx;
	rtn.sy[1] = ellipse->cy;
	rtn.ex[1] = px;
	rtn.ey[1] = py;
	la(&rtn);
	pic_angle = rtn.angle - angle;
	angle_check(&pic_angle);


	if (debug > 0) {
		g_print("Ellipse.c : point_on_ellipse() : pic_angle = %f  Ellipse sa = %f  ea = %f\n", 
				 pic_angle, ellipse->sa, ellipse->ea);
	}


	/* SA < EA */
	if (ellipse->sa < ellipse->ea) {
		if (debug > 0) g_print("Ellipse.c : point_on_ellipse() : sa (%f) < ea (%f)\n", ellipse->sa, ellipse->ea);

		if (pic_angle > ellipse->sa && pic_angle < ellipse->ea) {
			if (debug > 0) g_print("Ellipse.c : point_on_ellipse() : sa < pic (%f) < ea ---> OK !!\n", pic_angle);
			return 1;
		}
	}

	/* SA > EA */
	else if (ellipse->sa > ellipse->ea) {
		if (debug > 0) g_print("Ellipse.c : point_on_ellipse() : sa (%f) > ea (%f)\n", ellipse->sa, ellipse->ea);

		if (pic_angle > ellipse->sa || pic_angle < ellipse->ea) {
			if (debug > 0) g_print("Ellipse.c : point_on_ellipse() : pic (%f) > sa  pic (%f) < ea ---> OK !!\n", 
					pic_angle, pic_angle);
			return 1;
		}
	}
	else {
		return 0;
	}

	return 0;
}





/* -------------------------------------------------------
 * ʱߤˤ뤫ˤ뤫Ƚ
 * 
 * 
 * 
 * value : Ƚϰ()    0.001 Ȥ 0.5 Ȥ
 * 
 * return : 1 : IN
 *          2 : OUT
 *          3 : ON
 */
int point_in_ellipse (ELLIPSE *ellipse, double px, double py, double value)
{
//#define POINT_IN_ELLIPSE
	struct RtnDat rtn;
	double a, b, angle;
	double l1, l2;
	POINT focus1, focus2;
	int debug = 0;


#ifdef POINT_IN_ELLIPSE
	debug = 1;
	if (debug > 0) g_print("Ellipse.c : point_in_ellipse() : in\n");
#endif



	/* -----------------------------------------------------
	 * ʱߤǤ
	 */
	/* 濴Ĺΰ֤γ٤ȵΥ */
	angle = get_ellipse_angle(*ellipse);
	a = get_ellipse_a(*ellipse);
	b = get_ellipse_b(*ellipse);
	get_ellipse_focus(*ellipse, &focus1, &focus2);

	if (debug > 0) {
		g_print("Ellipse.c : point_in_ellipse() : a = %f  b = %f  angle = %f   (%f,%f) (%f,%f)\n", 
				 a, b, angle, focus1.x, focus1.y, focus2.x, focus2.y);
	}



	/* (px,py)  εΥδطǡ(1/pow(10, compa_digits)) Ƚ */
	/* -------------------------------------------------------------------
	 * pp : [9] ֤εΥ
	 */
	rtn.sx[1] = focus1.x;
	rtn.sy[1] = focus1.y;
	rtn.ex[1] = px;
	rtn.ey[1] = py;
	pp(&rtn);
	l1 = rtn.l;

	rtn.sx[1] = focus2.x;
	rtn.sy[1] = focus2.y;
	rtn.ex[1] = px;
	rtn.ey[1] = py;
	pp(&rtn);
	l2 = rtn.l;

	if (debug > 0) g_print("Ellipse.c : point_in_ellipse() : X10000 : (l1 + l2) = %f   (2 X a) = %f   value = %f\n", 10000*(l1 + l2), 10000*(2*a), 10000*value);



	/* (l1 + l2) = 2a ʤ Ellipse α߼ */
	if ( (l1 + l2) + (value) > (2*a) && (l1 + l2) - (value) < (2*a) ) {
		if (debug > 0) g_print("Ellipse.c : point_in_ellipse() : on Ellipse\n");
		return 3;
	}

	/* Ellipse  */
	else if (l1 + l2 < (2*a)) {
		if (debug > 0) g_print("Ellipse.c : point_in_ellipse() : in Ellipse\n");
		return 1;
	}

	/* Ellipse γ */
	else if (l1 + l2 > (2*a)) {
		if (debug > 0) g_print("Ellipse.c : point_in_ellipse() : out Ellipse\n");
		return 2;
	}

	return 0;
}





/* -------------------------------------------------------------------
 * ʱߤθ
 * 
 * in :
 *      Point (a->sx[1],a->sy[1])
 * 
 * out :
 *      type 0,1,2
 *      Point 1 (a->ex[1],a->ey[1])
 *      Point 2 (a->ex[2],a->ey[2])
 * 
 */
int pel(struct RtnDat *rtn, ELLIPSE ellipse)
{
	int Ret;
	ELLIPSE eps;
	CAD cad;
	double a, b, A, B, C, X1, Y1, X2, Y2;


	/* -----------------------------------------------------
	 * ΰ֤ǧ
	 */
	eps = ellipse;
	Ret = point_in_ellipse (&eps, rtn->sx[1], rtn->sy[1], 0.0000001);
	/* in */
	if (Ret == 1) {
		rtn->type = 0;
		return 0;
	}
	/* out */
	else if (Ret == 2) {
		rtn->type = 2;
	}
	/* out */
	else if (Ret == 3) {
		rtn->type = 1;
		rtn->ex[1] = rtn->sx[1];
		rtn->ey[1] = rtn->sy[1];
		return 1;
	}



	/* -----------------------------------------------------
	 * ޤʱߤ濴 (0,0) ǡ٤ 0 ˤʤ褦ʺɸѴ
	 */
	/*  */
	init_cad(&cad);
	cad.sx = rtn->sx[1];
	cad.sy = rtn->sy[1];

	parallel(&cad.sx, &cad.sy, -ellipse.cx, -ellipse.cy);
	rotation(&cad.sx, &cad.sy, 0, 0, (-1 * get_ellipse_angle(ellipse)));



	/*  */
	/* ʱߤμμ */
	a = get_ellipse_a(eps);
	b = get_ellipse_b(eps);

	A = (1/(a*a)) + (b * b * cad.sx * cad.sx) / (a * a * a * a * cad.sy * cad.sy);
	B = -1 * ((2 * b * b * cad.sx) / (a * a * cad.sy * cad.sy));
	C = ((b * b) / (cad.sy * cad.sy)) - 1;

	X1 = (-B + sqrt((B * B) - (4 * A * C))) / (2 * A);
	X2 = (-B - sqrt((B * B) - (4 * A * C))) / (2 * A);

	Y1 = ( (b*b) * (1 - ((X1 * cad.sx)/(a*a))) ) / cad.sy;
	Y2 = ( (b*b) * (1 - ((X2 * cad.sx)/(a*a))) ) / cad.sy;


	/* -----------------------------------------------------
	 * Ǹˡ򸵤κɸ᤹
	 */
	rtn->type = 2;
	rtn->ex[1] = X1;
	rtn->ey[1] = Y1;
	rtn->ex[2] = X2;
	rtn->ey[2] = Y2;

	rotation(&rtn->ex[1], &rtn->ey[1], 0, 0, get_ellipse_angle(ellipse));
	parallel(&rtn->ex[1], &rtn->ey[1], ellipse.cx, ellipse.cy);
	rotation(&rtn->ex[2], &rtn->ey[2], 0, 0, get_ellipse_angle(ellipse));
	parallel(&rtn->ex[2], &rtn->ey[2], ellipse.cx, ellipse.cy);

	return 2;
}





/* -------------------------------------------------------------------
 * ʱߤθ
 * lep
 * RtnDat
 *      : (sx[1],sy[1]) - (ex[1],ey[1])
 *   ʱ : 
 * RtnDat
 *   type	0 , 1 , 2
 *    1	(sx[2],sy[2])
 *    2	(sx[3],sy[3])
 */
int lep(struct RtnDat *rtn, ELLIPSE ellipse, int dgt)
{
//#define LEP
	ELLIPSE eps;
	CAD cad;
	double a, b, m, n, angle;
	double A, B, C, D, X1, Y1, X2, Y2;
	int debug = 0;


#ifdef LEP
	debug = 1;
#endif


	if (debug > 0) g_print("ellipse : (%f,%f),(%f,%f),%f, %f-%f\n", ellipse.cx, ellipse.cy, 
																	ellipse.dx, ellipse.dy, 
																	ellipse.k, 
																	ellipse.sa, ellipse.ea);
	if (debug > 0) g_print("rtn : (%f,%f)-(%f,%f)\n", rtn->sx[1], rtn->sy[1], rtn->ex[1], rtn->ey[1]);





	/* -----------------------------------------------------
	 * ޤʱߤ濴 (0,0) ǡ٤ 0 ˤʤ褦ʺɸѴ
	 */
	/*  */
	init_cad(&cad);
	cad.sx = rtn->sx[1];
	cad.sy = rtn->sy[1];
	cad.ex = rtn->ex[1];
	cad.ey = rtn->ey[1];

	parallel(&cad.sx, &cad.sy, -ellipse.cx, -ellipse.cy);
	rotation(&cad.sx, &cad.sy, 0, 0, (-1 * get_ellipse_angle(ellipse)));
	parallel(&cad.ex, &cad.ey, -ellipse.cx, -ellipse.cy);
	rotation(&cad.ex, &cad.ey, 0, 0, (-1 * get_ellipse_angle(ellipse)));



	eps = ellipse;
	a = get_ellipse_a(eps);
	b = get_ellipse_b(eps);


	/* y = mx + n  */

	/* ľ */
	if (cad.ex > cad.sx - (1/pow(10, dgt)) && cad.ex < cad.sx + (1/pow(10, dgt))) {
		if (debug > 0) g_print("ľ\n");

		/* -a ܤ */
		if (cad.sx > -a - (1/pow(10, dgt)) && cad.sx < -a + (1/pow(10, dgt))) {
			if (debug > 0) g_print("-a ܤ\n");
			rtn->type = 1;
			X1 = -a;
			Y1 = 0;
		}

		/* a ܤ */
		else if (cad.sx > a - (1/pow(10, dgt)) && cad.sx < a + (1/pow(10, dgt))) {
			if (debug > 0) g_print("a ܤ\n");
			rtn->type = 1;
			X1 = a;
			Y1 = 0;
		}

		/* Ťʤ */
		else if (cad.sx > -a && cad.sx < a) {
			if (debug > 0) g_print("Ťʤ\n");
			rtn->type = 2;

			angle = acos(cad.sx / a);
			X1 = cad.sx;
			Y1 = b * sin(angle);
			X2 = cad.sx;
			Y2 = -Y1;
		}

		else {
			if (debug > 0) g_print("̵\n");
			rtn->type = 0;
			return 0;
		}
	}



	/* ʿ */
	else if (cad.ey > cad.sy - (1/pow(10, dgt)) && cad.ey < cad.sy + (1/pow(10, dgt))) {
		if (debug > 0) g_print("ʿ\n");

		/* -b ܤ */
		if (cad.sy > -b - (1/pow(10, dgt)) && cad.sy < -b + (1/pow(10, dgt))) {
			rtn->type = 1;
			X1 = 0;
			Y1 = -b;
		}

		/* b ܤ */
		else if (cad.sy > b - (1/pow(10, dgt)) && cad.sy < b + (1/pow(10, dgt))) {
			rtn->type = 1;
			X1 = 0;
			Y1 = b;
		}

		/* Ťʤ */
		else if (cad.sy > -b && cad.sy < b) {
			rtn->type = 2;
			
			angle = asin(cad.sy / b);
			X1 = a * cos(angle);
			Y1 = cad.sy;
			X2 = -X1;
			Y2 = Y1;
		}
		
		else {
			rtn->type = 0;
			return 0;
		}
	}



	/* ̤ */
	else {
		m = (cad.ey - cad.sy) / (cad.ex - cad.sx);
		n = cad.sy - (m * cad.sx);

		A = (1/(a*a)) + ((m*m)/(b*b));
		B = (2*m*n) / (b*b);
		C = ((n*n) / (b*b)) - 1;

		D = (B*B) - (4*A*C);


		/* ʱߤܤƤ() */
		if (D < (1/pow(10, dgt)) && D > -(1/pow(10, dgt)) ) {
			if (debug > 0) g_print("ܤƤ D = %f\n", D);
			rtn->type = 1;

			X1 = (-B / (2*A));
			Y1 = m * X1 + n;
		}

		/* ŤʤäƤ() */
		else if (D > 0) {
			if (debug > 0) g_print("ŤʤäƤ D = %f\n", D);
			rtn->type = 2;

			X1 = (-B-sqrt(B*B-4*A*C)) / (2*A);
			Y1 = m * X1 + n;
			X2 = (-B+sqrt(B*B-4*A*C)) / (2*A);
			Y2 = m * X2 + n;
		}

		/* ΥƤ() */
		else if (D < 0) {
			if (debug > 0) g_print("ΥƤ D = %f\n", D);
			rtn->type = 0;
			return 0;
		}

		else {
			if (debug > 0) g_print(" D = %f\n", D);
			return -1;
		}
	}





	if (rtn->type == 1) {
		rotation(&X1, &Y1, 0, 0, get_ellipse_angle(ellipse));
		parallel(&X1, &Y1, ellipse.cx, ellipse.cy);
		rtn->sx[2] = X1;
		rtn->sy[2] = Y1;
	}

	if (rtn->type == 2) {
		rotation(&X1, &Y1, 0, 0, get_ellipse_angle(ellipse));
		parallel(&X1, &Y1, ellipse.cx, ellipse.cy);
		rotation(&X2, &Y2, 0, 0, get_ellipse_angle(ellipse));
		parallel(&X2, &Y2, ellipse.cx, ellipse.cy);
		rtn->sx[2] = X1;
		rtn->sy[2] = Y1;
		rtn->sx[3] = X2;
		rtn->sy[3] = Y2;
	}

	return rtn->type;
}





/* -------------------------------------------------------------------
 * ʱ߾(angle)Ǥ
 * 
 */
int ellipse_tangent(struct RtnDat *rtn, ELLIPSE ellipse, double angle)
{
	double a, b;


	/* ʱ߾ angle  */
	/* 濴 (0,0) Ƿ 0 ٤ʱߤκɸ */
	a = get_ellipse_a(ellipse);
	b = get_ellipse_b(ellipse);

	if (angle > -0.0001 && angle < 0.0001) {
		rtn->sx[1] = a;
		rtn->sy[1] = 0.;
		rtn->ex[1] = a;
		rtn->ey[1] = 100.;
		//g_print("ellipse_tangent() : rtn->ey[1] = %f\n", rtn->ey[1]);
	}
	else if (angle > 180 - 0.0001 && angle < 180 + 0.0001) {
		rtn->sx[1] = -a;
		rtn->sy[1] = 0.;
		rtn->ex[1] = -a;
		rtn->ey[1] = -100.;
		//g_print("ellipse_tangent() : rtn->ey[1] = %f\n", rtn->ey[1]);
	}
	else {
		rtn->sx[1] = get_ellipse_a(ellipse) * cos(degrad(angle));
		rtn->sy[1] = get_ellipse_b(ellipse) * sin(degrad(angle));

		rtn->ex[1] = rtn->sx[1] + 100;
		rtn->ey[1] = (1 - (rtn->sx[1] * rtn->ex[1]) / (a*a)) * ((b*b) / rtn->sy[1]);
	}


	/* -----------------------------------------------------
	 * Ǹˡ򸵤κɸ᤹
	 */
	rtn->type = 1;
	if (get_ellipse_angle(ellipse) != 0) {
		rotation(&rtn->sx[1], &rtn->sy[1], 0, 0, get_ellipse_angle(ellipse));
	}
	parallel(&rtn->sx[1], &rtn->sy[1], ellipse.cx, ellipse.cy);
	if (get_ellipse_angle(ellipse) != 0) {
		rotation(&rtn->ex[1], &rtn->ey[1], 0, 0, get_ellipse_angle(ellipse));
	}
	parallel(&rtn->ex[1], &rtn->ey[1], ellipse.cx, ellipse.cy);

	return 1;
}





/* -------------------------------------------------------------------
 * cc_check : ߤΰִطĴ٤
 * 
 *     : rtndat
 *     :      1	(cx[1] , cy[1]) ,r[1]
 *     :      2	(cx[2] , cy[2]) ,r[2]
 * 
 * return = type : 0 顼
 *                 1 ߤΥƤ
 *                 2 ߤܤƤ
 *                 3 ߤŤʤäƤ
 *                 4 ߤŤʤäܤƤ
 *                 5 ߤŤʤäΥƤ
 * 
 */
int cc_check(struct RtnDat *rtn)
{
//#define CC_CHECK
	struct RtnDat pph;
	double dist,r1pr2,r1mr2;
	int debug = 0;


#ifdef CC_CHECK
	debug = 1;
#endif

	pph.sx[1] = rtn->cx[1];
	pph.sy[1] = rtn->cy[1];
	pph.ex[1] = rtn->cx[2];
	pph.ey[1] = rtn->cy[2];
	pp(&pph);

	dist = sg(pph.l, compa_digits);
	r1pr2 = sg((rtn->r[1] + rtn->r[2]), compa_digits);
	r1mr2 = sg((rtn->r[1] - rtn->r[2]), compa_digits);


	if (debug > 1) {
		/* ߤΥƤ롣 */
		g_print("type 4 : dist > r1pr2 = %d\n", dist > r1pr2);
		/* ߤܤƤ롣 */
		g_print("type 3 : dist == r1pr2 = %d\n", dist == r1pr2);
		/* ߤŤʤäƤ롣 */
		g_print("type 2 : dist < r1pr2 && dist > r1mr2 = %d\n", (dist < r1pr2 && dist > r1mr2));
		g_print("  type 2-1 : dist < r1pr2 = %d\n", (dist < r1pr2));
		g_print("  type 2-2 : dist > r1mr2 = %d\n", (dist > r1mr2));
		/* ߤŤʤäܤƤ롣 */
		g_print("type 1 : dist == r1mr2 = %d\n", (dist == r1mr2));
		/* ߤŤʤäΥƤ롣 0  */
		g_print("type 0 : (dist < r1mr2 && sg(rtn->l, compa_digits) > 0) = %d\n", 
				(dist < r1mr2 && sg(rtn->l, compa_digits) > 0));
		g_print("  type 0-1 : (dist < r1mr2) = %d\n", (dist < r1mr2));
		g_print("  type 0-2 : (sg(rtn->l, compa_digits) > 0) = %d\n", (sg(rtn->l, compa_digits) > 0));
	}


	/* ߤΥƤ롣 */
	if (dist > r1pr2) {
		if (debug > 0) g_print("type 1 : ߤΥƤ\n");
		rtn->type = 1;
		return 1;
	}

	/* ߤܤƤ롣 */
	else if (dist == r1pr2) {
		if (debug > 0) g_print("type 2 : ߤܤƤ\n");
		rtn->type = 2;
		return 2;
	}

	/* ߤŤʤäƤ롣 */
	else if (dist < r1pr2 && dist > r1mr2) {
		if (debug > 0) g_print("type 2 : ߤŤʤäƤ\n");
		rtn->type = 3;
		return 3;
	}

	/* ߤŤʤäܤƤ롣 */
	else if (dist == r1mr2) {
		if (debug > 0) g_print("type 4 : ߤŤʤäܤƤ\n");
		rtn->type = 4;
		return 4;
	}

	/* ߤŤʤäΥƤ롣 0  */
	else if (dist < r1mr2 && sg(rtn->l, compa_digits) > 0) {
		if (debug > 0) g_print("type 5 : ߤŤʤäΥƤ\n");
		rtn->type = 5;
		return 5;
	}

	return 0;
}





/* -------------------------------------------------------
 * ʱߤʱ()θ (MAIN)
 * 
 * ʱߤϣĤ⤢ꤨ
 * 
 * rtn->type : 0 ̵
 *             1   (rtn->sx[1],rtn->sy[1])
 *             2   (rtn->sx[2],rtn->sy[2])
 *             3   (rtn->sx[3],rtn->sy[3])
 *             4   (rtn->sx[4],rtn->sy[4])
 * 
 *          ʱߤΰִطĴ٤
 *  return : 0 : 顼
 *           1 : ΥƤ
 *           2 : ¤ܤƤ
 *           3 : ŤʤäƤ
 *           4 : ŤʤäܤƤ
 *           5 : ŤʤäΥƤ
 */
int ellipse_on_ellipse(struct RtnDat *rtn, ELLIPSE ellipseA, ELLIPSE ellipseB)
{
//#define ELLIPSE_ON_ELLIPSE
	int i, j, Ret, Ret1, Ret2;
	double value;
	int A_data[360];
	int B_data[360];
	int AinB = 0, BinA = 0, start_frag = 0;
	double sa[5], ea[5];
	double sa1, ea1, sa2, ea2;
	POINT point1, point2;
	int BeforeRet = 0;
	int debug = 0;


#ifdef ELLIPSE_ON_ELLIPSE
	debug = 1;
#endif

	rtn->type = 0;
	if (debug > 0) g_print ("ellipse_on_ellipse() : in\n");


	/* -----------------------------------------------------
	 * ǡμ
	 * 
	 */
	/* ʱߣ1٤Ȥ˥ǡ */
	value = (2 * PI * get_ellipse_a(ellipseA)) / (360*2);
	if (debug > 0) g_print ("ʱߣβ\n");
	for (i = 0 ; i < 360 ; i++) {
		get_ellipse_point_from_angle (ellipseA, (double)i, &point1);
		Ret = point_in_ellipse (&ellipseB, point1.x, point1.y, value);
		if (Ret == 3) Ret = 1;
		if (debug > 0) {
			g_print ("%d", Ret);
			if (i == 89 || i == 179 || i == 269 || i == 359) g_print("\n");
		}
		A_data[i] = Ret;
	}

	/* ʱߣ¤1٤Ȥ˥ǡ */
	value = (2 * PI * get_ellipse_a(ellipseB)) / (360*2);
	if (debug > 0) g_print ("ʱߣ¤β\n");
	for (i = 0 ; i < 360 ; i++) {
		get_ellipse_point_from_angle (ellipseB, (double)i, &point1);
		Ret = point_in_ellipse (&ellipseA, point1.x, point1.y, value);
		if (Ret == 3) Ret = 1;
		if (debug > 0) {
			g_print ("%d", Ret);
			if (i == 89 || i == 179 || i == 269 || i == 359) g_print("\n");
		}
		B_data[i] = Ret;
	}


	/* ʱߣ¤濴ʱߣ */
	Ret = point_in_ellipse (&ellipseA, ellipseB.cx, ellipseB.cy, 0.0000001);
	if (Ret == 1) BinA = 1;
	/* ʱߣ濴ʱߣ¤ */
	Ret = point_in_ellipse (&ellipseB, ellipseA.cx, ellipseA.cy, 0.0000001);
	if (Ret == 1) AinB = 1;





	/* -----------------------------------------------------
	 * SA(out->in) or EA(in->out)  
	 * 
	 */
	for (i = 0 ; i < 5 ; i++) {
		sa[i] = 0;
		ea[i] = 0;
	}
	if (A_data[0] == 1) {
		start_frag = 1;
	}
	j = 0;
	BeforeRet = 0;
	for (i = 0 ; i < 360 ; i++) {
		/* out */
		if (A_data[i] == 2) {
			if (BeforeRet == 1) {
				ea[j] = (double) i;
				j++;
			}
			BeforeRet = 2;
		}
		/* in or on */
		else if (A_data[i] == 1) {
			if (BeforeRet == 2) {
				sa[j] = (double) i-1;
			}
			BeforeRet = 1;
		}
	}
	if (start_frag == 1) {
		sa[0] = sa[j];
	}

	if (debug > 0) {
		for (i = 0 ; i < j ; i++) {
			g_print ("sa[%d] = %f  ea[%d] = %f\n", i, sa[i], i, ea[i]);
		}
	}





	/* -----------------------------------------------------
	 * SA(out->in) or EA(in->out) 󤫤õ 
	 * 
	 */
	for (i = 0 ; i < j ; i++) {
		/*  */
		if (sa[i] == 0 && ea[i] == 0) {
			if (debug > 0) g_print("Ellipse.c : ellipse_on_ellipse_rect() : sa[i] == 0 && ea[i] == 0 ǽλ\n");
			return 0;
		}

		/* SA < EA */
		else if (sa[i] < ea[i]) {
			if (debug > 0) g_print("Ellipse.c : ellipse_on_ellipse_rect() : sa[i] < ea[i]\n");

			/* õϰϤ */
			sa1 = sa[i];
			ea1 = ((ea[i] - sa[i]) / 2) + sa[i];
			sa2 = ((ea[i] - sa[i]) / 2) + sa[i];
			ea2 = ea[i];

			/* ΰκǽ */
			if (debug > 0) g_print("Ellipse.c : ellipse_on_ellipse_rect() : sa1 = %f  ea1 = %f\n", sa1, ea1);
			Ret1 = ellipse_on_ellipse_point(ellipseA, ellipseB, &sa1, &ea1, ((ea[i] - sa[i]) / 10), 0.0000001);
			if (Ret1 == 1) {
				rtn->type++;
				get_ellipse_point_from_angle (ellipseA, ((ea1 + sa1) / 2), &point1);
				rtn->sx[rtn->type] = point1.x;
				rtn->sy[rtn->type] = point1.y;
				if (debug > 0) g_print("Ellipse.c : ellipse_on_ellipse_rect() : (%f,%f)\n", point1.x, point1.y);
			}

			/* ΰκǸ */
			if (debug > 0) g_print("Ellipse.c : ellipse_on_ellipse_rect() : sa2 = %f  ea2 = %f\n", sa2, ea2);
			Ret2 = ellipse_on_ellipse_point(ellipseA, ellipseB, &sa2, &ea2, ((ea[i] - sa[i]) / 10), 0.0000001);
			if (Ret2 == 1) {
				rtn->type++;
				get_ellipse_point_from_angle (ellipseA, ((ea2 + sa2) / 2), &point2);
				rtn->sx[rtn->type] = point2.x;
				rtn->sy[rtn->type] = point2.y;
				if (debug > 0) g_print("Ellipse.c : ellipse_on_ellipse_rect() : (%f,%f)\n", point2.x, point2.y);
			}

			if (Ret1 == 1 && Ret2 == 1) {
				if (sg(point1.x, 4) == sg(point2.x, 4) && sg(point1.y, 4) == sg(point2.y, 4)) {
					rtn->type--;
					rtn->sx[rtn->type] = sg(point1.x, 4);
					rtn->sy[rtn->type] = sg(point1.y, 4);
				}
			}
		}



		/* EA < SA */
		else if (sa[i] > ea[i]) {
			if (debug > 0) g_print("Ellipse.c : ellipse_on_ellipse_rect() : sa[i] > ea[i]\n");
			/* õϰϤ */
			sa1 = sa[i];
			ea1 = sa[i] + (360-sa[i]+ea[i])/2;
			if (ea1 <= 0) ea1 = ea1 + 360;

			sa2 = sa[i] + (360-sa[i]+ea[i])/2;
			if (sa2 >= 360) sa2 = sa2 - 360;
			if (sa2 == 360) sa2 = 0;
			ea2 = ea[i];


			/* ΰκǽ */
			if (debug > 0) g_print("Ellipse.c : ellipse_on_ellipse_rect() : sa1 = %f  ea1 = %f\n", sa1, ea1);
			Ret1 = ellipse_on_ellipse_point(ellipseA, ellipseB, &sa1, &ea1, ((360-sa[i]+ea[i])/20), 0.0000001);
			if (Ret1 == 1) {
				rtn->type++;
				get_ellipse_point_from_angle (ellipseA, ((ea1 + sa1) / 2), &point1);
				rtn->sx[rtn->type] = point1.x;
				rtn->sy[rtn->type] = point1.y;
				if (debug > 0) g_print("Ellipse.c : ellipse_on_ellipse_rect() : (%f,%f)\n", point1.x, point1.y);
			}

			/* ΰκǸ */
			if (debug > 0) g_print("Ellipse.c : ellipse_on_ellipse_rect() : sa2 = %f  ea2 = %f\n", sa2, ea2);
			Ret2 = ellipse_on_ellipse_point(ellipseA, ellipseB, &sa2, &ea2, ((360-sa[i]+ea[i])/20), 0.0000001);
			if (Ret2 == 1) {
				rtn->type++;
				get_ellipse_point_from_angle (ellipseA, ((ea2 + sa2) / 2), &point2);
				rtn->sx[rtn->type] = point2.x;
				rtn->sy[rtn->type] = point2.y;
				if (debug > 0) g_print("Ellipse.c : ellipse_on_ellipse_rect() : (%f,%f)\n", point2.x, point2.y);
			}

			if (Ret1 == 1 && Ret2 == 1) {
				if (sg(point1.x, 4) == sg(point2.x, 4) && sg(point1.y, 4) == sg(point2.y, 4)) {
					rtn->type--;
					rtn->sx[rtn->type] = sg(point1.x, 4);
					rtn->sy[rtn->type] = sg(point1.y, 4);
				}
			}
		}
	}

	/* ΥƤ */
	if (rtn->type == 0 && BinA == 0 && AinB == 0) {
		if (debug > 0) g_print ("ellipse_on_ellipse() : out 1\n");
		return 1;
	}
	/* ¤ܤƤ */
	else if (rtn->type == 1 && BinA == 0 && AinB == 0) {
		if (debug > 0) g_print ("ellipse_on_ellipse() : out 2\n");
		return 2;
	}
	/* ŤʤäƤ */
	else if (rtn->type > 1) {
		if (debug > 0) g_print ("ellipse_on_ellipse() : out 3\n");
		return 3;
	}
	/* ŤʤäܤƤ */
	else if (rtn->type == 1 && (BinA == 1 || AinB == 1)) {
		if (debug > 0) g_print ("ellipse_on_ellipse() : out 4\n");
		return 4;
	}
	/* ŤʤäΥƤ */
	else if (rtn->type == 0 && (BinA == 1 || AinB == 1)) {
		if (debug > 0) g_print ("ellipse_on_ellipse() : out 5\n");
		return 5;
	}

	if (debug > 0) g_print ("ellipse_on_ellipse() : out 0\n");
	return 0;
}





/* -------------------------------------------------------------------
 * ʱߣʱߣ¤θȤʤ롢ʱߣγ٤ϰ 
 * 
 */
int ellipse_on_ellipse_point(ELLIPSE ellipseA, 
							 ELLIPSE ellipseB, 
							 double *sa, 
							 double *ea, 
							 double angle_degits, 
							 double last_degits 
							 )
{
	double i, j = 0;
	int Ret = 0, BeforeRet = 0, End = 0;
	double dgt, value;
	double min = 0, max = 0;
	POINT point;
	int debug = 0;


//	value = (2 * PI * get_ellipse_a(ellipseA) * angle_degits) / (360*2);
	value = last_degits/5000;
	if (debug > 0) g_print("ellipse_on_ellipse_point() : sa = %f   ea = %f   value = %e   angle_degits = %e   last_degits = %e\n", *sa, *ea, value, angle_degits, last_degits);




	/* SA < EA */
	if (*sa < *ea) {
		if (debug > 0) g_print("ellipse_on_ellipse_point() : sa < ea\n");

		min = *sa;
		max = *ea;

		for (i = *sa - angle_degits ; i < *ea + angle_degits ; i = i + angle_degits) {
			if (End != 1) {
				get_ellipse_point_from_angle (ellipseA, (double)i, &point);
				Ret = point_in_ellipse (&ellipseB, point.x, point.y, value);
				if (Ret == 3) Ret = 1;

				if (debug > 0) g_print("ellipse_on_ellipse_point() : i = %f   Ret = %d\n", i, Ret);
				j++;

				/* out */
				if (Ret == 2) {
					/* start in */
					if (BeforeRet == 0) {
						//min = (double) i - angle_degits;
					}
					/* out -> out */
					else if(BeforeRet == 2) {
						min = (double) i;
					}
					/* in -> out */
					else if (BeforeRet == 1) {
						max = (double) i;
						End = 1;
					}
					BeforeRet = 2;
				}
				/* in */
				else if (Ret == 1) {
					/* start in */
					if (BeforeRet == 0) {
						//min = (double) i - angle_degits;
					}
					/* in -> in */
					else if(BeforeRet == 1) {
						min = (double) i;
					}
					/* out -> in */
					else if (BeforeRet == 2) {
						max = (double) i;
						End = 1;
					}
					BeforeRet = 1;
				}
			}
		}

		*sa = min;
		*ea = max;
		dgt = (max - min);

		if (debug > 0) g_print("ellipse_on_ellipse_point() : j = %f   X10000 : max[%f] - min[%f] = dgt[%f]\n\n\n", j, 10000*max, 10000*min, 10000*dgt);

		if (dgt < last_degits) {
//			if (debug > 0) g_print("dgt < last_degits\n");
			return 1;  // Ans (max + min) / 2
		}
		else {
//			if (debug > 0) g_print("dgt > last_degits\n");
			return ellipse_on_ellipse_point(ellipseA, ellipseB, sa, ea, (dgt / 10), last_degits);
		}
	}





	/* EA < SA */
	else if (*ea < *sa) {
		if (debug > 0) g_print("ellipse_on_ellipse_point() : sa > ea\n");

		min = *sa;
		max = *ea;

		for (i = *ea - angle_degits ; i < 360 + angle_degits ; i = i + angle_degits) {
			if (End != 1) {
				get_ellipse_point_from_angle (ellipseA, (double)i, &point);
				Ret = point_in_ellipse (&ellipseB, point.x, point.y, value);
				if (Ret == 3) Ret = 1;
				
				if (debug > 0) g_print("ellipse_on_ellipse_point() : i = %f   Ret = %d\n", i, Ret);
				j++;
	//			if (debug > 0) g_print("%d", Ret);

				/* out */
				if (Ret == 2) {
					/* start in */
					if (BeforeRet == 0) {
						//min = (double) i - angle_degits;
					}
					/* out -> out */
					else if(BeforeRet == 2) {
						min = (double) i;
					}
					/* in -> out */
					else if (BeforeRet == 1) {
						max = (double) i;
						End = 1;
					}
					BeforeRet = 2;
				}
				/* in */
				else if (Ret == 1) {
					/* start in */
					if (BeforeRet == 0) {
						//min = (double) i - angle_degits;
					}
					/* in -> in */
					else if(BeforeRet == 1) {
						min = (double) i;
					}
					/* out -> in */
					else if (BeforeRet == 2) {
						max = (double) i;
						End = 1;
					}
					BeforeRet = 1;
				}
			}
		}

		//if (max == *sa) {
			for (i = 0 - angle_degits ; i < *sa + angle_degits + angle_degits ; i = i + angle_degits) {
				if (End != 1) {
					get_ellipse_point_from_angle (ellipseA, (double)i, &point);
					Ret = point_in_ellipse (&ellipseB, point.x, point.y, value);
					if (Ret == 3) Ret = 1;

					if (debug > 0) g_print("ellipse_on_ellipse_point() : i = %f   Ret = %d\n", i, Ret);
					j++;
//					if (debug > 0) g_print("%d", Ret);

					/* out */
					if (Ret == 2) {
						/* start in */
						if (BeforeRet == 0) {
							//min = (double) i - angle_degits;
						}
						/* out -> out */
						else if(BeforeRet == 2) {
							min = (double) i;
						}
						/* in -> out */
						else if (BeforeRet == 1) {
							max = (double) i;
							End = 1;
						}
						BeforeRet = 2;
					}
					/* in */
					else if (Ret == 1) {
						/* start in */
						if (BeforeRet == 0) {
							//min = (double) i - angle_degits;
						}
						/* in -> in */
						else if(BeforeRet == 1) {
							min = (double) i;
						}
						/* out -> in */
						else if (BeforeRet == 2) {
							max = (double) i;
							End = 1;
						}
						BeforeRet = 1;
					}
				}
			}
		//}
		


		*sa = min;
		*ea = max;
		if (min < max) {
			dgt = (max - min);
		}
		else if (min > max) {
			dgt = ((360-min) + max);
		}
		else dgt = 0;
		
		//dgt = max - min;
		if (debug > 0) g_print("ellipse_on_ellipse_point() : j = %f   X10000 : max[%f] - min[%f] = dgt[%f]\n\n\n", j, 10000*max, 10000*min, 10000*dgt);

		if (dgt < last_degits) {
			return 1;  // Ans (max + min) / 2
		}
		else {
			return ellipse_on_ellipse_point(ellipseA, ellipseB, sa, ea, dgt / 10, last_degits);
		}
	}
	return 0;
}





/* -------------------------------------------------------
 * ʱߤʱ() (Main)
 * 
 * 
 * return : 0 : ʤ
 *          1 : 
 *          2 : 
 *          3 : 
 *          4 : 
 * 
 */
int ellipse_to_ellipse(struct RtnDat *rtn, ELLIPSE ellipseA, ELLIPSE ellipseB)
{
	int Ret, i, j = 0, BeforeRet = 0;
	int A_data[360];
	double sp[5], ep[5], AnsAngle;
	struct RtnDat lo_rtn;
	POINT point;
	int debug = 0;


	/* -----------------------------------------------------
	 * ǡμ
	 * 
	 * ʱߣ 1 ٤Ȥ˵ᡢ
	 * ʱߣ¤ΰִط A_data[] 롣
	 */
	/* ʱߣ1٤Ȥ˥ǡ */
	if (debug > 0) g_print ("ʱߣβ\n");
	for (i = 0 ; i < 360 ; i++) {
		ellipse_tangent(rtn, ellipseA, (double)i);
		lep(rtn, ellipseB, 4);
		Ret = rtn->type;
		if (Ret == 1) Ret = 2;
		if (debug > 0) {
			g_print ("%d", Ret);
			if (i == 89 || i == 179 || i == 269 || i == 359) g_print("\n");
		}
		A_data[i] = Ret;
	}



	/* -----------------------------------------------------
	 *  
	 * 
	 */
	/* Ȼפ٤ϰϤǼ */
	for (i = 0 ; i < 5 ; i++) {
		sp[i] = 0;
		ep[i] = 0;
	}

	/* Ȼפ٤ϰϤ */
	j = 0;
	BeforeRet = 1;
	for (i = 0 ; i < 360 ; i++) {
		/* out -> in */
		if (A_data[i] == 2) {
			if (BeforeRet == 0) {
				if (debug > 0) g_print ("i = %d  sp = %d  ep = %d\n", i, i-2, i);
				sp[j] = (double)(i - 2.);
				ep[j] = (double)i;
				j++;
			}
			BeforeRet = 2;
		}
		/* in -> out */
		else if (A_data[i] == 0) {
			if (BeforeRet == 2) {
				if (debug > 0) g_print ("i = %d  sp = %d  ep = %d\n", i, i-2, i);
				sp[j] = (double)(i - 2.);
				ep[j] = (double)i;
				j++;
			}
			BeforeRet = 0;
		}
	}

	/* Ȼפ٤ϰϤΥǡǧ */
	if (debug > 0) {
		for (i = 0 ; i < j ; i++) {
			g_print ("sp[%d] = %f  ep[%d] = %f\n", i, sp[i], i, ep[i]);
		}
	}



	/* -----------------------------------------------------
	 * 
	 * 
	 * Ȼפ٤ϰϤǼƤγƥǡ
	 * ٤٤ᡢ롣
	 */
	rtn->type = 0;
	for (i = 0 ; i < j ; i++) {
		point.frag = 0;
		Ret = ellipse_to_ellipse_search (ellipseA, ellipseB, &sp[i], &ep[i], &point, 0.1, 0.0000001);
		if (Ret == 1) {
			rtn->type++;
			AnsAngle = (sp[i] + ep[i]) / 2;
			ellipse_tangent(&lo_rtn, ellipseA, AnsAngle);
			rtn->sx[rtn->type] = lo_rtn.sx[1];
			rtn->sy[rtn->type] = lo_rtn.sy[1];

			lep(&lo_rtn, ellipseB, 10);
			if (lo_rtn.type == 1) {
				rtn->ex[rtn->type] = lo_rtn.sx[2];
				rtn->ey[rtn->type] = lo_rtn.sy[2];
			}
			else if (lo_rtn.type == 2) {
				rtn->ex[rtn->type] = (lo_rtn.sx[2] + lo_rtn.sx[3]) / 2;
				rtn->ey[rtn->type] = (lo_rtn.sy[2] + lo_rtn.sy[3]) / 2;
			}
			else if (point.frag == 1) {
				rtn->ex[rtn->type] = point.x;
				rtn->ey[rtn->type] = point.y;
			}
			else {
				rtn->type--;
			}
		}
	}

	return rtn->type;
}





/* -------------------------------------------------------
 * ʱߣ sp ep ʱߣ()õ (Ƶؿ)
 * 
 * 
 * ʱߣ sp  ep γ٤δ֤򥹥ƥå angle_degits ᡢ
 * 
 * ʱߣ¤椫鳰ȴ֤ sp ep ϰϤäȶ
 * ޤ
 * ʱߣ¤γ֤ sp ep ϰϤäȶ
 * ơƵƤӽФˤƤޤ ellipse_to_ellipse_search() Ƥ֡
 * 
 * λϡsp ep ϰϤ last_degits ⾮ʤäȤ
 * sp ep ϰϤѤʤȤ
 * 
 */
int ellipse_to_ellipse_search (ELLIPSE ellipseA, 
							   ELLIPSE ellipseB, 
							   double *sp, 
							   double *ep, 
							   POINT *point, 
							   double angle_degits, 
							   double last_degits 
							   )
{
	double i, dgt;
	int Ret = 0, BeforeRet = 1;
	struct RtnDat rtn;
	int debug = 0;
	double osp, oep;


	osp = *sp;
	oep = *ep;

	if (debug > 0) g_print ("sp = %f   ep = %f   angle_degits = %f\n", *sp, *ep, angle_degits);



	/* -----------------------------------------------------
	 * ʱߣʱߣ¤椫鳰ޤϳ
	 * ڤؤϰϤõ
	 */
	BeforeRet = 1;
	for (i = *sp ; i < *ep + angle_degits; i = i + angle_degits) {
		ellipse_tangent(&rtn, ellipseA, i);
		lep(&rtn, ellipseB, 10);
		if (rtn.type == 1) {
			point->frag = 1;
			point->x = rtn.sx[2];
			point->y = rtn.sy[2];
			if (debug > 0) g_print("point : Ret = %d   i = %f\n", Ret, i);
		}
		Ret = rtn.type;
		/*  1 ĤǤ 2 ĤȤƹͤ */
		if (Ret == 1) Ret = 2;
		if (debug > 0) g_print ("i = %f   Ret = %d\n", i, Ret);

		/* out -> in */
		if (Ret == 2) {
			if (BeforeRet == 0) {
				if (debug > 0) g_print ("    i = %f  sp = %f  ep = %f\n", i, i - angle_degits, i + angle_degits);
				*sp = i - angle_degits;
				*ep = i + angle_degits;
			}
			BeforeRet = 2;
		}
		/* in -> out */
		else if (Ret == 0) {
			if (BeforeRet == 2) {
				if (debug > 0) g_print ("    i = %f  sp = %f  ep = %f\n", i, i - angle_degits, i + angle_degits);
				*sp = i - angle_degits;
				*ep = i + angle_degits;
			}
			BeforeRet = 0;
		}
	}



	/* -----------------------------------------------------
	 * ᤿ϰϤˤäƼν櫓롣
	 */
	/*  */
	dgt = (*ep - *sp);
	if (debug > 0) g_print("    X10000 : ep[%f] - sp[%f] = dgt[%f]\n\n\n", 10000*(*ep), 10000*(*sp), 10000*dgt);

	/* sp ep Ѳ̵ʤ̵Ȥƽλ */
	if (osp == *sp && oep == *ep) {
		if (debug > 0) g_print("osp == *sp && oep == *ep ˤäƥ󥻥\n");
		return 0;
	}

	/*  last_degits 꾮нλ */
	else if (dgt < last_degits) {
		//if (debug > 0) g_print("dgt < last_degits\n");
		if (point->frag != 1) {
			for (i = *sp ; i < *ep + (angle_degits / 10); i = i + (angle_degits / 10)) {
				ellipse_tangent(&rtn, ellipseA, i);
				lep(&rtn, ellipseB, 10);
				if (rtn.type == 1) {
					point->frag = 1;
					point->x = rtn.sx[2];
					point->y = rtn.sy[2];
				}
				else {
					if (debug > 0) g_print("ellipse_to_ellipse_search() : 1 : ǤϸФʤä\n");
				}
			}
			if (point->frag != 1) {
				ellipse_tangent(&rtn, ellipseA, (*ep + *sp) / 2);
				lep(&rtn, ellipseB, 4);
				if (rtn.type == 1) {
					point->frag = 1;
					point->x = rtn.sx[2];
					point->y = rtn.sy[2];
				}
				else {
					if (debug > 0) g_print("ellipse_to_ellipse_search() : 2 : ǤϸФʤä\n");
				}
			}
		}
		return 1;  // Ans (max + min) / 2
	}

	/*  last_degits 礭ФäȺ٤õ ellipse_to_ellipse_search() Ƥ */
	else {
		//if (debug > 0) g_print("dgt > last_degits\n");
		return ellipse_to_ellipse_search(ellipseA, ellipseB, sp, ep, point, (dgt / 10), last_degits);
	}

	return 0;
}





/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : Ellipse.c
 * ====================================================================
 */
