/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : B_spline.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2003 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/01/03
 *    Last                 : 2003/04/16
 * ====================================================================
 */

#ifndef __B_SPLINE_H__
#define __B_SPLINE_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 :   (struct #define etc)
 * -------------------------------------------------------
 */



/* -------------------------------------------------------
 * 2 : ѿ (global)
 * -------------------------------------------------------
 */
#ifdef _B_SPLINE_
#define   GLOBAL
// 
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// ʬ̵
#define   GLOBAL_VAL(v)  /* */
#endif




#undef	GLOBAL
#undef	GLOBAL_VAL
#undef _B_SPLINE_



/* -------------------------------------------------------
 * 3 : ؿ (Function)
 * -------------------------------------------------------
 */
int split2(VERTEX sp, VERTEX ep, VERTEX *ap);
int split3(VERTEX sp, VERTEX ep, VERTEX *ap1, VERTEX *ap2);
int spl1(double u, double *s1, double *s2, double *s3, double *s4);
int spl2(double u, double *s1, double *s2, double *s3, double *s4);
int spl3(double u, double *s1, double *s2, double *s3, double *s4);
int spl4(double u, double *s1, double *s2, double *s3, double *s4);
int spl5(double u, double *s1, double *s2, double *s3, double *s4);
int conv(double *s1, double *s2, double *s3, double *s4);
int b_spline(int n, VERTEX *vertex, long color, double pitch);



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __B_SPLINE_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : B_spline.h
 * ====================================================================
 */
